<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $table_name = (
         isset( $_GET[ 'table_name' ] ) && (wp_verify_nonce($nonce, "bdds-table-view-nonce"))
         || wp_verify_nonce($nonce, "bdds-yes-drop-row-nonce") || wp_verify_nonce($nonce, "view-truncate-table-nonce")
         || wp_verify_nonce($nonce, "bdds-no-drop-row-nonce")
        ) ? sanitize_text_field(wp_unslash($_GET[ 'table_name' ])) : null;
    $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $values_to_insert = array();
    $is_break = 0;
    $bit_array = array();
    $column_ids = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->prepare(
            "SELECT ORDINAL_POSITION FROM information_schema.columns WHERE table_name = %s AND COLUMN_NAME NOT IN ('id', 'created_at', 'updated_at', 'deleted_at');",
            $table_name
        )
    );

    // we iterate trough column ids, and pass every id to retrive column info from table_structure_result array
    // index for table_structure_result is $column_id - 1, because ordinal position starts from 1 and not 0
    foreach($column_ids as $column_id) {
        $column_id      = $column_id->ORDINAL_POSITION;
        $column_name    = $table_structure_result[$column_id - 1]->Field;
        $column_default = $table_structure_result[$column_id - 1]->Default;
        $column_type    = $table_structure_result[$column_id - 1]->Type;
        $column_null    = $table_structure_result[$column_id - 1]->Null;
        // every new value has name "new-row-ID" where "ID" => id of a column that value should be inserted to
        // new-row-1 corresponds to first column in the table, new-row-2 second column...
        $value_to_insert = isset($_POST['new-row-' . $column_id]) ? sanitize_text_field(wp_unslash($_POST['new-row-' . $column_id])) : null;
        $new_row_value;

        $is_input_valid = str_contains($column_type, "longblob") ? "valid" : BDDS_Admin::validate_data($column_type, $value_to_insert, $column_name);
        if ( $column_name == 'id' || $column_name == 'created_at' || $column_name == 'deleted_at' || $column_name == 'updated_at') continue;

        if ( empty( $column_default ) && empty( $value_to_insert ) && $column_null == "NO" && !str_contains($column_type, "longblob")) {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(sprintf(
                'Column "%s" must have a value!', esc_html($column_name)
            ), 'error');
            $is_break = 1;
            break;

        } else if ($is_input_valid != "valid") {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                esc_html($is_input_valid), 'error'
            );
            $is_break = 1;
            break;

        } else {
            // check if column has a default value
            $column_default = isset($column_default) ? $column_default : '';

            if($column_null == "YES") {
                if(empty($column_default) && empty($value_to_insert)) {
                    $new_row_value = NULL;

                } else if(empty($column_default) && !empty($value_to_insert)) {
                    $new_row_value = $value_to_insert;

                } else if(!empty($column_default) && empty($value_to_insert)) {
                    $new_row_value = $column_default;

                } else {
                    $new_row_value = $value_to_insert;

                }

            } else if($column_null == "NO") {
                if(!empty($value_to_insert)) {
                    $new_row_value = $value_to_insert;

                } else if(empty($column_default) && !empty($value_to_insert)) {
                    $new_row_value = $value_to_insert;

                } else if(!empty($column_default) && empty($value_to_insert)) {
                    $new_row_value = $column_default;

                }

            }

            if(str_starts_with($column_type, "enum")) {
                if(str_contains($new_row_value, '"')) {
                    $new_row_value = str_replace('\"', '"', $new_row_value);
                }

                if(str_contains($new_row_value, "'")) {
                    $new_row_value = str_replace("\'", "'", $new_row_value);
                }
            }

            // handle bit insertion
            if( isset($new_row_value) && $new_row_value == "Yes" && str_contains($column_type, "bit") ) {
                $new_row_value = 1;
                array_push($bit_array, array($column_name => $new_row_value));

            } else if ( isset($new_row_value) && $new_row_value == "No" && str_contains($column_type, "bit") ) {
                $new_row_value = 0;
                array_push($bit_array, array($column_name => $new_row_value));

            }

            // handle file upload
            if(str_contains($column_type, 'longblob')) {
                foreach($_FILES as $file) {
                    $upload = wp_handle_upload(
                        $file,
                        array( 'test_form' => false)
                    );

                    if ( !empty($upload['error']) ) {
                        wp_die( esc_html($upload['error']) );
                    }

                    $attachment_id = wp_insert_attachment(
                        array(
                            'guid'           => sanitize_text_field($upload['url']),
                            'post_mime_type' => sanitize_text_field($upload['type']),
                            'post_title'     => sanitize_text_field(basename($upload['file'])),
                            'post_content'   => '',
                            'post_status'    => 'inherit',
                        ),
                        $upload['file']
                    );

                    if ( is_wp_error($attachment_id) || !$attachment_id ) {
                        wp_die("Upload error!");
                    }

                    require_once ABSPATH . "wp-admin/includes/image.php";

                    wp_update_attachment_metadata(
                        $attachment_id,
                        wp_generate_attachment_metadata( $attachment_id, $upload["file"] )
                    );

                    /* The file is actually uploaded to the WP uploads folder
                        (exact location depending on permalink structure).
                        Therefore good WP practice would be to store the attachment
                        ID and use it to access the file.
                        The existing 'longblob' column type helps us identify that
                        the column contains the file attachment ID, when the file
                        is needed. (BDDS_ATTACHMENT_COLUMN_TYPE)
                        (Attachment metadata is stored in the wp_postmeta table.)
                        !!! DO NOT add more 'longblob' types before considering this! */
                    $new_row_value = $attachment_id;
                }

            }

            $values_to_insert[$column_name] = $new_row_value;
        }
    }

    if( $is_break == 0 ) {
        $wpdb->insert( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
            $table_name,
            $values_to_insert
        );

        // wpdb insert does not support bit insertion, instead we use update query
        if(count($bit_array) > 0) {
            $last_inserted_row_id = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT `id` FROM `$table_name` ORDER BY ID DESC LIMIT 1;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                )
            );

            foreach($bit_array as $bit) {
                foreach($bit as $column_name=>$bit_value) {
                    // update bit value
                    $wpdb->query( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $wpdb->prepare(
                            "UPDATE `$table_name` SET $column_name = $bit_value WHERE id=%d", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            $last_inserted_row_id
                        )
                    );
                }
            }
        }

        // Page refresh
        $currentUri = isset($_SERVER["REQUEST_URI"]) ? sanitize_text_field(wp_unslash($_SERVER["REQUEST_URI"])) : '';
        BDDS_Admin::redirectTo($currentUri);

    }