<?php
    if ( ! defined( 'ABSPATH' ) ) exit;
    include "view_table/screen_options.php";

    require_once BDDS_PLUGIN_HELPERS_DIR . "BDDS_Formatter.php";
?>

<div class="wrap">
    <?php

        global $wp;
        global $wpdb;
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        $table_name  = (
            isset( $_GET[ 'table_name' ] ) && (wp_verify_nonce($nonce, "bdds-table-view-nonce")) || wp_verify_nonce($nonce, "bdds-yes-drop-row-nonce")
            || wp_verify_nonce($nonce, "view-truncate-table-nonce") || wp_verify_nonce($nonce, "bdds-no-drop-row-nonce")
        ) ? sanitize_text_field(wp_unslash($_GET[ 'table_name' ])) : null;
        $table_name_formatted = str_replace("{$wpdb->prefix}" . BDDS_PLUGIN_PREFIX . "_", "", $table_name);

        $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $post_a = map_deep($_POST, 'sanitize_text_field' );
        $fields = '';
        $show_fields = array();

        // user selected columns from screen options
        if ( isset( $_POST['screen-options-apply'] ) ) {
            // array show_fields is used only if column from screen options is selected
            // later we iterate trough every column name from table structure
            // if column name is not in show fields array we skip that element in loop and check next element
            array_push($show_fields, "id");
            foreach( $post_a as $key=>$post_value ) {
                if( str_contains($key, "screen-column-option-") ) {
                    // id and updated_at are displayed anyways so we continue, and append them at the end
                    if ($post_value == "id" || $post_value == "updated_at") continue;
                    $fields .= $post_value . ',';

                    array_push($show_fields, $post_value);
                }
            }
            array_push($show_fields, "updated_at");

            // variable fields is passed to query to get records from database
            // later variable fields is transofrmed into array
            $fields = "id," . $fields . "updated_at";

        } else {
            // append column names to variable fields
            foreach( $table_structure_result as $table_structure ) {
                $column_name = $table_structure->Field;
                // created_at and deleted_at should not be displayed at beginning so we skip on them
                if($column_name == "created_at" || $column_name == "deleted_at") continue;
                $fields .= $column_name . ',';
            }

            $fields = rtrim($fields, ',');
        }

        if ( isset( $_GET[ 'orderby' ] ) && isset( $_GET[ 'order' ] ) ) {
            $order_by_column = sanitize_text_field(wp_unslash($_GET[ 'orderby' ]));
            $order           = sanitize_text_field(wp_unslash($_GET[ 'order' ]));

            $table_data_result = $wpdb->get_results($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                "SELECT $fields FROM `$table_name` ORDER BY $order_by_column $order;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            ));

        } else {
            $table_data_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare("SELECT $fields FROM `$table_name`;") // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            );
        }

        if ( isset( $_POST[ 'column_to_search' ] ) && isset( $_POST[ 'search_value' ] ) ) {
            $column_to_search = sanitize_text_field(wp_unslash($_POST[ 'column_to_search' ]));
            $search_value     = sanitize_text_field(wp_unslash($_POST[ 'search_value' ]));
            $selected_records;

            if ( $column_to_search == "*" ) {
                // user selected to search in all columns for a specific value
                $all_fields = "";
                foreach( $table_structure_result as $table_structure ) {
                    $all_fields .= $table_structure->Field . ',';
                }

                $all_fields = rtrim( $all_fields, ',' );

                if ( empty( $search_value ) ) {
                    $table_data_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $wpdb->prepare("SELECT $fields FROM `$table_name`;") // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    );
                } else {
                    // get all records from table that match search value
                    $table_data_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $wpdb->prepare("SELECT $fields FROM `$table_name` WHERE '$search_value' in ( $all_fields );") // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    );
                }

            } else {
                // only one column is selected to search in
                $table_data_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare("SELECT $fields FROM $table_name WHERE '$search_value' in ( $column_to_search );") // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                );
            }
        }

        $metadata_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";

    ?>

    <?php if( isset( $_GET['trash'] ) ) {
        // display all records that do not have NULL in "deleted_at" column, this means they are deleted
        $deleted_records = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `$table_name` WHERE deleted_at IS NOT NULL;" ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

        include "view_table/trash.php";
        $back_url = remove_query_arg( "trash" );
    ?>

    <form method="post">
        <input
            type="submit"
            class="button button-primary"
            style="margin-top: 0.5em;"
            name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-trash-view-back"
            value="<?php esc_html_e('Back', 'black-desk')?>"
        >
    </form>

    <?php } else { ?>

    <?php
        $number_of_deleted_rows = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(deleted_at) FROM `$table_name` WHERE deleted_at IS NOT NULL;"
        )); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    ?>
    <h2><?php esc_html_e('View table', 'black-desk'); ?> - <?php echo esc_html($table_name_formatted); ?></h2>
    <form action="" id="tables_filter" method="post" enctype="multipart/form-data">
        <div>
            <p class="search-box">
                <select name="column_to_search" id="">
                    <option value="*"><?php esc_html_e('All columns', 'black-desk')?></option>
                    <?php
                        // display all table columns for search
                        foreach( $table_structure_result as $table_structure ) {
                            $table_field_name = $table_structure->Field;
                            echo "<option value='" . esc_attr($table_structure->Field) . "' >" . esc_html($table_field_name) . "</option>";
                        }
                    ?>
                </select>
                <input type="search" name="search_value">
                <input class="button" type="submit" value="<?php esc_attr_e('Search', 'black-desk'); ?>">
            </p>
        </div>

        <div>
            <ul>
                <li class="trash">
                    <a href="<?php echo esc_url( add_query_arg( array('trash' => '1') ) )?>" style="text-decoration: none;">
                        <?php esc_html_e('Trash', 'black-desk'); ?>
                        <span style="color: #000;">( <?php echo esc_html($number_of_deleted_rows); ?> )</span>
                    </a>
                </li>
            </ul>
        </div>

        <div class="tablenav top">
            <div id="top-left-bulk-action" class="alignleft actions bulkactions" name="action1">
                <select value="Bulk actions" name='doaction'>
                    <option><?php esc_html_e('Bulk actions', 'black-desk'); ?></option>
                    <option value="delete_action_1"><?php esc_html_e('Delete', 'black-desk'); ?></option>
                </select>

                <input type="submit" class="button" id="doaction"  value="<?php esc_attr_e('Apply', 'black-desk');?>">
            </div>
            <div class="alignright" style="margin-top: 0.35em">
                <?php
                    remove_query_arg( "action", false );
                    $turncate_url = add_query_arg(array(
                            "action" => "turncate",
                            "from_page" => BDDS_PLUGIN_PREFIX . "_table_view",
                            "_wpnonce" => wp_create_nonce("view-truncate-table-nonce")
                        )
                    );
                ?>
                <a href="<?php echo esc_url($turncate_url); ?>" style="color: red; border: 1px solid red; text-decoration: none; padding: 0.5em; border-radius: 3px;">
                    <?php esc_html_e('Empty Table', 'black-desk'); ?>
                </a>
            </div>
        </div>

        <table class="wp-list-table widefat striped table-view-list" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX);?>-data-table-view">
            <thead>
                <tr id="table-view-header">
                    <td class="manage-column column-cb check-column">
                        <input type="checkbox">
                    </td>
                    <?php
                        $fields = explode(',', $fields);
                        // show table columns in table header
                        foreach( $fields as $field ) {
                            // field is not in show_fields array so we skip that field and check next
                            if( !empty($show_fields) && !in_array($field, $show_fields) ) continue;

                            // orderby_order variable is url which contains get methods for sorting
                            $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "DESC" ) );
                            if ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] == "DESC" ) {
                                $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "ASC" ) );
                            } else if ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] == "ASC" ) {
                                $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "DESC" ) );
                            }

                            if($field == "id") {
                                $id = "id=" . BDDS_PLUGIN_PREFIX . "-table-header-id";
                            } else if ($field == "created_at" || $field == "deleted_at" || $field == "updated_at") {
                                $id = "id=" . BDDS_PLUGIN_PREFIX .  "-table-header-$field";
                            } else {
                                $id = "id=" . BDDS_PLUGIN_PREFIX . "-table-header";
                            }

                            $order_class = ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] == "DESC" ) ? "desc" : "asc";
                            echo '<th scope="col" class="manage-column column-title column-primary sorted ' . esc_attr($order_class) . '" aria-sort="ascending"' . esc_attr($id) . ' >';
                                echo '<a href="' . esc_url($orderby_order) . '">';
                                    echo "<span>". esc_html($field) ."</span>";
                                    echo "<span class='sorting-indicator'>";
                                        echo '<span class="sorting-indicator asc" aria-hidden="true"></span>';
                                        echo '<span class="sorting-indicator desc" aria-hidden="true"></span>';
                                    echo "</span>";
                                echo '</a>';
                            echo '</th>';
                        }
                    ?>
                    <?php // table header for "delete" ?>
                    <th></th>
                </tr>
            </thead>

            <tbody>
                <?php
                    // show table data in table body
                    foreach( $table_data_result as $table_data ) {
                        $row_id = $table_data->id;
                        // check if record is deleted, if deleted at is not null it means record is deleted so we skip that record
                        $is_record_deleted = $wpdb->get_var($wpdb->prepare("SELECT deleted_at FROM `$table_name` WHERE id=%d;", $row_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                        if($is_record_deleted != NULL) continue;

                        if( empty( $table_data->deleted_at ) ) {
                            echo "<tr>";
                                echo "<th scopre='row' class='check-column'>";
                                    echo "<input type='checkbox' name='column_id_" . esc_attr($row_id) . "' value='" . esc_attr($row_id) . "'>";
                                echo "</th>";
                                foreach( $fields as $field ) {
                                    $table_column_name = $field;
                                    $table_data_id     = $table_column_name . "-" . $table_data->id;
                                    $current_value     = ($table_data->$table_column_name != NULL) ? $table_data->$table_column_name : "NULL";
                                    $field_data_type   = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                        $wpdb->prepare(
                                                "SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = %s AND COLUMN_NAME = %s",
                                                array($table_name, $field)
                                            )
                                    );
                                    $last_field        = end($fields);

                                    // field is not in show_fields array so we skip that field and check next
                                    if( !empty($show_fields) && !in_array($field, $show_fields) ) continue;

                                    // field should be displayed
                                    if ( $table_column_name != 'id' && $table_column_name != 'created_at' && $table_column_name != 'updated_at' && $table_column_name != 'deleted_at' && $field_data_type != "longblob") {
                                        if ($field_data_type == "bit") {
                                            $yes_selected = ($current_value == 1) ? "selected" : '';
                                            $no_selected  = ($current_value == 0) ? "selected" : '';

                                            // select > change listener @showTables.js
                                            echo "<td>";
                                                echo "<select id='" . esc_attr($table_data_id) . "'>";
                                                    echo "<option value='Yes' " . $yes_selected . ">Yes</option>";
                                                    echo "<option value='No' " . $no_selected . ">No</option>";
                                                echo "</select>";
                                            echo "</td>";

                                        } else {
                                            // here we display fields that can have inline edit
                                            echo ($current_value == "NULL") ?
                                                "<td id='" . esc_attr($table_data_id) . "'  onclick=\"editData('" .
                                                    esc_js($table_data_id) . "','" . esc_js($current_value) .
                                                "')\" >" .
                                                    "<i>" . esc_html($current_value) . "</i>" .
                                                "</td>"
                                                :
                                                "<td id='" . esc_attr($table_data_id) . "'  onclick=\"editData('" .
                                                    esc_js($table_data_id) . "','" . esc_js($current_value) .
                                                "')\" >" .
                                                    esc_html($current_value) .
                                                "</td>";
                                        }


                                    } else if (
                                        $field_data_type == BDDS_ATTACHMENT_COLUMN_TYPE &&
                                        $current_value != "NULL"
                                    ) {
                                        $attachment_html = BDDS_Formatter::get_attachment_html($current_value);

                                        echo "<td>$attachment_html</td>";

                                    } else {
                                        echo "<td id='" . esc_attr($table_data_id) . "' " ." >". esc_html($current_value) ."</td>";

                                    }

                                    if($field == $last_field) {
                                        $drop_row_url = add_query_arg(array(
                                            "record_id" => $row_id,
                                            "_wpnonce"=> wp_create_nonce( 'bdds-drop-row-nonce' )
                                            )
                                        );
                                        $drop_row_url = str_replace("action=view", "action=drop_row", $drop_row_url);

                                        echo "<td>";
                                            echo "<a style='color:red;' href='" . esc_url($drop_row_url) . "'>Delete</a>";
                                            echo "<input type='hidden' name='" . esc_attr(BDDS_PLUGIN_PREFIX) . "-delete-row' value='" . esc_attr($row_id) . "'>";
                                        echo "</td>";
                                    }
                                }

                            echo "</tr>";
                        }
                    }
                ?>
                <tr id='insert-new-column-table-row'>
                    <th scope='row' class='check-column'>
                        <span style="padding-left:0.3em;padding-right:0.3em;margin-left:0.5em;font-size:1.1em;">
                            *
                        </span>
                    </th>
                    <td></td>
                    <?php
                        // NEW RECORDS
                        $input_id = 0;

                        foreach( $fields as $field ) {
                            $table_column_name  = $field;
                            $field_info = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                $wpdb->prepare(
                                    "SELECT COLUMN_TYPE,ORDINAL_POSITION,COLUMN_NAME,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,COLUMN_DEFAULT,IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = %s AND COLUMN_NAME = %s;",
                                    array($table_name, $table_column_name)
                                )
                            );
                            $column_id          = $field_info[0]->ORDINAL_POSITION;
                            $column_name        = $field_info[0]->COLUMN_NAME;
                            $column_type        = $field_info[0]->DATA_TYPE;
                            $column_type_enum   = $field_info[0]->COLUMN_TYPE;
                            $column_default     = $field_info[0]->COLUMN_DEFAULT;
                            $column_null        = $field_info[0]->IS_NULLABLE;
                            $column_length      = isset($field_info[0]->CHARACTER_MAXIMUM_LENGTH) ? $field_info[0]->CHARACTER_MAXIMUM_LENGTH : null;

                            if ( $column_type == "datetime" && $table_column_name != 'created_at' && $table_column_name != 'updated_at' && $table_column_name != 'deleted_at' ) {
                                // column type is date so we display specific input for datetime
                                echo "<td>";
                                    echo "<input type='datetime-local' name='new-row-" . esc_attr($column_id) . "'>";
                                echo "</td>";

                            } else if ($column_type == "mediumtext" || $column_type == "longtext" ) {
                                // Rich text, Long text and Attachment do not have insert for now
                                echo "<td>";
                                    echo "<input type='text' name='new-row-" . esc_attr($column_id) . "'";
                                echo "</td>";

                            } else if( $column_type == "longblob" ) {
                                echo "<td>";
                                    echo "<input type='file' name='new-row-" . esc_attr($column_id) . "'>";
                                echo "</td>";

                            } else if ( $column_type == "bit" ) {
                                // column type is bit so we display specific select with Yes and No
                                $default_yes_selected = (!empty($column_default) && $column_default == "b'1'") ? "selected" : '';
                                $default_no_selected  = (!empty($column_default) && $column_default == "b'0'") ? "selected" : '';

                                echo "<td>";
                                    echo "<select name='new-row-" . esc_attr($column_id) . "'>";
                                        echo "<option value='Yes' " . esc_attr($default_yes_selected) . ">Yes</option>";
                                        echo "<option value='No' " . esc_attr($default_no_selected) . ">No</option>";
                                    echo "</select>";
                                echo "</td>";

                            } else if ( $column_type . "($column_length)" == "varchar(100)" ) {
                                // column type is Lookup table, we need to display data from selected lookup table that is saved in table metadata
                                // $get_metadata_sql = "SELECT metadata FROM " . $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata WHERE table_name = \"$table_name\"";
                                $metadata_column = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";
                                $metadata_json    = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                    $wpdb->prepare(
                                        "SELECT `metadata` FROM `$metadata_column` WHERE table_name = %s", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                        array($table_name)
                                    )
                                );
                                $metadata         = json_decode($metadata_json, true);
                                $lookup_tables    = isset($metadata['lookup_tables']) ? $metadata['lookup_tables'] : null;

                                if (isset($lookup_tables)) {
                                    foreach($lookup_tables as $table) {
                                        foreach($table as $key=>$lookup_table) {
                                            $col_name_arr = explode('_', $key);
                                            $col_id       = end($col_name_arr);
                                            $col_name     = str_replace('_' . $col_id, '', $key);

                                            // current column id and column id from metadata table are matching so we display records for it
                                            if($column_id == $col_id) {
                                                $lookup_table      = explode('.', $lookup_table);
                                                $lookup_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $lookup_table[0];
                                                $lookup_field_name = $lookup_table[1];

                                                // select all records that are not deleted from lookup table for lookup field
                                                // $data_from_lookup_table_sql = "SELECT $lookup_field_name FROM $lookup_table_name WHERE `deleted_at` IS NULL";
                                                $lookup_table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                                    $wpdb->prepare("SELECT `$lookup_field_name` FROM `$lookup_table_name` WHERE `deleted_at` IS NULL") // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                                );
                                                echo "<td>";
                                                    echo "<select name='new-row-" . esc_attr($column_id) . "'>";
                                                        foreach($lookup_table_data as $lookup_data) {
                                                            echo "<option value='" . esc_attr($lookup_data->$lookup_field_name) . "'>" . esc_html($lookup_data->$lookup_field_name) . "</option>";
                                                        }
                                                    echo "</select>";
                                                echo "</td>";
                                            }
                                        }
                                    }
                                }

                            } else if( $column_type == "enum") {
                                $column_type_enum = rtrim($column_type_enum, '\')');
                                $column_type_enum = substr($column_type_enum, 6);
                                $enum_values      = explode("','", $column_type_enum);

                                echo "<td>";
                                    echo "<select name='new-row-" . esc_attr($column_id) . "'>";
                                        foreach($enum_values as $enum_value ) {
                                            if(str_contains($enum_value, '"')) {
                                                echo "<option value='" . esc_attr($enum_value) . "'>" . esc_html($enum_value) . "</option>";
                                            }
                                            if(str_contains($enum_value, "'")) {
                                                $enum_value = str_replace("''", "'", $enum_value);
                                                echo '<option value="' . esc_attr($enum_value) . '">' . esc_html($enum_value) . "</option>";
                                            }

                                            if(!str_contains($enum_value, '"') && !str_contains($enum_value, "'")) {
                                                echo '<option value="' . esc_attr($enum_value) . '">' . esc_html($enum_value) . "</option>";
                                            }

                                        }
                                    echo "</select>";
                                echo "</td>";

                            } else if ( $table_column_name != 'id' && $table_column_name != 'created_at' && $table_column_name != 'updated_at' && $table_column_name != 'deleted_at' ){
                                $previous_value = isset($_POST["new-row-$column_id"]) ? sanitize_text_field(wp_unslash($_POST["new-row-$column_id"])) : '';
                                // text input for other column types such as number, big number, currency...
                                echo "<td><input type='text' name='new-row-" . esc_attr($column_id) . "' value='" . esc_attr($previous_value) . "'></td>";

                            }

                            $input_id++;
                        }
                    ?>
                    <td>
                        <input type='submit' class='button button-primary' name='add-new-column' id='add-new-column' value='<?php esc_attr_e('Add Record', 'black-desk')?>'>
                        <?php wp_nonce_field('bdds-table-view'); ?>
                    </td>
                    <td></td>
                </tr>
            </tbody>

            <tfoot>
                <tr>
                    <td class="manage-column column-cb check-column">
                        <input type="checkbox">
                    </td>
                    <?php
                        foreach( $fields as $field ) {
                            // field is not in show_fields array so we skip that field and check next
                            if( !empty($show_fields) && !in_array($field, $show_fields) ) continue;

                            // orderby_order variable is url which contains get methods for sorting
                            $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "DESC" ) );
                            if ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] == "DESC" ) {
                                $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "ASC" ) );
                            } else if ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] == "ASC" ) {
                                $orderby_order = add_query_arg( array( "orderby" => $field, "order" => "DESC" ) );
                            }

                            echo '<th scope="col" class="manage-column column-title column-primary sorted ' . esc_attr($order_class) . '" aria-sort="ascending"' . esc_attr($id) . ' >';
                                echo '<a href="' . esc_url($orderby_order) . '">';
                                    echo "<span>". esc_html($field) ."</span>";
                                    echo "<span class='sorting-indicator'>";
                                        echo '<span class="sorting-indicator asc" aria-hidden="true"></span>';
                                        echo '<span class="sorting-indicator desc" aria-hidden="true"></span>';
                                    echo "</span>";
                                echo '</a>';
                            echo '</th>';

                        }
                        // table header for Delete
                        echo "<th></th>";
                    ?>
                </tr>
            </tfoot>
        </table>

        <div class="tablenav bottom">
            <div class="alignleft bulkactions actions">
                    <select name="action2" id="">
                        <option value="" selected><?php esc_html_e('Bulk actions', 'black-desk'); ?></option>
                        <option value="delete_action_2"><?php esc_html_e('Delete', 'black-desk'); ?></option>
                    </select>
                    <input type="submit" class="button" id="doaction2" value="<?php esc_attr_e('Apply', 'black-desk'); ?>">
            </div>
        </div>
    </form>
</div>
<?php } ?>