<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<div>
    <h2>
        <?php esc_html_e('Do you really want to truncate this table', 'black-desk');?>? 
        <?php esc_html_e('This action can not be undone', 'black-desk')?>! <?php esc_html_e('All data in this table will be lost', 'black-desk')?>! 
    </h2>
    
    <?php 
        global $wpdb;
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        $table_name = isset($_GET[ 'table_name' ]) && 
            (wp_verify_nonce($nonce, "bdds-truncate-table-nonce") || wp_verify_nonce($nonce, "view-truncate-table-nonce")) 
            ? sanitize_text_field(wp_unslash($_GET[ 'table_name' ])) : null;
    ?>

    <form method="POST">
        <input type="hidden" name="table_name" value="<?php echo esc_attr($table_name);?>">
        <input type="submit" class='button button-primary' id="yes-input" name="yes-input" value="<?php esc_attr_e('Yes', 'black-desk'); ?>">
        <input type="submit" class='button button-primary' id="no-input" name="no-input" value="<?php esc_attr_e('No', 'black-desk'); ?>">
        <?php wp_nonce_field("bdds-truncate-table"); ?>
    </form>


</div>