<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/BDDS_Type_Constants.php";

    global $wpdb;
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $table_name = (
        wp_verify_nonce($nonce, "bdds-edit-nonce") || wp_verify_nonce($nonce, "bdds-edit-add-column-nonce")
        || wp_verify_nonce($nonce, "bdds-edit-drop-column-nonce")
    ) || wp_verify_nonce($nonce, "bdds-change-structure-nonce") ? (isset($_GET[ 'table_name' ]) ? sanitize_text_field(wp_unslash($_GET[ 'table_name' ])) : null) : null;

    $table_comment = $wpdb->get_var(  // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->prepare( "SELECT table_comment FROM INFORMATION_SCHEMA.TABLES WHERE table_name=%s;", $table_name )
    );

    $table_structure_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->prepare(
            "SELECT ORDINAL_POSITION,COLUMN_NAME,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,COLLATION_NAME,IS_NULLABLE,COLUMN_DEFAULT,EXTRA FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME=%s ORDER BY ORDINAL_POSITION ASC;",
            $table_name
        )
    );

    if ( isset( $_POST[ BDDS_PLUGIN_PREFIX . '-new-table-description' ] ) && !empty( $_POST[ BDDS_PLUGIN_PREFIX . '-new-table-description' ] ) ) {
        $new_table_description = sanitize_text_field( wp_unslash($_POST[ BDDS_PLUGIN_PREFIX . '-new-table-description' ]) );

        $wpdb->query( $wpdb->prepare( "ALTER TABLE `$table_name` COMMENT = %s;", $new_table_description ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

        BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
            'Table description successfully updated!', 'success'
        );
    }


?>
<div class="wrap">
    <h2>
        <?php esc_html_e('Edit Table', 'black-desk'); ?> - <?php echo esc_html(str_replace( $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_name )); ?>
    </h2>

    <form id="edit-table-structure" method="post">
        <table class="form-table">
            <tr>
                <td>
                    <input
                        type="text"
                        name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-table-name"
                        value="<?php echo esc_attr(str_replace($wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_name));?>"
                        pattern="^[a-z0-9_]+$"
                        title="<?php esc_attr_e('Only lowercase Latin letters, underscore and numbers', 'black-desk'); ?>"
                    >
                    <input type="submit" id="" class="button" name="action-change-table-name" value="<?php esc_html_e('Change Table Name', 'black-desk')?>" >
                </td>
            </tr>

            <tr>
                <td>
                    <textarea id="" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-table-description" rows="2" cols="25"><?php echo esc_textarea($table_comment); ?></textarea>
                    <input type="submit" id="" class="button" name="action-change-table-description" value="<?php esc_html_e('Change Table Description', 'black-desk')?>">
                </td>
            </tr>
        </table>
    </form>

    <form>
        <table class="wp-list-table widefat fixed striped table-view-excerpt">
            <thead>
                <th>#</th>
                <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
                <th><?php esc_html_e('Column Type', 'black-desk'); ?></th>
                <th>Collation</th>
                <th><?php esc_html_e('Null', 'black-desk'); ?></th>
                <th><?php esc_html_e('Default', 'black-desk'); ?></th>
                <th><?php esc_html_e('Extra', 'black-desk'); ?></th>
                <th><?php esc_html_e('Action', 'black-desk'); ?></th>
            </thead>

            <tbody>
                <?php

                    foreach( $table_structure_result as $table_object ) {
                        $column_id        = $table_object->ORDINAL_POSITION;
                        $column_name      = $table_object->COLUMN_NAME;
                        $column_type      = $table_object->DATA_TYPE;
                        $column_type_len  = $table_object->CHARACTER_MAXIMUM_LENGTH;
                        $column_collation = $table_object->COLLATION_NAME;
                        $column_is_null   = $table_object->IS_NULLABLE;
                        $column_default   = $table_object->COLUMN_DEFAULT;
                        $column_extra     = $table_object->EXTRA;

                        if(str_contains($column_type, "bit") && $column_default == "b'1'") {
                            $column_default = "Yes";
                        } else if (str_contains($column_type, "bit") && $column_default == "b'0'"){
                            $column_default = "No";
                        }
                        $column_type = $column_type . "($column_type_len)";

                        switch ( $column_type ) {
                            case "varchar(255)":
                                $column_type = BDDS_Type_Constants::SHORT_TEXT;
                                break;
                            case "int()":
                                $column_type = BDDS_Type_Constants::NUMBER;
                                break;
                            case "bigint()":
                                $column_type = BDDS_Type_Constants::BIG_NUMBER;
                                break;
                            case "decimal()":
                                $column_type = BDDS_Type_Constants::CURRENCY;
                                break;
                            case "datetime()":
                                $column_type = BDDS_Type_Constants::DATE_TIME;
                                break;
                            case "varchar(100)":
                                $column_type = BDDS_Type_Constants::LOOKUP;
                                break;
                            case "bit()":
                                $column_type = BDDS_Type_Constants::YES_NO;
                                break;
                            case str_contains($column_type, "mediumtext"):
                                $column_type = BDDS_Type_Constants::RICH_TEXT;
                                break;
                            case str_contains($column_type, "longtext"):
                                $column_type = BDDS_Type_Constants::LONG_TEXT;
                                break;
                            case str_contains($column_type, "longblob"):
                                $column_type = BDDS_Type_Constants::ATTACHMENT;
                                break;
                            case "varchar(1024)":
                                $column_type = BDDS_Type_Constants::HYPERLINK;
                                break;
                            case str_starts_with($column_type, "enum"):
                                $column_type = BDDS_Type_Constants::ENUM;
                                break;
                            default:
                                echo "Unexpected value was passed!";
                                break;
                        }

                        echo "<tr>";
                            echo "<td>" . esc_html($column_id) . "</td>";
                            echo "<td>" . esc_html($column_name) . "</td>";
                            echo "<td>" . esc_html($column_type) . "</td>";
                            echo "<td>" . esc_html($column_collation) . "</td>";
                            echo "<td>" . esc_html($column_is_null) . "</td>";
                            echo "<td>" . esc_html($column_default) . "</td>";
                            echo "<td>" . esc_html($column_extra) . "</td>";
                            if ( $column_name == "id" || $column_name == "created_at" || $column_name == "deleted_at" || $column_name == "updated_at" ) {
                                echo "<td></td>";
                            } else {
                                $text = "Are you sure you want to drop this column?";
                                $drop_url = add_query_arg( array('column_name' => $column_name) );

                                echo "<td>";
                                    echo "<a href='" . esc_url( add_query_arg( array(
                                        'action' => 'change',
                                        'column_name' => $column_name,
                                        "_wpnonce" => wp_create_nonce("bdds-change-structure-nonce")
                                    ))) . "'>" . esc_html__('Change', 'black-desk') . "</a> ";

                                    echo "<a href='" . esc_url(add_query_arg(array(
                                        'action' => 'drop',
                                        'column_name' => $column_name,
                                        "_wpnonce"  => wp_create_nonce("bdds-edit-drop-column-nonce")
                                    ))) . "' style='color:red;cursor:pointer;'>" . esc_html__('Drop', 'black-desk') . "</a>";
                                echo "</td>";
                            }
                        echo "</tr>";
                    }
                ?>

            </tbody>
        </table>
    </form>

    <div style="margin-top: 1.5em;float:left;">
        <?php $back = remove_query_arg(array("action", "table_name", "_wpnonce")); ?>
        <a href="<?php echo esc_url($back); ?>" class="button button-primary"><?php esc_html_e('Back', 'black-desk')?></a>
    </div>

    <div style="margin-top: 1.5em;float:right;">
        <?php $redirect_url = add_query_arg(array(
            "action" => "add_column",
            "_wpnonce" => wp_create_nonce("bdds-edit-add-column-nonce")
        )); ?>
        <a href="<?php echo esc_url($redirect_url); ?>" class="button button-primary"><?php esc_html_e('Add new column', 'black-desk')?></a>
    </div>

</div>