<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<div>
    <?php 
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        $record_id_to_delete = (isset($_GET["record_id"]) && wp_verify_nonce($nonce, "bdds-drop-row-nonce")) ? sanitize_text_field(wp_unslash($_GET["record_id"])) : null;
    ?>
    
    <h2>
        <?php esc_html_e('Are you sure you want to delete record with id ', 'black-desk')?> <?php echo esc_html($record_id_to_delete); ?></h2>

    <form method="post">
        <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-drop-row" value="<?php esc_attr_e('Yes', 'black-desk');?>">
        <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-no-drop-row" value="<?php esc_attr_e('No', 'black-desk');?>">
        <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-record-id-delete" value="<?php echo esc_attr($record_id_to_delete); ?>">
        <?php wp_nonce_field("bdds-drop-row-nonce"); ?>
    </form>
</div>