<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    $column_name = (isset($_GET["column_name"]) && check_admin_referer("bdds-edit-drop-column-nonce")) ? sanitize_text_field(wp_unslash($_GET["column_name"])) : '';
?>

<form method="post">
    <h3><?php esc_html_e('Are you sure you want to delete', 'black-desk'); ?> "<?php echo esc_html($column_name); ?>" <?php esc_html_e('column','black-desk'); ?></h3>
    <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-drop-column" value="<?php esc_attr_e('Yes', 'black-desk');?>">
    <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-no-drop-column" value="<?php esc_attr_e('No', 'black-desk');?>">
    <input type="hidden" name="column_name" value="<?php echo esc_attr($column_name); ?>">
</form>