<?php
    if ( ! defined( 'ABSPATH' ) ) exit;
    /* 
        DROP TABLE 
    */
?>
<div>
    <h2><?php esc_html_e('Do you really want to drop this table', 'black-desk'); ?>? <?php esc_html_e('This action can not be undone', 'black-desk')?>!</h2>
    
    <?php 
        global $wpdb; 
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        $table_name = (isset( $_GET[ 'table_name' ] ) && wp_verify_nonce($nonce, "bdds-drop-table-nonce")) ? sanitize_text_field(wp_unslash($_GET[ 'table_name' ])) : null;
        $back_url = remove_query_arg( array( "action", "table_name" ), false );
        $metadata_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";
    ?>

    <form method="post" style="display: inline;">
        <input type="hidden" name="table_name" value="<?php echo esc_attr($table_name);?>">
        <input type="submit" class='button button-primary' name="yes-delete" value="<?php esc_attr_e('Yes', 'black-desk');?>">
        <?php wp_nonce_field("bdds-drop-table"); ?>
    </form>

    <a href="<?php echo esc_url($back_url); ?>">
        <button class='button button-primary'><?php esc_html_e('No', 'black-desk'); ?></button>
    </a>

</div>