<?php
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    require_once BDDS_PLUGIN_DIR . 'admin/classes/BDDS_Type_Constants.php';

    global $wpdb;
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $table_name = (isset( $_GET['table_name'] ) && wp_verify_nonce($nonce, "bdds-change-structure-nonce")) ? sanitize_text_field(wp_unslash($_GET['table_name'])) : "No table name";

    $table_structure_result = $wpdb->get_results( $wpdb->prepare("DESC $table_name"), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $metadata_table_name    = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";
    $column_name_err;

    $table_metadata   = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->prepare(
            "SELECT `metadata` FROM `$metadata_table_name` WHERE table_name = %s", $table_name // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        ), ARRAY_A);
    $table_meta       = isset($table_metadata[0]["metadata"]) ? $table_metadata[0]["metadata"] : null;
    $metadata         = json_decode($table_meta, true);
    $lookup_tables    = isset($metadata["lookup_tables"]) ? $metadata["lookup_tables"] : null;

    $column_name     = isset( $_GET['column_name'] ) ? sanitize_text_field(wp_unslash($_GET['column_name'])) : null;
    $column_desc     = $wpdb->get_results( $wpdb->prepare( "DESCRIBE `$table_name` `$column_name`" ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $column_default  = isset($column_desc[0]->Default) ? $column_desc[0]->Default : null;
    $field_type      = isset($column_desc[0]->Type) ? $column_desc[0]->Type : null;

    if(isset($_POST[BDDS_PLUGIN_PREFIX . "-selected-type"])) {
        $field_type = sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-selected-type"]));
    }

    $field_options  = BDDS_Admin::getFieldType($field_type);
    $option_type    = isset($field_options[0]) ? $field_options[0] : null;
    $option_pattern = isset($field_options[1]) ? $field_options[1] : null;
    $option_title   = isset($field_options[2]) ? $field_options[2] : null;
?>

<form method="post">
    <table class="form-table">
        <tbody>
            <tr>
                <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
                <td>
                    <input type="text" name="column_name" class="regular-text" value="<?php echo esc_attr($column_name); ?>" pattern="^[a-zA-Z0-9_]+$" required title="Only lower and upper case alphanumeric character's and underscore's">
                    <br>
                    <?php 
                        if(isset($column_name_err) && !empty($column_name_err)) {
                            echo "<span style='color:red;'>" . esc_html($column_name_err) . "</span>";
                        }
                    ?>
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Column Type', 'black-desk'); ?></th>
                <td>
                    <select name="column_type" id="column-types" class="regular-text">
                        <option value="varchar(255)" <?php if ($field_type == "varchar(255)") echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::SHORT_TEXT); ?>
                        </option>
                        <option value="int" <?php if (str_starts_with($field_type, "int")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::NUMBER); ?>
                        </option>
                        <option value="bigint" <?php if (str_contains($field_type, "bigint")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::BIG_NUMBER); ?>
                        </option>
                        <option value="decimal" <?php if (str_contains($field_type, "decimal")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::CURRENCY); ?>
                        </option>
                        <option value="datetime" <?php if (str_contains($field_type, "datetime")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::DATE_TIME); ?>
                        </option>
                        <option value="bit" <?php if (str_contains($field_type, "bit")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::YES_NO); ?>
                        </option>
                        <option value="varchar(100)" <?php if (str_contains($field_type, "varchar(100)")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::LOOKUP); ?>
                        </option>
                        <option value="mediumtext" <?php if (str_contains($field_type, "mediumtext")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::RICH_TEXT); ?>
                        </option>
                        <option value="longtext" <?php if (str_contains($field_type, "longtext")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::LONG_TEXT); ?>
                        </option>
                        <option value="longblob" <?php if (str_contains($field_type, "longblob")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::ATTACHMENT); ?>
                        </option>
                        <option value="varchar(1024)" <?php if (str_contains($field_type, "varchar(1024)")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::HYPERLINK); ?>
                        </option>
                        <option value="ENUM" <?php if (str_starts_with($field_type, "enum")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::ENUM); ?>
                        </option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Null', 'black-desk'); ?></th>
                <td>
                    <?php 
                        $column_n = isset( $_GET[ 'column_name' ] ) ? sanitize_text_field(wp_unslash($_GET[ 'column_name' ])) : null;
                        foreach( $table_structure_result as $table_structure ) {
                            if( $column_n == $table_structure->Field ) {
                                $is_nullable = $table_structure->Null;
                            }
                        }
                        
                    ?>
                    <input type="hidden" id="hidden-null-checkbox" name="hidden_null" value="<?php echo esc_attr($is_nullable); ?>">
                    <input type="checkbox" id="column-null-checkbox" name="current_column_nullable" value="<?php echo esc_attr($is_nullable); ?>" > 
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Default Value', 'black-desk'); ?></th>
                <td id="default-value-td">
                    <?php if (str_contains($field_type, "datetime")) { ?>
                        
                        <input class='regular-text' type='datetime-local' name='column_default' value="<?php echo esc_attr($column_desc[0]->Default); ?>">
                        
                    <?php } else if (str_contains($field_type, "bit")) { ?>         

                        <select name="column_default">
                            <option value='empty'>-<?php esc_html_e('Choose an option', 'black-desk'); ?>-</option>
                            <option value='1' <?php echo ($column_desc[0]->Default == "b'1'") ? "selected":''; ?>>Yes</option>
                            <option value='0' <?php echo ($column_desc[0]->Default == "b'0'") ? "selected":''; ?>>No</option>
                        </select>

                    <?php } else if (str_contains($field_type, "mediumtext") || str_contains($field_type, "longtext") || str_contains($field_type, "longblob")) { 
                        // Rich text, Long text and Attachment can't have a default value ?>

                    <?php } else if (str_starts_with($field_type, "enum")) { ?>
                        <span>If an <b>ENUM</b> column is declared <b>NOT NULL</b>, its <b>default value</b></span><br>
                        <span>  is the first element of the list of permitted values.</span>

                    <?php } else { ?>
                        <input class="regular-text" type="text" name="column_default" 
                         value="<?php echo isset($column_desc[0]->Default) ? esc_attr($column_desc[0]->Default) : ''; ?>" 
                         pattern="<?php echo esc_attr($option_pattern); ?>"
                         title="<?php echo esc_attr($option_title); ?>">
                        <br>
                        <?php 
                            if( isset($is_valid_default) && $is_valid_default != "valid" ) {
                                echo "<span style='color:red;'>" . esc_html($is_valid_default) . "</span>";
                            }
                        ?>
                    <?php } ?>
                </td>
            </tr>
            <tr>
            <?php if ($field_type == "varchar(100)" && !empty($lookup_tables)) { ?>
                <th><?php esc_html_e('Lookup field', 'black-desk'); ?></th>
                <td>
                    <?php 
                        $current_db = $wpdb->dbname;
                        $post_lookup_table = (isset($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"])) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"])) : '';
                        $column_id = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                            "SELECT ORDINAL_POSITION FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name =%s AND COLUMN_NAME = %s;",
                            array($table_name, $column_name)
                        )); 
                        // array_column($lookup_tables, "column_$column_id") => returns value from metadata table that corresponds to selected column
                        // explode array_column($lookup_tables, "column_$column_id") by '.' to get lookup table name and lookup table field
                        $column_lookup = isset(array_column($lookup_tables, "column_$column_id")[0]) ? array_column($lookup_tables, "column_$column_id")[0] : null;
                        $selected_lookup_table_and_field = explode('.', $column_lookup);
                        $selected_lookup_table = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $selected_lookup_table_and_field[0];
                        $selected_lookup_field = isset($selected_lookup_table_and_field[1]) ? $selected_lookup_table_and_field[1] : null;

                        $get_columns_sql = "SHOW COLUMNS FROM $selected_lookup_table;";
                        $columns = $wpdb->get_results($wpdb->prepare("SHOW COLUMNS FROM `$selected_lookup_table`;")); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    ?>
                    <label><b><?php echo esc_html(str_replace($wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $selected_lookup_table)); ?></b></label>
                    <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-lookup-field">
                        <option value=''>-<?php esc_html_e('Choose a field', 'black-desk'); ?>-</option>
                        <?php
                            foreach($columns as $lookup_column) {
                                $lookup_column_name = $lookup_column->Field;
                                
                                echo ($selected_lookup_field == $lookup_column_name) ? 
                                     "<option value='" . esc_attr($lookup_column_name) . "' selected>" . esc_html($lookup_column_name) . "</option>" : 
                                     "<option value='" . esc_attr($lookup_column_name) . "'>" . esc_html($lookup_column_name) . "</option>";
                            }
                        ?>
                    </select>
                    <?php } ?>
                </td>
            </tr>
            <?php if (str_starts_with($field_type, "enum")) { ?>
                <th>ENUM Values</th>
                <td>
                    <?php 
                        $enum_values = substr($field_type, 6, strlen($field_type));
                        $enum_values = rtrim($enum_values, "')");  
                        $enum_values_arr = explode("','", $enum_values);
                    ?>
                    <textarea name="new-enum-values" class="regular-text" rows="5"><?php 
                        foreach($enum_values_arr as $enum_value) {
                            echo esc_textarea($enum_value) . "\n";
                        }
                        ?>
                    </textarea>
                    <br>
                    <label for="">
                        <i>All values should be one below another</i>
                    </label>
                </td>
            <?php } ?>
        </tbody>

        <tfoot>
            <tr>
                <td>
                    <?php 
                        $back = remove_query_arg("column_name");
                        $back = str_replace( "action=change", "action=edit", $back );
                    ?>
                    <a href="<?php echo esc_url($back); ?>" class="button button-primary"><?php esc_html_e('Back', 'black-desk');?></a>
                </td>
                <td>
                    <input class="button button-primary" type="submit" name="saved" value="<?php esc_attr_e('Save', 'black-desk'); ?>">
                </td>
            </tr>
        </tfoot>
        <?php wp_nonce_field("bdds-save-structure-change-nonce")?>
    </table>
</form>

<form method="post" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-form">
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-table-select" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-table-select">
    <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-type" value="Lookup">
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-selected-type" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-selected-type">
</form>