<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/BDDS_Type_Constants.php";

    global $wpdb;
    $bdds_admin = BDDS_Admin::get_instance();
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $table_name             = (isset($_GET["table_name"]) && wp_verify_nonce($nonce, "bdds-edit-add-column-nonce")) ? sanitize_text_field(wp_unslash($_GET["table_name"])) : '';
    $table_prefix           = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";
    $formatted_table_name   = str_replace($table_prefix, '', $table_name);
    $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $field_type             = isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-type"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-new-column-type"])) : "varchar(255)";
    $field_options          = BDDS_Admin::getFieldType($field_type);
    $option_pattern         = isset($field_options[1]) ? $field_options[1] : '';
    $column_name_err        = '';
    $wpdb_err               = '';

    if(isset($_GET["action"]) && $_GET["action"] = "add_column") {
        wp_dequeue_script("admin_add_table_script");
    }

    // "varchar(100)" == Lookup type of field
    if((isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-lookup-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-new-column-lookup-type"] == "Lookup") || $field_type == "varchar(100)") {
        $field_type = "varchar(100)";
    }

    $new_column_name = isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-name"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-new-column-name"])) : '';
    $new_column_default = isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-default"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-new-column-default"])) : '';
?>

<h3><?php esc_html_e('Add column to', 'black-desk'); ?> "<?php echo esc_html($formatted_table_name);?>"</h3>

<?php
    if(isset($column_name_err) && !empty($column_name_err)) {
        $bdds_admin->bdds_set_and_display_admin_notice(esc_html($column_name_err), 'error');
    }

    if (isset($wpdb_err) && !empty($wpdb_err)) {
        $bdds_admin->bdds_set_and_display_admin_notice(esc_html($wpdb->last_error), 'error');
    }

    if(isset($default_value_error) && !empty($default_value_error)) {
        $bdds_admin->bdds_set_and_display_admin_notice(esc_html($default_value_error), 'error');
    }
?>

<form method="post" id="<?php echo esc_html(BDDS_PLUGIN_PREFIX); ?>-add-new-column-form">
    <table class="form-table">
        <tbody>
            <tr>
                <th>
                    <?php esc_html_e('Column Name', 'black-desk'); ?>
                    <span style="color:red;">*</span>
                </th>
                <td>
                    <input
                        required
                        type="text"
                        name="<?php echo esc_html(BDDS_PLUGIN_PREFIX); ?>-new-column-name"
                        id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-name"
                        class="regular-text" pattern="^[a-zA-Z0-9_]+$"
                        value="<?php echo isset($new_column_name) ? esc_attr($new_column_name) : ''; ?>"
                    >
                    <br>
                    <?php
                        if(isset($column_name_err)) {
                            echo "<span style='color:red;'>" . esc_html($column_name_err) . "</span>";
                        }

                    ?>
                </td>
            </tr>

            <tr>
                <th>
                    <?php esc_html_e('Column Type', 'black-desk'); ?>
                    <span style="color:red;">*</span>
                </th>
                <td>
                    <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-type" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-type" required>
                        <option value="varchar(255)" <?php if ($field_type == "varchar(255)") echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::SHORT_TEXT); ?>
                        </option>
                        <option value="int" <?php if (str_starts_with($field_type, "int")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::NUMBER); ?>
                        </option>
                        <option value="bigint" <?php if (str_contains($field_type, "bigint")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::BIG_NUMBER); ?>
                        </option>
                        <option value="decimal" <?php if (str_contains($field_type, "decimal")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::CURRENCY); ?>
                        </option>
                        <option value="datetime" <?php if (str_contains($field_type, "datetime")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::DATE_TIME); ?>
                        </option>
                        <option value="bit" <?php if (str_contains($field_type, "bit")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::YES_NO); ?>
                        </option>
                        <option value="varchar(100)" <?php if (str_contains($field_type, "varchar(100)")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::LOOKUP); ?>
                        </option>
                        <option value="mediumtext" <?php if (str_contains($field_type, "mediumtext")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::RICH_TEXT); ?>
                        </option>
                        <option value="longtext" <?php if (str_contains($field_type, "longtext")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::LONG_TEXT); ?>
                        </option>
                        <option value="longblob" <?php if (str_contains($field_type, "longblob")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::ATTACHMENT); ?>
                        </option>
                        <option value="varchar(1024)" <?php if (str_contains($field_type, "varchar(1024)")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::HYPERLINK); ?>
                        </option>
                        <option value="enum" <?php if (str_starts_with($field_type, "enum")) echo "selected"; ?> >
                            <?php echo esc_html(BDDS_Type_Constants::ENUM); ?>
                        </option>
                    </select>
                </td>
            </tr>

            <tr>
                <th><?php esc_html_e('Null', 'black-desk'); ?></th>
                <td>
                    <input
                        type="checkbox"
                        name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-null"
                        id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-null"
                        <?php echo isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-null"]) ? "checked" : ''; ?>
                    >
                </td>
            </tr>

            <tr>
                <th><?php esc_html_e('Default', 'black-desk'); ?></th>
                <td>
                    <?php if(isset($field_type) && $field_type == "datetime") { ?>
                        <input
                            type="datetime-local"
                            name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            class="regular-text"
                            value="<?php echo isset($new_column_default) ? esc_attr($new_column_default) : '';?>"
                        >

                    <?php } else if (isset($field_type) && $field_type == "bit") { ?>
                        <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>

                    <?php } else if (isset($field_type) && $field_type == "varchar(100)") { ?>
                        <input
                            type="text"
                            name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            class="regular-text"
                            value="<?php echo isset($new_column_default) ? esc_attr($new_column_default) : '';?>"
                        >

                    <?php } else if (isset($field_type) && ($field_type == "mediumtext" || $field_type == "longtext" || $field_type == "longblob" )) {?>

                    <?php } else if (isset($field_type) && $field_type == "varchar(1024)") { ?>
                        <input
                            type="url"
                            name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            class="regular-text"
                            value="<?php echo isset($new_column_default) ? esc_attr($new_column_default) : '';?>"
                        >

                    <?php } else if (isset($field_type) && $field_type == "enum") { ?>
                        <span>If an <b>ENUM</b> column is declared <b>NOT NULL</b>, its <b>default value</b></span><br>
                        <span>  is the first element of the list of permitted values.</span>

                    <?php } else { ?>
                        <input
                            type="text"
                            name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-default"
                            class="regular-text" pattern="<?php echo esc_attr($option_pattern); ?>"
                            value="<?php echo isset($new_column_default) ? esc_attr($new_column_default) : '';?>"
                        >

                    <?php } ?>

                    <br>
                    <?php
                        if(isset($default_value_error) && !empty($default_value_error)) {
                            echo "<span style='color:red;'>" . esc_html($default_value_error) . "</span>";
                        }
                    ?>
                </td>
            </tr>

            <tr>
                <?php if($field_type == "varchar(100)") {?>
                    <th><?php esc_html_e('Lookup table and field', 'black-desk') ?></th>
                    <td>
                        <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup-table" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup-table">
                                <option value=''>-<?php esc_html_e('Choose a table', 'black-desk'); ?>-</option>
                        <?php
                            $current_db = $wpdb->dbname;
                            $created_tables = $wpdb->get_results("SHOW TABLES;", ARRAY_A); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $lookup_table = isset($_POST[BDDS_PLUGIN_PREFIX . "-new-column-lookup"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-new-column-lookup"])) : '';

                            foreach($created_tables as $created_t) {
                                foreach($created_t as $created_table) {
                                    $table_name = $created_table;
                                    $table_name_without_prefix = str_replace($table_prefix, '', $table_name);
                                    if( str_contains($table_name, $table_prefix) && $table_name != $table_prefix . "table_metadata" && $table_name != $table_prefix . "queries") {

                                        if(isset($lookup_table) && $table_name == $table_prefix . $lookup_table ) {
                                            echo "<option value='" . esc_attr($table_name_without_prefix) . "' selected>" . esc_html($table_name_without_prefix) . "</option>";

                                        } else {
                                            echo "<option value='" . esc_attr($table_name_without_prefix) . "'>" . esc_html($table_name_without_prefix) . "</option>";

                                        }

                                    }
                                }
                            }
                        ?>
                        </select>

                        <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup-field">
                            <option value=''>-<?php esc_html_e('Choose a field', 'black-desk'); ?>-</option>
                            <?php
                                $current_db = $wpdb->dbname;
                                $selected_lookup_table = (!empty($lookup_table)) ? $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $lookup_table : '';

                                $selected_table_columns = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                    $wpdb->prepare(
                                        "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s;",
                                        array($current_db, $selected_lookup_table)
                                    )
                                );

                                foreach($selected_table_columns as $selected_table) {
                                    $column_name = $selected_table->COLUMN_NAME;
                                    echo "<option value='" . esc_attr($column_name) . "'>" . esc_html($column_name) . "</option>";
                                }
                            ?>
                        </select>
                    </td>
                <?php } else if ($field_type == "enum") { ?>
                    <th>ENUM Values</th>
                    <td>
                        <textarea name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-enum-values" class="regular-text" rows="5"></textarea>
                        <br>
                        <label for="">
                            <i>All values should be one below another</i>
                        </label>
                    </td>

                <?php } ?>
            </tr>

            <tr>
                <th><?php esc_html_e('Insert column after', 'black-desk') ?></th>
                <td>
                    <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-insert-after">
                        <?php
                            foreach($table_structure_result as $table_structure) {
                                $field_name = $table_structure->Field;
                                if($field_name == "created_at" || $field_name == "updated_at" || $field_name == "deleted_at") continue;
                                echo "<option value='" . esc_attr($field_name) . "'>" . esc_html($field_name) . "</option>";
                            }
                        ?>
                    </select>
                </td>
            </tr>
        </tbody>

        <tfoot>
            <tr>
                <td>
                    <input
                        type="submit"
                        name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-back"
                        id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-back"
                        class="button button-primary"
                        value="<?php esc_attr_e('Back', 'black-desk')?>"
                    >
                </td>
                <td>
                    <input
                        type="submit"
                        name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-save-new-column"
                        id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-save-new-column"
                        class="button button-primary"
                        value="<?php esc_attr_e('Add new column', 'black-desk')?>"
                    >
                </td>
            </tr>
            <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-selected-type" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-selected-type">
            <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup-type" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup-type">
            <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-new-column-lookup">

        </tfoot>
    </table>
</form>

<form method="post" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-back-form">
    <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-back" id="" value="back">
</form>