const BDDS_PLUGIN_PREFIX = "bdds";

let doActionInput = document.getElementById( 'doaction' );
let doActionInput2 = document.getElementById( 'doaction2' );
let tableFilterForm = document.getElementById( 'tables_filter' );
let editSelectTypeInput = document.getElementById( 'column-types' );
let lookupTableSelectEl = document.getElementById( BDDS_PLUGIN_PREFIX + '-new-lookup-table' );
let lookupTableInputStructure = document.getElementById( BDDS_PLUGIN_PREFIX + '-lookup-table-select' );
let lookupFormStructure = document.getElementById( BDDS_PLUGIN_PREFIX + '-lookup-form' );
let columnDefaultInput = document.getElementById( 'column_default' );
let selectedTypeInput = document.getElementById( BDDS_PLUGIN_PREFIX + '-selected-type' );
let columnTypesSelect = document.getElementById( 'column-types' );

let dataViewTable = document.getElementById(BDDS_PLUGIN_PREFIX + "-data-table-view");
let idTableHeader = document.getElementById(BDDS_PLUGIN_PREFIX + "-table-id");
let createdAtTableHeader = document.getElementById(BDDS_PLUGIN_PREFIX + "-table-created_at");
let updatedAtTableHeader = document.getElementById(BDDS_PLUGIN_PREFIX + "-table-updated_at");
let deletedAtTableHeader = document.getElementById(BDDS_PLUGIN_PREFIX + "-table-updated_at");

// JS for action => view
if(doActionInput) {
    doActionInput.addEventListener('click', () => {
        if( confirm( "Do you really want to delete selected records?" ) ) {
            tableFilterForm.submit();
        }
    });
}

if(doActionInput2) {
    doActionInput2.addEventListener('click', () => {
        if( confirm( "Do you really want to delete selected records?" ) ) {
            tableFilterForm.submit();
        }
    });
}

if(editSelectTypeInput) {
    editSelectTypeInput.addEventListener("change", () => {
        let defaultValueTd = document.getElementById("default-value-td");

        if(editSelectTypeInput.value == "mediumtext" || editSelectTypeInput.value == "longtext" || editSelectTypeInput.value == "longblob" ) {
            defaultValueTd.style.display = "none";
            defaultValueTd.getElementsByTagName("input")[0].value = '';
            defaultValueTd.getElementsByTagName("input")[0].type = "hidden";
        } else if(editSelectTypeInput.value == "datetime") {
            defaultValueTd.style.display = "inline-block";
            defaultValueTd.getElementsByTagName("input")[0].type = "datetime-local";
        } else {
            defaultValueTd.style.display = "inline-block";
            defaultValueTd.getElementsByTagName("input")[0].type = "text";
        }
    })
}

function editData ( dataId, value ) {
    let editInput = document.getElementById( 'edit-input' );
    let submitYes = document.getElementById( 'yes-submit-input' );
    let submitNo = document.getElementById( 'no-submit-input' );
    let currentValue = value;
    let selectedElement = document.getElementById( dataId );

    let newInput = document.createElement( 'input' );
    newInput.type = 'text';
    newInput.id = 'edit-input';
    newInput.name = 'edit_input';
    newInput.value = currentValue;
    newInput.style.width = "100%";

    let newSubmitYes = document.createElement( 'input' );
    newSubmitYes.type = 'submit';
    newSubmitYes.value = 'Yes';
    newSubmitYes.name = 'submit_yes';
    newSubmitYes.id = 'yes-submit-input';
    newSubmitYes.classList.add( "button" );
    newSubmitYes.style.marginTop = "0.15em";
    newSubmitYes.style.display = "none";

    let newSubmitNo = document.createElement( 'input' );
    newSubmitNo.type = 'submit';
    newSubmitNo.value = 'No';
    newSubmitNo.name = 'submit_no';
    newSubmitNo.id = 'no-submit-input';
    newSubmitNo.classList.add( "button" );
    newSubmitNo.style.marginTop = "0.15em";
    newSubmitNo.style.marginLeft = "0.25em";
    newSubmitNo.style.display = "none";

    newInput.addEventListener("keydown", function(event) {
        if (event.key === "Enter") {
            event.preventDefault();
            newSubmitYes.click();

        } else if (event.key === "Escape") {
            event.preventDefault();
            newSubmitNo.click();

        }
    });

    selectedElement.addEventListener("focusout", () => {
        newSubmitNo.click();
    })

    let columnNameId = document.createElement( 'input' );
    columnNameId.type = 'hidden';
    columnNameId.value = dataId;
    columnNameId.name = 'data_info';

    let hitSpan = document.createElement( 'span' );
    hitSpan.innerText = "Hit enter to save, esc to cancel";
    hitSpan.style.fontStyle = "italic";

    if ( editInput ) {
        // editInput.remove();
        // submitYes.remove();
        // submitNo.remove();
    } else {
        if ( selectedElement.childElementCount == 0 ) {
            selectedElement.innerHTML = '';
            selectedElement.appendChild( newInput );
            selectedElement.append( document.createElement( 'br' ) );
            selectedElement.append( hitSpan );
            selectedElement.append( document.createElement( 'br' ) );
            selectedElement.appendChild( newSubmitYes );
            selectedElement.appendChild( newSubmitNo );
            selectedElement.appendChild( columnNameId );
        } else {
            return;
        }
    }
}


/**
 * Handles select element changes for bit-type fields in the table view form.
 *
 * @param {*} selectElement - The select element that triggered the change event.
 *  It should have an ID in the format "columnName-rowId".
 */
function updateSelectData(selectElement) {
    const selectElementId = selectElement.id;
    const newValue = selectElement.value;

    // Create hidden input for the data info (column-row ID)
    const fieldIdHiddenInput = document.createElement('input');
    fieldIdHiddenInput.type = 'hidden';
    fieldIdHiddenInput.name = 'data_info';
    fieldIdHiddenInput.value = selectElementId;

    // Create hidden input for the new value
    const newValueHiddenInput = document.createElement('input');
    newValueHiddenInput.type = 'hidden';
    newValueHiddenInput.name = 'edit_input';
    newValueHiddenInput.value = newValue;

    // Create hidden input to indicate a "yes/confirm" action for the backend
    const confirmHiddenInput = document.createElement('input');
    confirmHiddenInput.type = 'hidden';
    confirmHiddenInput.name = 'submit_yes';
    confirmHiddenInput.value = 'Yes';

    tableFilterForm.appendChild(fieldIdHiddenInput);
    tableFilterForm.appendChild(newValueHiddenInput);
    tableFilterForm.appendChild(confirmHiddenInput);

    tableFilterForm.submit();
}


// Table > view > update row: Attach change listeners to select elements (bit-type fields)
if(dataViewTable) {
    const selectElements = dataViewTable.querySelectorAll('select');
    const newRowSection = dataViewTable.querySelector('#insert-new-column-table-row');

    selectElements.forEach((selectElement) => {
        // Skip select elements from the new row section
        if (newRowSection?.contains(selectElement)) {
            return;
        }

        selectElement.addEventListener('change', () => {
            updateSelectData(selectElement);
        });
    });
}


// JS for action => change structure
let columnNullCheckbox = document.getElementById( 'column-null-checkbox' );
let hiddenNullCheckbox = document.getElementById( 'hidden-null-checkbox' );

if(columnNullCheckbox) {
    if ( columnNullCheckbox.value == "YES" ) {
        columnNullCheckbox.checked = true;
        columnNullCheckbox.value = "YES";
        hiddenNullCheckbox.value = "YES";
    } else {
        columnNullCheckbox.checked = false;
        columnNullCheckbox.value = "NO";
        hiddenNullCheckbox.value = "NO";
    }
}

if( columnNullCheckbox ) {
    columnNullCheckbox.addEventListener( "click", () => {
            if ( columnNullCheckbox.checked ) {
                columnNullCheckbox.checked = true;
                columnNullCheckbox.value = "YES";
                hiddenNullCheckbox.value = "YES";
            } else {
                columnNullCheckbox.checked = false;
                columnNullCheckbox.value = "NO";
                hiddenNullCheckbox.value = "NO";
            }
    } );
}

if(columnTypesSelect) {
    columnTypesSelect.addEventListener("change", () => {
        selectedTypeInput.value = columnTypesSelect.value;
        lookupFormStructure.submit();
    });
}

if(lookupTableSelectEl) {
    lookupTableSelectEl.addEventListener( "change", () => {
        if(selectedTypeInput) {
            selectedTypeInput.value = columnTypesSelect.value;
        }
        lookupTableInputStructure.value = lookupTableSelectEl.value;
        lookupFormStructure.submit();
    } );
}


// JS for action => add new column
if(document.getElementById(BDDS_PLUGIN_PREFIX + "-add-new-column-form")) {
    let selectNewColumnType = document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-type");
    let hiddenColumnTypeInp = document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-selected-type");
    let lookupTableSelect = document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-lookup-table");
    let lookupTableHidden = document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-lookup");
    let addNewColumnForm = document.getElementById(BDDS_PLUGIN_PREFIX + "-add-new-column-form");

    selectNewColumnType.addEventListener("change", () => {
        hiddenColumnTypeInp.value = selectNewColumnType.value;
        addNewColumnForm.submit();
    });

    if(lookupTableSelect) {
        lookupTableSelect.addEventListener("change", () => {
            lookupTableHidden.value = lookupTableSelect.value;
            document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-lookup-type").value = "Lookup";

            addNewColumnForm.submit();
        });
    }
}

if(document.getElementById(BDDS_PLUGIN_PREFIX + "-back-form")) {
    document.getElementById(BDDS_PLUGIN_PREFIX + "-new-column-back").addEventListener("click", (e) => {
        e.preventDefault();
        document.getElementById(BDDS_PLUGIN_PREFIX + "-back-form").submit();
    });
}

