<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    class BDDS_Columns
    {
        private $columns;

        /**
         * Sets array of columns.
         *
         * 
         * @since 1.0.0
         *
         * @param array $columns Array containing columns for the table.
         */
        public function setColumns( $columns ) 
        {
            $this->columns = $columns;
        }
        /**
         * Returns columns array.
         *
         * 
         * @since 1.0.0
         * 
         * @return array Array that contains column objects for the table.
         */
        public function getColumns()
        {
            return $this->columns;
        }

        /**
         * Adds a new column object to array of columns.
         *
         * 
         * @since 1.0.0
         *
         * @param object $new_column Object BDDS_Column 
         */
        public function addNewColumn( $new_column )
        {
            $ids = array();
            $columns = isset($this->columns) ? $this->columns : array();

            foreach($columns as $key=>$column)
            {
                $id = str_replace("column_", '', $key);
                array_push($ids, $id);
            }

            $column_id = !empty($ids) ? max($ids) + 1 : 0;

            $this->columns["column_$column_id"] = $new_column;
        }

    }