<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    class BDDS_Column
    {
        private $name;
        private $type;
        private $null;
        private $default;
        private $lookup;
        private $enum_values;


        /**
         * Check if the column type is an attachment ID type (column contains
         * attachment ID)
         *
         * @param string $column_type The type of the column
         * @return bool True if the column type is an attachment ID type (column
         *               contains attachment ID), false otherwise
         */
        public static function isAttachmentIdType(string $column_type): bool
        {
            return str_contains($column_type, BDDS_ATTACHMENT_COLUMN_TYPE);
        }

        public function setColumnName( $column_name )
        {
            $this->name = $column_name;
        }

        public function setColumnType( $column_type )
        {
            $this->type = $column_type;
        }

        public function setColumnNull( $column_null )
        {
            $this->null = $column_null;
        }

        public function setColumnDefault( $column_default )
        {
            $this->default = $column_default;
        }

        public function setLookup( $table_lookup, $field_lookup )
        {
            $this->lookup = $table_lookup . '.' . $field_lookup;
        }

        public function setEnumValues( $enum_values )
        {
            $this->enum_values = $enum_values;
        }

        public function getColumnName()
        {
            return $this->name;
        }

        public function getColumnType()
        {
            return $this->type;
        }

        public function getColumnNull()
        {
            return $this->null;
        }

        public function getColumnDefault()
        {
            return $this->default;
        }

        public function getColumnLookup()
        {
            return $this->lookup;
        }

        public function getColumnEnumValues()
        {
            return $this->enum_values;
        }
    }