<?php 
/*
*   @since 1.0.12
*
*   @package black-desk
*   @subpackage black-desk/admin
*
*   This class is used in BDDS_Admin::route() method for controll over displayed content
*/

if ( ! defined( 'ABSPATH' ) ) exit;

if(! class_exists( 'BDDS_Query_Validator' ) ) {

    class BDDS_Query_Validator {

        public static function validate($table_name, $field, $value) {
            global $wpdb;

            $table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $table_name;
            $decimal_reg  = "/^-?\d{0,15}(,\d+)*(\.\d{0,2}(e\d+)?)?$/";
            $lookup_reg   = "/[a-zA-Z0-9]\.[a-zA-Z0-9]/";
            $field_type   = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME=%s AND COLUMN_NAME=%s",
                    array($table_name, $field)
                )
            );
            $err_msg = '';

            if (($field_type == "int" || $field_type == "bigint") && !is_numeric($value) && !empty($value)) {
                /* translators: %s: name of the field */
                $err_msg = sprintf(__('Value for "%s" must be a number', 'black-desk'), $field);

            } else if (($field_type == "Currency" || str_contains($field_type, "decimal")) && !preg_match($decimal_reg, $value) && !empty($value)) {
                /* translators: %s: name of the field */
                $err_msg = sprintf(__('Value for "%s" must be a decimal number {15,2}', 'black-desk'), $field);

            } else if($field_type == "Yes no" && ($value != "Yes" && $value != "No") && !empty($value)) {
                /* translators: %s: name of the field */
                $err_msg = sprintf(__('Value for "%s" must be "Yes" or "No"', 'black-desk'), $field);
            
            } else if($field_type == "Lookup" && !preg_match($lookup_reg, $value) && !empty($value)) {
                $err_msg = __('Lookup table default value should be formatted as "table_name.field_name"', 'black-desk');
            }

            return (!empty($err_msg)) ? $err_msg : "valid";
        }

    }

} else {
    echo "Query router class already exists!";
}
