<?php
/*
*   @since 1.0.11
*
*   @package black-desk
*   @subpackage black-desk/admin
*
*   This class is used in BDDS                                                                                                                                                                                  _Admin::route() method for control over displayed content
*/

if ( ! defined( 'ABSPATH' ) ) exit;

require_once "queryValidator.php";
require_once "Query.php";

if(! class_exists( 'BDDS_Query_Router' ) ) {

    class BDDS_Query_Router {

        /**
         * Sets sessions variables and routes between pages when creating a query.
         *
         *
         * @since 1.0.0
         *
         */
        public static function query_router() {
            if( isset( $_POST["add-selected-table"] ) && check_admin_referer("bdds-query-name-nonce") ) {
                global $wpdb;
                $query_name    = isset($_POST[BDDS_PLUGIN_PREFIX . "_query_name"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "_query_name"])) : null;
                $post_array    = map_deep($_POST, 'sanitize_text_field');
                $tables        = array();
                // if there is no instance of class in session, create new instance
                $query_from_object = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"]))
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                    : new BDDS_From($tables);

                if(preg_match("/^[a-z0-9_]+$/", $query_name)) {
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"] = $query_name;

                }

                foreach($post_array as $post_key=>$post_value) {
                    if($post_key == "available-tables") {
                        $selected_tables = $post_value;

                        for($i=0; $i<count($selected_tables); $i++)
                        {
                            $query_from_object->addTable($selected_tables[$i]);
                        }

                    }
                }

                $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"] = serialize($query_from_object);
            }

            if( isset($_POST[BDDS_PLUGIN_PREFIX . "-query-fields"]) ) {
                $query_fields_slug = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-fields-slug");
                $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"])) : null;
                $tables_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                    : null;

                $number_selected_tables = isset($tables_object) ? count($tables_object->getTables()) : 0;

                if(isset($_GET["action"]) && $_GET["action"] == "edit") {
                    $new_post_query_name = isset($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"]) ? sanitize_text_field(wp_unslash($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"])) : null;
                    $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"]) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])) : null;
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"] = isset($new_post_query_name) ? sanitize_text_field(wp_unslash($new_post_query_name)) : $query_name;

                    BDDS_Admin::redirectTo($query_fields_slug);

                } else {
                    // New query creation
                    if ($number_selected_tables < 1) {
                        // No tables selected => stay on the same page
                        return;
                    }

                    $post_query_name = isset($_POST[BDDS_PLUGIN_PREFIX . '_query_name']) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . '_query_name'])) : null;

                    if(( preg_match("/^[a-z0-9_]+$/", $query_name) || preg_match("/^[a-z0-9_]+$/", sanitize_text_field(wp_unslash($post_query_name)))) && $number_selected_tables > 0) {
                        $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"] = sanitize_text_field(wp_unslash($post_query_name));
                    }

                    BDDS_Admin::redirectTo($query_fields_slug);
                }


            }

            if(isset($_GET["page"]) && $_GET["page"] == BDDS_PLUGIN_PREFIX . "-query-name-and-tables-slug" && isset($_GET["query_id"])) {
                // set session variable for query object
                global $wpdb;
                $wp_tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";
                $query_id = isset($_GET["query_id"]) ? sanitize_text_field(wp_unslash($_GET["query_id"])) : null;
                $query_table_name = $wp_tables_prefix . "queries";

                $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                    ? sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                    : $wpdb->get_var($wpdb->prepare("SELECT `query_name` FROM `$query_table_name` WHERE id=%d", $query_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"] = $query_name;

                $post_new_query_name = isset($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"]) ? sanitize_text_field(wp_unslash($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"])) : '';
                if(isset($post_new_query_name) && preg_match("/^[a-z0-9_]+$/", $post_new_query_name)) {
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"] = sanitize_text_field(wp_unslash($post_new_query_name));
                }

                $query = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))
                        ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))
                        : $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare("SELECT `query`,`query_object` FROM `$query_table_name` WHERE `id`=%d", array($query_id)) // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                        )[0]->query_object;

                $query_object = unserialize($query);

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);

            }

            if( isset($_POST[BDDS_PLUGIN_PREFIX . "-preview-edit"]) && check_admin_referer("bdds-query-edit-preview-nonce")) {
                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                                : null;

                $query_preview_slug = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-preview-slug");
                $conditions_object  = $query_object->getConditionsObject();
                $conditions         = $conditions_object->getConditions();

                foreach($conditions as $key=>$condition) {
                    $condition_id = str_replace("condition_", '', $key);

                    $operator     = isset($conditions[$key]["condition_operator_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["condition_operator_0"])) : null;
                    $field_name   = isset($conditions[$key]["condition_field_name_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["condition_field_name_0"])) : null;
                    $field_cond   = isset($conditions[$key]["field_condition_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["field_condition_0"])) : null;
                    $type         = isset($conditions[$key]["field_value_type_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["field_value_type_0"])) : null;
                    $value_select = isset($conditions[$key]["field_value_select_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["field_value_select_0"])) : null;
                    $value_text   = isset($conditions[$key]["field_value_text_0"]) ? sanitize_text_field(wp_unslash($conditions[$key]["field_value_text_0"])) : null;

                    $new_operator   = isset($_POST["condition_operator_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["condition_operator_$condition_id"])) : null;
                    $new_field_name = isset($_POST["condition_field_name_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["condition_field_name_$condition_id"])) : null;
                    $new_condition  = isset($_POST["field_condition_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["field_condition_$condition_id"])) : null;
                    $new_type       = isset($_POST["field_value_type_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["field_value_type_$condition_id"])) : null;
                    $new_select_val = isset($_POST["field_value_select_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["field_value_select_$condition_id"])) : null;
                    $new_text_val   = isset($_POST["field_value_text_$condition_id"]) ? sanitize_text_field(wp_unslash($_POST["field_value_text_$condition_id"])) : null;

                    if(isset($new_operator) && $operator != $new_operator) {
                        $conditions[$key]["condition_operator_0"] = $new_operator;
                    }

                    if(isset($new_field_name) && $field_name != $new_field_name) {
                        $conditions[$key]["condition_field_name_0"] = $new_field_name;
                    }

                    if(isset($new_condition) && $field_cond != $new_condition) {
                        $conditions[$key]["field_condition_0"] = $new_condition;
                    }

                    if(isset($new_type) && $type != $new_type) {
                        $conditions[$key]["field_value_type_0"] = $new_type;
                    }

                    if(isset($new_select_val) && $value_select != $new_select_val) {
                        $conditions[$key]["field_value_select_0"] = $new_select_val;
                    }

                    if(isset($new_text_val) && $value_text != $new_text_val) {
                        $conditions[$key]["field_value_text_0"] = $new_text_val;
                    }

                }

                $conditions_object->setConditions($conditions);
                $query_object->setConditionsObject($conditions_object);

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);
                $url = add_query_arg( '_wpnonce', wp_create_nonce( 'bdds-edit-query-preview' ), $query_preview_slug );

                BDDS_Admin::redirectTo($url);
            }

            if( isset($_POST["add-selected-field"]) ) {
                $post_array = map_deep($_POST, 'sanitize_text_field');
                $fields = array();
                // if there is no instance of class in session, create new instance
                $query_select_object = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))) : new BDDS_Select($fields);
                $selected_fields = $query_select_object->getFields();

                foreach($post_array as $post_key=>$post_value) {
                    if($post_key == "available-fields") {
                        $new_fields = $post_value;

                        if(empty($selected_fields)) {
                            for($i=0; $i<count($new_fields); $i++) $query_select_object->setFieldsWithKeys("field_$i", $new_fields[$i]);

                        } else if (!empty($selected_fields)) {
                            $ids = array();

                            foreach($selected_fields as $key=>$selected_field) array_push($ids, end(explode("field_", $key)));

                            $id = max($ids) + 1;
                            foreach($new_fields as $new_field) {
                                $query_select_object->setFieldsWithKeys("field_$id", $new_field);
                                $id++;

                            }
                        }
                    }
                }

                $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"] = serialize($query_select_object);
            }

            if(isset($_POST["edit-add-selected-field"])) {
                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                              ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                              : null;

                $fields_object = $query_object->getFieldsObject();
                $fields = $fields_object->getFields();
                $post_array = $_POST;
                $new_fields = isset($_POST["available-fields"]) ? array_map('sanitize_text_field', array_map('wp_unslash', $_POST["available-fields"])) : array(); //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                $ids = array();

                foreach($fields as $key=>$field) {
                    $id = str_replace("field_", '', $key);
                    array_push($ids, $id);
                }

                $new_field_id = (count($ids) > 0) ? max($ids) + 1 : 0;
                foreach($new_fields as $new_field) {
                    $fields_object->setFieldsWithKeys("field_$new_field_id", $new_field);
                    $new_field_id++;
                }

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);
            }

            if( isset($_POST["edit-add-selected-table"]) ) {
                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                              ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                              : null;

                $tables_to_add = isset($_POST["available-tables"]) ? array_map('sanitize_text_field', array_map('wp_unslash', $_POST["available-tables"])) : array(); //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                $tables        = $query_object->getTablesObject()->getTables();
                $query_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";

                // save query name to session
                $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                    ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"]))
                    : $wpdb->get_var($wpdb->prepare("SELECT `query_name` FROM `$query_table_name` WHERE id=%d", $query_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                foreach($tables_to_add as $table_to_add) array_push($tables, $table_to_add);

                $query_object->getTablesObject()->setTables($tables);
                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);

            }

            if( isset($_POST[BDDS_PLUGIN_PREFIX . "-preview-edited"]) ) {
                $query_preview = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-preview-slug");
                if(isset($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"])) $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"] = sanitize_text_field(wp_unslash($_POST["new-" . BDDS_PLUGIN_PREFIX . "_query_name"]));

                BDDS_Admin::redirectTo($query_preview);
            }

            if( isset($_POST[BDDS_PLUGIN_PREFIX . "-query-aliases"]) ) {
                $query_aliases = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-aliases-slug");

                if (isset($_GET["action"]) && isset($_GET["query_id"])) {
                    $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                        ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                        : null;

                    if(count($query_object->getFieldsObject()->getFields()) > 0) BDDS_Admin::redirectTo($query_aliases);

                } else {
                    if(!isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) ||
                        empty(unserialize(sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))->getFields())) {


                    } else {

                        BDDS_Admin::redirectTo($query_aliases);
                    }
                }
            }

            if( isset( $_POST[BDDS_PLUGIN_PREFIX . "-query-conditions"]) || isset($_POST[BDDS_PLUGIN_PREFIX . "-edit-back-from-aliases"]) ) {
                $aliases = array();
                $post_array = map_deep($_POST, 'sanitize_text_field');
                foreach($post_array as $post_key=>$post_value) {
                    if(isset($_GET["action"]) && isset($_GET["query_id"])) {
                        $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                            ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                            : null;

                        $fields_object = isset($query_object) ? $query_object->getFieldsObject() : null;

                    } else {
                        $fields_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])
                            ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])))
                            : null;

                    }

                    if (str_starts_with($post_key, "field_alias_")) {
                        if(empty($post_value)) {
                            // no alias for field, use default field name
                            $field_name = str_replace("field_alias_", '', $post_key);
                            $aliases[$post_key] = $field_name;

                        } else if (!empty($post_value)) {
                            // save alias for field name
                            $aliases[$post_key] = $post_value;
                        }
                    }
                }

                $fields_object->setAliases($aliases);
                if(isset($_GET["action"]) && isset($_GET["query_id"])) {
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);
                } else {
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"] = serialize($fields_object);
                }

                $url = isset($_POST[BDDS_PLUGIN_PREFIX . "-edit-back-from-aliases"])
                     ? add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-fields-slug")
                     : add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug");

                BDDS_Admin::redirectTo($url);
            }

            if( isset( $_POST[BDDS_PLUGIN_PREFIX . "-query-preview"]) ) {
                $query_preview = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-preview-slug");

                BDDS_Admin::redirectTo($query_preview);
            }

            if( isset( $_POST[BDDS_PLUGIN_PREFIX . "-query-save"] ) ) {
                include BDDS_PLUGIN_DIR . "admin/views/query_views/query_save.php";

                if($query_inserted) {
                    $query_first_page = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-all-queries-slug");

                    BDDS_Admin::redirectTo($query_first_page);
                } else if ( $query_updated ) {
                    $query_page = remove_query_arg(array(
                        "query_id",
                        "action"
                    ));

                    $query_page = str_replace("page=" . BDDS_PLUGIN_PREFIX . "-query-preview-slug", "page=" . BDDS_PLUGIN_PREFIX . "-all-queries-slug", $query_page);

                    BDDS_Admin::redirectTo($query_page);
                }
            }

            // delete condition from conditions when editing a query
            if( isset( $_POST["yes-delete-condition"] ) ) {
                $condition_id = isset($_POST["condition-id"]) ? sanitize_text_field(wp_unslash($_POST["condition-id"])) : null;
                $query_conditions_page = remove_query_arg("condition_id");
                $query_conditions_page = str_replace("page=" . BDDS_PLUGIN_PREFIX . "-query-delete-condition-slug", "page=" . BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug", $query_conditions_page);
                $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                    : null;

                $conditions_array = (isset($conditions_object)) ? $conditions_object->getConditions() : array();

                unset($conditions_array["condition_$condition_id"]);
                $conditions_object->setConditions($conditions_array);

                $new_conditions_array = $conditions_object->getConditions();
                $first_key = array_key_first($new_conditions_array);
                if(isset($new_conditions_array[$first_key]["condition_operator_0"])) {
                    unset($new_conditions_array[$first_key]["condition_operator_0"]);
                }

                $conditions_object->setConditions($new_conditions_array);
                $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"] = serialize($conditions_object);

                BDDS_Admin::redirectTo($query_conditions_page);

            }

            // delete condition from conditions when editing a query
            if( isset( $_POST["yes-delete-edit"] ) ) {
                $condition_id = isset($_POST["condition-id"]) ? sanitize_text_field(wp_unslash($_POST["condition-id"])) : null;
                $query_conditions_page = remove_query_arg("condition_id");
                $query_conditions_page = str_replace("page=" . BDDS_PLUGIN_PREFIX . "-query-delete-condition-slug", "page=" . BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug", $query_conditions_page);
                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))) : null;
                $conditions_object = $query_object->getConditionsObject();
                $conditions = isset($conditions_object) ? $conditions_object->getConditions() : array();

                unset($conditions["condition_$condition_id"]);

                $new_conditions_array = $conditions;
                $first_key = array_key_first($new_conditions_array);

                if(isset($new_conditions_array[$first_key]["condition_operator_0"])) unset($new_conditions_array[$first_key]["condition_operator_0"]);

                $conditions_object->setConditions($new_conditions_array);
                $query_object->setConditionsObject($conditions_object);

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);
                BDDS_Admin::redirectTo($query_conditions_page);

            }

            if( isset( $_POST["no-delete-condition"] ) ) {
                $query_conditions_page = remove_query_arg("condition_id");
                $query_conditions_page = str_replace("page=". BDDS_PLUGIN_PREFIX . "-query-delete-condition-slug", "page=" . BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug", $query_conditions_page);

                BDDS_Admin::redirectTo($query_conditions_page);
            }

            if( isset( $_POST[BDDS_PLUGIN_PREFIX . "-query-name"] ) ) {
                $query_name_and_tables_page = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-name-and-tables-slug");

                BDDS_Admin::redirectTo($query_name_and_tables_page);
            }
        }

    }

} else {
    echo "Query router class already exists!";
}