# পুরোনো মেনু সরানোর গাইড

## সমস্যা

বর্তমানে প্লাগিনে দুইটি সেটিংস মেনু আছে:
1. **নতুন মেনু:** BizzPreOrder (মেইন মেনু, options-framework ব্যবহার করে)
2. **পুরোনো মেনু:** WooCommerce → Pre-Order (WooCommerce এর সাবমেনু)

পুরোনো মেনুটি সরাতে হলে নিচের ধাপগুলো অনুসরণ করুন।

---

## ধাপ ১: `includes/class-settings.php` ফাইলে পরিবর্তন

### ১.১ মেনু রেজিস্ট্রেশন বন্ধ করুন

`includes/class-settings.php` ফাইল খুলুন। `__construct()` মেথডে এই লাইনটি কমেন্ট আউট বা ডিলিট করুন:

```php
// এই লাইনটি সরান বা কমেন্ট আউট করুন:
add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
```

### ১.২ সেটিংস রেজিস্ট্রেশন বন্ধ করুন

একই `__construct()` মেথডে এই লাইনটিও কমেন্ট আউট বা ডিলিট করুন:

```php
// এই লাইনটি সরান বা কমেন্ট আউট করুন:
add_action( 'admin_init', array( $this, 'register_settings' ) );
```

### সম্পূর্ণ পরিবর্তন দেখতে:

**আগে:**
```php
public function __construct() {
    add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
    add_action( 'admin_init', array( $this, 'register_settings' ) );
}
```

**পরে:**
```php
public function __construct() {
    // Old menu removed - now using options-framework
    // add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
    // add_action( 'admin_init', array( $this, 'register_settings' ) );
}
```

---

## ধাপ ২ (ঐচ্ছিক): পুরো ফাইল সরানো

যদি ভবিষ্যতে পুরোনো সেটিংস পেজ একেবারেই দরকার না হয়, তাহলে:

### ২.১ `bizzorder.php` থেকে ইনক্লুড সরান

`load_dependencies()` মেথড থেকে এই লাইনটি সরান:
```php
require_once BIZZORDER_PLUGIN_DIR . '/includes/class-settings.php';
```

### ২.২ `bizzorder.php` থেকে ইনিশিয়ালাইজেশন সরান

`init_components()` মেথড থেকে এই লাইনটি সরান:
```php
new BIZZORDER_Settings();
```

### ২.৩ ফাইল ডিলিট করুন (ঐচ্ছিক)

`includes/class-settings.php` ফাইলটি ডিলিট করতে পারেন। তবে ব্যাকআপ রাখুন।

---

## ধাপ ৩: `bizzorder.php` এর `plugin_action_links` আপডেট

মেইন প্লাগিন ফাইলে (`bizzorder.php`) `plugin_action_links()` মেথডটি সরান বা কমেন্ট আউট করুন, কারণ নতুন `BizzOrder_Admin_Loader` ক্লাসে এটি ইতোমধ্যে হ্যান্ডেল করা হচ্ছে।

```php
// এই পুরো মেথড এবং এর হুক সরান:
// add_filter( 'plugin_action_links_' . BIZZORDER_PLUGIN_BASE, array( $this, 'plugin_action_links' ) );
```

এবং:
```php
// এই মেথড সরান:
// public function plugin_action_links( $links ) { ... }
```

---

## ধাপ ৪: `bizzorder.php` এর `admin_enqueue_scripts` আপডেট

মেইন প্লাগিন ফাইলে `admin_enqueue_scripts()` মেথড থেকে `bizzorder-settings` চেক সরাতে পারেন, কারণ নতুন `BizzOrder_Admin_Loader` এই কাজ করছে:

```php
// আগে:
if ( $screen && ( $screen->id === 'product' || strpos( $hook, 'bizzorder-settings' ) !== false || strpos( $hook, 'wc-orders' ) !== false ) ) {

// পরে (শুধু product ও orders পেজের জন্য):
if ( $screen && ( $screen->id === 'product' || strpos( $hook, 'wc-orders' ) !== false ) ) {
```

---

## গুরুত্বপূর্ণ তথ্য

- ⚠️ সেটিংস ডেটা হারাবে না। পুরোনো ও নতুন দুটোই একই `bizzorder_settings` অপশন কী ব্যবহার করে।
- ⚠️ `admin/options-framework/` ফোল্ডারের কোনো ফাইলে পরিবর্তন করবেন না।
- ✅ পরিবর্তনের পর প্লাগিন ডিঅ্যাক্টিভেট ও পুনরায় অ্যাক্টিভেট করার প্রয়োজন নেই।
