# Bizzorder - ডকুমেন্টেশন

## প্লাগিন সম্পর্কে

**Bizzorder** হলো একটি সহজ ও হালকা প্রি-অর্ডার প্লাগিন। এটি WooCommerce স্টোরে প্রি-অর্ডার ফাংশনালিটি যোগ করে।

---

## 📋 সূচিপত্র

1. [দ্রুত শুরু](#দ্রুত-শুরু)
2. [ফিচার তালিকা](#ফিচার-তালিকা)
3. [কোড স্ট্রাকচার](#কোড-স্ট্রাকচার)
4. [বিগিনার ডেভেলোপারের জন্য](#বিগিনার-ডেভেলোপারের-জন্য)
5. [ভবিষ্যত ফিচার প্ল্যান](#ভবিষ্যত-ফিচার-প্ল্যান)
6. [টিউটোরিয়াল](#টিউটোরিয়াল)

---

## দ্রুত শুরু

### ইনস্টলেশন
1. প্লাগিন ফোল্ডার `bizzorder` কপি করুন
2. `wp-content/plugins/` এ পেস্ট করুন
3. WordPress Dashboard > Plugins থেকে Activate করুন

### প্রথম প্রি-অর্ডার প্রোডাক্ট
1. Products > Any Product > Edit
2. Product Data > Inventory ট্যাব
3. ☑️ "Pre-Order Product" চেক করুন
4. 📅 "Available Date" সেট করুন
5. Update/Publish করুন

---

## ফিচার তালিকা

### বর্তমান ফিচার (v1.0.0)

| ফিচার | বর্ণনা |
|--------|--------|
| ✅ Simple Product | প্রি-অর্ডার সাপোর্ট |
| ✅ Variable Product | প্রতিটি ভেরিয়েশনের জন্য আলাদা |
| ✅ কাস্টম বাটন টেক্সট | "Pre Order Now!" |
| ✅ উপলব্ধতার তারিখ | প্রোডাক্ট পেজে দেখায় |
| ✅ প্রি-অর্ডার ব্যাজ | শপ/প্রোডাক্ট পেজে |
| ✅ কাস্টম স্ট্যাটাস | "Pre-Ordered" |
| ✅ কার্ট নোটিস | দিন বাকি দেখায় |
| ✅ Either Mode | মিক্স কার্ট প্রতিরোধ |
| ✅ ক্রন সিঙ্ক | স্বয়ংক্রিয় স্ট্যাটাস আপডেট |
| ✅ HPOS সাপোর্ট | WC High-Performance Order Storage |

---

## কোড স্ট্রাকচার

```
bizzorder/
│
├── bizzorder.php  # Main plugin file
│   └── Bizzorder_Loader class     # Singleton entry point
│   └── bizzorder_get_option()           # Helper function
│   └── bizzorder_is_preorder()          # Helper function
│   └── bizzorder_get_preorder_date()    # Helper function
│
├── includes/                        # PHP Classes
│   ├── class-product.php      # Product edit fields
│   ├── class-shop.php         # Shop/product display
│   ├── class-cart.php         # Cart validation
│   ├── class-checkout.php     # Checkout & order
│   ├── class-status.php       # Custom order status
│   ├── class-order.php        # Order list
│   └── class-settings.php     # Settings page
│
├── assets/                          # Static files
│   ├── css/
│   │   ├── admin.css          # Admin styles
│   │   └── frontend.css       # Frontend styles
│   └── js/
│       ├── admin.js           # Admin JS (OOP Module)
│       └── frontend.js        # Frontend JS (OOP Module)
│
├── languages/                       # Translation files
├── doc/                             # Documentation
└── readme.txt                       # WordPress.org readme
```

### ক্লাস দায়িত্ব

| ক্লাস | দায়িত্ব |
|-------|---------|
| `BIZZORDER_Product` | প্রোডাক্ট এডিট পেজে ফিল্ড যোগ ও সেভ |
| `BIZZORDER_Shop` | শপ/প্রোডাক্ট পেজে বাটন, ব্যাজ, তারিখ |
| `BIZZORDER_Cart` | কার্ট ভ্যালিডেশন, নোটিস |
| `BIZZORDER_Checkout` | অর্ডার মেটা সেভ, স্ট্যাটাস সেট |
| `BIZZORDER_Status` | কাস্টম অর্ডার স্ট্যাটাস, ক্রন |
| `BIZZORDER_Order` | অর্ডার লিস্ট কলাম |

---

## বিগিনার ডেভেলোপারের জন্য

### প্রয়োজনীয় জ্ঞান
- PHP OOP বেসিক
- WordPress Hooks (Actions & Filters)
- WooCommerce বেসিক
- jQuery বেসিক

### প্রথম কোড পড়া

#### ধাপ ১: Main File পড়ুন
```php
// bizzorder.php
// এখানে দেখুন:
// - Plugin header
// - Constants
// - Main class
// - Helper functions
```

#### ধাপ ২: একটি ক্লাস বিশ্লেষণ করুন
```php
// includes/class-shop.php
// দেখুন কিভাবে:
// - Hooks যোগ করা হয়
// - Button text পরিবর্তন হয়
// - Badge দেখানো হয়
```

### কোড মডিফিকেশন উদাহরণ

#### নতুন সেটিং যোগ করা
```php
// class-settings.php এ register_settings() মেথডে
add_settings_field(
    'my_new_setting',
    __( 'My New Setting', 'bizzorder' ),
    array( $this, 'text_field_callback' ),
    'bizzorder-settings',
    'bizzorder_general_section',
    array(
        'id'          => 'my_new_setting',
        'description' => 'Description here',
        'default'     => 'Default value',
    )
);
```

#### নতুন হুক যোগ করা
```php
// যেকোনো ক্লাসে
add_action( 'woocommerce_before_cart', array( $this, 'my_custom_notice' ) );

public function my_custom_notice() {
    if ( BIZZORDER_Cart::cart_has_preorder() ) {
        wc_print_notice( 'আপনার কার্টে প্রি-অর্ডার প্রোডাক্ট আছে।', 'notice' );
    }
}
```

---

## ভবিষ্যত ফিচার প্ল্যান

### Phase 2 (v1.1.0)
| ফিচার | অগ্রাধিকার |
|--------|-----------|
| কাস্টম ইমেইল টেমপ্লেট | ★★★★★ |
| চেকআউটে ডেট পিকার | ★★★★☆ |
| Shortcode | ★★★☆☆ |

### Phase 3 (v1.2.0)
| ফিচার | অগ্রাধিকার |
|--------|-----------|
| Pay Later | ★★★★★ |
| প্রি-অর্ডার প্রাইস | ★★★★☆ |
| কাউন্টডাউন টাইমার | ★★★☆☆ |

### Phase 4 (v2.0.0)
| ফিচার | অগ্রাধিকার |
|--------|-----------|
| প্রি-অর্ডার ম্যানেজমেন্ট প্যানেল | ★★★★★ |
| বাল্ক এডিট | ★★★★☆ |
| রিপোর্ট ও অ্যানালিটিক্স | ★★★☆☆ |
| WC Blocks সাপোর্ট | ★★★☆☆ |

---

## টিউটোরিয়াল

### ১. প্রি-অর্ডার প্রোডাক্ট তৈরি

1. **Products > Add New** বা যেকোনো প্রোডাক্ট এডিট করুন
2. **Product Data** সেকশনে যান
3. **Inventory** ট্যাব সিলেক্ট করুন
4. নিচের দিকে দুটি নতুন ফিল্ড দেখবেন:
   - ☑️ **Pre-Order Product** - এটি চেক করুন
   - 📅 **Available Date** - তারিখ সিলেক্ট করুন
5. **Update/Publish** ক্লিক করুন

### ২. সেটিংস কনফিগারেশন

1. **WooCommerce > Pre-Order** এ যান
2. নিম্নলিখিত সেটিংস কনফিগার করুন:
   - **Pre-Order Button Text**: বাটনে কি লেখা দেখাবে
   - **Pre-Order Status Label**: অর্ডার স্ট্যাটাসের নাম
   - **Cart Item Notice**: কার্টে কি নোটিস দেখাবে
   - **Show Pre-Order Badge**: ব্যাজ দেখাতে চাইলে চেক করুন
   - **Either Mode**: মিক্স কার্ট প্রতিরোধ করতে চাইলে চেক করুন
3. **Save Settings** ক্লিক করুন

### ৩. Variable Product এ প্রি-অর্ডার

1. Variable প্রোডাক্ট এডিট করুন
2. **Product Data > Variations** ট্যাবে যান
3. যে ভেরিয়েশন প্রি-অর্ডার করতে চান সেটি এক্সপ্যান্ড করুন
4. নিচে দেখবেন:
   - ☑️ **Pre-Order Variation**
   - 📅 **Available Date**
5. সেট করে **Save changes** ক্লিক করুন

### ৪. অর্ডার ম্যানেজমেন্ট

1. **WooCommerce > Orders** এ যান
2. প্রি-অর্ডার অর্ডারগুলো "Pre-Ordered" স্ট্যাটাসে দেখাবে
3. "Pre-Order Date" কলামে দেখাবে কত দিন বাকি
4. তারিখ পার হলে স্বয়ংক্রিয়ভাবে "Processing" হয়ে যাবে

---

## সাপোর্ট

কোনো সমস্যা হলে বা প্রশ্ন থাকলে:
- GitHub Issues ব্যবহার করুন
- Email: [your-email@example.com]
