/**
 * Bizzorder - Admin JavaScript
 * 
 * Object Oriented Module Pattern
 *
 * @package Bizzorder
 */

(function($) {
    'use strict';

    /**
     * BPOW Admin Module
     */
    var Bizzorder_Admin = (function() {
        
        /**
         * Module configuration
         */
        var config = {
            selectors: {
                preorderCheckbox: '#_bizzorder_is_preorder',
                preorderDate: '#_bizzorder_preorder_date',
                variationsContainer: '#variable_product_options',
                variationMetabox: '.wc-metabox'
            }
        };

        /**
         * Cache DOM elements
         */
        var $elements = {};

        /**
         * Initialize the module
         */
        function init() {
            cacheElements();
            bindEvents();
            toggleDateField();
        }

        /**
         * Cache DOM elements for better performance
         */
        function cacheElements() {
            $elements.preorderCheckbox = $(config.selectors.preorderCheckbox);
            $elements.preorderDate = $(config.selectors.preorderDate);
            $elements.variationsContainer = $(config.selectors.variationsContainer);
        }

        /**
         * Bind event handlers
         */
        function bindEvents() {
            // Toggle date field visibility
            $elements.preorderCheckbox.on('change', toggleDateField);

            // Handle variation checkbox changes
            $elements.variationsContainer.on('change', 'input[id^="_bizzorder_is_preorder_"]', handleVariationCheckbox);

            // Initialize date fields in variations when they are loaded
            $elements.variationsContainer.on('click', config.selectors.variationMetabox, initVariationDateFields);
        }

        /**
         * Toggle pre-order date field visibility based on checkbox
         */
        function toggleDateField() {
            var $checkbox = $elements.preorderCheckbox;
            var $dateField = $elements.preorderDate.closest('.form-field');

            if ($checkbox.is(':checked')) {
                $dateField.slideDown(200);
            } else {
                $dateField.slideUp(200);
            }
        }

        /**
         * Handle variation checkbox change
         * 
         * @param {Event} e Event object
         */
        function handleVariationCheckbox(e) {
            var $checkbox = $(e.target);
            var variationId = $checkbox.attr('id').replace('_bizzorder_is_preorder_', '');
            var $dateField = $('#_bizzorder_preorder_date_' + variationId).closest('.form-field');

            if ($checkbox.is(':checked')) {
                $dateField.slideDown(200);
            } else {
                $dateField.slideUp(200);
            }
        }

        /**
         * Initialize date fields in newly loaded variations
         */
        function initVariationDateFields() {
            // Re-check all variation checkboxes to show/hide date fields
            $('input[id^="_bizzorder_is_preorder_"]').each(function() {
                var $checkbox = $(this);
                var variationId = $checkbox.attr('id').replace('_bizzorder_is_preorder_', '');
                var $dateField = $('#_bizzorder_preorder_date_' + variationId).closest('.form-field');

                if ($checkbox.is(':checked')) {
                    $dateField.show();
                } else {
                    $dateField.hide();
                }
            });
        }

        /**
         * Public API
         */
        return {
            init: init
        };

    })();

    /**
     * Initialize on document ready
     */
    $(document).ready(function() {
        Bizzorder_Admin.init();
    });

})(jQuery);
