<?php
/**
 * BizzPlugin Options Framework - Field Renderer
 * 
 * Shared field rendering class used by both BizzPlugin_Panel and BizzPlugin_Metabox.
 * 
 * @package BizzPlugin_Options_Framework
 * @version 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Field Renderer Class
 * 
 * Provides static methods for rendering various field types.
 * Used by both Panel (options page) and Metabox contexts.
 */
class BizzPlugin_Helper_Common {

    /**
     * Get section or subsection dependency attributes for HTML attr return
     * **************************************
     * IMPORTANT:
     * **************************************
     * It's for Section and Subsections
     * for Single Section or Subsection dependency support
     * 
     * @param array $sections Array of section configurations or Subsection configurations
     * @return string HTML data attributes for section dependency
     */
    public static function get_dependency_attr( $section = array() ) {
        $section_dependency = isset($section['dependency']) ? $section['dependency'] : array();
        $section_dependency_attr = '';
        //for empty or not array
        if( empty($section_dependency) || !is_array($section_dependency) ){
            return $section_dependency_attr;
        }   
        if (!empty($section_dependency) && is_array($section_dependency) && isset($section_dependency['field']) && isset($section_dependency['value'])) {
            $section_dependency_attr = sprintf(
                'data-section-dependency="%s" data-section-dependency-value="%s"',
                esc_attr($section_dependency['field']),
                esc_attr($section_dependency['value'])
            );
        }
        return $section_dependency_attr;
    }

    
}