/**
 * WP Color Picker Alpha - 3.0.3
 * 
 * Adds alpha (opacity) support to the WordPress color picker.
 * 
 * Based on wp-color-picker-alpha by Sergio (kallookoo)
 * Licensed under GPLv2
 * 
 * Minified version for production use.
 */
!function(t){"use strict";if(!t||!t.fn||!t.fn.wpColorPicker)return void console.warn("wp-color-picker-alpha: wpColorPicker not found");var e=t.extend(!0,{},t.wp.wpColorPicker.prototype);t.wp.wpColorPicker=function(n){if(!n.alpha)return e.init.apply(this,arguments);this.options=n,this.$element=t(n.element),this.alpha=n.alpha||!1};var n={alpha:!1,alphaStep:.01,alphaWidth:28};t.widget("wp.wpColorPicker",{options:n,_createAlphaBackground:function(t){var e=t.split(",");if(e.length>=3){var n=(e[0]||"").replace(/[^\d]/g,""),o=(e[1]||"").replace(/[^\d]/g,""),a=(e[2]||"").replace(/[^\d]/g,""),r="linear-gradient(to right, rgba("+n+", "+o+", "+a+", 0) 0%, rgba("+n+", "+o+", "+a+", 1) 100%)";this.$alphaSlider.css("background",r)}},_createRgbaFromHex:function(t,e){var n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);if(!n)return t;var o=parseInt(n[1],16),a=parseInt(n[2],16),r=parseInt(n[3],16);return"rgba("+o+", "+a+", "+r+", "+e+")"},_parseRgba:function(t){if(!t||!t.match)return{r:0,g:0,b:0,a:1};var e=t.match(/rgba?\s*\(\s*(\d+),\s*(\d+),\s*(\d+)(?:,\s*([\d.]+))?\s*\)/i);return e?{r:parseInt(e[1],10),g:parseInt(e[2],10),b:parseInt(e[3],10),a:void 0!==e[4]?parseFloat(e[4]):1}:{r:0,g:0,b:0,a:1}},_create:function(){if(e._create.apply(this,arguments),this.options.alpha){var n=this;this.$alphaWrap=t('<div class="wp-picker-alpha-wrap"></div>'),this.$alphaSlider=t('<div class="wp-picker-alpha-slider"></div>'),this.$alphaValue=t('<span class="wp-picker-alpha-value"></span>');var o=this.element.val();if(o&&o.indexOf("rgba")>-1){var a=this._parseRgba(o);this.currentAlpha=a.a}else this.currentAlpha=1;this.$alphaSlider.slider({orientation:"horizontal",min:0,max:1,step:this.options.alphaStep,value:this.currentAlpha,slide:function(t,e){n.currentAlpha=e.value,n._updateAlphaValue()}}),this.$alphaWrap.append(this.$alphaSlider).append(this.$alphaValue),this._updateAlphaBackground(),this._updateAlphaValue(),this.wrap.after(this.$alphaWrap),this.element.on("irischange.wpColorPicker",function(){n._updateAlphaBackground()}).trigger("irischange.wpColorPicker")}},_updateAlphaBackground:function(){if(this.options.alpha){var t=this.element.iris("color");this._createAlphaBackground(t)}},_updateAlphaValue:function(){if(this.options.alpha){var t=Math.round(100*this.currentAlpha)+"%";this.$alphaValue.text(t);var e=this.element.iris("color"),n=this._parseRgba(e),o="rgba("+n.r+", "+n.g+", "+n.b+", "+this.currentAlpha+")";this.element.val(o).trigger("change")}},_change:function(){e._change.apply(this,arguments),this.options.alpha&&this._updateAlphaBackground()},_clear:function(){e._clear.apply(this,arguments),this.options.alpha&&(this.currentAlpha=1,this.$alphaSlider&&this.$alphaSlider.slider("value",1),this._updateAlphaValue())}})}(jQuery);
