/**
 * BizzPlugin Metabox JavaScript
 * 
 * Handles metabox interactions for posts, pages, and custom post types.
 * Common functionality is handled by bizzplugin-common.js
 * 
 * @package BizzPlugin_Options_Framework
 * @version 2.0.0
 * @requires bizzplugin-common.js
 */

(function($) {
    'use strict';

    /**
     * Metabox Handler
     */
    var BizzPluginMetabox = {
        /**
         * Configuration
         */
        config: {
            ajaxUrl: '',
            nonce: '',
            strings: {}
        },

        /**
         * Initialize
         */
        init: function() {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            // Set configuration from localized data
            if (typeof bizzpluginMetabox !== 'undefined') {
                this.config.ajaxUrl = bizzpluginMetabox.ajaxUrl || '';
                this.config.nonce = bizzpluginMetabox.nonce || '';
                this.config.strings = bizzpluginMetabox.strings || {};
                
                // Set common module config
                if (Common) {
                    Common.setConfig(this.config);
                }
            }
            
            this.bindEvents();
            
            // Use common module for field initialization
            if (Common) {
                Common.initColorPickers($('.bizzplugin-metabox-wrap'));
                Common.initAlphaColorPickers($('.bizzplugin-metabox-wrap'));
                Common.initDatePickers($('.bizzplugin-metabox-wrap'));
                Common.initSliders($('.bizzplugin-metabox-wrap'));
                Common.initImageSelect($('.bizzplugin-metabox-wrap'));
                Common.initOptionSelect($('.bizzplugin-metabox-wrap'));
                Common.initRepeaterSortable($('.bizzplugin-metabox-wrap'), function($wrap) {
                    self.updateRepeaterIndexes($wrap);
                });
                Common.initSingleRepeaterSortable($('.bizzplugin-metabox-wrap'));
                // Common.initDependencies($('.bizzplugin-metabox-wrap'));
                Common.initConditionalFields();
            }
            
            this.handleHashNavigation();
        },

        /**
         * Bind all events
         */
        bindEvents: function() {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            // Navigation click
            $(document).on('click', '.bizzplugin-metabox-nav-link', this.handleNavClick);
            $(document).on('click', '.bizzplugin-metabox-nav-sublink', this.handleSubNavClick);
            
            // Image upload - use common module
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-image-select', function(e) {
                if (Common) {
                    Common.openImageUploader(e);
                }
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-image-remove', function(e) {
                if (Common) {
                    Common.removeImage(e);
                }
            });
            
            // File upload - use common module
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-file-select', function(e) {
                if (Common) {
                    Common.openFileUploader(e);
                }
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-file-remove', function(e) {
                if (Common) {
                    Common.removeFile(e);
                }
            });
            
            // On/Off toggle - trigger conditional fields
            $(document).on('change', '.bizzplugin-toggle-input, .bizzplugin-checkbox', function(e) {
                if (Common) {
                    console.log("Coummon Calleds");
                    Common.handleToggleChange(e);
                }else{
                    console.log("Common Not Calleds");
                }
            });

            // Select change - trigger conditional fields
            $(document).on('change', '.bizzplugin-select, .bizzplugin-radio, .bizzplugin-option-select-input', function(e) {
                if (Common) {
                    console.log("Coummon Called");
                    Common.handleSelectChange(e);
                }else{
                    console.log("Common Not Called");
                }
            });

            // Image select field - use common module
            $(document).on('change', '.bizzplugin-metabox-wrap .bizzplugin-image-select-input', function(e) {
                if (Common) {
                    Common.handleImageSelectChange(e);
                }
            });
            
            // Option select field - use common module
            $(document).on('change', '.bizzplugin-metabox-wrap .bizzplugin-option-select-input', function(e) {
                if (Common) {
                    Common.handleOptionSelectChange(e);
                }
            });
            
            // Slider value update - use common module
            $(document).on('input', '.bizzplugin-metabox-wrap .bizzplugin-slider', function(e) {
                if (Common) {
                    Common.handleSliderChange(e);
                }
            });
            
            // Dependency handling - use common module
            $(document).on('change', '.bizzplugin-metabox-wrap input, .bizzplugin-metabox-wrap select', function(e) {
                if (Common) {
                    Common.handleDependencyChange(e);
                }
            });
            
            // Repeater events - use common module
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-repeater-add', function(e) {
                self.handleRepeaterAdd(e);
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-repeater-item-remove', function(e) {
                self.handleRepeaterRemove(e);
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-repeater-item-toggle', function(e) {
                if (Common) {
                    Common.repeaterToggleItem(e);
                }
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-repeater-item-header', function(e) {
                if (Common) {
                    Common.repeaterHandleHeaderClick(e);
                }
            });
            // Update repeater item title on input/change for all field types
            $(document).on('input change', '.bizzplugin-metabox-wrap .bizzplugin-repeater-item input, .bizzplugin-metabox-wrap .bizzplugin-repeater-item select, .bizzplugin-metabox-wrap .bizzplugin-repeater-item textarea', function(e) {
                if (Common) {
                    Common.repeaterUpdateItemTitle(e);
                }
            });
            
            // Single repeater events - use common module
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-single-repeater-add', function(e) {
                self.handleSingleRepeaterAdd(e);
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-single-repeater-remove', function(e) {
                self.handleSingleRepeaterRemove(e);
            });
            
            // Plugin install/activate events - use common module
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-install-plugin', function(e) {
                self.handlePluginInstall(e);
            });
            $(document).on('click', '.bizzplugin-metabox-wrap .bizzplugin-activate-plugin', function(e) {
                self.handlePluginActivate(e);
            });
            
            // Handle hash changes
            $(window).on('hashchange', this.handleHashChange.bind(this));
        },
        
        /**
         * Handle plugin install button click - uses common module
         */
        handlePluginInstall: function(e) {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.installPlugin(e, function(response) {
                    self.showNotification(response.data.message, 'success');
                }, function(response) {
                    self.showNotification(response.data.message || self.config.strings.install_error || 'Error installing plugin', 'error');
                });
            }
        },
        
        /**
         * Handle plugin activate button click - uses common module
         */
        handlePluginActivate: function(e) {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.activatePlugin(e, function(response) {
                    self.showNotification(response.data.message, 'success');
                }, function(response) {
                    self.showNotification(response.data.message || self.config.strings.activate_error || 'Error activating plugin', 'error');
                });
            }
        },
        
        /**
         * Show notification - uses common module
         */
        showNotification: function(message, type) {
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.showNotification(message, type, $('.bizzplugin-metabox-wrap').first());
            } else {
                alert(message);
            }
        },

        /**
         * Handle main navigation click
         */
        handleNavClick: function(e) {
            e.preventDefault();
            
            var $link = $(this);
            var sectionId = $link.data('section');
            var hasFields = $link.data('has-fields') === 1 || $link.data('has-fields') === '1';
            var hasSubsections = $link.data('has-subsections') === 1 || $link.data('has-subsections') === '1';
            var $metabox = $link.closest('.bizzplugin-metabox-wrap');
            var $navItem = $link.closest('.bizzplugin-metabox-nav-item');
            
            // If has subsections, toggle submenu
            if (hasSubsections) {
                var $submenu = $navItem.find('.bizzplugin-metabox-nav-submenu');
                var isExpanded = $navItem.hasClass('expanded');
                
                if (isExpanded) {
                    $submenu.slideUp(200);
                    $navItem.removeClass('expanded');
                } else {
                    $submenu.slideDown(200);
                    $navItem.addClass('expanded');
                    
                    // If has fields, show section content
                    if (hasFields) {
                        BizzPluginMetabox.showSection($metabox, sectionId);
                    } else {
                        // Auto-select first subsection
                        var $firstSublink = $submenu.find('.bizzplugin-metabox-nav-sublink').first();
                        if ($firstSublink.length) {
                            $firstSublink.trigger('click');
                        }
                    }
                }
            }
            
            // If has fields, show section
            if (hasFields) {
                BizzPluginMetabox.showSection($metabox, sectionId);
                
                // Update URL hash
                BizzPluginMetabox.updateHash(sectionId);
            }
        },

        /**
         * Handle subsection navigation click
         */
        handleSubNavClick: function(e) {
            e.preventDefault();
            
            var $link = $(this);
            var sectionId = $link.data('section');
            var subsectionId = $link.data('subsection');
            var $metabox = $link.closest('.bizzplugin-metabox-wrap');
            
            // Show subsection content
            BizzPluginMetabox.showSubsection($metabox, sectionId, subsectionId);
            
            // Update URL hash
            BizzPluginMetabox.updateHash(sectionId + '-' + subsectionId);
        },

        /**
         * Show section content
         */
        showSection: function($metabox, sectionId) {
            // Hide all sections
            $metabox.find('.bizzplugin-metabox-section').hide();
            
            // Show target section
            $metabox.find('.bizzplugin-metabox-section[data-section="' + sectionId + '"]:not([data-subsection])').show();
            
            // Update nav active state
            $metabox.find('.bizzplugin-metabox-nav-item').removeClass('active');
            $metabox.find('.bizzplugin-metabox-nav-link').removeClass('current');
            $metabox.find('.bizzplugin-metabox-nav-subitem').removeClass('active');
            $metabox.find('.bizzplugin-metabox-nav-sublink').removeClass('current');
            
            var $navItem = $metabox.find('.bizzplugin-metabox-nav-link[data-section="' + sectionId + '"]').closest('.bizzplugin-metabox-nav-item');
            $navItem.addClass('active');
            $navItem.find('> .bizzplugin-metabox-nav-link').addClass('current');
        },

        /**
         * Show subsection content
         */
        showSubsection: function($metabox, sectionId, subsectionId) {
            // Hide all sections
            $metabox.find('.bizzplugin-metabox-section').hide();
            
            // Show target subsection
            $metabox.find('.bizzplugin-metabox-section[data-section="' + sectionId + '"][data-subsection="' + subsectionId + '"]').show();
            
            // Update nav active state
            $metabox.find('.bizzplugin-metabox-nav-item').removeClass('active');
            $metabox.find('.bizzplugin-metabox-nav-link').removeClass('current');
            $metabox.find('.bizzplugin-metabox-nav-subitem').removeClass('active');
            $metabox.find('.bizzplugin-metabox-nav-sublink').removeClass('current');
            
            var $navItem = $metabox.find('.bizzplugin-metabox-nav-link[data-section="' + sectionId + '"]').closest('.bizzplugin-metabox-nav-item');
            $navItem.addClass('active expanded');
            $navItem.find('.bizzplugin-metabox-nav-submenu').show();
            
            var $subLink = $metabox.find('.bizzplugin-metabox-nav-sublink[data-subsection="' + subsectionId + '"]');
            $subLink.addClass('current');
            $subLink.closest('.bizzplugin-metabox-nav-subitem').addClass('active');
        },

        /**
         * Update URL hash
         */
        updateHash: function(hash) {
            if (history.pushState) {
                history.pushState(null, null, '#' + hash);
            } else {
                window.location.hash = hash;
            }
        },

        /**
         * Handle hash navigation on page load
         */
        handleHashNavigation: function() {
            var hash = window.location.hash;
            if (!hash || hash === '#') {
                return;
            }
            
            hash = hash.substring(1); // Remove #
            
            $('.bizzplugin-metabox-wrap').each(function() {
                var $metabox = $(this);
                
                // Check if hash contains subsection
                if (hash.indexOf('-') !== -1) {
                    var parts = hash.split('-');
                    var sectionId = parts[0];
                    var subsectionId = parts.slice(1).join('-');
                    
                    var $subLink = $metabox.find('.bizzplugin-metabox-nav-sublink[data-section="' + sectionId + '"][data-subsection="' + subsectionId + '"]');
                    if ($subLink.length) {
                        BizzPluginMetabox.showSubsection($metabox, sectionId, subsectionId);
                        return false; // Break loop
                    }
                }
                
                // Try as section
                var $link = $metabox.find('.bizzplugin-metabox-nav-link[data-section="' + hash + '"]');
                if ($link.length) {
                    var hasFields = $link.data('has-fields') === 1 || $link.data('has-fields') === '1';
                    if (hasFields) {
                        BizzPluginMetabox.showSection($metabox, hash);
                    }
                    return false; // Break loop
                }
            });
        },

        /**
         * Handle hash change event
         */
        handleHashChange: function() {
            this.handleHashNavigation();
        },

        /**
         * Handle repeater add button click - uses common module
         */
        handleRepeaterAdd: function(e) {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.repeaterAddItem(e, 
                    function($newItem, $wrap) {
                        // Additional initialization if needed
                    },
                    function($newItem) {
                        // Initialize fields for new item
                        self.initItemFields($newItem);
                    }
                );
            }
        },

        /**
         * Handle repeater remove button click - uses common module
         */
        handleRepeaterRemove: function(e) {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.repeaterRemoveItem(e,
                    function($wrap) {
                        // Callback after removal
                    },
                    function($wrap) {
                        // Use common reindex
                        Common.repeaterReindex($wrap);
                    }
                );
            }
        },

        /**
         * Update repeater indexes after reorder
         */
        updateRepeaterIndexes: function($repeater) {
            var Common = window.BizzPluginCommon;
            if (Common) {
                Common.repeaterReindex($repeater);
            }
        },

        /**
         * Initialize fields for a new repeater item
         */
        initItemFields: function($item) {
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                // Use common module for field initialization
                Common.initColorPickers($item);
                Common.initAlphaColorPickers($item);
                Common.initDatePickers($item);
                Common.initSliders($item);
            }
        },

        /**
         * Handle single repeater add button click - uses common module
         */
        handleSingleRepeaterAdd: function(e) {
            var self = this;
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.singleRepeaterAddItem(e, 
                    function($newItem, $wrap) {
                        // Additional initialization if needed
                    },
                    function($newItem) {
                        // Initialize fields for new item
                        Common.initColorPickers($newItem);
                        Common.initAlphaColorPickers($newItem);
                    }
                );
            }
        },

        /**
         * Handle single repeater remove button click - uses common module
         */
        handleSingleRepeaterRemove: function(e) {
            var Common = window.BizzPluginCommon;
            
            if (Common) {
                Common.singleRepeaterRemoveItem(e);
            }
        }
    };

    /**
     * Initialize on document ready
     */
    $(document).ready(function() {
        BizzPluginMetabox.init();
    });

})(jQuery);
