function b1nT_cls_address_vldtr(b1nT_arg_config) { 
     var b1nT_address_data = this;
     b1nT_address_data.config = b1nT_arg_config;
     b1nT_address_data.random_number = Math.floor(Math.random() * 1000000);

     this._b1nT_init = async function() {
          let b1nT_waitForGoogle = async function() {
               return new Promise(function(b1nT_resolve) {
                    async function b1nT_isItReady() {
                         if(typeof(google.maps.places) !== "undefined") {
                              try { //make a call to make sure the api is included in the key.
                                    //this call is not included in billing because the get details never
                                    //never gets called.
                                   const b1nT_token = new google.maps.places.AutocompleteSessionToken();
                                   const b1nT_suggestions = await google.maps.places.AutocompleteSuggestion.fetchAutocompleteSuggestions({
                                        sessionToken: b1nT_token,
                                        input: "588",
                                        language: "en-US",
                                        includedRegionCodes: ["us", "ca"]    
                                   });
                              } catch(e) {
                                    b1nT_resolve(1);
                              } 
                              b1nT_resolve(0);
                         } else {
                              setTimeout(b1nT_isItReady, 50);
                         }
                    } 
                    b1nT_isItReady();
               });
          };

          let b1nT_legacy_check = await b1nT_waitForGoogle();

          if(b1nT_legacy_check) {
               b1nT_address_data._b1nT_init_legacy(); 
               return; 
          }

          let b1nT_address_suggestion_wrap                   = document.createElement("div");
          b1nT_address_suggestion_wrap.style.position        = "absolute";
          b1nT_address_suggestion_wrap.style.marginTop       = "1px";
          b1nT_address_suggestion_wrap.style.borderRadius    = "1px";
          b1nT_address_suggestion_wrap.style.backgroundColor = "#ffffff";
          b1nT_address_suggestion_wrap.style.zIndex          = 1;

          //allow developers to style it
          b1nT_address_suggestion_wrap.setAttribute("class", "b1nT_address_suggestion_wrap");

          b1nT_address_data.address_suggestion_wrap          = b1nT_address_suggestion_wrap;
          b1nT_address_data.config.searchCtrl.after(b1nT_address_suggestion_wrap);
     
          //setup event listensers on fields
          b1nT_address_data.config.searchCtrl.addEventListener("keyup", function(b1nT_e) {
               if(b1nT_e.key != "ArrowDown" && b1nT_e.key != "ArrowUp" && b1nT_e.key != "ArrowLeft" && b1nT_e.key != "ArrowRight" && b1nT_e.key) {       
                    clearTimeout(b1nT_address_data.searchTimeOut);  
                    b1nT_address_data.searchTimeOut = setTimeout(function() {
                         if(!String(b1nT_address_data.config.searchCtrl.value).trim()) { 
                              b1nT_address_data.address_suggestion_wrap.innerHTML = "";
                              b1nT_address_data.address_suggestion_wrap.style.boxShadow = "none";
                              return; 
                         }

                         //if we are using the search bar to act as the address bar aswell. then trigger the address changed
                         if(b1nT_address_data.config.addressCtrl && (b1nT_address_data.config.addressCtrl == b1nT_address_data.config.searchCtrl)) {
                              b1nT_address_data._b1nT_address_changed();
                         }
      
                         b1nT_address_data._b1nT_get_suggestions(b1nT_address_data.config.searchCtrl.value);
                         b1nT_address_data.address_suggestion_wrap.style.boxShadow = "0px 0px 4px 1px #d2d2d2";
                    }, 500);
               }
          });

          b1nT_address_data.config.searchCtrl.addEventListener("keydown", function(b1nT_e) {
               let b1nT_address_suggestions_wrap = document.getElementById("b1nT_"+b1nT_address_data.random_number+"_AddrVldtrSuggestionsContent");
               if(!b1nT_address_suggestions_wrap) { return; }

               let b1nT_selected = function(b1nT_argDiv) {
                    b1nT_argDiv.parentElement.style.color = "#0174ab";
                    b1nT_argDiv.parentElement.style.backgroundColor = "#dddddd";
                    b1nT_address_data.config.searchCtrl.value = b1nT_argDiv.valHTML;
               };

               let b1nT_unSelected = function(b1nT_argDiv) {
                    b1nT_argDiv.parentElement.style.removeProperty("color");
                    b1nT_argDiv.parentElement.style.removeProperty("background-color");
               };

               if(b1nT_e.key == "ArrowDown" || b1nT_e.key == "ArrowUp" || b1nT_e.key == "Enter") {
                    let b1nT_child_wrappers = Array.from(b1nT_address_suggestions_wrap.children);

                    if(b1nT_e.key == "ArrowDown" || b1nT_e.key == "ArrowUp") {
                         clearTimeout(b1nT_address_data.cursorTimeout);
                         b1nT_child_wrappers.forEach(function(b1nT_argDiv) {
                              b1nT_unSelected(b1nT_argDiv.children[0]);
                         });

                         if(String(b1nT_address_suggestions_wrap.keyIndex) == "") {
                              b1nT_address_suggestions_wrap.keyIndex  = -1;
                         }

                         if(b1nT_e.key == "ArrowDown") {
                              if(b1nT_address_suggestions_wrap.keyIndex < b1nT_child_wrappers.length) {
                                   b1nT_address_suggestions_wrap.keyIndex++;
                              }

                              if(b1nT_address_suggestions_wrap.keyIndex == b1nT_child_wrappers.length) {
                                   b1nT_address_suggestions_wrap.keyIndex = -1;
                              }
                         } else {
                              if(b1nT_address_suggestions_wrap.keyIndex >= -1) {
                                   b1nT_address_suggestions_wrap.keyIndex--;
                              }

                              if(b1nT_address_suggestions_wrap.keyIndex == -2) {
                                   b1nT_address_suggestions_wrap.keyIndex = b1nT_child_wrappers.length - 1;
                              }
                         }

                         if(b1nT_child_wrappers[b1nT_address_suggestions_wrap.keyIndex]) {
                              let b1nT_nextDiv = b1nT_child_wrappers[b1nT_address_suggestions_wrap.keyIndex].children[0];
                              b1nT_selected(b1nT_nextDiv);
                         } else {
                              b1nT_address_data.config.searchCtrl.value = b1nT_address_suggestions_wrap.keyOrgVal;
                         }

                         //for smooth transition
                         b1nT_address_data.config.searchCtrl.style.caretColor = 'transparent';
                         b1nT_address_data.cursorTimeout = setTimeout(function() {
                              let b1nT_valLength = b1nT_address_data.config.searchCtrl.value.length;
                              b1nT_address_data.config.searchCtrl.setSelectionRange(b1nT_valLength, b1nT_valLength);
                              b1nT_address_data.config.searchCtrl.style.removeProperty("caret-color");
                         }, 10);
                    } else if(b1nT_e.key == "Enter") {
                         if(b1nT_child_wrappers[b1nT_address_suggestions_wrap.keyIndex]) {
                              let b1nT_nextDiv = b1nT_child_wrappers[b1nT_address_suggestions_wrap.keyIndex].children[0];
                              b1nT_nextDiv.click();
                              b1nT_address_data.config.searchCtrl.blur();
                         }
                    }
               }
          });

          b1nT_address_data.config.searchCtrl.addEventListener("focus", function(b1nT_e) {      
               clearTimeout(b1nT_address_data.searchTimeOut);  
               b1nT_address_data.searchTimeOut = setTimeout(function() {
                    if(!String(b1nT_address_data.config.searchCtrl.value).trim()) { return; }
                    b1nT_address_data._b1nT_get_suggestions(b1nT_address_data.config.searchCtrl.value);
                    b1nT_address_data.address_suggestion_wrap.style.boxShadow = "0px 0px 4px 1px #d2d2d2";
               }, 500);
          });

          b1nT_address_data.config.searchCtrl.addEventListener("blur", function(b1nT_e) { 
               clearTimeout(b1nT_address_data.blurTimeOut);  
               b1nT_address_data.blurTimeOut = setTimeout(function() {
                    let b1nT_address_suggestions_wrap_content = document.getElementById("b1nT_"+b1nT_address_data.random_number+"_AddrVldtrSuggestionsContent");
                    if(b1nT_address_suggestions_wrap_content) {
                         b1nT_address_data.config.searchCtrl.value = b1nT_address_suggestions_wrap_content.keyOrgVal;
                    }

                    b1nT_address_data.address_suggestion_wrap.innerHTML = "";
                    b1nT_address_data.address_suggestion_wrap.style.boxShadow = "none";
               }, 500);
          });

          //if we are not using the search bar to act as the address bar, then set an onchange handler. Otherwise skip it
          if(b1nT_address_data.config.addressCtrl && (b1nT_address_data.config.addressCtrl != b1nT_address_data.config.searchCtrl)) {
               b1nT_address_data.config.addressCtrl = b1nT_address_data._b1nT_address_changed;
          }

          b1nT_address_data.config.cityCtrl.onchange   = b1nT_address_data._b1nT_address_changed;
          b1nT_address_data.config.stateCtrl.onchange  = b1nT_address_data._b1nT_address_changed;
          b1nT_address_data.config.postalCtrl.onchange = b1nT_address_data._b1nT_address_changed; 
     };

     this._b1nT_init_legacy = function() {
          let b1nT_search = b1nT_address_data.config.searchCtrl;
          let b1nT_place_auto_complete = new google.maps.places.Autocomplete(
               b1nT_search, { 
                    fields: ['geometry', 'address_component', 'type']
               }
          );

          let b1nT_call_back = function () {
               b1nT_address_data._b1nT_fill_in_address_legacy();
          }

          b1nT_place_auto_complete.addListener('place_changed',  b1nT_call_back);
          b1nT_address_data.placeautocomplete_legacy = b1nT_place_auto_complete;

          //limit the counties to usa and canada
          b1nT_place_auto_complete.setComponentRestrictions({
               country: ['us', 'ca']
          });

          //setup event listensers on fields
          b1nT_address_data.config.addressCtrl.onchange = function() { b1nT_address_data._b1nT_address_changed(1); }
          b1nT_address_data.config.cityCtrl.onchange    = function() { b1nT_address_data._b1nT_address_changed(1); }
          b1nT_address_data.config.stateCtrl.onchange   = function() { b1nT_address_data._b1nT_address_changed(1); }
          b1nT_address_data.config.postalCtrl.onchange  = function() { b1nT_address_data._b1nT_address_changed(1); }
     }

     this._b1nT_get_suggestions = async function(b1nT_v) { 
          //creating a new session if it does not exist.
          const b1nT_token = b1nT_address_data.token_session ? b1nT_address_data.token_session : new google.maps.places.AutocompleteSessionToken();
          b1nT_address_data.token_session = b1nT_token;

          let b1nT_options = {
               sessionToken: b1nT_token,
               input: b1nT_v,
               language: "en-US",
               includedRegionCodes: ["us", "ca"]
          };

          const b1nT_suggestions = await google.maps.places.AutocompleteSuggestion.fetchAutocompleteSuggestions(b1nT_options);
          const b1nT_suggestions_array = b1nT_suggestions.suggestions;

          let b1nT_fill_structure = function(b1nT_address_suggestions_wrap) {
               b1nT_address_suggestions_wrap.innerHTML = "";
               b1nT_address_suggestions_wrap.keyIndex  = "";
               b1nT_address_suggestions_wrap.keyOrgVal = b1nT_address_data.config.searchCtrl.value;

               b1nT_suggestions_array.forEach(function(b1nT_suggestion, b1nT_index) {
                    const b1nT_place_prediction = b1nT_suggestion.placePrediction;
                    let b1nT_input_wrap              = document.createElement("div");
                    let b1nT_input                   = document.createElement("div");
                    b1nT_input.style.whiteSpace      = "nowrap";
                    b1nT_input.style.borderRadius    = "0px";
                    b1nT_input.style.border          = "0px";
                    b1nT_input.style.padding         = "10px";
                    b1nT_input.style.cursor          = "pointer";

                    let b1nT_icon                    = document.createElement("i");
                    b1nT_icon.style.verticalAlign    = "middle";
                    b1nT_icon.style.fontSize         = "14pt";
                    b1nT_icon.style.marginRight      = "5px";
                    b1nT_icon.style.color            = "#808080";

                    b1nT_icon.setAttribute("class", "material-icons");
                    b1nT_icon.innerHTML = "place";

                    b1nT_input.appendChild(b1nT_icon);
                    b1nT_input.innerHTML += b1nT_place_prediction.text.toString();
                    b1nT_input.valHTML = b1nT_place_prediction.text.toString();

                    if(b1nT_index < b1nT_suggestions_array.length - 1) {
                         b1nT_input_wrap.style.borderBottom = "1px solid #d1cfcf";
                    }


                    b1nT_input.onmouseover = function() {
                         this.style.color = "#0174ab";
                         this.style.backgroundColor = "#f5f5f5";
                    };
                    b1nT_input.onmouseout = function() {
                         this.style.removeProperty("color");
                         this.style.removeProperty("background-color");
                    }
                    b1nT_input.onclick = function() {
                         clearTimeout(b1nT_address_data.blurTimeOut);
                         clearTimeout(b1nT_address_data.searchTimeOut);
                         b1nT_address_data._b1nT_fill_in_address(b1nT_place_prediction);
                         b1nT_address_data.address_suggestion_wrap.innerHTML = "";
                         b1nT_address_data.address_suggestion_wrap.style.boxShadow = "none";
                    }

                    b1nT_input_wrap.appendChild(b1nT_input);
                    b1nT_address_suggestions_wrap.appendChild(b1nT_input_wrap);
               });
          };

          let b1nT_build_structure = function() {
               let b1nT_flex_master_div                 = document.createElement("div");
               b1nT_flex_master_div.style.flexDirection = "column";
               b1nT_flex_master_div.style.display       = "flex";

               //content
               let b1nT_address_suggestions_wrap                = document.createElement("div");
               b1nT_address_suggestions_wrap.setAttribute("id", "b1nT_"+b1nT_address_data.random_number+"_AddrVldtrSuggestionsContent");
               b1nT_address_suggestions_wrap.style.border       = "1px solid #d1cfcf";
               b1nT_address_suggestions_wrap.style.borderBottom = "0px";
               b1nT_address_suggestions_wrap.style.overflowY    = "auto";
               b1nT_address_suggestions_wrap.style.maxHeight    = "300px";

               b1nT_fill_structure(b1nT_address_suggestions_wrap);

               b1nT_flex_master_div.appendChild(b1nT_address_suggestions_wrap);

               //logo
               let b1nT_powered_by_wrap = document.createElement("div");
               b1nT_powered_by_wrap.style.border    = "1px solid #d1cfcf";          
               b1nT_powered_by_wrap.style.borderTop = "0px";

               let b1nT_powered_by = document.createElement("div");
               b1nT_powered_by.style.borderRadius  = "0px";
               b1nT_powered_by.style.border        = "0px";
               b1nT_powered_by.style.padding       = "10px";

               b1nT_powered_by.style.color         = "#808080";
               b1nT_powered_by.style.textAlign     = "right";
               b1nT_powered_by.style.fontWeight    = "bold";
               b1nT_powered_by.style.pointerEvents = "none";
               b1nT_powered_by.innerHTML           = "powered by";

               let b1nT_icon = document.createElement("img");
               b1nT_icon.setAttribute("src", b1nT_address_data.config.imageUrl+"/Google_logo.png");

               b1nT_icon.style.height        = "18px";
               b1nT_icon.style.verticalAlign = "middle";
               b1nT_icon.style.marginLeft    = "5px";

               b1nT_powered_by.appendChild(b1nT_icon);
               b1nT_powered_by_wrap.appendChild(b1nT_powered_by);

               b1nT_flex_master_div.appendChild(b1nT_powered_by_wrap);

               //put it together
               b1nT_address_data.address_suggestion_wrap.appendChild(b1nT_flex_master_div);
          };

          let b1nT_address_suggestions_wrap = document.getElementById("b1nT_"+b1nT_address_data.random_number+"_AddrVldtrSuggestionsContent");

          if(!b1nT_address_suggestions_wrap) {
               b1nT_build_structure();
          } else { 
               b1nT_fill_structure(b1nT_address_suggestions_wrap);
          }
     };

     this._b1nT_fill_in_address = async function (b1nT_place_prediction) {
          var b1nT_place = b1nT_place_prediction.toPlace();

          await b1nT_place.fetchFields({fields: ['location', 'addressComponents', 'types', 'displayName']});

          //clear session token, this way we create a
          //new one when the suggestion triggers again
          b1nT_address_data.token_session = undefined;

          if (!b1nT_place.location) {
               b1nT_address_data.b1nT_refresh_google_verification();

               if(b1nT_address_data.dBox) {
                    b1nT_address_data.dBox.b1nT_open_dialog("WARNING!!", 'No details available for input: '+b1nT_place.displayName);
               }
               return;
          }
        
          //get autocompleted address
          let b1nT_street_number = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'street_number' );
          b1nT_street_number.shortText = b1nT_street_number.shortText ? b1nT_street_number.shortText : b1nT_address_data.config.searchCtrl.value.split(' ')[0].replaceAll(/\D/g, '');
  
          let b1nT_street_name = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'street_address' );
          b1nT_street_name = b1nT_street_name.longText ? b1nT_street_name : b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'route' );
          b1nT_street_name = b1nT_street_name.longText ? b1nT_street_name : b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'intersection' );
  
          let b1nT_city = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'locality' );
          b1nT_city = b1nT_city.longText ? b1nT_city : b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'administrative_area_level_3' );
          b1nT_city = b1nT_city.longText ? b1nT_city : b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'sublocality_level_1' );
  
          let b1nT_state = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'administrative_area_level_1' );
          let b1nT_postal = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'postal_code' );         
          let b1nT_postal_suffix = b1nT_address_data._b1nT_find_address_component( b1nT_place.addressComponents, 'postal_code_suffix' );

          //we are done, clear address field
          b1nT_address_data.config.addressCtrl.value = "";

          //however, is state part of the selected country ?
          //if not we dont want to go any further than this
          var found_state = 0;
          for(var option of b1nT_address_data.config.stateCtrl.options) {
               if(option.value == b1nT_state.shortText) {
                    found_state++;
               }
          }

          if(!found_state) {
               b1nT_address_data.b1nT_refresh_google_verification();

               if(b1nT_address_data.dBox) {
                    b1nT_address_data.dBox.b1nT_open_dialog("WARNING!!", "This address appears to reside in a country that is not accepted by this company");
               }
               return;
          }

          b1nT_address_data.config.addressCtrl.value = `${b1nT_street_number.shortText} ${b1nT_street_name.shortText}`;
          b1nT_address_data.config.cityCtrl.value = b1nT_city.longText;
          b1nT_address_data.config.stateCtrl.value = b1nT_state.shortText;
          b1nT_address_data.config.postalCtrl.value = b1nT_postal.shortText;

          //check if the address is rooftop
          let b1nT_verified = 0;
          if(b1nT_place.types.includes('premise') || b1nT_place.location.location_type == 'ROOFTOP' || b1nT_postal_suffix.shortText.length) {
               //TODO::
               b1nT_verified = 1;
          } else if(document.getElementById("b1nT_google_status_bypass").value == "On") {
               //we are going to check for valid cordinates
               let b1nT_coordinate_validate = function() {
                    let b1nT_pattern = new RegExp("^-?[1-9]\\d{1,2}($|\.\\d+$)");

                    if(!b1nT_place.location) { return 0; }

                    let b1nT_lat = b1nT_place.location.lat() * 1;
                    let b1nT_lng = b1nT_place.location.lng() * 1;

                    if(!b1nT_pattern.exec(b1nT_lat)) { return 0; }
                    if(!b1nT_pattern.exec(b1nT_lng)) { return 0; }

                    if(!(b1nT_lat <= 90 && b1nT_lat >= -90)) { return 0; }
                    if(!(b1nT_lng <= 180 && b1nT_lng >= -180)) { return 0; }
                    return 2;
               }

               b1nT_verified = b1nT_coordinate_validate();
          }

          b1nT_address_data.b1nT_refresh_google_verification(b1nT_verified);
     };

     this._b1nT_fill_in_address_legacy = function() {
          var b1nT_place = b1nT_address_data.placeautocomplete_legacy.getPlace();

          if (!b1nT_place.geometry) {
               b1nT_address_data.b1nT_refresh_google_verification();

               if(b1nT_address_data.dBox) {
                    b1nT_address_data.dBox.b1nT_open_dialog("WARNING!!", 'No details available for input: '+b1nT_place.name);
               }
               return;
          }
        
          //get autocompleted address
          let b1nT_street_number = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'street_number', 1);
          b1nT_street_number.short_name = b1nT_street_number.short_name ? b1nT_street_number.short_name : b1nT_address_data.config.searchCtrl.value.split(' ')[0].replaceAll(/\D/g, '');
  
          let b1nT_street_name = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'street_address' );
          b1nT_street_name = b1nT_street_name.long_name ? b1nT_street_name : b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'route', 1);
          b1nT_street_name = b1nT_street_name.long_name ? b1nT_street_name : b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'intersection', 1);
  
          let b1nT_city = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'locality', 1);
          b1nT_city = b1nT_city.long_name ? b1nT_city : b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'administrative_area_level_3', 1);
          b1nT_city = b1nT_city.long_name ? b1nT_city : b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'sublocality_level_1', 1);
  
          let b1nT_state = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'administrative_area_level_1', 1);
          let b1nT_postal = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'postal_code', 1);         
          let b1nT_postal_suffix = b1nT_address_data._b1nT_find_address_component(b1nT_place.address_components, 'postal_code_suffix', 1);

          //we are done, clear address field
          b1nT_address_data.config.addressCtrl.value = "";

          //however, is state part of the selected country ?
          //if not we dont want to go any further than this
          var found_state = 0;
          for(var option of b1nT_address_data.config.stateCtrl.options) {
               if(option.value == b1nT_state.short_name) {
                    found_state++;
               }
          }

          if(!found_state) {
               b1nT_address_data.b1nT_refresh_google_verification();
               if(b1nT_address_data.dBox) {
                    b1nT_address_data.dBox.b1nT_open_dialog("WARNING!!", "This address appears to reside in a country that is not accepted by this company");
               }
               return;
          }

          b1nT_address_data.config.addressCtrl.value = `${b1nT_street_number.short_name} ${b1nT_street_name.short_name}`;
          b1nT_address_data.config.cityCtrl.value    = b1nT_city.long_name;
          b1nT_address_data.config.stateCtrl.value   = b1nT_state.short_name;
          b1nT_address_data.config.postalCtrl.value  = b1nT_postal.short_name;

          //check if the address is rooftop
          let b1nT_verified = 0;
          if(b1nT_place.types.includes('premise') || b1nT_place.geometry.location_type == 'ROOFTOP' || b1nT_postal_suffix.short_name.length) {
               //TODO::
               b1nT_verified = 1;
          } else if(document.getElementById("b1nT_google_status_bypass").value == "On") {
               //we are going to check for valid cordinates
               let b1nT_coordinate_validate = function() {
                    let b1nT_pattern = new RegExp("^-?[1-9]\\d{1,2}($|\.\\d+$)");

                    if(!b1nT_place.geometry) { return 0; }
                    if(!b1nT_place.geometry.location) { return 0; }

                    let b1nT_lat = b1nT_place.geometry.location.lat() * 1;
                    let b1nT_lng = b1nT_place.geometry.location.lng() * 1;

                    if(!b1nT_pattern.exec(b1nT_lat)) { return 0; }
                    if(!b1nT_pattern.exec(b1nT_lng)) { return 0; }

                    if(!(b1nT_lat <= 90 && b1nT_lat >= -90)) { return 0; }
                    if(!(b1nT_lng <= 180 && b1nT_lng >= -180)) { return 0; }
                    return 2;
               }

               b1nT_verified = b1nT_coordinate_validate();
          }

          b1nT_address_data.b1nT_refresh_google_verification(b1nT_verified);
     }

     this._b1nT_find_address_component = function(b1nT_address_array, b1nT_search, b1nT_arg_legacy) {
          for( let i = 0; i < b1nT_address_array.length; i++ ) {
               if ( b1nT_address_array[i].types[0] == b1nT_search ) {
                    return b1nT_address_array[i];
               }
          }
          if(b1nT_arg_legacy) {
               return { long_name: '', short_name: '', types: [ b1nT_search ] };
          }
          return { longText: '', shortText: '', types: [ b1nT_search ] };
     };

     this.b1nT_refresh_google_verification = function(b1nT_arg_code) {
          switch( b1nT_arg_code ) {
               case 1:
                    b1nT_address_data.config.validateCtrl.innerHTML = 'VERIFIED';
                    b1nT_address_data.config.validateCtrl.className = 'b1nT_verify_success';
                    break;
               case 2:
                    b1nT_address_data.config.validateCtrl.innerHTML = 'BYPASSED';
                    b1nT_address_data.config.validateCtrl.className = 'b1nT_verify_success';
                    break;
               default:
                    b1nT_address_data.config.validateCtrl.innerHTML = 'NOT VERIFIED';
                    b1nT_address_data.config.validateCtrl.className = 'b1nT_verify_error';
                    break;
          }
     };

     this._b1nT_address_changed = function(b1nT_arg_legacy) {
          let b1nT_the_work = function() {
               if(b1nT_address_data.config.validateCtrl.className != 'b1nT_verify_error') {
                    b1nT_address_data.b1nT_refresh_google_verification();
               }
               //reset error div if its present
               if(document.getElementsByClassName("b1nT-error-msg") && document.getElementsByClassName("b1nT-error-msg")[0]) {
                    document.getElementsByClassName("b1nT-error-msg")[0].remove();
               }
          };

          if(b1nT_arg_legacy) {
               b1nT_the_work();
               return;
          }

          clearTimeout(b1nT_address_data.changeTimeout);
          b1nT_address_data.changeTimeout = setTimeout(function() {
               b1nT_the_work();  
          }, 500);
     };

     this._b1nT_set_defaults = function() {
          if ( !b1nT_address_data.config.addressCtrl   ) b1nT_address_data.config.addressCtrl   = b1nT_address_data._b1nT_create_input_text_obj();
          if ( !b1nT_address_data.config.cityCtrl      ) b1nT_address_data.config.cityCtrl      = b1nT_address_data._b1nT_create_input_text_obj();
          if ( !b1nT_address_data.config.stateCtrl     ) b1nT_address_data.config.stateCtrl     = b1nT_address_data._b1nT_create_input_text_obj();
          if ( !b1nT_address_data.config.postalCtrl    ) b1nT_address_data.config.postalCtrl    = b1nT_address_data._b1nT_create_input_text_obj();

          if(b1nT_address_data.config.errorShield && b1nT_address_data.config.errorDialog) {
               var config = new Object();
               config.shield_div = b1nT_address_data.config.errorShield;
               config.dialog_box_div = b1nT_address_data.config.errorDialog;
               if((typeof(b1nT_pop_up_dialog) == "function")) {
                    b1nT_address_data.dBox = new b1nT_pop_up_dialog(config);
               }
          }
     };

     this._b1nT_create_input_text_obj = function() {
        let b1nT_input = document.createElement('INPUT');
        b1nT_input.setAttribute('type', 'text');
        return b1nT_input;
     };

     this._b1nT_set_defaults();
     this._b1nT_init();
     return this;
}