<?php
/**
 * Uninstall BetterCX Widget Plugin
 *
 * This file is executed when the plugin is uninstalled.
 * It removes all plugin data from the database.
 *
 * @package BetterCX_Widget
 * @version 1.0.0
 * @author BetterCX
 * @license GPLv2+
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('bettercx_widget_settings');
delete_option('bettercx_widget_version');

// Remove plugin transients
delete_transient('bettercx_widget_cache');
delete_transient('bettercx_widget_connection_test');

// Remove user meta (if any) - using WordPress API instead of direct DB query
$users = get_users(array('fields' => 'ID'));
foreach ($users as $user_id) {
    delete_user_meta($user_id, 'bettercx_widget_user_preferences');
}

// Clear any cached data
wp_cache_flush();
