/**
 * API Types - Generated from backend analysis
 * These types match the backend serializers and endpoints exactly
 */

// Widget Session Creation
export interface WidgetSessionRequest {
  widget_key: string;
  origin: string;
}

export interface WidgetSessionResponse {
  status: string;
  message: string;
  data: {
    token: string;
    expires_at: string; // ISO datetime string
    session_id: string; // JTI from JWT
    attrs?: {
      dark_mode?: {
        primary_color: string;
        secondary_color: string;
        background_color: string;
        text_color: string;
      };
      light_mode?: {
        primary_color: string;
        secondary_color: string;
        background_color: string;
        text_color: string;
      };
    };
    example_questions?: Array<{
      id: number;
      question_text: string;
      answer_text: string;
      created_at: number;
    }>;
    title?: string;
    show_powered_by_bettercx?: boolean;
    agent_name?: string;
  };
}

// Widget Configuration
export interface ColorModeConfig {
  primary_color?: string;
  secondary_color?: string;
  background_color?: string;
  text_color?: string;
}

export interface WidgetConfiguration {
  dark_mode?: ColorModeConfig;
  light_mode?: ColorModeConfig;
}

export interface OrganizationWidgetConfiguration {
  id: number;
  organization: number;
  attrs: WidgetConfiguration;
  created_at: string;
  updated_at: string;
}

// Chat API
export interface MessageRequest {
  content: string;
  images?: File[];
}

export interface Product {
  image_url: string;
  product_name: string;
  product_url: string;
}

export interface ChatMessage {
  content: string;
  author: 'user' | 'assistant';
  timestamp?: string;
  id?: string;
  images?: string[]; // Base64 data URLs for display
  products?: Product[]; // Products to display in slider
  streamingFinished?: boolean; // Whether streaming has finished
}

// Widget API Key (for reference)
export interface WidgetAPIKey {
  id: string;
  name: string;
  public_key: string;
  allowed_origins: string[];
  status: 'active' | 'inactive' | 'revoked';
  created_at: string;
  updated_at: string;
  last_used_at?: string;
  total_requests: number;
}

// Error responses
export interface APIError {
  error: string;
  details?: Record<string, unknown>;
}

// Widget Events
export interface WidgetEvent {
  type: 'opened' | 'closed' | 'message-sent' | 'message-received' | 'error' | 'config-loaded' | 'session-created';
  data?: Record<string, unknown>;
  timestamp: string;
}

// Widget Configuration Options
export interface WidgetOptions {
  publicKey: string;
  orgId?: number;
  theme?: 'light' | 'dark' | 'auto';
  palette?: string;
  disableShadow?: boolean;
  debug?: boolean;
  baseUrl?: string;
  aiServiceUrl?: string;
}

// Chat Messages API
export interface BackendMessage {
  id: string; // UUID
  chat: string; // UUID
  author: 'user' | 'ai';
  content: string;
  used_text_tokens: number;
  created_at: string; // ISO datetime
  updated_at: string; // ISO datetime
  ai_settings?: number | null;
  sent: boolean;
  has_no_answer?: boolean | null;
  are_conditions_met?: boolean | null;
  processing_time?: number | null;
  attachments?: Array<{
    id: string;
    message: string;
    file_path: string;
  }>;
  error: boolean;
}

export interface PaginatedMessagesResponse {
  count: number;
  num_pages: number;
  current_page: number;
  page_size: number;
  has_next: boolean;
  has_previous: boolean;
  results: BackendMessage[];
}

// Chat List Item (for localStorage)
export interface ChatListItem {
  chatId: string;
  lastMessage: string;
  lastMessageTimestamp: string; // ISO datetime
}

// Internal Widget State
export interface WidgetState {
  isOpen: boolean;
  isAuthenticated: boolean;
  isLoading: boolean;
  error?: string;
  sessionToken?: string;
  sessionExpiresAt?: Date;
  chatId?: string; // Chat ID for maintaining conversation context
  config?: OrganizationWidgetConfiguration;
  messages: ChatMessage[];
  isTyping: boolean;
  exampleQuestions?: Array<{
    id: number;
    question_text: string;
    answer_text: string;
    created_at: number;
  }>;
  title?: string;
  showPoweredByBetterCX?: boolean;
  logo?: string;
  welcomeMessage?: string;
  welcomeMessagePlacement?: 'header' | 'message'; // Where to show welcome message
  triggerMessages?: Array<{
    id: number;
    url: string;
    message: string;
    is_default: boolean;
    trigger_after_seconds: number;
    created_at: string;
    updated_at: string;
  }>; // Array of trigger messages from backend
  selectedTriggerMessage?: {
    id: number;
    url: string;
    message: string;
    is_default: boolean;
    trigger_after_seconds: number;
    created_at: string;
    updated_at: string;
  }; // The trigger message selected based on URL matching
  showPingMessage?: boolean; // Added to control ping message visibility
  agentName?: string; // Added for custom agent name from backend
  currentPage?: number; // Current page of messages loaded
  hasNextPage?: boolean; // Whether there are more messages to load
  isLoadingMore?: boolean; // Whether we are currently loading more messages
}
