import { newE2EPage } from '@stencil/core/testing';

describe('bettercx-widget e2e', () => {
  it('renders', async () => {
    const page = await newE2EPage();
    await page.setContent('<bettercx-widget public-key="pk_test_key"></bettercx-widget>');

    const element = await page.find('bettercx-widget');
    expect(element).toBeDefined();
  });

  it('handles component lifecycle', async () => {
    const page = await newE2EPage();
    await page.setContent('<bettercx-widget public-key="pk_test_key"></bettercx-widget>');

    // Wait for component to initialize
    await page.waitForChanges();

    // The component should be rendered (even if it shows an error due to network issues)
    const element = await page.find('bettercx-widget');
    expect(element).toBeTruthy();
  });

  it('handles missing public key', async () => {
    const page = await newE2EPage();
    await page.setContent('<bettercx-widget></bettercx-widget>');

    // Wait for component to initialize
    await page.waitForChanges();

    // The component should be rendered
    const element = await page.find('bettercx-widget');
    expect(element).toBeTruthy();
  });
});
