jQuery(document).ready(function ($) {
  // Test connection functionality
  $('#test-connection').on('click', function (e) {
    e.preventDefault();

    var button = $(this);
    var originalText = button.text();

    button.prop('disabled', true).text('Testing...');

    $.ajax({
      url: bettercxWidgetAdmin.ajaxUrl,
      type: 'POST',
      data: {
        action: 'bettercx_test_connection',
        nonce: bettercxWidgetAdmin.nonce,
      },
      success: function (response) {
        if (response.success) {
          alert('Connection test successful!');
        } else {
          alert('Connection test failed: ' + response.data);
        }
      },
      error: function () {
        alert('Connection test failed: Network error');
      },
      complete: function () {
        button.prop('disabled', false).text(originalText);
      },
    });
  });

  // Form validation
  $('#bettercx-widget-settings-form').on('submit', function (e) {
    var publicKey = $('input[name="bettercx_widget_settings[public_key]"]').val();

    if (!publicKey.trim()) {
      e.preventDefault();
      alert('Public key is required.');
      $('input[name="bettercx_widget_settings[public_key]"]').focus();
      return false;
    }
  });
});
