<?php

class ITSEC_Malware_Scheduling_Scanner {
	/**
	 * Get the next site ID to scan based on the current site ID.
	 *
	 * @param int $site_id
	 *
	 * @return int|null
	 */
	public static function get_next_site_id( $site_id ) {

		global $wpdb;

		$id = $wpdb->get_var( $wpdb->prepare( "SELECT `blog_id` FROM {$wpdb->blogs} WHERE `public` = 1 AND `archived` = 0 AND `deleted` = 0 AND `blog_id` > %d ORDER BY `blog_id` ASC LIMIT 1", $site_id ) );

		if ( null === $id ) {
			return null;
		}

		if ( is_main_site( $id ) ) {
			return static::get_next_site_id( $id );
		}

		return (int) $id;
	}
}
