<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/public/partials
 */
defined( 'ABSPATH' ) || exit();

class Bc_Public_Main_Display {

    public static function output() {
        $beep_settings = get_option( 'beep_notifier_plugin_settings', [] );

        // Fetch settings with sanitization
        $blsn_theme          = isset( $beep_settings['blsn_theme'] ) ? sanitize_text_field( $beep_settings['blsn_theme'] ) : '';
        $blsn_position       = isset( $beep_settings['blsn_position'] ) ? sanitize_text_field( $beep_settings['blsn_position'] ) : '';
        $blsn_size           = isset( $beep_settings['blsn_size'] ) ? absint( $beep_settings['blsn_size'] ) : '';
        $blsn_cose_option    = isset( $beep_settings['blsn_cose_option'] ) ? (bool) $beep_settings['blsn_cose_option'] : false;
        $blsn_mobile_visible = isset( $beep_settings['blsn_mobile_visible'] ) ? (bool) $beep_settings['blsn_mobile_visible'] : false;
        $blsn_image          = isset( $beep_settings['blsn_image'] ) ? sanitize_text_field( $beep_settings['blsn_image'] ) : '';
        $blsn_show_on        = isset( $beep_settings['blsn_show_on'] ) ? sanitize_text_field( $beep_settings['blsn_show_on'] ) : 'everywhere';
        $blsn_show_on_location = isset( $beep_settings['blsn_show_on_location'] ) ? (array) $beep_settings['blsn_show_on_location'] : [];

        // Determine notification position styles
        $position_style = '';
        if ( $blsn_position === 'bottom_left' ) {
            $position_style = 'left: 20px; right: auto;';
        } elseif ( $blsn_position === 'bottom_right' ) {
            $position_style = 'left: auto; right: 20px;';
        }

        // Define width style
        $width_style = !empty( $blsn_size ) ? "width: {$blsn_size}px;" : 'width: 320px;';
        $mobile_class = $blsn_mobile_visible ? '' : 'hide-on-mobile';

        // Check if we should display on the current page when "selected" is active
        if ( $blsn_show_on === 'selected' ) {
            $show = false;

            if ( ! empty( $blsn_show_on_location ) ) {
                foreach ( $blsn_show_on_location as $location ) {
                    switch ( $location ) {
                        case 'front_page':
                            if ( is_front_page() ) $show = true;
                            break;
                        case 'blog_page':
                            if ( is_home() ) $show = true;
                            break;
                        case 'shop_page':
                            if ( function_exists('is_shop') && is_shop() ) $show = true;
                            break;
                        case 'cart_page':
                            if ( function_exists('is_cart') && is_cart() ) $show = true;
                            break;
                        case 'checkout_page':
                            if ( function_exists('is_checkout') && is_checkout() ) $show = true;
                            break;
                        case 'single_product_page':
                            if ( function_exists('is_product') && is_product() ) $show = true;
                            break;
                        case 'all_posts_pages_custom':
                            if ( is_singular() ) $show = true;
                            break;
                    }
                }
            }

            if ( ! $show ) {
                return;
            }
        }

        ?>

        <div class="bc-notification <?php echo esc_attr( $mobile_class ); ?> bc-notification-theme-<?php echo esc_attr( $blsn_theme ); ?>" 
             id="bc-notification" 
             style="<?php echo esc_attr( $position_style . $width_style ); ?>">
            
            <?php if ( $blsn_cose_option ): ?>
                <div class="bc-close" id="bc-close">&times;</div>
            <?php endif; ?>

            <!-- Theme-specific content -->
            <?php if ( in_array( $blsn_theme, ['1', '2', '3', '4', '5', '6', '7', '8', '9'], true ) ): ?>
                <div class="bc-content">
                    <div class="bc-image-container">
                        <?php if ( $blsn_image === 'featured' ): ?>
                            <img src="<?php echo esc_url(plugins_url('assets/images/beepnotifier.png', dirname(__FILE__))); ?>" 
                                 alt="<?php esc_attr_e( 'Theme Image', 'beep-notifier' ); ?>" 
                                 class="bc-image">
                        <?php endif; ?>
                    </div>
                    
                    <div class="bc-text-content">
                        <a href="#">
                            <span class="bc-user-name"><?php esc_html_e( 'John Doe', 'beep-notifier' ); ?></span> 
                            <span class="bc-static-text"><?php esc_html_e( 'just purchased', 'beep-notifier' ); ?></span><br> 
                            <strong class="bc-product-name"><?php esc_html_e( 'BeepNotifier Pro', 'beep-notifier' ); ?></strong>!
                            <span class="bc-order-time"><?php esc_html_e( '2 minutes ago', 'beep-notifier' ); ?></span>
                        </a>
                    </div>

                    <?php if ( $blsn_theme === '5' ): ?>
                        <a href="#" class="bc-buy-now"><?php esc_html_e( 'Buy Now', 'beep-notifier' ); ?></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            
        </div>

        <?php
    }
}
?>
