(function ($) {
    'use strict';

    jQuery(document).ready(function ($) {
        let salesData = [];
        let currentIndex = 0;
        let selectedTheme = beep_ajax.theme || '1';
        let mobile_class = beep_ajax.mobile_class || '1';
        let showAnimation = beep_ajax.show_animation || 'fade_in';
        let hideAnimation = beep_ajax.hide_animation || 'fade_out';
        let loopNotifications = parseInt(beep_ajax.loop) === 1;
        let openNewTab = parseInt(beep_ajax.open_new_tab) === 1;

        // Fetch user-defined delay settings
        let firstDelay = parseInt(beep_ajax.first_delay) * 1000 || 3000; // Convert to milliseconds
        let displayTime = parseInt(beep_ajax.display_time) * 1000 || 4000;
        let betweenDelay = parseInt(beep_ajax.between_delay) * 1000 || 2000;

        function fetchSalesData() {
            $.ajax({
                url: beep_ajax.ajax_url,
                type: 'POST',
                data: { action: 'beep_get_recent_sales' },
                success: function (response) {
                    if (response.success && response.data.length > 0) {
                        salesData = response.data;
                        currentIndex = 0;
                        setTimeout(ShowNextBeepNotification, firstDelay);
                    }
                },
                error: function () {
                    console.log('Error fetching sales data.');
                }
            });
        }

        function ShowNextBeepNotification() {
            if (salesData.length === 0) return;

            if (currentIndex >= salesData.length) {
                if (loopNotifications) {
                    currentIndex = 0; // Restart loop
                } else {
                    return; // Stop notifications
                }
            }

            let sale = salesData[currentIndex];

            // Update notification content
            $('#bc-notification .bc-text-content').html(
                `<a href="${sale.link}" class="bc-link" ${openNewTab ? 'target="_blank"' : ''}>
                    <span class="bc-user-name">${sale.name || 'Someone'}</span> <span class="bc-static-text">just purchased</span> <br>
                    <strong class="bc-product-name">${sale.product}</strong>!<span class="bc-order-time">${sale.time}</span>
                </a>`
            );
            $('#bc-notification .bc-image').attr('src', sale.image || 'https://example.com/default.jpg');

            // Remove old animations and apply new ones
            $('#bc-notification')
                .removeClass()
                .addClass(`bc-notification ${mobile_class} bc-notification-theme-${selectedTheme} animated ${showAnimation}`)
                .show();

            setTimeout(function () {
                $('#bc-notification')
                    .removeClass(showAnimation)
                    .addClass(hideAnimation);

                setTimeout(function () {
                    $('#bc-notification').hide();
                    currentIndex++;
                    setTimeout(ShowNextBeepNotification, betweenDelay);
                }, 1000); // Adjust delay to match animation duration
            }, displayTime);


            if (selectedTheme === '5') {
                $('.bc-buy-now').attr({
                    'href': sale.link,
                    'target': openNewTab ? '_blank' : '_self'
                });
            }

        }

        

        // Allow manual close
        $('#bc-close').click(function () {
            $('#bc-notification').hide();
        });

        fetchSalesData();
    });
})(jQuery);
