<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/public
 */

defined( 'ABSPATH' ) || exit();

$beep_settings = get_option( 'beep_notifier_plugin_settings', [] );

// Sanitize settings
$blsn_bg_color       = isset( $beep_settings['blsn_bg_color'] ) ? sanitize_hex_color( $beep_settings['blsn_bg_color'] ) : '';
$blsn_text_color     = isset( $beep_settings['blsn_text_color'] ) ? sanitize_hex_color( $beep_settings['blsn_text_color'] ) : '';

$blsn_want_border    = isset( $beep_settings['blsn_want_border'] ) ? absint( $beep_settings['blsn_want_border'] ) : 0;
$blsn_border_size    = isset( $beep_settings['blsn_border_size'] ) ? absint( $beep_settings['blsn_border_size'] ) : 1;
$blsn_border_style   = isset( $beep_settings['blsn_border_style'] ) ? sanitize_text_field( $beep_settings['blsn_border_style'] ) : 'solid';
$blsn_border_color   = isset( $beep_settings['blsn_border_color'] ) ? sanitize_hex_color( $beep_settings['blsn_border_color'] ) : '';

$blsn_font_size_first  = isset( $beep_settings['blsn_font_size_first'] ) ? absint( $beep_settings['blsn_font_size_first'] ) : 14;
$blsn_font_size_second = isset( $beep_settings['blsn_font_size_second'] ) ? absint( $beep_settings['blsn_font_size_second'] ) : 12;
$blsn_font_size_third  = isset( $beep_settings['blsn_font_size_third'] ) ? absint( $beep_settings['blsn_font_size_third'] ) : 10;

$blsn_image_shape    = isset( $beep_settings['blsn_image_shape'] ) ? sanitize_text_field( $beep_settings['blsn_image_shape'] ) : 'circle';
$blsn_image_position = isset( $beep_settings['blsn_image_position'] ) ? sanitize_text_field( $beep_settings['blsn_image_position'] ) : 'left';

// Generate border CSS if enabled
$bc_notifier_border_css = $blsn_want_border ? ".bc-notification { border: {$blsn_border_size}px {$blsn_border_style} {$blsn_border_color}; }" : "";

// Image shape CSS 
$bc_image_shape_styles = [
    'circle'  => '.bc-image { border-radius: 50%; }',
    'rounded' => '.bc-image { border-radius: 5px; }',
    'square'  => '.bc-image { border-radius: 0px; }'
];

$bc_image_shape_css = isset( $bc_image_shape_styles[ $blsn_image_shape ] ) ? $bc_image_shape_styles[ $blsn_image_shape ] : '';

// Image position
$bc_image_position_css = $blsn_image_position === 'right' ? 'order: 2; margin-left: 15px;' : 'order: 0; margin-right: 15px;';

// Custom CSS block
$bc_custom_css = "
    .bc-notification {
        background-color: {$blsn_bg_color};
    }
    .bc-text-content a {
        color: {$blsn_text_color};
    }
    {$bc_notifier_border_css}
    .bc-user-name,
    .bc-static-text {
        font-size: {$blsn_font_size_first}px;
    }
    .bc-product-name {
        font-size: {$blsn_font_size_second}px;
    }
    .bc-order-time {
        font-size: {$blsn_font_size_third}px;
    }
    {$bc_image_shape_css}
    .bc-image-container {
        {$bc_image_position_css}
    }
";
?>
