<?php

/**
 * Fired during plugin activation
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/includes
 */

/**
 * Handles actions during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/includes
 * @author     Beepcoder <hello@beepcoder.com>
 */
class Beep_Notifier_Activator {

    /**
     * Runs on plugin activation.
     *
     * @since 1.0.0
     */
    public static function activate() {

        // Default settings
        $default_options = [
            'blsn_theme'              => 1,
            'blsn_advance_design'     => 0,
            'blsn_bg_color'           => '#ffffff',
            'blsn_text_color'         => '#000000',
            'blsn_want_border'        => 0,
            'blsn_border_size'        => 1,  // Changed to integer
            'blsn_border_style'       => 'solid',
            'blsn_border_color'       => '#cccccc',
            'blsn_font_size_first'    => 16, // Changed to integer
            'blsn_font_size_second'   => 14, // Changed to integer
            'blsn_font_size_third'    => 12, // Changed to integer
            'blsn_image_shape'        => 'square',
            'blsn_image_position'     => 'left',
            'blsn_template'           => 'first_name',
            'blsn_random_order'       => 0,
            'blsn_order_status'       => ['completed'], // Changed to an array
            'blsn_order_limit'        => 10,
            'blsn_link_type'          => 'none',
            'blsn_show_defult_image'  => 0,
            'blsn_default_image'      => '',
            'blsn_image'              => 'featured',
            'blsn_show_on'            => 'everywhere',
            'blsn_show_on_location'   => [], // Changed to an array
            'blsn_position'           => 'bottom_left',
            'blsn_size'               => 300,
            'blsn_cose_option'        => 1,
            'blsn_mobile_visible'     => 0,
            'blsn_show_animation'     => 'default_in',
            'blsn_hide_animation'     => 'default_out',
            'blsn_delay_first'        => 2,
            'blsn_display_time'       => 5,
            'blsn_delay_between_time' => 2,
            'blsn_loop'               => 1,
            'blsn_open_link_new_tab'  => 0,
        ];

        // Check if the settings already exist
        $current_settings = get_option('beep_notifier_plugin_settings', []);

        // Merge default options with existing settings (avoid overwriting existing values)
        $new_settings = array_merge($default_options, $current_settings);

        // Save or update the settings
        update_option('beep_notifier_plugin_settings', $new_settings);
    }

}
