<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. It includes all dependencies, registers activation/deactivation hooks,
 * and initializes the plugin.
 *
 * @link              https://beepcoder.com
 * @since             1.0.0
 * @package           Beep_Notifier
 *
 * @wordpress-plugin
 * Plugin Name:       Beep Notifier
 * Plugin URI:        https://beepcoder.com/plugins/beep-notification
 * Description:       A WooCommerce live sale notification plugin that displays recent purchases to boost conversions.
 * Version:           1.0.0
 * Author:            Beepcoder
 * Author URI:        https://beepcoder.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       beep-notifier
 * Domain Path:       /languages
 */

// Prevent direct file access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ensure the PHP version is compatible (recommended: PHP 7.4+)
 */
if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
	function beep_notifier_php_version_error() {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		wp_die(
			'<strong>Beep Notifier requires PHP 7.4 or higher.</strong> Your site is running PHP ' . PHP_VERSION .
			'. Please update your PHP version or contact your hosting provider.',
			'Plugin Activation Error',
			['back_link' => true]
		);
	}
	add_action( 'admin_init', 'beep_notifier_php_version_error' );
	return;
}

/**
 * Define plugin version constant.
 */
define( 'BEEP_NOTIFIER_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 */
function activate_beep_notifier() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-beep-notifier-activator.php';
	Beep_Notifier_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_beep_notifier() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-beep-notifier-deactivator.php';
	Beep_Notifier_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_beep_notifier' );
register_deactivation_hook( __FILE__, 'deactivate_beep_notifier' );

/**
 * Load the core plugin class that initializes hooks.
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/class-beep-notifier.php';

/**
 * Begins execution of the plugin.
 */
function run_beep_notifier() {
	if ( class_exists( 'Beep_Notifier' ) ) {
		$plugin = new Beep_Notifier();
		$plugin->run();
	}
}
run_beep_notifier();
