<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/admin/partials
 */

defined( 'ABSPATH' ) || exit();


class Bc_Admin_Main_Display {

    public static function output(){

    	$beep_settings = get_option('beep_notifier_plugin_settings', []);

		$blsn_theme              = isset($beep_settings['blsn_theme']) ? $beep_settings['blsn_theme'] : '';
		$blsn_advance_design     = isset($beep_settings['blsn_advance_design']) ? intval($beep_settings['blsn_advance_design']) : 1;

		$blsn_bg_color           = isset($beep_settings['blsn_bg_color']) ? sanitize_hex_color($beep_settings['blsn_bg_color']) : '';
      $blsn_text_color         = isset($beep_settings['blsn_text_color']) ? sanitize_hex_color($beep_settings['blsn_text_color']) : '';
		$blsn_want_border        = isset($beep_settings['blsn_want_border']) ? intval($beep_settings['blsn_want_border']) : 0;
      $blsn_border_size        = isset($beep_settings['blsn_border_size']) ? absint($beep_settings['blsn_border_size']) : '';
      $blsn_border_style       = isset($beep_settings['blsn_border_style']) ? sanitize_text_field($beep_settings['blsn_border_style']) : '';
      $blsn_border_color       = isset($beep_settings['blsn_border_color']) ? sanitize_hex_color($beep_settings['blsn_border_color']) : '';

		$blsn_font_size_first    = isset($beep_settings['blsn_font_size_first']) ? $beep_settings['blsn_font_size_first'] : '';
		$blsn_font_size_second   = isset($beep_settings['blsn_font_size_second']) ? $beep_settings['blsn_font_size_second'] : '';
		$blsn_font_size_third    = isset($beep_settings['blsn_font_size_third']) ? $beep_settings['blsn_font_size_third'] : '';

		$blsn_image_shape        = isset($beep_settings['blsn_image_shape']) ? $beep_settings['blsn_image_shape'] : '';
		$blsn_image_position     = isset($beep_settings['blsn_image_position']) ? $beep_settings['blsn_image_position'] : '';

		$blsn_template           = isset($beep_settings['blsn_template']) ? $beep_settings['blsn_template'] : '';
		$blsn_random_order       = isset($beep_settings['blsn_random_order']) ? $beep_settings['blsn_random_order'] : 0;
		$blsn_order_status       = isset($beep_settings['blsn_order_status']) ? $beep_settings['blsn_order_status'] : array();
		$blsn_order_limit        = isset($beep_settings['blsn_order_limit']) ? $beep_settings['blsn_order_limit'] : '';
		$blsn_link_type          = isset($beep_settings['blsn_link_type']) ? $beep_settings['blsn_link_type'] : '';

		$blsn_show_defult_image  = isset($beep_settings['blsn_show_defult_image']) ? $beep_settings['blsn_show_defult_image'] : 0;
		$blsn_default_image      = isset($beep_settings['blsn_default_image']) ? $beep_settings['blsn_default_image'] : '';
		$blsn_image              = isset($beep_settings['blsn_image']) ? $beep_settings['blsn_image'] : '';

		$blsn_show_on            = isset($beep_settings['blsn_show_on']) ? $beep_settings['blsn_show_on'] : '';
		$blsn_show_on_location   = isset($beep_settings['blsn_show_on_location']) ? $beep_settings['blsn_show_on_location'] : array();
		$blsn_position           = isset($beep_settings['blsn_position']) ? $beep_settings['blsn_position'] : '';
		$blsn_size               = isset($beep_settings['blsn_size']) ? $beep_settings['blsn_size'] : '';
		$blsn_cose_option        = isset($beep_settings['blsn_cose_option']) ? $beep_settings['blsn_cose_option'] : 0;
		$blsn_mobile_visible     = isset($beep_settings['blsn_mobile_visible']) ? $beep_settings['blsn_mobile_visible'] : 0;

		$blsn_show_animation     = isset($beep_settings['blsn_show_animation']) ? $beep_settings['blsn_show_animation'] : '';
		$blsn_hide_animation     = isset($beep_settings['blsn_hide_animation']) ? $beep_settings['blsn_hide_animation'] : '';

		$blsn_delay_first        = isset($beep_settings['blsn_delay_first']) ? $beep_settings['blsn_delay_first'] : '';
		$blsn_display_time       = isset($beep_settings['blsn_display_time']) ? $beep_settings['blsn_display_time'] : '';
		$blsn_delay_between_time = isset($beep_settings['blsn_delay_between_time']) ? $beep_settings['blsn_delay_between_time'] : '';

		$blsn_loop               = isset($beep_settings['blsn_loop']) ? $beep_settings['blsn_loop'] : 0;
		$blsn_open_link_new_tab  = isset($beep_settings['blsn_open_link_new_tab']) ? $beep_settings['blsn_open_link_new_tab'] : 0;

      ?>
     <div class="bc-page-wrapper">
	   <div class="bc-header-section">
	      <div class="bc-header d-flex justify-content-between">
	         <div class="bc-header-left">
	            <!-- <h2>Beep Notifier Settings</h2> -->
	            <img src="<?php echo esc_url(plugins_url('assets/images/beepnotifier.png', dirname(__FILE__))); ?>">
	         </div>
	         <div class="bc-header-right">
	            <span><?php esc_html_e('BeepNotifier:', 'beep-notifier'); ?> <strong><?php echo esc_html(defined('BEEP_NOTIFIER_VERSION') ? BEEP_NOTIFIER_VERSION : '1.0.0'); ?></strong></span>
	         </div>
	      </div>
	   </div>
	  <?php if (isset($_GET['saved']) && sanitize_text_field($_GET['saved']) === 'true') : ?>
		    <div class="notice notice-success is-dismissible">
		        <p><?php esc_html_e('Settings saved successfully.', 'beep-notifier'); ?></p>
		    </div>
		<?php endif; ?>
	   <div class="bc-settigns-wrapper">
	      <div class="bc-container">
	         <div class="bc-settings-tab-area">
	            <div class="row">
	               <div class="col-md-12">
	                  <ul class="nav nav-tabs" id="customTabs">
	                     <li class="nav-item">
	                        <a class="nav-link active" data-bs-toggle="tab" href="#design">Design</a>
	                     </li>
	                     <li class="nav-item">
	                        <a class="nav-link" data-bs-toggle="tab" href="#message">Content</a>
	                     </li>
	                     <li class="nav-item">
	                        <a class="nav-link" data-bs-toggle="tab" href="#display">Display</a>
	                     </li>
	                     <li class="nav-item">
	                        <a class="nav-link" data-bs-toggle="tab" href="#customize">Customize</a>
	                     </li>
	                  </ul>
	               </div>
	            </div>
	         </div>
	         <div class="bc-settings-tab-contact-area">
	            <div class="row">
	               <div class="col-md-9">
	                  <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
	                     <input type="hidden" name="action" value="beep_save_settings">
	                     <?php wp_nonce_field('beep_save_settings_action', 'beep_save_settings_nonce'); ?>
	                     <div class="tab-content mt-3">
	                        <div class="tab-pane fade show active" id="design">
	                           <div class="bc-settings-container">
	                              <div class="settings-header"><?php esc_html_e('Themes', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 
	                              	<div class="row g-3 mb-3">
												   <?php
												    $themes = [
												        1 => __('Theme 1', 'beep-notifier'),
												        2 => __('Theme 2', 'beep-notifier'),
												        3 => __('Theme 3', 'beep-notifier'),
												        4 => __('Theme 4', 'beep-notifier'),
												        5 => __('Theme 5', 'beep-notifier'),
												        6 => __('Theme 6', 'beep-notifier'),
												    ];

												    // Sanitize selected theme
												    $blsn_theme = isset($blsn_theme) ? sanitize_text_field($blsn_theme) : '';

												    foreach ($themes as $value => $label) {
												        $image_url = esc_url(plugins_url("assets/images/beep-notify-theme-{$value}.png", dirname(__FILE__)));
												        $is_pro = in_array($value, [3, 4, 5, 6]); // Themes 3-6 are "pro" versions

												        ?>
												        <div class="col-6 col-md-4 col-lg-4 <?php echo $is_pro ? 'pro-deactivated' : ''; ?>">
												            <label class="bc-image-radio">
												                <?php if ($is_pro) : ?>
												                    <span class="bc-pro-icon bc-pro-over-img"></span>
												                <?php endif; ?>
												                <input type="radio" name="blsn_theme" value="<?php echo esc_attr($value); ?>" <?php checked($blsn_theme, $value); ?>>
												                <img src="<?php echo esc_attr($image_url); ?>" alt="<?php echo esc_attr($label); ?>">
												            </label>
												        </div>
												        <?php
												    }
												    ?>
												</div>

	                                 <div class="row mb-3">
                                       <label for="blsn_advance_design" class="col-sm-3 col-form-label"><?php esc_html_e('Advanced Design', 'beep-notifier'); ?></label>
                                       <div class="col-sm-6">
                                          <label class="bc-custom-switch">
                                          <input type="checkbox" name="blsn_advance_design" id="blsn_advance_design" <?php checked($blsn_advance_design, 1); ?>>
                                          <span class="slider"></span>
                                          </label>
                                       </div>
                                    </div>
	                              </div>
	                           </div>

	                          <div id="bc_advance_design" style="display: none;">
		                           <div class="bc-settings-container mt-3">
		                              <div class="settings-header"><?php esc_html_e('Design', 'beep-notifier'); ?></div>
		                              <div class="bc-settings-body">
		                              	<div class="row mb-3">
	                                       <label for="blsn_bg_color" class="col-sm-3 col-form-label"><?php esc_html_e('Background Color', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input name="blsn_bg_color" id="blsn_bg_color" class="my-color-field" type="text" value="<?php echo esc_attr(sanitize_hex_color($blsn_bg_color)); ?>" data-default-color="#fff" />
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_text_color" class="col-sm-3 col-form-label"><?php esc_html_e('Text  Color', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input name="blsn_text_color" id="blsn_text_color" class="my-color-field" type="text" value="<?php echo esc_attr(sanitize_hex_color($blsn_text_color)); ?>" data-default-color="#092161" />
	                                       </div>
	                                    </div>
	                        				<div class="row mb-3">
	                                       <label for="blsn_want_border" class="col-sm-3 col-form-label"><?php esc_html_e('Want Border?', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_want_border" id="blsn_want_border" <?php checked(intval($blsn_want_border), 1); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>

	                                    <div id="blsn_border_proparty" style="display:none;" >
	                                    	<div class="row mb-3">
		                                       <label for="blsn_border_size" class="col-sm-3 col-form-label"><?php esc_html_e('Border Size', 'beep-notifier'); ?></label>
		                                       <div class="col-sm-6">
		                                          <input type="number" class="form-control" min="0" step="1" name="blsn_border_size" id="blsn_border_size" value="<?php echo esc_attr(absint($blsn_border_size)); ?>">
		                                       </div>
		                                    </div>
		                                    <div class="row mb-3">
		                                       <label for="blsn_border_style" class="col-sm-3 col-form-label"><?php esc_html_e('Border Style', 'beep-notifier'); ?></label>
		                                       <div class="col-sm-6">
		                                           <select class="form-control" name="blsn_border_style" id="blsn_border_style" style="max-width: 100%;">
													            <?php
													            $border_styles = [
													                'solid'  => __('Solid', 'beep-notifier'),
													                'dashed' => __('Dashed', 'beep-notifier'),
													                'dotted' => __('Dotted', 'beep-notifier'),
													            ];

													            // Sanitize selected option
													            $blsn_border_style = isset($blsn_border_style) ? sanitize_text_field($blsn_border_style) : '';

													            foreach ($border_styles as $value => $label) {
													                printf(
													                    '<option value="%s" %s>%s</option>',
													                    esc_attr($value),
													                    selected($blsn_border_style, $value, false),
													                    esc_html($label)
													                );
													            }
													            ?>
													         </select>
		                                       </div>
		                                    </div>
		                                    <div class="row mb-3">
		                                       <label for="blsn_border_color" class="col-sm-3 col-form-label"><?php esc_html_e('Border Color', 'beep-notifier'); ?></label>
		                                       <div class="col-sm-6">
		                                          <input name="blsn_border_color" id="blsn_border_color" class="my-color-field" type="text" value="<?php echo esc_attr(sanitize_hex_color($blsn_border_color)); ?>" data-default-color="#000" />
		                                       </div>
		                                    </div>
	                                    </div>

		                              </div>
		                           </div>
		                           <div class="bc-settings-container mt-3">
		                              <div class="settings-header"><?php esc_html_e('Typography', 'beep-notifier'); ?></div>
		                              <div class="bc-settings-body">
		                              	<div class="row mb-3">
	                                       <label for="blsn_font_size_first" class="col-sm-3 col-form-label"><?php esc_html_e('Font Size', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" class="form-control" min="1" name="blsn_font_size_first" id="blsn_font_size_first" value="<?php echo esc_attr(absint($blsn_font_size_first)); ?>">
	                                          <small><?php esc_html_e('This font size will be applied for first row', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_font_size_second" class="col-sm-3 col-form-label"><?php esc_html_e('Font Size', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" class="form-control" min="1" name="blsn_font_size_second" id="blsn_font_size_second" value="<?php echo esc_attr(absint($blsn_font_size_second)); ?>">
	                                          <small><?php esc_html_e('This font size will be applied for second row', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_font_size_third" class="col-sm-3 col-form-label"><?php esc_html_e('Font Size', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" class="form-control" name="blsn_font_size_third" id="blsn_font_size_third" value="<?php echo esc_attr(absint($blsn_font_size_third)); ?>" min="1">
	                                          <small><?php esc_html_e('This font size will be applied for third  row', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
		                              </div>
		                           </div>
		                           <div class="bc-settings-container mt-3">
		                              <div class="settings-header"><?php esc_html_e('Image Appearance', 'beep-notifier'); ?></div>
		                              <div class="bc-settings-body">
		                              	<div class="row mb-3">
	                                       <label for="blsn_image_shape" class="col-sm-3 col-form-label"><?php esc_html_e('Image Shape', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                         <select class="form-control" name="blsn_image_shape" id="blsn_image_shape">
												            <?php
												            $image_shapes = [
												                'circle'  => __('Circle', 'beep-notifier'),
												                'rounded' => __('Rounded', 'beep-notifier'),
												                'square'  => __('Square', 'beep-notifier'),
												            ];

												            // Sanitize selected option
												            $blsn_image_shape = isset($blsn_image_shape) ? sanitize_text_field($blsn_image_shape) : '';

												            foreach ($image_shapes as $value => $label) {
												                printf(
												                    '<option value="%s" %s>%s</option>',
												                    esc_attr($value),
												                    selected($blsn_image_shape, $value, false),
												                    esc_html($label)
												                );
												            }
												            ?>
												        </select>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_image_position" class="col-sm-3 col-form-label"><?php esc_html_e('Image Position', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                             <select class="form-control" name="blsn_image_position" id="blsn_image_position">
													            <?php
													            $image_positions = [
													                'left'  => __('Left', 'beep-notifier'),
													                'right' => __('Right', 'beep-notifier'),
													            ];

													            // Sanitize selected option
													            $blsn_image_position = isset($blsn_image_position) ? sanitize_text_field($blsn_image_position) : '';

													            foreach ($image_positions as $value => $label) {
													                printf(
													                    '<option value="%s" %s>%s</option>',
													                    esc_attr($value),
													                    selected($blsn_image_position, $value, false),
													                    esc_html($label)
													                );
													            }
													            ?>
													        </select>
	                                       </div>
	                                    </div>
		                              </div>
		                           </div>
	                          </div>

	                           <div class="bc-btn-area mt-3">
	                              <button class="btn btn-primary bc-btn"><?php esc_html_e('Save All Changes', 'beep-notifier'); ?></button>
	                           </div>
	                        </div>
	                        <div class="tab-pane fade" id="message">
	                           <div class="bc-settings-container">
	                              <div class="settings-header"><?php esc_html_e('Content', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3">
	                                       <label for="blsn_template" class="col-sm-3 col-form-label"><?php esc_html_e('Customer Name', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                            <select class="form-control" name="blsn_template" id="blsn_template">
													            <?php
													            $template_options = [
													                'first_name' => __('First Name', 'beep-notifier'),
													                'last_name'  => __('Last Name', 'beep-notifier'),
													                'full_name'  => __('Full Name', 'beep-notifier'),
													            ];

													            // Sanitize selected option
													            $blsn_template = isset($blsn_template) ? sanitize_text_field($blsn_template) : '';

													            foreach ($template_options as $value => $label) {
													                printf(
													                    '<option value="%s" %s>%s</option>',
													                    esc_attr($value),
													                    selected($blsn_template, $value, false),
													                    esc_html($label)
													                );
													            }
													            ?>
													        </select>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_random_order" class="col-sm-3 col-form-label"><?php esc_html_e('Randor Order', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_random_order" id="blsn_random_order" <?php checked( intval( $blsn_random_order ), 1 ); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_order_limit" class="col-sm-3 col-form-label"><?php esc_html_e('Order Limit', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" name="blsn_order_limit" value="<?php echo esc_attr($blsn_order_limit); ?>" class="form-control" id="blsn_order_limit">
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_order_status" class="col-sm-3 col-form-label"><?php esc_html_e('Order Status', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" name="blsn_order_status[]" id="blsn_order_status" multiple>
												            <?php
												            $order_statuses = [
												                'processing' => __('Processing', 'beep-notifier'),
												                'completed'  => __('Completed', 'beep-notifier'),
												                'on-hold'    => __('On Hold', 'beep-notifier'),
												            ];

												            $blsn_order_status = is_array($blsn_order_status) ? array_map('sanitize_text_field', $blsn_order_status) : [];

												            foreach ($order_statuses as $value => $label) {
												                printf(
												                    '<option value="%s" %s>%s</option>',
												                    esc_attr($value),
												                    in_array($value, $blsn_order_status, true) ? 'selected' : '',
												                    esc_html($label)
												                );
												            }
												            ?>
												         </select>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_link_type" class="col-sm-3 col-form-label"><?php esc_html_e('Link Type', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" name="blsn_link_type" id="blsn_link_type">
												            <?php
												            $link_types = [
												                'product_page' => __('Product Page', 'beep-notifier'),
												                'none'         => __('None', 'beep-notifier'),
												            ];

												            // Sanitize selected option
           													$blsn_link_type = isset($blsn_link_type) ? sanitize_text_field($blsn_link_type) : '';

												            foreach ($link_types as $value => $label) {
												                printf(
												                    '<option value="%s" %s>%s</option>',
												                    esc_attr($value),
												                    selected($blsn_link_type, $value, false),
												                    esc_html($label)
												                );
												            }
												            ?>
												        </select>
	                                       </div>
	                                    </div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-btn-area mt-3">
	                              <button class="btn btn-primary bc-btn"><?php esc_html_e('Save All Changes', 'beep-notifier'); ?></button>
	                           </div>
	                        </div>
	                        <div class="tab-pane fade" id="display">
	                           <div class="bc-settings-container">
	                              <div class="settings-header"><?php esc_html_e('IMAGE', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3">
	                                       <label for="beep_show_defult_image" class="col-sm-3 col-form-label"><?php esc_html_e('Show Default Image', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_show_defult_image" id="beep_show_defult_image" <?php checked($blsn_show_defult_image, 1); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                    <!-- Image Selection Section -->
													<div id="bcImageSelection" class="row mb-4" style="display: none;">
													    <label class="col-sm-3 col-form-label"><?php esc_html_e('Choose an Image', 'beep-notifier'); ?></label>
														<div class="col-sm-6 d-flex flex-wrap gap-2">
														    <?php
														    $images = [
														        'bc-check.png'           => __('Check', 'beep-notifier'),
														        'bc-flame.png'           => __('Flame', 'beep-notifier'),
														        'bc-notification.png'    => __('Notification', 'beep-notifier'),
														        'bc-avatar-male.png'     => __('Male Avatar', 'beep-notifier'),
														        'bc-avatar-female.png'   => __('Female Avatar', 'beep-notifier'),
														        'bc-avatar-s.png'        => __('Small Avatar', 'beep-notifier'),
														    ];

														    $blsn_default_image = isset($blsn_default_image) ? sanitize_text_field($blsn_default_image) : '';

														    foreach ($images as $filename => $label) {
														        $image_url = esc_url(plugins_url('assets/images/' . $filename, dirname(__FILE__)));
														        ?>
														        <label class="bc-image-option">
														            <input type="radio" name="blsn_default_image" value="<?php echo esc_attr($image_url); ?>"
														                <?php checked($blsn_default_image, $image_url); ?>>
														            <img src="<?php echo esc_attr($image_url); ?>" class="img-thumbnail" width="70px" alt="<?php echo esc_attr($label); ?>">
														        </label>
														        <?php
														    }
														    ?>
														</div>
													</div>
	                                    <div class="row mb-3">
													    <label for="blsn_image" class="col-sm-3 col-form-label"><?php esc_html_e('Image', 'beep-notifier'); ?></label>
													    <div class="col-sm-6">
													        <select class="form-control" name="blsn_image" id="blsn_image">
													            <?php
													            $image_options = [
													                'featured' => __('Featured Images', 'beep-notifier'),
													                'none'     => __('None', 'beep-notifier'),
													            ];

													            // Sanitize selected option
													            $blsn_image = isset($blsn_image) ? sanitize_text_field($blsn_image) : '';

													            foreach ($image_options as $value => $label) {
													                printf(
													                    '<option value="%s" %s>%s</option>',
													                    esc_attr($value),
													                    selected($blsn_image, $value, false),
													                    esc_html($label)
													                );
													            }
													            ?>
													        </select>
													    </div>
													</div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-settings-container mt-3">
	                              <div class="settings-header"><?php esc_html_e('Visibility', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_show_on" class="col-sm-3 col-form-label"><?php esc_html_e('Show On', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" name="blsn_show_on" id="blsn_show_on">
	                                             <option value="everywhere" <?php selected($blsn_show_on, 'everywhere'); ?>>Show Everywhere</option>
	                                             <option value="selected" <?php selected($blsn_show_on, 'selected'); ?>>Show On Selected</option>
	                                          </select>
	                                       </div>
	                                    </div>
	                                     <div class="row mb-3" id="bc_location_select" style="display: none;">
													   <label for="blsn_show_on_location" class="col-sm-3 col-form-label"><?php esc_html_e('Locations', 'beep-notifier'); ?></label>
													   <div class="col-sm-6">
													      <select class="form-control" name="blsn_show_on_location[]" id="blsn_show_on_location" multiple>
												            <?php 
												            $locations = [
												                'front_page'             => __('Front Page', 'beep-notifier'),
												                'blog_page'              => __('Blog Page', 'beep-notifier'),
												                'shop_page'              => __('Shop Page', 'beep-notifier'),
												                'cart_page'              => __('Cart Page', 'beep-notifier'),
												                'checkout_page'          => __('Checkout Page', 'beep-notifier'),
												                'single_product_page'    => __('Product Page', 'beep-notifier'),
												                'all_posts_pages_custom' => __('All Posts, Pages and Custom Post Types', 'beep-notifier'),
												            ];

												            // Ensure $blsn_show_on_location is an array
												            $blsn_show_on_location = is_array($blsn_show_on_location) ? array_map('sanitize_text_field', $blsn_show_on_location) : [];

												            foreach ($locations as $key => $label) {
												                $selected = in_array($key, $blsn_show_on_location) ? 'selected' : '';
												                echo '<option value="' . esc_attr($key) . '" ' . esc_attr($selected) . '>' . esc_html($label) . '</option>';
												            }
												            ?>
												         </select>
													   </div>
													</div>

	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-btn-area mt-3">
	                              <button class="btn btn-primary bc-btn"><?php esc_html_e('Save All Changes', 'beep-notifier'); ?></button>
	                           </div>
	                        </div>
	                        <div class="tab-pane fade" id="customize">
	                           <div class="bc-settings-container mt-3">
	                              <div class="settings-header"><?php esc_html_e('Appearance', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3">
	                                       <label for="blsn_position" class="col-sm-3 col-form-label"><?php esc_html_e('Position', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" id="blsn_position" name="blsn_position">
	                                             <option value="bottom_left" <?php selected( esc_attr( $blsn_position ), 'bottom_left' ); ?>><?php esc_html_e('Bottom Left', 'beep-notifier'); ?></option>
	                                             <option value="bottom_right" <?php selected( esc_attr($blsn_position), 'bottom_right'); ?>><?php esc_html_e('Bottom Right', 'beep-notifier'); ?></option>
	                                          </select>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_size" class="col-sm-3 col-form-label"><?php esc_html_e('Notification Size', 'beep-notifier'); ?></span></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" class="form-control" name="blsn_size" id="blsn_size" value="<?php echo esc_attr($blsn_size); ?>">
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_cose_option" class="col-sm-3 col-form-label"><?php esc_html_e('Display Close Option', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_cose_option" id="blsn_cose_option" <?php checked($blsn_cose_option, 1); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_mobile_visible" class="col-sm-3 col-form-label"><?php esc_html_e('Mobile Visibility', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_mobile_visible" id="blsn_mobile_visible" <?php checked($blsn_mobile_visible, 1); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-settings-container mt-3">
	                              <div class="settings-header"><?php esc_html_e('Animation', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_show_animation" class="col-sm-3 col-form-label"><?php esc_html_e('Notification Show', 'beep-notifier'); ?> <span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" name="blsn_show_animation" id="blsn_show_animation">
												            <?php
												            $animations = [
												                'default_in'    => __('Default', 'beep-notifier'),
												                'fade_in'       => __('Fade In', 'beep-notifier'),
												                'fade_in_up'    => __('Fade In Up', 'beep-notifier'),
												                'fade_in_down'  => __('Fade In Down', 'beep-notifier'),
												                'fade_in_left'  => __('Fade In Left', 'beep-notifier'),
												                'fade_in_right' => __('Fade In Right', 'beep-notifier'),
												                'zoom_in'       => __('Zoom In', 'beep-notifier'),
												                'slide_in_up'   => __('Slide In Up', 'beep-notifier'),
												                'slide_in_down' => __('Slide In Down', 'beep-notifier'),
												                'slide_in_left' => __('Slide In Left', 'beep-notifier'),
												                'slide_in_right'=> __('Slide In Right', 'beep-notifier'),
												            ];

												            // Sanitize the selected option
            												$blsn_show_animation = isset($blsn_show_animation) ? sanitize_text_field($blsn_show_animation) : '';

												            foreach ($animations as $value => $label) {
												                printf(
												                    '<option value="%s" %s>%s</option>',
												                    esc_attr($value),
												                    selected($blsn_show_animation, $value, false),
												                    esc_html($label)
												                );
												            }
												            ?>
												        </select>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_hide_animation" class="col-sm-3 col-form-label"><?php esc_html_e('Notification Hide', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <select class="form-control" name="blsn_hide_animation" id="blsn_hide_animation">
												            <?php
												            $animations = [
												                'default_out'     => __('Default', 'beep-notifier'),
												                'fade_out'        => __('Fade Out', 'beep-notifier'),
												                'fade_out_up'     => __('Fade Out Up', 'beep-notifier'),
												                'fade_out_down'   => __('Fade Out Down', 'beep-notifier'),
												                'fade_out_left'   => __('Fade Out Left', 'beep-notifier'),
												                'fade_out_right'  => __('Fade Out Right', 'beep-notifier'),
												                'zoom_out'        => __('Zoom Out', 'beep-notifier'),
												                'slide_out_up'    => __('Slide Out Up', 'beep-notifier'),
												                'slide_out_down'  => __('Slide Out Down', 'beep-notifier'),
												                'slide_out_left'  => __('Slide Out Left', 'beep-notifier'),
												                'slide_out_right' => __('Slide Out Right', 'beep-notifier'),
												            ];

												            // Sanitize the selected option
            												$blsn_hide_animation = isset($blsn_hide_animation) ? sanitize_text_field($blsn_hide_animation) : '';

												            foreach ($animations as $value => $label) {
												                printf(
												                    '<option value="%s" %s>%s</option>',
												                    esc_attr($value),
												                    selected($blsn_hide_animation, $value, false),
												                    esc_html($label)
												                );
												            }
												            ?>
												        </select>
	                                       </div>
	                                    </div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-settings-container mt-3">
	                              <div class="settings-header"><?php esc_html_e('Timing', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3">
	                                       <label for="blsn_frist_delay_time" class="col-sm-3 col-form-label"><?php esc_html_e('Delay Before First Notification', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" name="blsn_delay_first" value="<?php echo esc_attr($blsn_delay_first); ?>" class="form-control" id="blsn_delay_first">
	                                          <small><?php esc_html_e('Initial Delay * seconds', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_display_time" class="col-sm-3 col-form-label"><?php esc_html_e('Display For', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" name="blsn_display_time" value="<?php echo esc_attr($blsn_display_time); ?>" class="form-control" id="blsn_display_time">
	                                          <small><?php esc_html_e('Display each notification for * seconds', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3">
	                                       <label for="blsn_delay_between_time" class="col-sm-3 col-form-label"><?php esc_html_e('Delay Between', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <input type="number" name="blsn_delay_between_time" value="<?php echo esc_attr($blsn_delay_between_time); ?>"  class="form-control" id="blsn_delay_between_time">
	                                          <small><?php esc_html_e('Delay between each notification', 'beep-notifier'); ?></small>
	                                       </div>
	                                    </div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-settings-container mt-3">
	                              <div class="settings-header"><?php esc_html_e('Behavior', 'beep-notifier'); ?></div>
	                              <div class="bc-settings-body">
	                                 <div class="bc-settings-form">
	                                    <div class="row mb-3">
	                                       <label for="blsn_loop" class="col-sm-3 col-form-label"><?php esc_html_e('Loop Notification', 'beep-notifier'); ?></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_loop" id="blsn_loop" <?php checked($blsn_loop, 1); ?>>
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                    <div class="row mb-3 pro-deactivated">
	                                       <label for="blsn_open_link_new_tab" class="col-sm-3 col-form-label"><?php esc_html_e('Open Link In New Tab', 'beep-notifier'); ?><span class="bc-pro-icon"></span></label>
	                                       <div class="col-sm-6">
	                                          <label class="bc-custom-switch">
	                                          <input type="checkbox" name="blsn_open_link_new_tab" <?php checked($blsn_open_link_new_tab, 1); ?> id="blsn_open_link_new_tab">
	                                          <span class="slider"></span>
	                                          </label>
	                                       </div>
	                                    </div>
	                                 </div>
	                              </div>
	                           </div>
	                           <div class="bc-btn-area mt-3">
	                              <button class="btn btn-primary bc-btn"><?php esc_html_e('Save All Changes', 'beep-notifier'); ?></button>
	                           </div>
	                        </div>
	                     </div>
	                  </form>
	               </div>
	               <div class="col-md-3">
						    <div class="bc-settings-sidebar mt-3">

						        <!-- Show Your Love Section -->
						        <div class="bc-settings-container mb-3">
						            <div class="settings-header"><?php esc_html_e('Show Your Love', 'beep-notifier'); ?></div>
						            <div class="bc-settings-body">
						                <div class="bc-sidebar-content">
						                    <p><?php esc_html_e('We love having you in the Beep Notifier family. We are making it more awesome every day. Please take two minutes to review the plugin and spread the love to encourage us to keep it going.', 'beep-notifier'); ?></p>
						                    <a href="<?php echo esc_url('https://wordpress.org/support/plugin/beep-notifier/reviews'); ?>" target="_blank" rel="noopener noreferrer">
						                        <?php esc_html_e('Leave a Review', 'beep-notifier'); ?>
						                    </a>
						                </div>
						            </div>
						        </div>

						        <!-- Join Our Community Section -->
						        <div class="bc-settings-container mb-3">
						            <div class="settings-header"><?php esc_html_e('Join Our Community', 'beep-notifier'); ?></div>
						            <div class="bc-settings-body">
						                <div class="bc-sidebar-content">
						                    <p><?php esc_html_e('Join the Facebook community to discuss with fellow developers, connect with others, and stay updated.', 'beep-notifier'); ?></p>
						                    <a href="<?php echo esc_url('https://www.facebook.com/beepcoder/'); ?>" target="_blank" rel="noopener noreferrer">
						                        <?php esc_html_e('Join Our Community', 'beep-notifier'); ?>
						                    </a>
						                </div>
						            </div>
						        </div>

						        <!-- Need Any Help Section -->
						        <div class="bc-settings-container">
						            <div class="settings-header"><?php esc_html_e('Need Any Help?', 'beep-notifier'); ?></div>
						            <div class="bc-settings-body">
						                <div class="bc-sidebar-content">
						                    <p><?php esc_html_e('If you encounter issues or need assistance, we\'re here to help. You can also report specific problems on our GitHub issues page.', 'beep-notifier'); ?></p>
						                    <a href="<?php echo esc_url('https://github.com/BeepCoder16/beep-notifier/issues'); ?>" target="_blank" rel="noopener noreferrer">
						                        <?php esc_html_e('Contact Us', 'beep-notifier'); ?>
						                    </a>
						                </div>
						            </div>
						        </div>

						    </div>
						</div>
	            </div>
	         </div>
	      </div>
	   </div>
	</div>
   <?php
  }

    
}

?>
