(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$(document).ready(function () {

		$('.my-color-field').wpColorPicker();

		// Load the last active tab from localStorage
	    var activeTab = localStorage.getItem("beep_active_tab");
	    if (activeTab) {
	        $('#customTabs a[href="' + activeTab + '"]').tab('show');
	    }

	    // Save the selected tab to localStorage when clicked
	    $('#customTabs a').on('click', function () {
	        var selectedTab = $(this).attr('href');
	        localStorage.setItem("beep_active_tab", selectedTab);
	    });


	    // for beep_show_defult_image
        var $toggleSwitch = $("#beep_show_defult_image");
        var $imageSelection = $("#bcImageSelection");

        function toggleImageSelection() {
            if ($toggleSwitch.is(":checked")) {
                $imageSelection.show();
            } else {
                $imageSelection.hide();
            }
        }

        $toggleSwitch.change(toggleImageSelection);
        toggleImageSelection();

        // for blsn_want_border
        var $borderToggleSwitch = $("#blsn_want_border");
        var $proparySelection = $("#blsn_border_proparty");

        function toggleBorderSelection() {
            if ($borderToggleSwitch.is(":checked")) {
                $proparySelection.show();
            } else {
                $proparySelection.hide();
            }
        }

        $borderToggleSwitch.change(toggleBorderSelection);
        toggleBorderSelection();


        // for blsn_advance_design
        var $AdToggleSwitch = $("#blsn_advance_design");
        var $advanceDesignSelection = $("#bc_advance_design");

        function toggleDesignSelection() {
            if ($AdToggleSwitch.is(":checked")) {
                $advanceDesignSelection.show();
            } else {
                $advanceDesignSelection.hide();
            }
        }

        $AdToggleSwitch.change(toggleDesignSelection);
        toggleDesignSelection();


        // for blsn_show_on
        function toggleLocationDropdown() {
            var selectedValue = $("#blsn_show_on").val();
            if (selectedValue === "selected") {
                $("#bc_location_select").show();
            } else {
                $("#bc_location_select").hide();
            }
        }

        $("#blsn_show_on").change(toggleLocationDropdown);
        toggleLocationDropdown();


        $('#blsn_show_on_location').select2({
            placeholder: 'Select locations',
            allowClear: true,
            width: '100%'
        });

        $('#blsn_order_status').select2({
            placeholder: 'Select locations',
            allowClear: true,
            width: '100%'
        });

        $('.pro-deactivated').on('click', function(e) {
          e.preventDefault(); 
            Swal.fire({
                icon: 'warning',
                title: 'Opps...',
                text: 'You need to upgrade to the Premium Version to use this feature.',
                showCancelButton: true,
                confirmButtonText: 'Upgrade Now',
                cancelButtonText: 'Cancel'
              }).then((result) => {
                if (result.isConfirmed) {
                  window.open('https://beepcoder.com/beep-notifier', '_blank');
                }
            });

        });

         $(".pro-deactivated input, .pro-deactivated select").prop("disabled", false);


    });

})( jQuery );
