<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/admin
 * @author     Beepcoder <hello@beepcoder.com>
 */
class Beep_Notifier_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Beep_Notifier_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Beep_Notifier_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// Load assets only on Beep Notifier admin pages.
        $screen = get_current_screen();
        if ( isset( $screen->id ) && $screen->id !== 'toplevel_page_beep-notifier' ) {
            return;
        }

        // Enqueue styles
        wp_enqueue_style( 'beep-bootstrap', esc_url( plugin_dir_url( __FILE__ ) . 'css/bootstrap.min.css' ), [], $this->version, 'all' );
        wp_enqueue_style( 'beep-swel2', esc_url( plugin_dir_url( __FILE__ ) . 'css/sweetalert2.min.css' ), [], $this->version, 'all' );
        wp_enqueue_style( 'beep-select2', esc_url( plugin_dir_url( __FILE__ ) . 'css/select2.min.css' ), [], $this->version, 'all' );
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_style( $this->plugin_name, esc_url( plugin_dir_url( __FILE__ ) . 'css/beep-notifier-admin.css' ), [], $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Beep_Notifier_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Beep_Notifier_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		$screen = get_current_screen();
        if ( isset( $screen->id ) && $screen->id !== 'toplevel_page_beep-notifier' ) {
            return;
        }

		wp_enqueue_script( "beep-bootstrap", plugin_dir_url( __FILE__ ) . 'js/bootstrap.bundle.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( "beep-swel2", plugin_dir_url( __FILE__ ) . 'js/sweetalert2.all.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( "beep-select2", plugin_dir_url( __FILE__ ) . 'js/select2.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/beep-notifier-admin.js', array( 'jquery','wp-color-picker'), $this->version, false );
		

	}

	public function bc_remove_wpcontent_padding(){
		
		$screen = get_current_screen();
	    if ( isset( $screen->id ) && $screen->id === 'toplevel_page_beep-notifier' ) {
	        echo '<style>
	            #wpcontent {
	                padding-left: 0 !important;
	            }
	        </style>';
	    }
	}

	/**
	 * Add action links to the plugin listing page.
	 *
	 * @since 1.0.0
	 */
	public function beep_notifier_add_action_links( $links ) {
	    
	    $settings_link = '<a href="' . esc_url(admin_url('admin.php?page=beep-notifier')) . '">' . __('Settings', 'beep-notifier') . '</a>';
	    $pro_link = '<a href="https://beepcoder.com/beep-notifier-pro" target="_blank" style="color: #ff5722; font-weight: bold;">' . __('Go to Pro', 'beep-notifier') . '</a>';

	    // Add the custom links before the default links
	    array_unshift( $links, $settings_link, $pro_link );

	    return $links;
	}

}
