<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://beepcoder.com
 * @since      1.0.0
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/admin
 */

/**
 * Handles the admin menu for Beep Notifier.
 *
 * Registers the main menu and submenus in the WordPress admin dashboard.
 *
 * @package    Beep_Notifier
 * @subpackage Beep_Notifier/admin
 * @author     Beepcoder <hello@beepcoder.com>
 */
class Beep_Notifier_Admin_Menu {

    /**
     * Initializes the class and hooks into WordPress.
     */
    public function __construct() {
        add_action('admin_menu', [$this, 'bc_register_admin_menu']);
    }

    /**
     * Registers the admin menu for the Beep Notifier plugin.
     */
    public function bc_register_admin_menu() {
        $menu_slug = sanitize_key('beep-notifier');

        add_menu_page(
            esc_html__('Beep Notifier', 'beep-notifier'),
            esc_html__('Beep Notifier', 'beep-notifier'),
            'manage_options',
            $menu_slug,
            ['Bc_Admin_Main_Display', 'output'],
            esc_url(plugin_dir_url(__FILE__) . 'assets/images/beep-notifier-icon.png'),
        );
    }
}

// Initialize the class.
new Beep_Notifier_Admin_Menu();
