<?php
defined('ABSPATH') || exit();

/**
 * Beep_Notifier_Admin_Action Class
 */
class Beep_Notifier_Admin_Action {
    public static function init() {
        add_action('admin_post_beep_save_settings', [__CLASS__, 'beep_save_plugin_settings']);
    }

    public static function beep_save_plugin_settings() {
        // Verify nonce for security
        if (!isset($_POST['beep_save_settings_nonce']) || 
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['beep_save_settings_nonce'])), 'beep_save_settings_action')) {
            wp_die(esc_html__('Security check failed.', 'beep-notifier'));
        }

        // Check user capability
        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('You do not have permission to perform this action.', 'beep-notifier'));
        }

        // Sanitize checkbox fields
        $checkbox_fields = [
            'blsn_advance_design',
            'blsn_want_border',
            'blsn_random_order',
            'blsn_show_defult_image',
            'blsn_cose_option',
            'blsn_loop',
            'blsn_open_link_new_tab',
        ];

        $options = [];
        foreach ($checkbox_fields as $field) {
            $options[$field] = isset($_POST[$field]) ? 1 : 0;
        }

        // Sanitize text fields
        $text_fields = [
            'blsn_bg_color'       => 'sanitize_hex_color',
            'blsn_text_color'     => 'sanitize_hex_color',
            'blsn_border_color'   => 'sanitize_hex_color',
            'blsn_border_style'   => 'sanitize_text_field',
            'blsn_font_size_first'=> 'sanitize_text_field',
            'blsn_font_size_second'=> 'sanitize_text_field',
            'blsn_font_size_third'=> 'sanitize_text_field',
            'blsn_image_shape'    => 'sanitize_text_field',
            'blsn_image_position' => 'sanitize_text_field',
            'blsn_template'       => 'sanitize_text_field',
            'blsn_position'       => 'sanitize_text_field',
            'blsn_show_on'        => 'sanitize_text_field',
            'blsn_link_type'      => 'sanitize_text_field',
        ];

        foreach ($text_fields as $field => $sanitize_callback) {
            $options[$field] = isset($_POST[$field]) ? call_user_func($sanitize_callback, wp_unslash($_POST[$field])) : '';
        }

        // Sanitize numeric fields
        $number_fields = [
            'blsn_border_size',
            'blsn_order_limit',
            'blsn_size',
            'blsn_delay_first',
            'blsn_display_time',
            'blsn_delay_between_time',
        ];

        foreach ($number_fields as $field) {
            $options[$field] = isset($_POST[$field]) ? absint(wp_unslash($_POST[$field])) : 0;
        }

        // Sanitize selected locations (array)
        $options['blsn_show_on_location'] = isset($_POST['blsn_show_on_location']) 
            ? array_map('sanitize_text_field', wp_unslash($_POST['blsn_show_on_location'])) 
            : [];

        // Sanitize order statuses (array)
        $options['blsn_order_status'] = isset($_POST['blsn_order_status']) 
            ? array_map('sanitize_text_field', wp_unslash($_POST['blsn_order_status'])) 
            : ['processing', 'completed'];

        // Sanitize animations with `wp_unslash()`
        $valid_animations = [
            'default_in', 'fade_in', 'fade_in_up', 'fade_in_down',
            'fade_in_left', 'fade_in_right', 'zoom_in', 'slide_in_up',
            'slide_in_down', 'slide_in_left', 'slide_in_right',
        ];

        $options['blsn_show_animation'] = isset($_POST['blsn_show_animation']) 
            ? (in_array(wp_unslash($_POST['blsn_show_animation']), $valid_animations, true) 
                ? sanitize_text_field(wp_unslash($_POST['blsn_show_animation'])) 
                : 'default_in') 
            : 'default_in';

        $valid_hide_animations = [
            'default_out', 'fade_out', 'fade_out_up', 'fade_out_down',
            'fade_out_left', 'fade_out_right', 'zoom_out', 'slide_out_up',
            'slide_out_down', 'slide_out_left', 'slide_out_right',
        ];

        $options['blsn_hide_animation'] = isset($_POST['blsn_hide_animation']) 
            ? (in_array(wp_unslash($_POST['blsn_hide_animation']), $valid_hide_animations, true) 
                ? sanitize_text_field(wp_unslash($_POST['blsn_hide_animation'])) 
                : 'default_out') 
            : 'default_out';

        // Sanitize images
        $options['blsn_default_image'] = isset($_POST['blsn_default_image']) 
            ? esc_url_raw(wp_unslash($_POST['blsn_default_image'])) 
            : '';

        $options['blsn_image'] = isset($_POST['blsn_image']) 
            ? sanitize_text_field(wp_unslash($_POST['blsn_image'])) 
            : '';

        // Sanitize theme selection (only allow valid values)
        $valid_themes = ['1', '2', '3', '4', '5', '6'];
        $options['blsn_theme'] = isset($_POST['blsn_theme']) && in_array(wp_unslash($_POST['blsn_theme']), $valid_themes, true) 
            ? absint(wp_unslash($_POST['blsn_theme'])) 
            : 1;

        // Update options in the database
        update_option('beep_notifier_plugin_settings', $options);

        // Redirect back to settings page with success message
        wp_safe_redirect(admin_url('admin.php?page=beep-notifier&saved=true'));
        exit;
    }
}

Beep_Notifier_Admin_Action::init();
