/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/classnames/index.js":
/*!******************************************!*\
  !*** ./node_modules/classnames/index.js ***!
  \******************************************/
/***/ ((module, exports) => {

eval("{var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!\n\tCopyright (c) 2018 Jed Watson.\n\tLicensed under the MIT License (MIT), see\n\thttp://jedwatson.github.io/classnames\n*/\n/* global define */\n\n(function () {\n\t'use strict';\n\n\tvar hasOwn = {}.hasOwnProperty;\n\n\tfunction classNames () {\n\t\tvar classes = '';\n\n\t\tfor (var i = 0; i < arguments.length; i++) {\n\t\t\tvar arg = arguments[i];\n\t\t\tif (arg) {\n\t\t\t\tclasses = appendClass(classes, parseValue(arg));\n\t\t\t}\n\t\t}\n\n\t\treturn classes;\n\t}\n\n\tfunction parseValue (arg) {\n\t\tif (typeof arg === 'string' || typeof arg === 'number') {\n\t\t\treturn arg;\n\t\t}\n\n\t\tif (typeof arg !== 'object') {\n\t\t\treturn '';\n\t\t}\n\n\t\tif (Array.isArray(arg)) {\n\t\t\treturn classNames.apply(null, arg);\n\t\t}\n\n\t\tif (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {\n\t\t\treturn arg.toString();\n\t\t}\n\n\t\tvar classes = '';\n\n\t\tfor (var key in arg) {\n\t\t\tif (hasOwn.call(arg, key) && arg[key]) {\n\t\t\t\tclasses = appendClass(classes, key);\n\t\t\t}\n\t\t}\n\n\t\treturn classes;\n\t}\n\n\tfunction appendClass (value, newClass) {\n\t\tif (!newClass) {\n\t\t\treturn value;\n\t\t}\n\t\n\t\tif (value) {\n\t\t\treturn value + ' ' + newClass;\n\t\t}\n\t\n\t\treturn value + newClass;\n\t}\n\n\tif ( true && module.exports) {\n\t\tclassNames.default = classNames;\n\t\tmodule.exports = classNames;\n\t} else if (true) {\n\t\t// register as 'classnames', consistent with npm package name\n\t\t!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {\n\t\t\treturn classNames;\n\t\t}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n\t} else // removed by dead control flow\n{}\n}());\n\n\n//# sourceURL=webpack://bb-plugin/./node_modules/classnames/index.js?\n}");

/***/ }),

/***/ "./node_modules/colorjs.io/dist/color.js":
/*!***********************************************!*\
  !*** ./node_modules/colorjs.io/dist/color.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Color)\n/* harmony export */ });\n// A is m x n. B is n x p. product is m x p.\nfunction multiplyMatrices (A, B) {\n\tlet m = A.length;\n\n\tif (!Array.isArray(A[0])) {\n\t\t// A is vector, convert to [[a, b, c, ...]]\n\t\tA = [A];\n\t}\n\n\tif (!Array.isArray(B[0])) {\n\t\t// B is vector, convert to [[a], [b], [c], ...]]\n\t\tB = B.map(x => [x]);\n\t}\n\n\tlet p = B[0].length;\n\tlet B_cols = B[0].map((_, i) => B.map(x => x[i])); // transpose B\n\tlet product = A.map(row => B_cols.map(col => {\n\t\tlet ret = 0;\n\n\t\tif (!Array.isArray(row)) {\n\t\t\tfor (let c of col) {\n\t\t\t\tret += row * c;\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t}\n\n\t\tfor (let i = 0; i < row.length; i++) {\n\t\t\tret += row[i] * (col[i] || 0);\n\t\t}\n\n\t\treturn ret;\n\t}));\n\n\tif (m === 1) {\n\t\tproduct = product[0]; // Avoid [[a, b, c, ...]]\n\t}\n\n\tif (p === 1) {\n\t\treturn product.map(x => x[0]); // Avoid [[a], [b], [c], ...]]\n\t}\n\n\treturn product;\n}\n\n/**\n * Various utility functions\n */\n\n\n/**\n * Check if a value is a string (including a String object)\n * @param {*} str - Value to check\n * @returns {boolean}\n */\nfunction isString (str) {\n\treturn type(str) === \"string\";\n}\n\n/**\n * Determine the internal JavaScript [[Class]] of an object.\n * @param {*} o - Value to check\n * @returns {string}\n */\nfunction type (o) {\n\tlet str = Object.prototype.toString.call(o);\n\n\treturn (str.match(/^\\[object\\s+(.*?)\\]$/)[1] || \"\").toLowerCase();\n}\n\nfunction serializeNumber (n, {precision, unit }) {\n\tif (isNone(n)) {\n\t\treturn \"none\";\n\t}\n\n\treturn toPrecision(n, precision) + (unit ?? \"\");\n}\n\n/**\n * Check if a value corresponds to a none argument\n * @param {*} n - Value to check\n * @returns {boolean}\n */\nfunction isNone (n) {\n\treturn Number.isNaN(n) || (n instanceof Number && n?.none);\n}\n\n/**\n * Replace none values with 0\n */\nfunction skipNone (n) {\n\treturn isNone(n) ? 0 : n;\n}\n\n/**\n * Round a number to a certain number of significant digits\n * @param {number} n - The number to round\n * @param {number} precision - Number of significant digits\n */\nfunction toPrecision (n, precision) {\n\tif (n === 0) {\n\t\treturn 0;\n\t}\n\tlet integer = ~~n;\n\tlet digits = 0;\n\tif (integer && precision) {\n\t\tdigits = ~~Math.log10(Math.abs(integer)) + 1;\n\t}\n\tconst multiplier = 10.0 ** (precision - digits);\n\treturn Math.floor(n * multiplier + 0.5) / multiplier;\n}\n\nconst angleFactor = {\n\tdeg: 1,\n\tgrad: 0.9,\n\trad: 180 / Math.PI,\n\tturn: 360,\n};\n\n/**\n* Parse a CSS function, regardless of its name and arguments\n* @param String str String to parse\n* @return {{name, args, rawArgs}}\n*/\nfunction parseFunction (str) {\n\tif (!str) {\n\t\treturn;\n\t}\n\n\tstr = str.trim();\n\n\tconst isFunctionRegex = /^([a-z]+)\\((.+?)\\)$/i;\n\tconst isNumberRegex = /^-?[\\d.]+$/;\n\tconst unitValueRegex = /%|deg|g?rad|turn$/;\n\tconst singleArgument = /\\/?\\s*(none|[-\\w.]+(?:%|deg|g?rad|turn)?)/g;\n\tlet parts = str.match(isFunctionRegex);\n\n\tif (parts) {\n\t\t// It is a function, parse args\n\t\tlet args = [];\n\t\tparts[2].replace(singleArgument, ($0, rawArg) => {\n\t\t\tlet match = rawArg.match(unitValueRegex);\n\t\t\tlet arg = rawArg;\n\n\t\t\tif (match) {\n\t\t\t\tlet unit = match[0];\n\t\t\t\t// Drop unit from value\n\t\t\t\tlet unitlessArg = arg.slice(0, -unit.length);\n\n\t\t\t\tif (unit === \"%\") {\n\t\t\t\t\t// Convert percentages to 0-1 numbers\n\t\t\t\t\targ = new Number(unitlessArg / 100);\n\t\t\t\t\targ.type = \"<percentage>\";\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\t// Multiply angle by appropriate factor for its unit\n\t\t\t\t\targ = new Number(unitlessArg * angleFactor[unit]);\n\t\t\t\t\targ.type = \"<angle>\";\n\t\t\t\t\targ.unit = unit;\n\t\t\t\t}\n\t\t\t}\n\t\t\telse if (isNumberRegex.test(arg)) {\n\t\t\t\t// Convert numerical args to numbers\n\t\t\t\targ = new Number(arg);\n\t\t\t\targ.type = \"<number>\";\n\t\t\t}\n\t\t\telse if (arg === \"none\") {\n\t\t\t\targ = new Number(NaN);\n\t\t\t\targ.none = true;\n\t\t\t}\n\n\t\t\tif ($0.startsWith(\"/\")) {\n\t\t\t\t// It's alpha\n\t\t\t\targ = arg instanceof Number ? arg : new Number(arg);\n\t\t\t\targ.alpha = true;\n\t\t\t}\n\n\t\t\tif (typeof arg === \"object\" && arg instanceof Number) {\n\t\t\t\targ.raw = rawArg;\n\t\t\t}\n\n\t\t\targs.push(arg);\n\t\t});\n\n\t\treturn {\n\t\t\tname: parts[1].toLowerCase(),\n\t\t\trawName: parts[1],\n\t\t\trawArgs: parts[2],\n\t\t\t// An argument could be (as of css-color-4):\n\t\t\t// a number, percentage, degrees (hue), ident (in color())\n\t\t\targs,\n\t\t};\n\t}\n}\n\nfunction last (arr) {\n\treturn arr[arr.length - 1];\n}\n\nfunction interpolate (start, end, p) {\n\tif (isNaN(start)) {\n\t\treturn end;\n\t}\n\n\tif (isNaN(end)) {\n\t\treturn start;\n\t}\n\n\treturn start + (end - start) * p;\n}\n\nfunction interpolateInv (start, end, value) {\n\treturn (value - start) / (end - start);\n}\n\nfunction mapRange (from, to, value) {\n\treturn interpolate(to[0], to[1], interpolateInv(from[0], from[1], value));\n}\n\nfunction parseCoordGrammar (coordGrammars) {\n\treturn coordGrammars.map(coordGrammar => {\n\t\treturn coordGrammar.split(\"|\").map(type => {\n\t\t\ttype = type.trim();\n\t\t\tlet range = type.match(/^(<[a-z]+>)\\[(-?[.\\d]+),\\s*(-?[.\\d]+)\\]?$/);\n\n\t\t\tif (range) {\n\t\t\t\tlet ret = new String(range[1]);\n\t\t\t\tret.range = [+range[2], +range[3]];\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\treturn type;\n\t\t});\n\t});\n}\n\n/**\n * Clamp value between the minimum and maximum\n * @param {number} min minimum value to return\n * @param {number} val the value to return if it is between min and max\n * @param {number} max maximum value to return\n * @returns number\n */\nfunction clamp (min, val, max) {\n\treturn Math.max(Math.min(max, val), min);\n}\n\n/**\n * Copy sign of one value to another.\n * @param {number} - to number to copy sign to\n * @param {number} - from number to copy sign from\n * @returns number\n */\nfunction copySign (to, from) {\n\treturn Math.sign(to) === Math.sign(from) ? to : -to;\n}\n\n/**\n * Perform pow on a signed number and copy sign to result\n * @param {number} - base the base number\n * @param {number} - exp the exponent\n * @returns number\n */\nfunction spow (base, exp) {\n\treturn copySign(Math.abs(base) ** exp, base);\n}\n\n/**\n * Perform a divide, but return zero if the numerator is zero\n * @param {number} n - the numerator\n * @param {number} d - the denominator\n * @returns number\n */\nfunction zdiv (n, d) {\n\treturn (d === 0) ? 0 : n / d;\n}\n\n/**\n * Perform a bisect on a sorted list and locate the insertion point for\n * a value in arr to maintain sorted order.\n * @param {number[]} arr - array of sorted numbers\n * @param {number} value - value to find insertion point for\n * @param {number} lo - used to specify a the low end of a subset of the list\n * @param {number} hi - used to specify a the high end of a subset of the list\n * @returns number\n */\nfunction bisectLeft (arr, value, lo = 0, hi = arr.length) {\n\twhile (lo < hi) {\n\t\tconst mid = (lo + hi) >> 1;\n\t\tif (arr[mid] < value) {\n\t\t\tlo = mid + 1;\n\t\t}\n\t\telse {\n\t\t\thi = mid;\n\t\t}\n\t}\n\treturn lo;\n}\n\nvar util = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tbisectLeft: bisectLeft,\n\tclamp: clamp,\n\tcopySign: copySign,\n\tinterpolate: interpolate,\n\tinterpolateInv: interpolateInv,\n\tisNone: isNone,\n\tisString: isString,\n\tlast: last,\n\tmapRange: mapRange,\n\tmultiplyMatrices: multiplyMatrices,\n\tparseCoordGrammar: parseCoordGrammar,\n\tparseFunction: parseFunction,\n\tserializeNumber: serializeNumber,\n\tskipNone: skipNone,\n\tspow: spow,\n\ttoPrecision: toPrecision,\n\ttype: type,\n\tzdiv: zdiv\n});\n\n/**\n * A class for adding deep extensibility to any piece of JS code\n */\nclass Hooks {\n\tadd (name, callback, first) {\n\t\tif (typeof arguments[0] != \"string\") {\n\t\t\t// Multiple hooks\n\t\t\tfor (var name in arguments[0]) {\n\t\t\t\tthis.add(name, arguments[0][name], arguments[1]);\n\t\t\t}\n\n\t\t\treturn;\n\t\t}\n\n\t\t(Array.isArray(name) ? name : [name]).forEach(function (name) {\n\t\t\tthis[name] = this[name] || [];\n\n\t\t\tif (callback) {\n\t\t\t\tthis[name][first ? \"unshift\" : \"push\"](callback);\n\t\t\t}\n\t\t}, this);\n\t}\n\n\trun (name, env) {\n\t\tthis[name] = this[name] || [];\n\t\tthis[name].forEach(function (callback) {\n\t\t\tcallback.call(env && env.context ? env.context : env, env);\n\t\t});\n\t}\n}\n\n/**\n * The instance of {@link Hooks} used throughout Color.js\n */\nconst hooks = new Hooks();\n\n// Global defaults one may want to configure\nvar defaults = {\n\tgamut_mapping: \"css\",\n\tprecision: 5,\n\tdeltaE: \"76\", // Default deltaE method\n\tverbose: globalThis?.process?.env?.NODE_ENV?.toLowerCase() !== \"test\",\n\twarn: function warn (msg) {\n\t\tif (this.verbose) {\n\t\t\tglobalThis?.console?.warn?.(msg);\n\t\t}\n\t},\n};\n\nconst WHITES = {\n\t// for compatibility, the four-digit chromaticity-derived ones everyone else uses\n\tD50: [0.3457 / 0.3585, 1.00000, (1.0 - 0.3457 - 0.3585) / 0.3585],\n\tD65: [0.3127 / 0.3290, 1.00000, (1.0 - 0.3127 - 0.3290) / 0.3290],\n};\n\nfunction getWhite (name) {\n\tif (Array.isArray(name)) {\n\t\treturn name;\n\t}\n\n\treturn WHITES[name];\n}\n\n// Adapt XYZ from white point W1 to W2\nfunction adapt$2 (W1, W2, XYZ, options = {}) {\n\tW1 = getWhite(W1);\n\tW2 = getWhite(W2);\n\n\tif (!W1 || !W2) {\n\t\tthrow new TypeError(`Missing white point to convert ${!W1 ? \"from\" : \"\"}${!W1 && !W2 ? \"/\" : \"\"}${!W2 ? \"to\" : \"\"}`);\n\t}\n\n\tif (W1 === W2) {\n\t\t// Same whitepoints, no conversion needed\n\t\treturn XYZ;\n\t}\n\n\tlet env = {W1, W2, XYZ, options};\n\n\thooks.run(\"chromatic-adaptation-start\", env);\n\n\tif (!env.M) {\n\t\tif (env.W1 === WHITES.D65 && env.W2 === WHITES.D50) {\n\t\t\tenv.M = [\n\t\t\t\t[ 1.0479297925449969, 0.022946870601609652, -0.05019226628920524 ],\n\t\t\t\t[ 0.02962780877005599, 0.9904344267538799, -0.017073799063418826 ],\n\t\t\t\t[ -0.009243040646204504, 0.015055191490298152, 0.7518742814281371 ],\n\t\t\t];\n\t\t}\n\t\telse if (env.W1 === WHITES.D50 && env.W2 === WHITES.D65) {\n\n\t\t\tenv.M = [\n\t\t\t\t[ 0.955473421488075, -0.02309845494876471, 0.06325924320057072 ],\n\t\t\t\t[ -0.0283697093338637, 1.0099953980813041, 0.021041441191917323 ],\n\t\t\t\t[ 0.012314014864481998, -0.020507649298898964, 1.330365926242124 ],\n\t\t\t];\n\t\t}\n\t}\n\n\thooks.run(\"chromatic-adaptation-end\", env);\n\n\tif (env.M) {\n\t\treturn multiplyMatrices(env.M, env.XYZ);\n\t}\n\telse {\n\t\tthrow new TypeError(\"Only Bradford CAT with white points D50 and D65 supported for now.\");\n\t}\n}\n\nconst noneTypes = new Set([\"<number>\", \"<percentage>\", \"<angle>\"]);\n\n/**\n * Validates the coordinates of a color against a format's coord grammar and\n * maps the coordinates to the range or refRange of the coordinates.\n * @param {ColorSpace} space - Colorspace the coords are in\n * @param {object} format - the format object to validate against\n * @param {string} name - the name of the color function. e.g. \"oklab\" or \"color\"\n * @returns {object[]} - an array of type metadata for each coordinate\n */\nfunction coerceCoords (space, format, name, coords) {\n\tlet types = Object.entries(space.coords).map(([id, coordMeta], i) => {\n\t\tlet coordGrammar = format.coordGrammar[i];\n\t\tlet arg = coords[i];\n\t\tlet providedType = arg?.type;\n\n\t\t// Find grammar alternative that matches the provided type\n\t\t// Non-strict equals is intentional because we are comparing w/ string objects\n\t\tlet type;\n\t\tif (arg.none) {\n\t\t\ttype = coordGrammar.find(c => noneTypes.has(c));\n\t\t}\n\t\telse {\n\t\t\ttype = coordGrammar.find(c => c == providedType);\n\t\t}\n\n\t\t// Check that each coord conforms to its grammar\n\t\tif (!type) {\n\t\t\t// Type does not exist in the grammar, throw\n\t\t\tlet coordName = coordMeta.name || id;\n\t\t\tthrow new TypeError(`${providedType ?? arg.raw} not allowed for ${coordName} in ${name}()`);\n\t\t}\n\n\t\tlet fromRange = type.range;\n\n\t\tif (providedType === \"<percentage>\") {\n\t\t\tfromRange ||= [0, 1];\n\t\t}\n\n\t\tlet toRange = coordMeta.range || coordMeta.refRange;\n\n\t\tif (fromRange && toRange) {\n\t\t\tcoords[i] = mapRange(fromRange, toRange, coords[i]);\n\t\t}\n\n\t\treturn type;\n\t});\n\n\treturn types;\n}\n\n\n/**\n * Convert a CSS Color string to a color object\n * @param {string} str\n * @param {object} [options]\n * @param {object} [options.meta] - Object for additional information about the parsing\n * @returns {Color}\n */\nfunction parse (str, {meta} = {}) {\n\tlet env = {\"str\": String(str)?.trim()};\n\thooks.run(\"parse-start\", env);\n\n\tif (env.color) {\n\t\treturn env.color;\n\t}\n\n\tenv.parsed = parseFunction(env.str);\n\n\tif (env.parsed) {\n\t\t// Is a functional syntax\n\t\tlet name = env.parsed.name;\n\n\t\tif (name === \"color\") {\n\t\t\t// color() function\n\t\t\tlet id = env.parsed.args.shift();\n\t\t\t// Check against both <dashed-ident> and <ident> versions\n\t\t\tlet alternateId = id.startsWith(\"--\") ? id.substring(2) : `--${id}`;\n\t\t\tlet ids = [id, alternateId];\n\t\t\tlet alpha = env.parsed.rawArgs.indexOf(\"/\") > 0 ? env.parsed.args.pop() : 1;\n\n\t\t\tfor (let space of ColorSpace.all) {\n\t\t\t\tlet colorSpec = space.getFormat(\"color\");\n\n\t\t\t\tif (colorSpec) {\n\t\t\t\t\tif (ids.includes(colorSpec.id) || colorSpec.ids?.filter((specId) => ids.includes(specId)).length) {\n\t\t\t\t\t\t// From https://drafts.csswg.org/css-color-4/#color-function\n\t\t\t\t\t\t// If more <number>s or <percentage>s are provided than parameters that the colorspace takes, the excess <number>s at the end are ignored.\n\t\t\t\t\t\t// If less <number>s or <percentage>s are provided than parameters that the colorspace takes, the missing parameters default to 0. (This is particularly convenient for multichannel printers where the additional inks are spot colors or varnishes that most colors on the page won’t use.)\n\t\t\t\t\t\tconst coords = Object.keys(space.coords).map((_, i) => env.parsed.args[i] || 0);\n\n\t\t\t\t\t\tlet types;\n\n\t\t\t\t\t\tif (colorSpec.coordGrammar) {\n\t\t\t\t\t\t\ttypes = coerceCoords(space, colorSpec, \"color\", coords);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (meta) {\n\t\t\t\t\t\t\tObject.assign(meta, {formatId: \"color\", types});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (colorSpec.id.startsWith(\"--\") && !id.startsWith(\"--\")) {\n\t\t\t\t\t\t\tdefaults.warn(`${space.name} is a non-standard space and not currently supported in the CSS spec. ` +\n\t\t\t\t\t\t\t              `Use prefixed color(${colorSpec.id}) instead of color(${id}).`);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (id.startsWith(\"--\") && !colorSpec.id.startsWith(\"--\")) {\n\t\t\t\t\t\t\tdefaults.warn(`${space.name} is a standard space and supported in the CSS spec. ` +\n\t\t\t\t\t\t\t              `Use color(${colorSpec.id}) instead of prefixed color(${id}).`);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn {spaceId: space.id, coords, alpha};\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Not found\n\t\t\tlet didYouMean = \"\";\n\t\t\tlet registryId = id in ColorSpace.registry ? id : alternateId;\n\t\t\tif (registryId in ColorSpace.registry) {\n\t\t\t\t// Used color space id instead of color() id, these are often different\n\t\t\t\tlet cssId = ColorSpace.registry[registryId].formats?.color?.id;\n\n\t\t\t\tif (cssId) {\n\t\t\t\t\tdidYouMean = `Did you mean color(${cssId})?`;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthrow new TypeError(`Cannot parse color(${id}). ` + (didYouMean || \"Missing a plugin?\"));\n\t\t}\n\t\telse {\n\t\t\tfor (let space of ColorSpace.all) {\n\t\t\t\t// color space specific function\n\t\t\t\tlet format = space.getFormat(name);\n\t\t\t\tif (format && format.type === \"function\") {\n\t\t\t\t\tlet alpha = 1;\n\n\t\t\t\t\tif (format.lastAlpha || last(env.parsed.args).alpha) {\n\t\t\t\t\t\talpha = env.parsed.args.pop();\n\t\t\t\t\t}\n\n\t\t\t\t\tlet coords = env.parsed.args;\n\n\t\t\t\t\tlet types;\n\n\t\t\t\t\tif (format.coordGrammar) {\n\t\t\t\t\t\ttypes = coerceCoords(space, format, name, coords);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (meta) {\n\t\t\t\t\t\tObject.assign(meta, {formatId: format.name, types});\n\t\t\t\t\t}\n\n\t\t\t\t\treturn {\n\t\t\t\t\t\tspaceId: space.id,\n\t\t\t\t\t\tcoords, alpha,\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\t// Custom, colorspace-specific format\n\t\tfor (let space of ColorSpace.all) {\n\t\t\tfor (let formatId in space.formats) {\n\t\t\t\tlet format = space.formats[formatId];\n\n\t\t\t\tif (format.type !== \"custom\") {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tif (format.test && !format.test(env.str)) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tlet color = format.parse(env.str);\n\n\t\t\t\tif (color) {\n\t\t\t\t\tcolor.alpha ??= 1;\n\n\t\t\t\t\tif (meta) {\n\t\t\t\t\t\tmeta.formatId = formatId;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn color;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\n\t// If we're here, we couldn't parse\n\tthrow new TypeError(`Could not parse ${str} as a color. Missing a plugin?`);\n}\n\n/**\n * Resolves a color reference (object or string) to a plain color object\n * @param {Color | {space, coords, alpha} | string | Array<Color | {space, coords, alpha} | string> } color\n * @returns {{space, coords, alpha} | Array<{space, coords, alpha}}>\n */\nfunction getColor (color) {\n\tif (Array.isArray(color)) {\n\t\treturn color.map(getColor);\n\t}\n\n\tif (!color) {\n\t\tthrow new TypeError(\"Empty color reference\");\n\t}\n\n\tif (isString(color)) {\n\t\tcolor = parse(color);\n\t}\n\n\t// Object fixup\n\tlet space = color.space || color.spaceId;\n\n\tif (!(space instanceof ColorSpace)) {\n\t\t// Convert string id to color space object\n\t\tcolor.space = ColorSpace.get(space);\n\t}\n\n\tif (color.alpha === undefined) {\n\t\tcolor.alpha = 1;\n\t}\n\n\treturn color;\n}\n\nconst ε$7 = .000075;\n\n/**\n * Class to represent a color space\n */\nclass ColorSpace {\n\tconstructor (options) {\n\t\tthis.id = options.id;\n\t\tthis.name = options.name;\n\t\tthis.base = options.base ? ColorSpace.get(options.base) : null;\n\t\tthis.aliases = options.aliases;\n\n\t\tif (this.base) {\n\t\t\tthis.fromBase = options.fromBase;\n\t\t\tthis.toBase = options.toBase;\n\t\t}\n\n\t\t// Coordinate metadata\n\n\t\tlet coords = options.coords ?? this.base.coords;\n\n\t\tfor (let name in coords) {\n\t\t\tif (!(\"name\" in coords[name])) {\n\t\t\t\tcoords[name].name = name;\n\t\t\t}\n\t\t}\n\t\tthis.coords = coords;\n\n\t\t// White point\n\n\t\tlet white = options.white ?? this.base.white ?? \"D65\";\n\t\tthis.white = getWhite(white);\n\n\t\t// Sort out formats\n\n\t\tthis.formats = options.formats ?? {};\n\n\t\tfor (let name in this.formats) {\n\t\t\tlet format = this.formats[name];\n\t\t\tformat.type ||= \"function\";\n\t\t\tformat.name ||= name;\n\t\t}\n\n\t\tif (!this.formats.color?.id) {\n\t\t\tthis.formats.color = {\n\t\t\t\t...this.formats.color ?? {},\n\t\t\t\tid: options.cssId || this.id,\n\t\t\t};\n\t\t}\n\n\t\t// Gamut space\n\n\t\tif (options.gamutSpace) {\n\t\t\t// Gamut space explicitly specified\n\t\t\tthis.gamutSpace = options.gamutSpace === \"self\" ? this : ColorSpace.get(options.gamutSpace);\n\t\t}\n\t\telse {\n\t\t\t// No gamut space specified, calculate a sensible default\n\t\t\tif (this.isPolar) {\n\t\t\t\t// Do not check gamut through polar coordinates\n\t\t\t\tthis.gamutSpace = this.base;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tthis.gamutSpace =  this;\n\t\t\t}\n\t\t}\n\n\t\t// Optimize inGamut for unbounded spaces\n\t\tif (this.gamutSpace.isUnbounded) {\n\t\t\tthis.inGamut = (coords, options) => {\n\t\t\t\treturn true;\n\t\t\t};\n\t\t}\n\n\t\t// Other stuff\n\t\tthis.referred = options.referred;\n\n\t\t// Compute ancestors and store them, since they will never change\n\t\tObject.defineProperty(this, \"path\", {\n\t\t\tvalue: getPath(this).reverse(),\n\t\t\twritable: false,\n\t\t\tenumerable: true,\n\t\t\tconfigurable: true,\n\t\t});\n\n\t\thooks.run(\"colorspace-init-end\", this);\n\t}\n\n\tinGamut (coords, {epsilon = ε$7} = {}) {\n\t\tif (!this.equals(this.gamutSpace)) {\n\t\t\tcoords = this.to(this.gamutSpace, coords);\n\t\t\treturn this.gamutSpace.inGamut(coords, {epsilon});\n\t\t}\n\n\t\tlet coordMeta = Object.values(this.coords);\n\n\t\treturn coords.every((c, i) => {\n\t\t\tlet meta = coordMeta[i];\n\n\t\t\tif (meta.type !== \"angle\" && meta.range) {\n\t\t\t\tif (Number.isNaN(c)) {\n\t\t\t\t\t// NaN is always in gamut\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\tlet [min, max] = meta.range;\n\t\t\t\treturn (min === undefined || c >= min - epsilon)\n\t\t\t\t    && (max === undefined || c <= max + epsilon);\n\t\t\t}\n\n\t\t\treturn true;\n\t\t});\n\t}\n\n\tget isUnbounded () {\n\t\treturn Object.values(this.coords).every(coord => !(\"range\" in coord));\n\t}\n\n\tget cssId () {\n\t\treturn this.formats?.color?.id || this.id;\n\t}\n\n\tget isPolar () {\n\t\tfor (let id in this.coords) {\n\t\t\tif (this.coords[id].type === \"angle\") {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t}\n\n\tgetFormat (format) {\n\t\tif (typeof format === \"object\") {\n\t\t\tformat = processFormat(format, this);\n\t\t\treturn format;\n\t\t}\n\n\t\tlet ret;\n\t\tif (format === \"default\") {\n\t\t\t// Get first format\n\t\t\tret = Object.values(this.formats)[0];\n\t\t}\n\t\telse {\n\t\t\tret = this.formats[format];\n\t\t}\n\n\t\tif (ret) {\n\t\t\tret = processFormat(ret, this);\n\t\t\treturn ret;\n\t\t}\n\n\t\treturn null;\n\t}\n\n\t/**\n\t * Check if this color space is the same as another color space reference.\n\t * Allows proxying color space objects and comparing color spaces with ids.\n\t * @param {string | ColorSpace} space ColorSpace object or id to compare to\n\t * @returns {boolean}\n\t */\n\tequals (space) {\n\t\tif (!space) {\n\t\t\treturn false;\n\t\t}\n\n\t\treturn this === space || this.id === space || this.id === space.id;\n\t}\n\n\tto (space, coords) {\n\t\tif (arguments.length === 1) {\n\t\t\tconst color = getColor(space);\n\t\t\t[space, coords] = [color.space, color.coords];\n\t\t}\n\n\t\tspace = ColorSpace.get(space);\n\n\t\tif (this.equals(space)) {\n\t\t\t// Same space, no change needed\n\t\t\treturn coords;\n\t\t}\n\n\t\t// Convert NaN to 0, which seems to be valid in every coordinate of every color space\n\t\tcoords = coords.map(c => Number.isNaN(c) ? 0 : c);\n\n\t\t// Find connection space = lowest common ancestor in the base tree\n\t\tlet myPath = this.path;\n\t\tlet otherPath = space.path;\n\n\t\tlet connectionSpace, connectionSpaceIndex;\n\n\t\tfor (let i = 0; i < myPath.length; i++) {\n\t\t\tif (myPath[i].equals(otherPath[i])) {\n\t\t\t\tconnectionSpace = myPath[i];\n\t\t\t\tconnectionSpaceIndex = i;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\tif (!connectionSpace) {\n\t\t\t// This should never happen\n\t\t\tthrow new Error(`Cannot convert between color spaces ${this} and ${space}: no connection space was found`);\n\t\t}\n\n\t\t// Go up from current space to connection space\n\t\tfor (let i = myPath.length - 1; i > connectionSpaceIndex; i--) {\n\t\t\tcoords = myPath[i].toBase(coords);\n\t\t}\n\n\t\t// Go down from connection space to target space\n\t\tfor (let i = connectionSpaceIndex + 1; i < otherPath.length; i++) {\n\t\t\tcoords = otherPath[i].fromBase(coords);\n\t\t}\n\n\t\treturn coords;\n\t}\n\n\tfrom (space, coords) {\n\t\tif (arguments.length === 1) {\n\t\t\tconst color = getColor(space);\n\t\t\t[space, coords] = [color.space, color.coords];\n\t\t}\n\n\t\tspace = ColorSpace.get(space);\n\n\t\treturn space.to(this, coords);\n\t}\n\n\ttoString () {\n\t\treturn `${this.name} (${this.id})`;\n\t}\n\n\tgetMinCoords () {\n\t\tlet ret = [];\n\n\t\tfor (let id in this.coords) {\n\t\t\tlet meta = this.coords[id];\n\t\t\tlet range = meta.range || meta.refRange;\n\t\t\tret.push(range?.min ?? 0);\n\t\t}\n\n\t\treturn ret;\n\t}\n\n\tstatic registry = {};\n\n\t// Returns array of unique color spaces\n\tstatic get all () {\n\t\treturn [...new Set(Object.values(ColorSpace.registry))];\n\t}\n\n\tstatic register (id, space) {\n\t\tif (arguments.length === 1) {\n\t\t\tspace = arguments[0];\n\t\t\tid = space.id;\n\t\t}\n\n\t\tspace = this.get(space);\n\n\t\tif (this.registry[id] && this.registry[id] !== space) {\n\t\t\tthrow new Error(`Duplicate color space registration: '${id}'`);\n\t\t}\n\t\tthis.registry[id] = space;\n\n\t\t// Register aliases when called without an explicit ID.\n\t\tif (arguments.length === 1 && space.aliases) {\n\t\t\tfor (let alias of space.aliases) {\n\t\t\t\tthis.register(alias, space);\n\t\t\t}\n\t\t}\n\n\t\treturn space;\n\t}\n\n\t/**\n\t * Lookup ColorSpace object by name\n\t * @param {ColorSpace | string} name\n\t */\n\tstatic get (space, ...alternatives) {\n\t\tif (!space || space instanceof ColorSpace) {\n\t\t\treturn space;\n\t\t}\n\n\t\tlet argType = type(space);\n\n\t\tif (argType === \"string\") {\n\t\t\t// It's a color space id\n\t\t\tlet ret = ColorSpace.registry[space.toLowerCase()];\n\n\t\t\tif (!ret) {\n\t\t\t\tthrow new TypeError(`No color space found with id = \"${space}\"`);\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t}\n\n\t\tif (alternatives.length) {\n\t\t\treturn ColorSpace.get(...alternatives);\n\t\t}\n\n\t\tthrow new TypeError(`${space} is not a valid color space`);\n\t}\n\n\t/**\n\t * Get metadata about a coordinate of a color space\n\t *\n\t * @static\n\t * @param {Array | string} ref\n\t * @param {ColorSpace | string} [workingSpace]\n\t * @return {Object}\n\t */\n\tstatic resolveCoord (ref, workingSpace) {\n\t\tlet coordType = type(ref);\n\t\tlet space, coord;\n\n\t\tif (coordType === \"string\") {\n\t\t\tif (ref.includes(\".\")) {\n\t\t\t\t// Absolute coordinate\n\t\t\t\t[space, coord] = ref.split(\".\");\n\t\t\t}\n\t\t\telse {\n\t\t\t\t// Relative coordinate\n\t\t\t\t[space, coord] = [, ref];\n\t\t\t}\n\t\t}\n\t\telse if (Array.isArray(ref)) {\n\t\t\t[space, coord] = ref;\n\t\t}\n\t\telse {\n\t\t\t// Object\n\t\t\tspace = ref.space;\n\t\t\tcoord = ref.coordId;\n\t\t}\n\n\t\tspace = ColorSpace.get(space);\n\n\t\tif (!space) {\n\t\t\tspace = workingSpace;\n\t\t}\n\n\t\tif (!space) {\n\t\t\tthrow new TypeError(`Cannot resolve coordinate reference ${ref}: No color space specified and relative references are not allowed here`);\n\t\t}\n\n\t\tcoordType = type(coord);\n\n\t\tif (coordType === \"number\" || coordType === \"string\" && coord >= 0) {\n\t\t\t// Resolve numerical coord\n\t\t\tlet meta = Object.entries(space.coords)[coord];\n\n\t\t\tif (meta) {\n\t\t\t\treturn {space, id: meta[0], index: coord, ...meta[1]};\n\t\t\t}\n\t\t}\n\n\t\tspace = ColorSpace.get(space);\n\n\t\tlet normalizedCoord = coord.toLowerCase();\n\n\t\tlet i = 0;\n\t\tfor (let id in space.coords) {\n\t\t\tlet meta = space.coords[id];\n\n\t\t\tif (id.toLowerCase() === normalizedCoord || meta.name?.toLowerCase() === normalizedCoord) {\n\t\t\t\treturn {space, id, index: i, ...meta};\n\t\t\t}\n\n\t\t\ti++;\n\t\t}\n\n\t\tthrow new TypeError(`No \"${coord}\" coordinate found in ${space.name}. Its coordinates are: ${Object.keys(space.coords).join(\", \")}`);\n\t}\n\n\tstatic DEFAULT_FORMAT = {\n\t\ttype: \"functions\",\n\t\tname: \"color\",\n\t};\n}\n\nfunction getPath (space) {\n\tlet ret = [space];\n\n\tfor (let s = space; s = s.base;) {\n\t\tret.push(s);\n\t}\n\n\treturn ret;\n}\n\nfunction processFormat (format, {coords} = {}) {\n\tif (format.coords && !format.coordGrammar) {\n\t\tformat.type ||= \"function\";\n\t\tformat.name ||= \"color\";\n\n\t\t// Format has not been processed\n\t\tformat.coordGrammar = parseCoordGrammar(format.coords);\n\n\t\tlet coordFormats = Object.entries(coords).map(([id, coordMeta], i) => {\n\t\t\t// Preferred format for each coord is the first one\n\t\t\tlet outputType = format.coordGrammar[i][0];\n\n\t\t\tlet fromRange = coordMeta.range || coordMeta.refRange;\n\t\t\tlet toRange = outputType.range, suffix = \"\";\n\n\t\t\t// Non-strict equals intentional since outputType could be a string object\n\t\t\tif (outputType == \"<percentage>\") {\n\t\t\t\ttoRange = [0, 100];\n\t\t\t\tsuffix = \"%\";\n\t\t\t}\n\t\t\telse if (outputType == \"<angle>\") {\n\t\t\t\tsuffix = \"deg\";\n\t\t\t}\n\n\t\t\treturn  {fromRange, toRange, suffix};\n\t\t});\n\n\t\tformat.serializeCoords = (coords, precision) => {\n\t\t\treturn coords.map((c, i) => {\n\t\t\t\tlet {fromRange, toRange, suffix} = coordFormats[i];\n\n\t\t\t\tif (fromRange && toRange) {\n\t\t\t\t\tc = mapRange(fromRange, toRange, c);\n\t\t\t\t}\n\n\t\t\t\tc = serializeNumber(c, {precision, unit: suffix});\n\n\t\t\t\treturn c;\n\t\t\t});\n\t\t};\n\t}\n\n\treturn format;\n}\n\nvar xyz_d65 = new ColorSpace({\n\tid: \"xyz-d65\",\n\tname: \"XYZ D65\",\n\tcoords: {\n\t\tx: {name: \"X\"},\n\t\ty: {name: \"Y\"},\n\t\tz: {name: \"Z\"},\n\t},\n\twhite: \"D65\",\n\tformats: {\n\t\tcolor: {\n\t\t\tids: [\"xyz-d65\", \"xyz\"],\n\t\t},\n\t},\n\taliases: [\"xyz\"],\n});\n\n/**\n * Convenience class for RGB color spaces\n * @extends {ColorSpace}\n */\nclass RGBColorSpace extends ColorSpace {\n\t/**\n\t * Creates a new RGB ColorSpace.\n\t * If coords are not specified, they will use the default RGB coords.\n\t * Instead of `fromBase()` and `toBase()` functions,\n\t * you can specify to/from XYZ matrices and have `toBase()` and `fromBase()` automatically generated.\n\t * @param {*} options - Same options as {@link ColorSpace} plus:\n\t * @param {number[][]} options.toXYZ_M - Matrix to convert to XYZ\n\t * @param {number[][]} options.fromXYZ_M - Matrix to convert from XYZ\n\t */\n\tconstructor (options) {\n\t\tif (!options.coords) {\n\t\t\toptions.coords = {\n\t\t\t\tr: {\n\t\t\t\t\trange: [0, 1],\n\t\t\t\t\tname: \"Red\",\n\t\t\t\t},\n\t\t\t\tg: {\n\t\t\t\t\trange: [0, 1],\n\t\t\t\t\tname: \"Green\",\n\t\t\t\t},\n\t\t\t\tb: {\n\t\t\t\t\trange: [0, 1],\n\t\t\t\t\tname: \"Blue\",\n\t\t\t\t},\n\t\t\t};\n\t\t}\n\n\t\tif (!options.base) {\n\t\t\toptions.base = xyz_d65;\n\t\t}\n\n\t\tif (options.toXYZ_M && options.fromXYZ_M) {\n\t\t\toptions.toBase ??= rgb => {\n\t\t\t\tlet xyz = multiplyMatrices(options.toXYZ_M, rgb);\n\n\t\t\t\tif (this.white !== this.base.white) {\n\t\t\t\t\t// Perform chromatic adaptation\n\t\t\t\t\txyz = adapt$2(this.white, this.base.white, xyz);\n\t\t\t\t}\n\n\t\t\t\treturn xyz;\n\t\t\t};\n\n\t\t\toptions.fromBase ??= xyz => {\n\t\t\t\txyz = adapt$2(this.base.white, this.white, xyz);\n\t\t\t\treturn multiplyMatrices(options.fromXYZ_M, xyz);\n\t\t\t};\n\t\t}\n\n\t\toptions.referred ??= \"display\";\n\n\t\tsuper(options);\n\t}\n}\n\n/**\n * Get the coordinates of a color in any color space\n * @param {Color} color\n * @param {string | ColorSpace} [space = color.space] The color space to convert to. Defaults to the color's current space\n * @returns {number[]} The color coordinates in the given color space\n */\nfunction getAll (color, space) {\n\tcolor = getColor(color);\n\n\tif (!space || color.space.equals(space)) {\n\t\t// No conversion needed\n\t\treturn color.coords.slice();\n\t}\n\n\tspace = ColorSpace.get(space);\n\treturn space.from(color);\n}\n\nfunction get (color, prop) {\n\tcolor = getColor(color);\n\n\tlet {space, index} = ColorSpace.resolveCoord(prop, color.space);\n\tlet coords = getAll(color, space);\n\treturn coords[index];\n}\n\nfunction setAll (color, space, coords) {\n\tcolor = getColor(color);\n\n\tspace = ColorSpace.get(space);\n\tcolor.coords = space.to(color.space, coords);\n\treturn color;\n}\n\nsetAll.returns = \"color\";\n\n// Set properties and return current instance\nfunction set (color, prop, value) {\n\tcolor = getColor(color);\n\n\tif (arguments.length === 2 && type(arguments[1]) === \"object\") {\n\t\t// Argument is an object literal\n\t\tlet object = arguments[1];\n\t\tfor (let p in object) {\n\t\t\tset(color, p, object[p]);\n\t\t}\n\t}\n\telse {\n\t\tif (typeof value === \"function\") {\n\t\t\tvalue = value(get(color, prop));\n\t\t}\n\n\t\tlet {space, index} = ColorSpace.resolveCoord(prop, color.space);\n\t\tlet coords = getAll(color, space);\n\t\tcoords[index] = value;\n\t\tsetAll(color, space, coords);\n\t}\n\n\treturn color;\n}\n\nset.returns = \"color\";\n\nvar XYZ_D50 = new ColorSpace({\n\tid: \"xyz-d50\",\n\tname: \"XYZ D50\",\n\twhite: \"D50\",\n\tbase: xyz_d65,\n\tfromBase: coords => adapt$2(xyz_d65.white, \"D50\", coords),\n\ttoBase: coords => adapt$2(\"D50\", xyz_d65.white, coords),\n});\n\n// κ * ε  = 2^3 = 8\nconst ε$6 = 216 / 24389;  // 6^3/29^3 == (24/116)^3\nconst ε3$1 = 24 / 116;\nconst κ$4 = 24389 / 27;   // 29^3/3^3\n\nlet white$4 = WHITES.D50;\n\nvar lab = new ColorSpace({\n\tid: \"lab\",\n\tname: \"Lab\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\ta: {\n\t\t\trefRange: [-125, 125],\n\t\t},\n\t\tb: {\n\t\t\trefRange: [-125, 125],\n\t\t},\n\t},\n\n\t// Assuming XYZ is relative to D50, convert to CIE Lab\n\t// from CIE standard, which now defines these as a rational fraction\n\twhite: white$4,\n\n\tbase: XYZ_D50,\n\t// Convert D50-adapted XYX to Lab\n\t//  CIE 15.3:2004 section 8.2.1.1\n\tfromBase (XYZ) {\n\t\t// compute xyz, which is XYZ scaled relative to reference white\n\t\tlet xyz = XYZ.map((value, i) => value / white$4[i]);\n\n\t\t// now compute f\n\t\tlet f = xyz.map(value => value > ε$6 ? Math.cbrt(value) : (κ$4 * value + 16) / 116);\n\n\t\treturn [\n\t\t\t(116 * f[1]) - 16,   // L\n\t\t\t500 * (f[0] - f[1]), // a\n\t\t\t200 * (f[1] - f[2]),  // b\n\t\t];\n\t},\n\t// Convert Lab to D50-adapted XYZ\n\t// Same result as CIE 15.3:2004 Appendix D although the derivation is different\n\t// http://www.brucelindbloom.com/index.html?Eqn_RGB_XYZ_Matrix.html\n\ttoBase (Lab) {\n\t\t// compute f, starting with the luminance-related term\n\t\tlet f = [];\n\t\tf[1] = (Lab[0] + 16) / 116;\n\t\tf[0] = Lab[1] / 500 + f[1];\n\t\tf[2] = f[1] - Lab[2] / 200;\n\n\t\t// compute xyz\n\t\tlet xyz = [\n\t\t\tf[0]   > ε3$1 ? Math.pow(f[0], 3)                : (116 * f[0] - 16) / κ$4,\n\t\t\tLab[0] > 8  ? Math.pow((Lab[0] + 16) / 116, 3) : Lab[0] / κ$4,\n\t\t\tf[2]   > ε3$1 ? Math.pow(f[2], 3)                : (116 * f[2] - 16) / κ$4,\n\t\t];\n\n\t\t// Compute XYZ by scaling xyz by reference white\n\t\treturn xyz.map((value, i) => value * white$4[i]);\n\t},\n\n\tformats: {\n\t\t\"lab\": {\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>[-1,1]\", \"<number> | <percentage>[-1,1]\"],\n\t\t},\n\t},\n});\n\nfunction constrain (angle) {\n\treturn ((angle % 360) + 360) % 360;\n}\n\nfunction adjust (arc, angles) {\n\tif (arc === \"raw\") {\n\t\treturn angles;\n\t}\n\n\tlet [a1, a2] = angles.map(constrain);\n\n\tlet angleDiff = a2 - a1;\n\n\tif (arc === \"increasing\") {\n\t\tif (angleDiff < 0) {\n\t\t\ta2 += 360;\n\t\t}\n\t}\n\telse if (arc === \"decreasing\") {\n\t\tif (angleDiff > 0) {\n\t\t\ta1 += 360;\n\t\t}\n\t}\n\telse if (arc === \"longer\") {\n\t\tif (-180 < angleDiff && angleDiff < 180) {\n\t\t\tif (angleDiff > 0) {\n\t\t\t\ta1 += 360;\n\t\t\t}\n\t\t\telse {\n\t\t\t\ta2 += 360;\n\t\t\t}\n\t\t}\n\t}\n\telse if (arc === \"shorter\") {\n\t\tif (angleDiff > 180) {\n\t\t\ta1 += 360;\n\t\t}\n\t\telse if (angleDiff < -180) {\n\t\t\ta2 += 360;\n\t\t}\n\t}\n\n\treturn [a1, a2];\n}\n\nvar lch = new ColorSpace({\n\tid: \"lch\",\n\tname: \"LCH\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\tc: {\n\t\t\trefRange: [0, 150],\n\t\t\tname: \"Chroma\",\n\t\t},\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t},\n\n\tbase: lab,\n\tfromBase (Lab) {\n\t\t// Convert to polar form\n\t\tlet [L, a, b] = Lab;\n\t\tlet hue;\n\t\tconst ε = 0.02;\n\n\t\tif (Math.abs(a) < ε && Math.abs(b) < ε) {\n\t\t\thue = NaN;\n\t\t}\n\t\telse {\n\t\t\thue = Math.atan2(b, a) * 180 / Math.PI;\n\t\t}\n\n\t\treturn [\n\t\t\tL, // L is still L\n\t\t\tMath.sqrt(a ** 2 + b ** 2), // Chroma\n\t\t\tconstrain(hue), // Hue, in degrees [0 to 360)\n\t\t];\n\t},\n\ttoBase (LCH) {\n\t\t// Convert from polar form\n\t\tlet [Lightness, Chroma, Hue] = LCH;\n\t\t// Clamp any negative Chroma\n\t\tif (Chroma < 0) {\n\t\t\tChroma = 0;\n\t\t}\n\t\t// Deal with NaN Hue\n\t\tif (isNaN(Hue)) {\n\t\t\tHue = 0;\n\t\t}\n\t\treturn [\n\t\t\tLightness, // L is still L\n\t\t\tChroma * Math.cos(Hue * Math.PI / 180), // a\n\t\t\tChroma * Math.sin(Hue * Math.PI / 180),  // b\n\t\t];\n\t},\n\n\tformats: {\n\t\t\"lch\": {\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>\", \"<number> | <angle>\"],\n\t\t},\n\t},\n});\n\n// deltaE2000 is a statistically significant improvement\n// and is recommended by the CIE and Idealliance\n// especially for color differences less than 10 deltaE76\n// but is wicked complicated\n// and many implementations have small errors!\n// DeltaE2000 is also discontinuous; in case this\n// matters to you, use deltaECMC instead.\n\nconst Gfactor = 25 ** 7;\nconst π$1 = Math.PI;\nconst r2d = 180 / π$1;\nconst d2r$1 = π$1 / 180;\n\nfunction pow7 (x) {\n\t// Faster than x ** 7 or Math.pow(x, 7)\n\n\tconst x2 = x * x;\n\tconst x7 = x2 * x2 * x2 * x;\n\n\treturn x7;\n}\n\nfunction deltaE2000 (color, sample, {kL = 1, kC = 1, kH = 1} = {}) {\n\t[color, sample] = getColor([color, sample]);\n\n\t// Given this color as the reference\n\t// and the function parameter as the sample,\n\t// calculate deltaE 2000.\n\n\t// This implementation assumes the parametric\n\t// weighting factors kL, kC and kH\n\t// for the influence of viewing conditions\n\t// are all 1, as sadly seems typical.\n\t// kL should be increased for lightness texture or noise\n\t// and kC increased for chroma noise\n\n\tlet [L1, a1, b1] = lab.from(color);\n\tlet C1 = lch.from(lab, [L1, a1, b1])[1];\n\tlet [L2, a2, b2] = lab.from(sample);\n\tlet C2 = lch.from(lab, [L2, a2, b2])[1];\n\n\t// Check for negative Chroma,\n\t// which might happen through\n\t// direct user input of LCH values\n\n\tif (C1 < 0) {\n\t\tC1 = 0;\n\t}\n\tif (C2 < 0) {\n\t\tC2 = 0;\n\t}\n\n\tlet Cbar = (C1 + C2) / 2; // mean Chroma\n\n\t// calculate a-axis asymmetry factor from mean Chroma\n\t// this turns JND ellipses for near-neutral colors back into circles\n\tlet C7 = pow7(Cbar);\n\n\tlet G = 0.5 * (1 - Math.sqrt(C7 / (C7 + Gfactor)));\n\n\t// scale a axes by asymmetry factor\n\t// this by the way is why there is no Lab2000 colorspace\n\tlet adash1 = (1 + G) * a1;\n\tlet adash2 = (1 + G) * a2;\n\n\t// calculate new Chroma from scaled a and original b axes\n\tlet Cdash1 = Math.sqrt(adash1 ** 2 + b1 ** 2);\n\tlet Cdash2 = Math.sqrt(adash2 ** 2 + b2 ** 2);\n\n\t// calculate new hues, with zero hue for true neutrals\n\t// and in degrees, not radians\n\n\tlet h1 = (adash1 === 0 && b1 === 0) ? 0 : Math.atan2(b1, adash1);\n\tlet h2 = (adash2 === 0 && b2 === 0) ? 0 : Math.atan2(b2, adash2);\n\n\tif (h1 < 0) {\n\t\th1 += 2 * π$1;\n\t}\n\tif (h2 < 0) {\n\t\th2 += 2 * π$1;\n\t}\n\n\th1 *= r2d;\n\th2 *= r2d;\n\n\t// Lightness and Chroma differences; sign matters\n\tlet ΔL = L2 - L1;\n\tlet ΔC = Cdash2 - Cdash1;\n\n\t// Hue difference, getting the sign correct\n\tlet hdiff = h2 - h1;\n\tlet hsum = h1 + h2;\n\tlet habs = Math.abs(hdiff);\n\tlet Δh;\n\n\tif (Cdash1 * Cdash2 === 0) {\n\t\tΔh = 0;\n\t}\n\telse if (habs <= 180) {\n\t\tΔh = hdiff;\n\t}\n\telse if (hdiff > 180) {\n\t\tΔh = hdiff - 360;\n\t}\n\telse if (hdiff < -180) {\n\t\tΔh = hdiff + 360;\n\t}\n\telse {\n\t\tdefaults.warn(\"the unthinkable has happened\");\n\t}\n\n\t// weighted Hue difference, more for larger Chroma\n\tlet ΔH = 2 * Math.sqrt(Cdash2 * Cdash1) * Math.sin(Δh * d2r$1 / 2);\n\n\t// calculate mean Lightness and Chroma\n\tlet Ldash = (L1 + L2) / 2;\n\tlet Cdash = (Cdash1 + Cdash2) / 2;\n\tlet Cdash7 = pow7(Cdash);\n\n\t// Compensate for non-linearity in the blue region of Lab.\n\t// Four possibilities for hue weighting factor,\n\t// depending on the angles, to get the correct sign\n\tlet hdash;\n\tif (Cdash1 * Cdash2 === 0) {\n\t\thdash = hsum;   // which should be zero\n\t}\n\telse if (habs <= 180) {\n\t\thdash = hsum / 2;\n\t}\n\telse if (hsum < 360) {\n\t\thdash = (hsum + 360) / 2;\n\t}\n\telse {\n\t\thdash = (hsum - 360) / 2;\n\t}\n\n\t// positional corrections to the lack of uniformity of CIELAB\n\t// These are all trying to make JND ellipsoids more like spheres\n\n\t// SL Lightness crispening factor\n\t// a background with L=50 is assumed\n\tlet lsq = (Ldash - 50) ** 2;\n\tlet SL = 1 + ((0.015 * lsq) / Math.sqrt(20 + lsq));\n\n\t// SC Chroma factor, similar to those in CMC and deltaE 94 formulae\n\tlet SC = 1 + 0.045 * Cdash;\n\n\t// Cross term T for blue non-linearity\n\tlet T = 1;\n\tT -= (0.17 * Math.cos((     hdash - 30)  * d2r$1));\n\tT += (0.24 * Math.cos(  2 * hdash        * d2r$1));\n\tT += (0.32 * Math.cos(((3 * hdash) + 6)  * d2r$1));\n\tT -= (0.20 * Math.cos(((4 * hdash) - 63) * d2r$1));\n\n\t// SH Hue factor depends on Chroma,\n\t// as well as adjusted hue angle like deltaE94.\n\tlet SH = 1 + 0.015 * Cdash * T;\n\n\t// RT Hue rotation term compensates for rotation of JND ellipses\n\t// and Munsell constant hue lines\n\t// in the medium-high Chroma blue region\n\t// (Hue 225 to 315)\n\tlet Δθ = 30 * Math.exp(-1 * (((hdash - 275) / 25) ** 2));\n\tlet RC = 2 * Math.sqrt(Cdash7 / (Cdash7 + Gfactor));\n\tlet RT = -1 * Math.sin(2 * Δθ * d2r$1) * RC;\n\n\t// Finally calculate the deltaE, term by term as root sume of squares\n\tlet dE = (ΔL / (kL * SL)) ** 2;\n\tdE += (ΔC / (kC * SC)) ** 2;\n\tdE += (ΔH / (kH * SH)) ** 2;\n\tdE += RT * (ΔC / (kC * SC)) * (ΔH / (kH * SH));\n\treturn Math.sqrt(dE);\n\t// Yay!!!\n}\n\n// Recalculated for consistent reference white\n// see https://github.com/w3c/csswg-drafts/issues/6642#issuecomment-943521484\nconst XYZtoLMS_M$1 = [\n\t[ 0.8190224379967030, 0.3619062600528904, -0.1288737815209879 ],\n\t[ 0.0329836539323885, 0.9292868615863434,  0.0361446663506424 ],\n\t[ 0.0481771893596242, 0.2642395317527308,  0.6335478284694309 ],\n];\n// inverse of XYZtoLMS_M\nconst LMStoXYZ_M$1 = [\n\t[  1.2268798758459243, -0.5578149944602171,  0.2813910456659647 ],\n\t[ -0.0405757452148008,  1.1122868032803170, -0.0717110580655164 ],\n\t[ -0.0763729366746601, -0.4214933324022432,  1.5869240198367816 ],\n];\nconst LMStoLab_M = [\n\t[ 0.2104542683093140,  0.7936177747023054, -0.0040720430116193 ],\n\t[ 1.9779985324311684, -2.4285922420485799,  0.4505937096174110 ],\n\t[ 0.0259040424655478,  0.7827717124575296, -0.8086757549230774 ],\n];\n// LMStoIab_M inverted\nconst LabtoLMS_M = [\n\t[ 1.0000000000000000,  0.3963377773761749,  0.2158037573099136 ],\n\t[ 1.0000000000000000, -0.1055613458156586, -0.0638541728258133 ],\n\t[ 1.0000000000000000, -0.0894841775298119, -1.2914855480194092 ],\n];\n\nvar OKLab = new ColorSpace({\n\tid: \"oklab\",\n\tname: \"Oklab\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 1],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\ta: {\n\t\t\trefRange: [-0.4, 0.4],\n\t\t},\n\t\tb: {\n\t\t\trefRange: [-0.4, 0.4],\n\t\t},\n\t},\n\n\t// Note that XYZ is relative to D65\n\twhite: \"D65\",\n\tbase: xyz_d65,\n\tfromBase (XYZ) {\n\t\t// move to LMS cone domain\n\t\tlet LMS = multiplyMatrices(XYZtoLMS_M$1, XYZ);\n\n\t\t// non-linearity\n\t\tlet LMSg = LMS.map(val => Math.cbrt(val));\n\n\t\treturn multiplyMatrices(LMStoLab_M, LMSg);\n\n\t},\n\ttoBase (OKLab) {\n\t\t// move to LMS cone domain\n\t\tlet LMSg = multiplyMatrices(LabtoLMS_M, OKLab);\n\n\t\t// restore linearity\n\t\tlet LMS = LMSg.map(val => val ** 3);\n\n\t\treturn multiplyMatrices(LMStoXYZ_M$1, LMS);\n\t},\n\n\tformats: {\n\t\t\"oklab\": {\n\t\t\tcoords: [\"<percentage> | <number>\", \"<number> | <percentage>[-1,1]\", \"<number> | <percentage>[-1,1]\"],\n\t\t},\n\t},\n});\n\n// More accurate color-difference formulae\n// than the simple 1976 Euclidean distance in CIE Lab\n\n\nfunction deltaEOK (color, sample) {\n\t[color, sample] = getColor([color, sample]);\n\n\t// Given this color as the reference\n\t// and a sample,\n\t// calculate deltaEOK, term by term as root sum of squares\n\tlet [L1, a1, b1] = OKLab.from(color);\n\tlet [L2, a2, b2] = OKLab.from(sample);\n\tlet ΔL = L1 - L2;\n\tlet Δa = a1 - a2;\n\tlet Δb = b1 - b2;\n\treturn Math.sqrt(ΔL ** 2 + Δa ** 2 + Δb ** 2);\n}\n\nconst ε$5 = .000075;\n\n/**\n * Check if a color is in gamut of either its own or another color space\n * @return {Boolean} Is the color in gamut?\n */\nfunction inGamut (color, space, {epsilon = ε$5} = {}) {\n\tcolor = getColor(color);\n\n\tif (!space) {\n\t\tspace = color.space;\n\t}\n\n\tspace = ColorSpace.get(space);\n\tlet coords = color.coords;\n\n\tif (space !== color.space) {\n\t\tcoords = space.from(color);\n\t}\n\n\treturn space.inGamut(coords, {epsilon});\n}\n\nfunction clone (color) {\n\treturn {\n\t\tspace: color.space,\n\t\tcoords: color.coords.slice(),\n\t\talpha: color.alpha,\n\t};\n}\n\n/**\n * Euclidean distance of colors in an arbitrary color space\n */\nfunction distance (color1, color2, space = \"lab\") {\n\tspace = ColorSpace.get(space);\n\n\t// Assume getColor() is called on color in space.from()\n\tlet coords1 = space.from(color1);\n\tlet coords2 = space.from(color2);\n\n\treturn Math.sqrt(coords1.reduce((acc, c1, i) => {\n\t\tlet c2 = coords2[i];\n\t\tif (isNaN(c1) || isNaN(c2)) {\n\t\t\treturn acc;\n\t\t}\n\n\t\treturn acc + (c2 - c1) ** 2;\n\t}, 0));\n}\n\nfunction deltaE76 (color, sample) {\n\t// Assume getColor() is called in the distance function\n\treturn distance(color, sample, \"lab\");\n}\n\n// More accurate color-difference formulae\n// than the simple 1976 Euclidean distance in Lab\n\n// CMC by the Color Measurement Committee of the\n// Bradford Society of Dyeists and Colorsts, 1994.\n// Uses LCH rather than Lab,\n// with different weights for L, C and H differences\n// A nice increase in accuracy for modest increase in complexity\nconst π = Math.PI;\nconst d2r = π / 180;\n\nfunction deltaECMC (color, sample, {l = 2, c = 1} = {}) {\n\t[color, sample] = getColor([color, sample]);\n\n\t// Given this color as the reference\n\t// and a sample,\n\t// calculate deltaE CMC.\n\n\t// This implementation assumes the parametric\n\t// weighting factors l:c are 2:1\n\t// which is typical for non-textile uses.\n\n\tlet [L1, a1, b1] = lab.from(color);\n\tlet [, C1, H1] = lch.from(lab, [L1, a1, b1]);\n\tlet [L2, a2, b2] = lab.from(sample);\n\tlet C2 = lch.from(lab, [L2, a2, b2])[1];\n\n\t// let [L1, a1, b1] = color.getAll(lab);\n\t// let C1 = color.get(\"lch.c\");\n\t// let H1 = color.get(\"lch.h\");\n\t// let [L2, a2, b2] = sample.getAll(lab);\n\t// let C2 = sample.get(\"lch.c\");\n\n\t// Check for negative Chroma,\n\t// which might happen through\n\t// direct user input of LCH values\n\n\tif (C1 < 0) {\n\t\tC1 = 0;\n\t}\n\tif (C2 < 0) {\n\t\tC2 = 0;\n\t}\n\n\t// we don't need H2 as ΔH is calculated from Δa, Δb and ΔC\n\n\t// Lightness and Chroma differences\n\t// These are (color - sample), unlike deltaE2000\n\tlet ΔL = L1 - L2;\n\tlet ΔC = C1 - C2;\n\n\tlet Δa = a1 - a2;\n\tlet Δb = b1 - b2;\n\n\t// weighted Hue difference, less for larger Chroma difference\n\n\tlet H2 = (Δa ** 2) + (Δb ** 2) - (ΔC ** 2);\n\t// due to roundoff error it is possible that, for zero a and b,\n\t// ΔC > Δa + Δb is 0, resulting in attempting\n\t// to take the square root of a negative number\n\n\t// trying instead the equation from Industrial Color Physics\n\t// By Georg A. Klein\n\n\t// let ΔH = ((a1 * b2) - (a2 * b1)) / Math.sqrt(0.5 * ((C2 * C1) + (a2 * a1) + (b2 * b1)));\n\t// console.log({ΔH});\n\t// This gives the same result to 12 decimal places\n\t// except it sometimes NaNs when trying to root a negative number\n\n\t// let ΔH = Math.sqrt(H2); we never actually use the root, it gets squared again!!\n\n\t// positional corrections to the lack of uniformity of CIELAB\n\t// These are all trying to make JND ellipsoids more like spheres\n\n\t// SL Lightness crispening factor, depends entirely on L1 not L2\n\tlet SL = 0.511;\t// linear portion of the Y to L transfer function\n\tif (L1 >= 16) {\t// cubic portion\n\t\tSL = (0.040975 * L1) / (1 + 0.01765 * L1);\n\t}\n\n\t// SC Chroma factor\n\tlet SC = ((0.0638 * C1) / (1 + 0.0131 * C1)) + 0.638;\n\n\t// Cross term T for blue non-linearity\n\tlet T;\n\tif (Number.isNaN(H1)) {\n\t\tH1 = 0;\n\t}\n\n\tif (H1 >= 164 && H1 <= 345) {\n\t\tT = 0.56 + Math.abs(0.2 * Math.cos((H1 + 168) * d2r));\n\t}\n\telse {\n\t\tT = 0.36 + Math.abs(0.4 * Math.cos((H1 + 35) * d2r));\n\t}\n\t// console.log({T});\n\n\t// SH Hue factor also depends on C1,\n\tlet C4 = Math.pow(C1, 4);\n\tlet F = Math.sqrt(C4 / (C4 + 1900));\n\tlet SH = SC * ((F * T) + 1 - F);\n\n\t// Finally calculate the deltaE, term by term as root sume of squares\n\tlet dE = (ΔL / (l * SL)) ** 2;\n\tdE += (ΔC / (c * SC)) ** 2;\n\tdE += (H2 / (SH ** 2));\n\t// dE += (ΔH / SH)  ** 2;\n\treturn Math.sqrt(dE);\n\t// Yay!!!\n}\n\nconst Yw$1 = 203;\t// absolute luminance of media white\n\nvar XYZ_Abs_D65 = new ColorSpace({\n// Absolute CIE XYZ, with a D65 whitepoint,\n// as used in most HDR colorspaces as a starting point.\n// SDR spaces are converted per BT.2048\n// so that diffuse, media white is 203 cd/m²\n\tid: \"xyz-abs-d65\",\n\tcssId: \"--xyz-abs-d65\",\n\tname: \"Absolute XYZ D65\",\n\tcoords: {\n\t\tx: {\n\t\t\trefRange: [0, 9504.7],\n\t\t\tname: \"Xa\",\n\t\t},\n\t\ty: {\n\t\t\trefRange: [0, 10000],\n\t\t\tname: \"Ya\",\n\t\t},\n\t\tz: {\n\t\t\trefRange: [0, 10888.3],\n\t\t\tname: \"Za\",\n\t\t},\n\t},\n\n\tbase: xyz_d65,\n\tfromBase (XYZ) {\n\t\t// Make XYZ absolute, not relative to media white\n\t\t// Maximum luminance in PQ is 10,000 cd/m²\n\t\t// Relative XYZ has Y=1 for media white\n\t\treturn XYZ.map (v => Math.max(v * Yw$1, 0));\n\t},\n\ttoBase (AbsXYZ) {\n\t\t// Convert to media-white relative XYZ\n\t\treturn AbsXYZ.map(v => Math.max(v / Yw$1, 0));\n\t},\n});\n\nconst b$1 = 1.15;\nconst g = 0.66;\nconst n$1 = 2610 / (2 ** 14);\nconst ninv$1 = (2 ** 14) / 2610;\nconst c1$2 = 3424 / (2 ** 12);\nconst c2$2 = 2413 / (2 ** 7);\nconst c3$2 = 2392 / (2 ** 7);\nconst p = 1.7 * 2523 / (2 ** 5);\nconst pinv = (2 ** 5) / (1.7 * 2523);\nconst d = -0.56;\nconst d0 = 1.6295499532821566E-11;\n\nconst XYZtoCone_M = [\n\t[  0.41478972, 0.579999,  0.0146480 ],\n\t[ -0.2015100,  1.120649,  0.0531008 ],\n\t[ -0.0166008,  0.264800,  0.6684799 ],\n];\n// XYZtoCone_M inverted\nconst ConetoXYZ_M = [\n\t[  1.9242264357876067,  -1.0047923125953657,  0.037651404030618   ],\n\t[  0.35031676209499907,  0.7264811939316552, -0.06538442294808501 ],\n\t[ -0.09098281098284752, -0.3127282905230739,  1.5227665613052603  ],\n];\nconst ConetoIab_M = [\n\t[  0.5,       0.5,       0        ],\n\t[  3.524000, -4.066708,  0.542708 ],\n\t[  0.199076,  1.096799, -1.295875 ],\n];\n// ConetoIab_M inverted\nconst IabtoCone_M = [\n\t[ 1,                   0.1386050432715393,   0.05804731615611886 ],\n\t[ 0.9999999999999999, -0.1386050432715393,  -0.05804731615611886 ],\n\t[ 0.9999999999999998, -0.09601924202631895, -0.8118918960560388  ],\n];\n\nvar Jzazbz = new ColorSpace({\n\tid: \"jzazbz\",\n\tname: \"Jzazbz\",\n\tcoords: {\n\t\tjz: {\n\t\t\trefRange: [0, 1],\n\t\t\tname: \"Jz\",\n\t\t},\n\t\taz: {\n\t\t\trefRange: [-0.5, 0.5],\n\t\t},\n\t\tbz: {\n\t\t\trefRange: [-0.5, 0.5],\n\t\t},\n\t},\n\n\tbase: XYZ_Abs_D65,\n\tfromBase (XYZ) {\n\t\t// First make XYZ absolute, not relative to media white\n\t\t// Maximum luminance in PQ is 10,000 cd/m²\n\t\t// Relative XYZ has Y=1 for media white\n\t\t// BT.2048 says media white Y=203 at PQ 58\n\n\t\tlet [ Xa, Ya, Za ] = XYZ;\n\n\t\t// modify X and Y\n\t\tlet Xm = (b$1 * Xa) - ((b$1 - 1) * Za);\n\t\tlet Ym = (g * Ya) - ((g - 1) * Xa);\n\n\t\t// move to LMS cone domain\n\t\tlet LMS = multiplyMatrices(XYZtoCone_M, [ Xm, Ym, Za ]);\n\n\t\t// PQ-encode LMS\n\t\tlet PQLMS = LMS.map (function (val) {\n\t\t\tlet num = c1$2 + (c2$2 * ((val / 10000) ** n$1));\n\t\t\tlet denom = 1 + (c3$2 * ((val / 10000) ** n$1));\n\n\t\t\treturn (num / denom)  ** p;\n\t\t});\n\n\t\t// almost there, calculate Iz az bz\n\t\tlet [ Iz, az, bz] = multiplyMatrices(ConetoIab_M, PQLMS);\n\t\t// console.log({Iz, az, bz});\n\n\t\tlet Jz = ((1 + d) * Iz) / (1 + (d * Iz)) - d0;\n\t\treturn [Jz, az, bz];\n\t},\n\ttoBase (Jzazbz) {\n\t\tlet [Jz, az, bz] = Jzazbz;\n\t\tlet Iz = (Jz + d0) / (1 + d - d * (Jz + d0));\n\n\t\t// bring into LMS cone domain\n\t\tlet PQLMS = multiplyMatrices(IabtoCone_M, [ Iz, az, bz ]);\n\n\t\t// convert from PQ-coded to linear-light\n\t\tlet LMS = PQLMS.map(function (val) {\n\t\t\tlet num = (c1$2 - (val ** pinv));\n\t\t\tlet denom = (c3$2 * (val ** pinv)) - c2$2;\n\t\t\tlet x = 10000 * ((num / denom) ** ninv$1);\n\n\t\t\treturn (x); \t// luminance relative to diffuse white, [0, 70 or so].\n\t\t});\n\n\t\t// modified abs XYZ\n\t\tlet [ Xm, Ym, Za ] = multiplyMatrices(ConetoXYZ_M, LMS);\n\n\t\t// restore standard D50 relative XYZ, relative to media white\n\t\tlet Xa = (Xm + ((b$1 - 1) * Za)) / b$1;\n\t\tlet Ya = (Ym + ((g - 1) * Xa)) / g;\n\t\treturn [ Xa, Ya, Za ];\n\t},\n\n\tformats: {\n\t\t// https://drafts.csswg.org/css-color-hdr/#Jzazbz\n\t\t\"color\": {\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>[-1,1]\", \"<number> | <percentage>[-1,1]\"],\n\t\t},\n\t},\n});\n\nvar jzczhz = new ColorSpace({\n\tid: \"jzczhz\",\n\tname: \"JzCzHz\",\n\tcoords: {\n\t\tjz: {\n\t\t\trefRange: [0, 1],\n\t\t\tname: \"Jz\",\n\t\t},\n\t\tcz: {\n\t\t\trefRange: [0, 1],\n\t\t\tname: \"Chroma\",\n\t\t},\n\t\thz: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t},\n\n\tbase: Jzazbz,\n\tfromBase (jzazbz) {\n\t\t// Convert to polar form\n\t\tlet [Jz, az, bz] = jzazbz;\n\t\tlet hue;\n\t\tconst ε = 0.0002; // chromatic components much smaller than a,b\n\n\t\tif (Math.abs(az) < ε && Math.abs(bz) < ε) {\n\t\t\thue = NaN;\n\t\t}\n\t\telse {\n\t\t\thue = Math.atan2(bz, az) * 180 / Math.PI;\n\t\t}\n\n\t\treturn [\n\t\t\tJz, // Jz is still Jz\n\t\t\tMath.sqrt(az ** 2 + bz ** 2), // Chroma\n\t\t\tconstrain(hue), // Hue, in degrees [0 to 360)\n\t\t];\n\t},\n\ttoBase (jzczhz) {\n\t\t// Convert from polar form\n\t\t// debugger;\n\t\treturn [\n\t\t\tjzczhz[0], // Jz is still Jz\n\t\t\tjzczhz[1] * Math.cos(jzczhz[2] * Math.PI / 180), // az\n\t\t\tjzczhz[1] * Math.sin(jzczhz[2] * Math.PI / 180),  // bz\n\t\t];\n\t},\n});\n\n// More accurate color-difference formulae\n// than the simple 1976 Euclidean distance in Lab\n\n// Uses JzCzHz, which has improved perceptual uniformity\n// and thus a simple Euclidean root-sum of ΔL² ΔC² ΔH²\n// gives good results.\n\nfunction deltaEJz (color, sample) {\n\t[color, sample] = getColor([color, sample]);\n\n\t// Given this color as the reference\n\t// and a sample,\n\t// calculate deltaE in JzCzHz.\n\tlet [Jz1, Cz1, Hz1] = jzczhz.from(color);\n\tlet [Jz2, Cz2, Hz2] = jzczhz.from(sample);\n\n\t// Lightness and Chroma differences\n\t// sign does not matter as they are squared.\n\tlet ΔJ = Jz1 - Jz2;\n\tlet ΔC = Cz1 - Cz2;\n\n\t// length of chord for ΔH\n\tif ((Number.isNaN(Hz1)) && (Number.isNaN(Hz2))) {\n\t\t// both undefined hues\n\t\tHz1 = 0;\n\t\tHz2 = 0;\n\t}\n\telse if (Number.isNaN(Hz1)) {\n\t\t// one undefined, set to the defined hue\n\t\tHz1 = Hz2;\n\t}\n\telse if (Number.isNaN(Hz2)) {\n\t\tHz2 = Hz1;\n\t}\n\n\tlet Δh = Hz1 - Hz2;\n\tlet ΔH = 2 * Math.sqrt(Cz1 * Cz2) * Math.sin((Δh / 2) * (Math.PI / 180));\n\n\treturn Math.sqrt(ΔJ ** 2 + ΔC ** 2 + ΔH ** 2);\n}\n\nconst c1$1 = 3424 / 4096;\nconst c2$1 = 2413 / 128;\nconst c3$1 = 2392 / 128;\nconst m1$1 = 2610 / 16384;\nconst m2 = 2523 / 32;\nconst im1 = 16384 / 2610;\nconst im2 = 32 / 2523;\n\n// The matrix below includes the 4% crosstalk components\n// and is from the Dolby \"What is ICtCp\" paper\"\nconst XYZtoLMS_M = [\n\t[  0.3592832590121217,  0.6976051147779502, -0.0358915932320290 ],\n\t[ -0.1920808463704993,  1.1004767970374321,  0.0753748658519118 ],\n\t[  0.0070797844607479,  0.0748396662186362,  0.8433265453898765 ],\n];\n// linear-light Rec.2020 to LMS, again with crosstalk\n// rational terms from Jan Fröhlich,\n// Encoding High Dynamic Range andWide Color Gamut Imagery, p.97\n// and ITU-R BT.2124-0 p.2\n/*\nconst Rec2020toLMS_M = [\n\t[ 1688 / 4096,  2146 / 4096,   262 / 4096 ],\n\t[  683 / 4096,  2951 / 4096,   462 / 4096 ],\n\t[   99 / 4096,   309 / 4096,  3688 / 4096 ]\n];\n*/\n// this includes the Ebner LMS coefficients,\n// the rotation, and the scaling to [-0.5,0.5] range\n// rational terms from Fröhlich p.97\n// and ITU-R BT.2124-0 pp.2-3\nconst LMStoIPT_M = [\n\t[  2048 / 4096,   2048 / 4096,       0      ],\n\t[  6610 / 4096, -13613 / 4096,  7003 / 4096 ],\n\t[ 17933 / 4096, -17390 / 4096,  -543 / 4096 ],\n];\n\n// inverted matrices, calculated from the above\nconst IPTtoLMS_M = [\n\t[ 0.9999999999999998,  0.0086090370379328,  0.1110296250030260 ],\n\t[ 0.9999999999999998, -0.0086090370379328, -0.1110296250030259 ],\n\t[ 0.9999999999999998,  0.5600313357106791, -0.3206271749873188 ],\n];\n/*\nconst LMStoRec2020_M = [\n\t[ 3.4375568932814012112,   -2.5072112125095058195,   0.069654319228104608382],\n\t[-0.79142868665644156125,   1.9838372198740089874,  -0.19240853321756742626 ],\n\t[-0.025646662911506476363, -0.099240248643945566751, 1.1248869115554520431  ]\n];\n*/\nconst LMStoXYZ_M = [\n\t[  2.0701522183894223, -1.3263473389671563,  0.2066510476294053 ],\n\t[  0.3647385209748072,  0.6805660249472273, -0.0453045459220347 ],\n\t[ -0.0497472075358123, -0.0492609666966131,  1.1880659249923042 ],\n];\n\n// Only the PQ form of ICtCp is implemented here. There is also an HLG form.\n// from Dolby, \"WHAT IS ICTCP?\"\n// https://professional.dolby.com/siteassets/pdfs/ictcp_dolbywhitepaper_v071.pdf\n// and\n// Dolby, \"Perceptual Color Volume\n// Measuring the Distinguishable Colors of HDR and WCG Displays\"\n// https://professional.dolby.com/siteassets/pdfs/dolby-vision-measuring-perceptual-color-volume-v7.1.pdf\nvar ictcp = new ColorSpace({\n\tid: \"ictcp\",\n\tname: \"ICTCP\",\n\t// From BT.2100-2 page 7:\n\t// During production, signal values are expected to exceed the\n\t// range E′ = [0.0 : 1.0]. This provides processing headroom and avoids\n\t// signal degradation during cascaded processing. Such values of E′,\n\t// below 0.0 or exceeding 1.0, should not be clipped during production\n\t// and exchange.\n\t// Values below 0.0 should not be clipped in reference displays (even\n\t// though they represent “negative” light) to allow the black level of\n\t// the signal (LB) to be properly set using test signals known as “PLUGE”\n\tcoords: {\n\t\ti: {\n\t\t\trefRange: [0, 1],\t// Constant luminance,\n\t\t\tname: \"I\",\n\t\t},\n\t\tct: {\n\t\t\trefRange: [-0.5, 0.5],\t// Full BT.2020 gamut in range [-0.5, 0.5]\n\t\t\tname: \"CT\",\n\t\t},\n\t\tcp: {\n\t\t\trefRange: [-0.5, 0.5],\n\t\t\tname: \"CP\",\n\t\t},\n\t},\n\n\tbase: XYZ_Abs_D65,\n\tfromBase (XYZ) {\n\t\t// move to LMS cone domain\n\t\tlet LMS = multiplyMatrices(XYZtoLMS_M, XYZ);\n\n\t\treturn LMStoICtCp(LMS);\n\t},\n\ttoBase (ICtCp) {\n\t\tlet LMS = ICtCptoLMS(ICtCp);\n\n\t\treturn multiplyMatrices(LMStoXYZ_M, LMS);\n\t},\n});\n\nfunction LMStoICtCp (LMS) {\n\t// apply the PQ EOTF\n\t// we can't ever be dividing by zero because of the \"1 +\" in the denominator\n\tlet PQLMS = LMS.map (function (val) {\n\t\tlet num = c1$1 + (c2$1 * ((val / 10000) ** m1$1));\n\t\tlet denom = 1 + (c3$1 * ((val / 10000) ** m1$1));\n\n\t\treturn (num / denom)  ** m2;\n\t});\n\n\t// LMS to IPT, with rotation for Y'C'bC'r compatibility\n\treturn multiplyMatrices(LMStoIPT_M, PQLMS);\n}\n\nfunction ICtCptoLMS (ICtCp) {\n\tlet PQLMS = multiplyMatrices(IPTtoLMS_M, ICtCp);\n\n\t// From BT.2124-0 Annex 2 Conversion 3\n\tlet LMS = PQLMS.map (function (val) {\n\t\tlet num  = Math.max((val ** im2) - c1$1, 0);\n\t\tlet denom = (c2$1 - (c3$1 * (val ** im2)));\n\t\treturn 10000 * ((num / denom) ** im1);\n\t});\n\n\treturn LMS;\n}\n\n// Delta E in ICtCp space,\n// which the ITU calls Delta E ITP, which is shorter\n// formulae from ITU Rec. ITU-R BT.2124-0\n\nfunction deltaEITP (color, sample) {\n\t[color, sample] = getColor([color, sample]);\n\n\t// Given this color as the reference\n\t// and a sample,\n\t// calculate deltaE in ICtCp\n\t// which is simply the Euclidean distance\n\n\tlet [ I1, T1, P1 ] = ictcp.from(color);\n\tlet [ I2, T2, P2 ] = ictcp.from(sample);\n\n\t// the 0.25 factor is to undo the encoding scaling in Ct\n\t// the 720 is so that 1 deltaE = 1 JND\n\t// per  ITU-R BT.2124-0 p.3\n\n\treturn 720 * Math.sqrt((I1 - I2) ** 2 + (0.25 * (T1 - T2) ** 2) + (P1 - P2) ** 2);\n}\n\nconst white$3 = WHITES.D65;\nconst adaptedCoef = 0.42;\nconst adaptedCoefInv = 1 / adaptedCoef;\nconst tau = 2 * Math.PI;\n\nconst cat16 = [\n\t[  0.401288,  0.650173, -0.051461 ],\n\t[ -0.250268,  1.204414,  0.045854 ],\n\t[ -0.002079,  0.048952,  0.953127 ],\n];\n\nconst cat16Inv = [\n\t[1.8620678550872327, -1.0112546305316843, 0.14918677544445175],\n\t[0.38752654323613717, 0.6214474419314753, -0.008973985167612518],\n\t[-0.015841498849333856, -0.03412293802851557, 1.0499644368778496],\n];\n\nconst m1 = [\n\t[460.0, 451.0, 288.0],\n\t[460.0, -891.0, -261.0],\n\t[460.0, -220.0, -6300.0],\n];\n\nconst surroundMap = {\n\tdark: [0.8, 0.525, 0.8],\n\tdim: [0.9, 0.59, 0.9],\n\taverage: [1, 0.69, 1],\n};\n\nconst hueQuadMap = {\n\t// Red, Yellow, Green, Blue, Red\n\th: [20.14, 90.00, 164.25, 237.53, 380.14],\n\te: [0.8, 0.7, 1.0, 1.2, 0.8],\n\tH: [0.0, 100.0, 200.0, 300.0, 400.0],\n};\n\nconst rad2deg = 180 / Math.PI;\nconst deg2rad$1 = Math.PI / 180;\n\nfunction adapt$1 (coords, fl) {\n\tconst temp = coords.map(c => {\n\t\tconst x = spow(fl * Math.abs(c) * 0.01, adaptedCoef);\n\t\treturn 400 * copySign(x, c) / (x + 27.13);\n\t});\n\treturn temp;\n}\n\nfunction unadapt (adapted, fl) {\n\tconst constant = 100 / fl * (27.13 ** adaptedCoefInv);\n\treturn adapted.map(c => {\n\t\tconst cabs = Math.abs(c);\n\t\treturn copySign(constant * spow(cabs / (400 - cabs), adaptedCoefInv), c);\n\t});\n}\n\nfunction hueQuadrature (h) {\n\tlet hp = constrain(h);\n\tif (hp <= hueQuadMap.h[0]) {\n\t\thp += 360;\n\t}\n\n\tconst i = bisectLeft(hueQuadMap.h, hp) - 1;\n\tconst [hi, hii] = hueQuadMap.h.slice(i, i + 2);\n\tconst [ei, eii] = hueQuadMap.e.slice(i, i + 2);\n\tconst Hi = hueQuadMap.H[i];\n\n\tconst t = (hp - hi) / ei;\n\treturn Hi + (100 * t) / (t + (hii - hp) / eii);\n}\n\nfunction invHueQuadrature (H) {\n\tlet Hp = ((H % 400 + 400) % 400);\n\tconst i = Math.floor(0.01 * Hp);\n\tHp = Hp % 100;\n\tconst [hi, hii] = hueQuadMap.h.slice(i, i + 2);\n\tconst [ei, eii] = hueQuadMap.e.slice(i, i + 2);\n\n\treturn constrain(\n\t\t(Hp * (eii * hi - ei * hii) - 100 * hi * eii) /\n\t\t(Hp * (eii - ei) - 100 * eii),\n\t);\n}\n\nfunction environment (\n\trefWhite,\n\tadaptingLuminance,\n\tbackgroundLuminance,\n\tsurround,\n\tdiscounting,\n) {\n\n\tconst env = {};\n\n\tenv.discounting = discounting;\n\tenv.refWhite = refWhite;\n\tenv.surround = surround;\n\tconst xyzW = refWhite.map(c => {\n\t\treturn c * 100;\n\t});\n\n\t// The average luminance of the environment in `cd/m^2cd/m` (a.k.a. nits)\n\tenv.la = adaptingLuminance;\n\t// The relative luminance of the nearby background\n\tenv.yb = backgroundLuminance;\n\t// Absolute luminance of the reference white.\n\tconst yw = xyzW[1];\n\n\t// Cone response for reference white\n\tconst rgbW = multiplyMatrices(cat16, xyzW);\n\n\t// Surround: dark, dim, and average\n\tsurround = surroundMap[env.surround];\n\tconst f = surround[0];\n\tenv.c = surround[1];\n\tenv.nc = surround[2];\n\n\tconst k = 1 / (5 * env.la + 1);\n\tconst k4 = k ** 4;\n\n\t// Factor of luminance level adaptation\n\tenv.fl = (k4 * env.la + 0.1 * (1 - k4) * (1 - k4) * Math.cbrt(5 * env.la));\n\tenv.flRoot = env.fl ** 0.25;\n\n\tenv.n = env.yb / yw;\n\tenv.z = 1.48 + Math.sqrt(env.n);\n\tenv.nbb = 0.725 * (env.n ** -0.2);\n\tenv.ncb = env.nbb;\n\n\t// Degree of adaptation calculating if not discounting\n\t// illuminant (assumed eye is fully adapted)\n\tconst d = (discounting) ?\n\t\t1 :\n\t\tMath.max(\n\t\t\tMath.min(f * (1 - 1 / 3.6 * Math.exp((-env.la - 42) / 92)), 1),\n\t\t\t0,\n\t\t);\n\tenv.dRgb = rgbW.map(c => {\n\t\treturn interpolate(1, yw / c, d);\n\t});\n\tenv.dRgbInv = env.dRgb.map(c => {\n\t\treturn 1 / c;\n\t});\n\n\t// Achromatic response\n\tconst rgbCW = rgbW.map((c, i) => {\n\t\treturn c * env.dRgb[i];\n\t});\n\tconst rgbAW = adapt$1(rgbCW, env.fl);\n\tenv.aW = env.nbb * (2 * rgbAW[0] + rgbAW[1] + 0.05 * rgbAW[2]);\n\n\t// console.log(env);\n\n\treturn env;\n}\n\n// Pre-calculate everything we can with the viewing conditions\nconst viewingConditions$1 = environment(\n\twhite$3,\n\t64 / Math.PI * 0.2, 20,\n\t\"average\",\n\tfalse,\n);\n\nfunction fromCam16 (cam16, env) {\n\n\t// These check ensure one, and only one attribute for a\n\t// given category is provided.\n\tif (!((cam16.J !== undefined) ^ (cam16.Q !== undefined))) {\n\t\tthrow new Error(\"Conversion requires one and only one: 'J' or 'Q'\");\n\t}\n\n\tif (!((cam16.C !== undefined) ^ (cam16.M !== undefined) ^ (cam16.s !== undefined))) {\n\t\tthrow new Error(\"Conversion requires one and only one: 'C', 'M' or 's'\");\n\t}\n\n\t// Hue is absolutely required\n\tif (!((cam16.h !== undefined) ^ (cam16.H !== undefined))) {\n\t\tthrow new Error(\"Conversion requires one and only one: 'h' or 'H'\");\n\t}\n\n\t// Black\n\tif (cam16.J === 0.0 || cam16.Q === 0.0) {\n\t\treturn [0.0, 0.0, 0.0];\n\t}\n\n\t// Break hue into Cartesian components\n\tlet hRad = 0.0;\n\tif (cam16.h !== undefined) {\n\t\thRad = constrain(cam16.h) * deg2rad$1;\n\t}\n\telse {\n\t\thRad = invHueQuadrature(cam16.H) * deg2rad$1;\n\t}\n\n\tconst cosh = Math.cos(hRad);\n\tconst sinh = Math.sin(hRad);\n\n\t// Calculate `Jroot` from one of the lightness derived coordinates.\n\tlet Jroot = 0.0;\n\tif (cam16.J !== undefined) {\n\t\tJroot = spow(cam16.J, 1 / 2) * 0.1;\n\t}\n\telse if (cam16.Q !== undefined) {\n\t\tJroot = 0.25 * env.c * cam16.Q / ((env.aW + 4) * env.flRoot);\n\t}\n\n\t// Calculate the `t` value from one of the chroma derived coordinates\n\tlet alpha = 0.0;\n\tif (cam16.C !== undefined) {\n\t\talpha = cam16.C / Jroot;\n\t}\n\telse if (cam16.M !== undefined) {\n\t\talpha = (cam16.M / env.flRoot) / Jroot;\n\t}\n\telse if (cam16.s !== undefined) {\n\t\talpha = 0.0004 * (cam16.s ** 2) * (env.aW + 4) / env.c;\n\t}\n\tconst t = spow(\n\t\talpha * Math.pow(1.64 - Math.pow(0.29, env.n), -0.73),\n\t\t10 / 9,\n\t);\n\n\t// Eccentricity\n\tconst et = 0.25 * (Math.cos(hRad + 2) + 3.8);\n\n\t// Achromatic response\n\tconst A = env.aW * spow(Jroot, 2 / env.c / env.z);\n\n\t// Calculate red-green and yellow-blue components\n\tconst p1 = 5e4 / 13 * env.nc * env.ncb * et;\n\tconst p2 = A / env.nbb;\n\tconst r = (\n\t\t23 * (p2 + 0.305) *\n\t\tzdiv(t, 23 * p1 + t * (11 * cosh + 108 * sinh))\n\t);\n\tconst a = r * cosh;\n\tconst b = r * sinh;\n\n\t// Calculate back from cone response to XYZ\n\tconst rgb_c = unadapt(\n\t\tmultiplyMatrices(m1, [p2, a, b]).map(c => {\n\t\t\treturn c * 1 / 1403;\n\t\t}),\n\t\tenv.fl,\n\t);\n\treturn multiplyMatrices(\n\t\tcat16Inv,\n\t\trgb_c.map((c, i) => {\n\t\t\treturn c * env.dRgbInv[i];\n\t\t}),\n\t).map(c => {\n\t\treturn c / 100;\n\t});\n}\n\n\nfunction toCam16 (xyzd65, env) {\n\t// Cone response\n\tconst xyz100 = xyzd65.map(c => {\n\t\treturn c * 100;\n\t});\n\tconst rgbA = adapt$1(\n\t\tmultiplyMatrices(cat16, xyz100).map((c, i) => {\n\t\t\treturn c * env.dRgb[i];\n\t\t}),\n\t\tenv.fl,\n\t);\n\n\t// Calculate hue from red-green and yellow-blue components\n\tconst a = rgbA[0] + (-12 * rgbA[1] + rgbA[2]) / 11;\n\tconst b = (rgbA[0] + rgbA[1] - 2 * rgbA[2]) / 9;\n\tconst hRad = ((Math.atan2(b, a) % tau) + tau) % tau;\n\n\t// Eccentricity\n\tconst et = 0.25 * (Math.cos(hRad + 2) + 3.8);\n\n\tconst t = (\n\t\t5e4 / 13 * env.nc * env.ncb *\n\t\tzdiv(\n\t\t\tet * Math.sqrt(a ** 2 + b ** 2),\n\t\t\trgbA[0] + rgbA[1] + 1.05 * rgbA[2] + 0.305,\n\t\t)\n\t);\n\tconst alpha = spow(t, 0.9) * Math.pow(1.64 - Math.pow(0.29, env.n), 0.73);\n\n\t// Achromatic response\n\tconst A = env.nbb * (2 * rgbA[0] + rgbA[1] + 0.05 * rgbA[2]);\n\n\tconst Jroot = spow(A / env.aW, 0.5 * env.c * env.z);\n\n\t// Lightness\n\tconst J = 100 * spow(Jroot, 2);\n\n\t// Brightness\n\tconst Q = (4 / env.c * Jroot * (env.aW + 4) * env.flRoot);\n\n\t// Chroma\n\tconst C = alpha * Jroot;\n\n\t// Colorfulness\n\tconst M = C * env.flRoot;\n\n\t// Hue\n\tconst h = constrain(hRad * rad2deg);\n\n\t// Hue quadrature\n\tconst H = hueQuadrature(h);\n\n\t// Saturation\n\tconst s = 50 * spow(env.c * alpha / (env.aW + 4), 1 / 2);\n\n\t// console.log({J: J, C: C, h: h, s: s, Q: Q, M: M, H: H});\n\n\treturn {J: J, C: C, h: h, s: s, Q: Q, M: M, H: H};\n}\n\n\n// Provided as a way to directly evaluate the CAM16 model\n// https://observablehq.com/@jrus/cam16: reference implementation\n// https://arxiv.org/pdf/1802.06067.pdf: Nico Schlömer\n// https://onlinelibrary.wiley.com/doi/pdf/10.1002/col.22324: hue quadrature\n// https://www.researchgate.net/publication/318152296_Comprehensive_color_solutions_CAM16_CAT16_and_CAM16-UCS\n// Results compared against: https://github.com/colour-science/colour\nvar cam16 = new ColorSpace({\n\tid: \"cam16-jmh\",\n\tcssId: \"--cam16-jmh\",\n\tname: \"CAM16-JMh\",\n\tcoords: {\n\t\tj: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"J\",\n\t\t},\n\t\tm: {\n\t\t\trefRange: [0, 105.0],\n\t\t\tname: \"Colorfulness\",\n\t\t},\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t},\n\n\tbase: xyz_d65,\n\n\tfromBase (xyz) {\n\t\tconst cam16 = toCam16(xyz, viewingConditions$1);\n\t\treturn [cam16.J, cam16.M, cam16.h];\n\t},\n\ttoBase (cam16) {\n\t\treturn fromCam16(\n\t\t\t{J: cam16[0], M: cam16[1], h: cam16[2]},\n\t\t\tviewingConditions$1,\n\t\t);\n\t},\n});\n\nconst white$2 = WHITES.D65;\nconst ε$4 = 216 / 24389;  // 6^3/29^3 == (24/116)^3\nconst κ$3 = 24389 / 27;   // 29^3/3^3\n\nfunction toLstar (y) {\n\t// Convert XYZ Y to L*\n\n\tconst fy = (y > ε$4) ? Math.cbrt(y) : (κ$3 * y + 16) / 116;\n\treturn (116.0 * fy) - 16.0;\n}\n\nfunction fromLstar (lstar) {\n\t// Convert L* back to XYZ Y\n\n\treturn (lstar > 8) ?  Math.pow((lstar + 16) / 116, 3) : lstar / κ$3;\n}\n\nfunction fromHct (coords, env) {\n\t// Use Newton's method to try and converge as quick as possible or\n\t// converge as close as we can. While the requested precision is achieved\n\t// most of the time, it may not always be achievable. Especially past the\n\t// visible spectrum, the algorithm will likely struggle to get the same\n\t// precision. If, for whatever reason, we cannot achieve the accuracy we\n\t// seek in the allotted iterations, just return the closest we were able to\n\t// get.\n\n\tlet [h, c, t] = coords;\n\tlet xyz = [];\n\tlet j = 0;\n\n\t// Shortcut out for black\n\tif (t === 0) {\n\t\treturn [0.0, 0.0, 0.0];\n\t}\n\n\t// Calculate the Y we need to target\n\tlet y = fromLstar(t);\n\n\t// A better initial guess yields better results. Polynomials come from\n\t// curve fitting the T vs J response.\n\tif (t > 0) {\n\t\tj = 0.00379058511492914 * t ** 2 + 0.608983189401032 * t + 0.9155088574762233;\n\t}\n\telse {\n\t\tj = 9.514440756550361e-06 * t ** 2 + 0.08693057439788597 * t - 21.928975842194614;\n\t}\n\n\t// Threshold of how close is close enough, and max number of attempts.\n\t// More precision and more attempts means more time spent iterating. Higher\n\t// required precision gives more accuracy but also increases the chance of\n\t// not hitting the goal. 2e-12 allows us to convert round trip with\n\t// reasonable accuracy of six decimal places or more.\n\tconst threshold = 2e-12;\n\tconst max_attempts = 15;\n\n\tlet attempt = 0;\n\tlet last = Infinity;\n\n\t// Try to find a J such that the returned y matches the returned y of the L*\n\twhile (attempt <= max_attempts) {\n\t\txyz = fromCam16({J: j, C: c, h: h}, env);\n\n\t\t// If we are within range, return XYZ\n\t\t// If we are closer than last time, save the values\n\t\tconst delta = Math.abs(xyz[1] - y);\n\t\tif (delta < last) {\n\t\t\tif (delta <= threshold) {\n\t\t\t\treturn xyz;\n\t\t\t}\n\t\t\tlast = delta;\n\t\t}\n\n\t\t// f(j_root) = (j ** (1 / 2)) * 0.1\n\t\t// f(j) = ((f(j_root) * 100) ** 2) / j - 1 = 0\n\t\t// f(j_root) = Y = y / 100\n\t\t// f(j) = (y ** 2) / j - 1\n\t\t// f'(j) = (2 * y) / j\n\t\tj = j - (xyz[1] - y) * j / (2 * xyz[1]);\n\n\t\tattempt += 1;\n\t}\n\n\t// We could not acquire the precision we desired,\n\t// return our closest attempt.\n\treturn fromCam16({J: j, C: c, h: h}, env);\n}\n\nfunction toHct (xyz, env) {\n\t// Calculate HCT by taking the L* of CIE LCh D65 and CAM16 chroma and hue.\n\n\tconst t = toLstar(xyz[1]);\n\tif (t === 0.0) {\n\t\treturn [0.0, 0.0, 0.0];\n\t}\n\tconst cam16 = toCam16(xyz, viewingConditions);\n\treturn [constrain(cam16.h), cam16.C, t];\n}\n\n// Pre-calculate everything we can with the viewing conditions\nconst viewingConditions = environment(\n\twhite$2, 200 / Math.PI * fromLstar(50.0),\n\tfromLstar(50.0) * 100,\n\t\"average\",\n\tfalse,\n);\n\n// https://material.io/blog/science-of-color-design\n// This is not a port of the material-color-utilities,\n// but instead implements the full color space as described,\n// combining CAM16 JCh and Lab D65. This does not clamp conversion\n// to HCT to specific chroma bands and provides support for wider\n// gamuts than Google currently supports and does so at a greater\n// precision (> 8 bits back to sRGB).\n// This implementation comes from https://github.com/facelessuser/coloraide\n// which is licensed under MIT.\nvar hct = new ColorSpace({\n\tid: \"hct\",\n\tname: \"HCT\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\tc: {\n\t\t\trefRange: [0, 145],\n\t\t\tname: \"Colorfulness\",\n\t\t},\n\t\tt: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Tone\",\n\t\t},\n\t},\n\n\tbase: xyz_d65,\n\n\tfromBase (xyz) {\n\t\treturn toHct(xyz);\n\t},\n\ttoBase (hct) {\n\t\treturn fromHct(hct, viewingConditions);\n\t},\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--hct\",\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage> | <number>\", \"<percentage> | <number>\"],\n\t\t},\n\t},\n});\n\nconst deg2rad = Math.PI / 180;\nconst ucsCoeff = [1.00, 0.007, 0.0228];\n\n/**\n* Convert HCT chroma and hue (CAM16 JMh colorfulness and hue) using UCS logic for a and b.\n* @param {number[]} coords - HCT coordinates.\n* @return {number[]}\n*/\nfunction convertUcsAb (coords) {\n\t// We want the distance between the actual color.\n\t// If chroma is negative, it will throw off our calculations.\n\t// Normally, converting back to the base and forward will correct it.\n\t// If we have a negative chroma after this, then we have a color that\n\t// cannot resolve to positive chroma.\n\tif (coords[1] < 0) {\n\t\tcoords = hct.fromBase(hct.toBase(coords));\n\t}\n\n\t// Only in extreme cases (usually outside the visible spectrum)\n\t// can the input value for log become negative.\n\t// Avoid domain error by forcing a zero result via \"max\" if necessary.\n\tconst M = Math.log(Math.max(1 + ucsCoeff[2] * coords[1] * viewingConditions.flRoot, 1.0)) / ucsCoeff[2];\n\tconst hrad = coords[0] * deg2rad;\n\tconst a = M * Math.cos(hrad);\n\tconst b = M * Math.sin(hrad);\n\n\treturn [coords[2], a, b];\n}\n\n\n/**\n* Color distance using HCT.\n* @param {Color} color - Color to compare.\n* @param {Color} sample - Color to compare.\n* @return {number[]}\n*/\nfunction deltaEHCT (color, sample) {\n\t[color, sample] = getColor([color, sample]);\n\n\tlet [ t1, a1, b1 ] = convertUcsAb(hct.from(color));\n\tlet [ t2, a2, b2 ] = convertUcsAb(hct.from(sample));\n\n\t// Use simple euclidean distance with a and b using UCS conversion\n\t// and LCh lightness (HCT tone).\n\treturn Math.sqrt((t1 - t2) ** 2 + (a1 - a2) ** 2 + (b1 - b2) ** 2);\n}\n\nvar deltaEMethods = {\n\tdeltaE76,\n\tdeltaECMC,\n\tdeltaE2000,\n\tdeltaEJz,\n\tdeltaEITP,\n\tdeltaEOK,\n\tdeltaEHCT,\n};\n\n/**\n * Calculate the epsilon to 2 degrees smaller than the specified JND.\n * @param {Number} jnd - The target \"just noticeable difference\".\n * @returns {Number}\n */\nfunction calcEpsilon (jnd) {\n\t// Calculate the epsilon to 2 degrees smaller than the specified JND.\n\n\tconst order = (!jnd) ? 0 : Math.floor(Math.log10(Math.abs(jnd)));\n\t// Limit to an arbitrary value to ensure value is never too small and causes infinite loops.\n\treturn Math.max(parseFloat(`1e${order - 2}`), 1e-6);\n}\n\nconst GMAPPRESET = {\n\t\"hct\": {\n\t\tmethod: \"hct.c\",\n\t\tjnd: 2,\n\t\tdeltaEMethod: \"hct\",\n\t\tblackWhiteClamp: {},\n\t},\n\t\"hct-tonal\": {\n\t\tmethod: \"hct.c\",\n\t\tjnd: 0,\n\t\tdeltaEMethod: \"hct\",\n\t\tblackWhiteClamp: { channel: \"hct.t\", min: 0, max: 100 },\n\t},\n};\n\n/**\n * Force coordinates to be in gamut of a certain color space.\n * Mutates the color it is passed.\n * @param {Object|string} options object or spaceId string\n * @param {string} options.method - How to force into gamut.\n *        If \"clip\", coordinates are just clipped to their reference range.\n *        If \"css\", coordinates are reduced according to the CSS 4 Gamut Mapping Algorithm.\n *        If in the form [colorSpaceId].[coordName], that coordinate is reduced\n *        until the color is in gamut. Please note that this may produce nonsensical\n *        results for certain coordinates (e.g. hue) or infinite loops if reducing the coordinate never brings the color in gamut.\n * @param {ColorSpace|string} options.space - The space whose gamut we want to map to\n * @param {string} options.deltaEMethod - The delta E method to use while performing gamut mapping.\n *        If no method is specified, delta E 2000 is used.\n * @param {Number} options.jnd - The \"just noticeable difference\" to target.\n * @param {Object} options.blackWhiteClamp - Used to configure SDR black and clamping.\n *        \"channel\" indicates the \"space.channel\" to use for determining when to clamp.\n *        \"min\" indicates the lower limit for black clamping and \"max\" indicates the upper\n *        limit for white clamping.\n */\n\nfunction toGamut (\n\tcolor,\n\t{\n\t\tmethod = defaults.gamut_mapping,\n\t\tspace = undefined,\n\t\tdeltaEMethod = \"\",\n\t\tjnd = 2,\n\t\tblackWhiteClamp = {},\n\t} = {},\n) {\n\tcolor = getColor(color);\n\n\tif (isString(arguments[1])) {\n\t\tspace = arguments[1];\n\t}\n\telse if (!space) {\n\t\tspace = color.space;\n\t}\n\n\tspace = ColorSpace.get(space);\n\n\t// 3 spaces:\n\t// color.space: current color space\n\t// space: space whose gamut we are mapping to\n\t// mapSpace: space with the coord we're reducing\n\n\tif (inGamut(color, space, { epsilon: 0 })) {\n\t\treturn color;\n\t}\n\n\tlet spaceColor;\n\tif (method === \"css\") {\n\t\tspaceColor = toGamutCSS(color, { space });\n\t}\n\telse {\n\t\tif (method !== \"clip\" && !inGamut(color, space)) {\n\n\t\t\tif (Object.prototype.hasOwnProperty.call(GMAPPRESET, method)) {\n\t\t\t\t({method, jnd, deltaEMethod, blackWhiteClamp} = GMAPPRESET[method]);\n\t\t\t}\n\n\t\t\t// Get the correct delta E method\n\t\t\tlet de = deltaE2000;\n\t\t\tif (deltaEMethod !== \"\") {\n\t\t\t\tfor (let m in deltaEMethods) {\n\t\t\t\t\tif (\"deltae\" + deltaEMethod.toLowerCase() === m.toLowerCase()) {\n\t\t\t\t\t\tde = deltaEMethods[m];\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tlet clipped = toGamut(to(color, space), { method: \"clip\", space });\n\t\t\tif (de(color, clipped) > jnd) {\n\n\t\t\t\t// Clamp to SDR white and black if required\n\t\t\t\tif (Object.keys(blackWhiteClamp).length === 3) {\n\t\t\t\t\tlet channelMeta = ColorSpace.resolveCoord(blackWhiteClamp.channel);\n\t\t\t\t\tlet channel = get(to(color, channelMeta.space), channelMeta.id);\n\t\t\t\t\tif (isNone(channel)) {\n\t\t\t\t\t\tchannel = 0;\n\t\t\t\t\t}\n\t\t\t\t\tif (channel >= blackWhiteClamp.max) {\n\t\t\t\t\t\treturn to({ space: \"xyz-d65\", coords: WHITES[\"D65\"] }, color.space);\n\t\t\t\t\t}\n\t\t\t\t\telse if (channel <= blackWhiteClamp.min) {\n\t\t\t\t\t\treturn to({ space: \"xyz-d65\", coords: [0, 0, 0] }, color.space);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Reduce a coordinate of a certain color space until the color is in gamut\n\t\t\t\tlet coordMeta = ColorSpace.resolveCoord(method);\n\t\t\t\tlet mapSpace = coordMeta.space;\n\t\t\t\tlet coordId = coordMeta.id;\n\n\t\t\t\tlet mappedColor = to(color, mapSpace);\n\t\t\t\t// If we were already in the mapped color space, we need to resolve undefined channels\n\t\t\t\tmappedColor.coords.forEach((c, i) => {\n\t\t\t\t\tif (isNone(c)) {\n\t\t\t\t\t\tmappedColor.coords[i] = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\tlet bounds = coordMeta.range || coordMeta.refRange;\n\t\t\t\tlet min = bounds[0];\n\t\t\t\tlet ε = calcEpsilon(jnd);\n\t\t\t\tlet low = min;\n\t\t\t\tlet high = get(mappedColor, coordId);\n\n\t\t\t\twhile (high - low > ε) {\n\t\t\t\t\tlet clipped = clone(mappedColor);\n\t\t\t\t\tclipped = toGamut(clipped, { space, method: \"clip\" });\n\t\t\t\t\tlet deltaE = de(mappedColor, clipped);\n\n\t\t\t\t\tif (deltaE - jnd < ε) {\n\t\t\t\t\t\tlow = get(mappedColor, coordId);\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\thigh = get(mappedColor, coordId);\n\t\t\t\t\t}\n\n\t\t\t\t\tset(mappedColor, coordId, (low + high) / 2);\n\t\t\t\t}\n\n\t\t\t\tspaceColor = to(mappedColor, space);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tspaceColor = clipped;\n\t\t\t}\n\t\t}\n\t\telse {\n\t\t\tspaceColor = to(color, space);\n\t\t}\n\n\t\tif (method === \"clip\" // Dumb coord clipping\n\t\t\t// finish off smarter gamut mapping with clip to get rid of ε, see #17\n\t\t\t|| !inGamut(spaceColor, space, { epsilon: 0 })\n\t\t) {\n\t\t\tlet bounds = Object.values(space.coords).map(c => c.range || []);\n\n\t\t\tspaceColor.coords = spaceColor.coords.map((c, i) => {\n\t\t\t\tlet [min, max] = bounds[i];\n\n\t\t\t\tif (min !== undefined) {\n\t\t\t\t\tc = Math.max(min, c);\n\t\t\t\t}\n\n\t\t\t\tif (max !== undefined) {\n\t\t\t\t\tc = Math.min(c, max);\n\t\t\t\t}\n\n\t\t\t\treturn c;\n\t\t\t});\n\t\t}\n\t}\n\n\tif (space !== color.space) {\n\t\tspaceColor = to(spaceColor, color.space);\n\t}\n\n\tcolor.coords = spaceColor.coords;\n\treturn color;\n}\n\ntoGamut.returns = \"color\";\n\n// The reference colors to be used if lightness is out of the range 0-1 in the\n// `Oklch` space. These are created in the `Oklab` space, as it is used by the\n// DeltaEOK calculation, so it is guaranteed to be imported.\nconst COLORS = {\n\tWHITE: { space: OKLab, coords: [1, 0, 0] },\n\tBLACK: { space: OKLab, coords: [0, 0, 0] },\n};\n\n/**\n * Given a color `origin`, returns a new color that is in gamut using\n * the CSS Gamut Mapping Algorithm. If `space` is specified, it will be in gamut\n * in `space`, and returned in `space`. Otherwise, it will be in gamut and\n * returned in the color space of `origin`.\n * @param {Object} origin\n * @param {Object} options\n * @param {ColorSpace|string} options.space\n * @returns {Color}\n */\nfunction toGamutCSS (origin, {space} = {}) {\n\tconst JND = 0.02;\n\tconst ε = 0.0001;\n\n\torigin = getColor(origin);\n\n\tif (!space) {\n\t\tspace = origin.space;\n\t}\n\n\tspace = ColorSpace.get(space);\n\tconst oklchSpace = ColorSpace.get(\"oklch\");\n\n\tif (space.isUnbounded) {\n\t\treturn to(origin, space);\n\t}\n\n\tconst origin_OKLCH = to(origin, oklchSpace);\n\tlet L = origin_OKLCH.coords[0];\n\n\t// return media white or black, if lightness is out of range\n\tif (L >= 1) {\n\t\tconst white = to(COLORS.WHITE, space);\n\t\twhite.alpha = origin.alpha;\n\t\treturn to(white, space);\n\t}\n\tif (L <= 0) {\n\t\tconst black = to(COLORS.BLACK, space);\n\t\tblack.alpha = origin.alpha;\n\t\treturn to(black, space);\n\t}\n\n\tif (inGamut(origin_OKLCH, space, {epsilon: 0})) {\n\t\treturn to(origin_OKLCH, space);\n\t}\n\n\tfunction clip (_color) {\n\t\tconst destColor = to(_color, space);\n\t\tconst spaceCoords = Object.values(space.coords);\n\t\tdestColor.coords = destColor.coords.map((coord, index) => {\n\t\t\tif (\"range\" in spaceCoords[index]) {\n\t\t\t\tconst [min, max] =  spaceCoords[index].range;\n\t\t\t\treturn clamp(min, coord, max);\n\t\t\t}\n\t\t\treturn coord;\n\t\t});\n\t\treturn destColor;\n\t}\n\tlet min = 0;\n\tlet max = origin_OKLCH.coords[1];\n\tlet min_inGamut = true;\n\tlet current = clone(origin_OKLCH);\n\tlet clipped = clip(current);\n\n\tlet E = deltaEOK(clipped, current);\n\tif (E < JND) {\n\t\treturn clipped;\n\t}\n\n\twhile ((max - min) > ε) {\n\t\tconst chroma = (min + max) / 2;\n\t\tcurrent.coords[1] = chroma;\n\t\tif (min_inGamut && inGamut(current, space, {epsilon: 0})) {\n\t\t\tmin = chroma;\n\t\t}\n\t\telse {\n\t\t\tclipped = clip(current);\n\t\t\tE = deltaEOK(clipped, current);\n\t\t\tif (E < JND) {\n\t\t\t\tif ((JND - E < ε)) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tmin_inGamut = false;\n\t\t\t\t\tmin = chroma;\n\t\t\t\t}\n\t\t\t}\n\t\t\telse {\n\t\t\t\tmax = chroma;\n\t\t\t}\n\t\t}\n\t}\n\treturn clipped;\n}\n\n/**\n * Convert to color space and return a new color\n * @param {Object|string} space - Color space object or id\n * @param {Object} options\n * @param {boolean} options.inGamut - Whether to force resulting color in gamut\n * @returns {Color}\n */\nfunction to (color, space, {inGamut} = {}) {\n\tcolor = getColor(color);\n\tspace = ColorSpace.get(space);\n\n\tlet coords = space.from(color);\n\tlet ret = {space, coords, alpha: color.alpha};\n\n\tif (inGamut) {\n\t\tret = toGamut(ret, inGamut === true ? undefined : inGamut);\n\t}\n\n\treturn ret;\n}\n\nto.returns = \"color\";\n\n/**\n * Generic toString() method, outputs a color(spaceId ...coords) function, a functional syntax, or custom formats defined by the color space\n * @param {Object} options\n * @param {number} options.precision - Significant digits\n * @param {boolean} options.inGamut - Adjust coordinates to fit in gamut first? [default: false]\n */\nfunction serialize (color, {\n\tprecision = defaults.precision,\n\tformat = \"default\",\n\tinGamut: inGamut$1 = true,\n\t...customOptions\n} = {}) {\n\tlet ret;\n\n\tcolor = getColor(color);\n\n\tlet formatId = format;\n\tformat = color.space.getFormat(format)\n\t       ?? color.space.getFormat(\"default\")\n\t       ?? ColorSpace.DEFAULT_FORMAT;\n\n\t// The assignment to coords and inGamut needs to stay in the order they are now\n\t// The order of the assignment was changed as a workaround for a bug in Next.js\n\t// See this issue for details: https://github.com/color-js/color.js/issues/260\n\n\tlet coords = color.coords.slice(); // clone so we can manipulate it\n\n\tinGamut$1 ||= format.toGamut;\n\n\tif (inGamut$1 && !inGamut(color)) {\n\t\t// FIXME what happens if the color contains NaNs?\n\t\tcoords = toGamut(clone(color), inGamut$1 === true ? undefined : inGamut$1).coords;\n\t}\n\n\tif (format.type === \"custom\") {\n\t\tcustomOptions.precision = precision;\n\n\t\tif (format.serialize) {\n\t\t\tret = format.serialize(coords, color.alpha, customOptions);\n\t\t}\n\t\telse {\n\t\t\tthrow new TypeError(`format ${formatId} can only be used to parse colors, not for serialization`);\n\t\t}\n\t}\n\telse {\n\t\t// Functional syntax\n\t\tlet name = format.name || \"color\";\n\n\t\tif (format.serializeCoords) {\n\t\t\tcoords = format.serializeCoords(coords, precision);\n\t\t}\n\t\telse {\n\t\t\tif (precision !== null) {\n\t\t\t\tcoords = coords.map(c => {\n\t\t\t\t\treturn serializeNumber(c, {precision});\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\n\t\tlet args = [...coords];\n\n\t\tif (name === \"color\") {\n\t\t\t// If output is a color() function, add colorspace id as first argument\n\t\t\tlet cssId = format.id || format.ids?.[0] || color.space.id;\n\t\t\targs.unshift(cssId);\n\t\t}\n\n\t\tlet alpha = color.alpha;\n\t\tif (precision !== null) {\n\t\t\talpha = serializeNumber(alpha, {precision});\n\t\t}\n\n\t\tlet strAlpha = color.alpha >= 1 || format.noAlpha ? \"\" : `${format.commas ? \",\" : \" /\"} ${alpha}`;\n\t\tret = `${name}(${args.join(format.commas ? \", \" : \" \")}${strAlpha})`;\n\t}\n\n\treturn ret;\n}\n\n// convert an array of linear-light rec2020 values to CIE XYZ\n// using  D65 (no chromatic adaptation)\n// http://www.brucelindbloom.com/index.html?Eqn_RGB_XYZ_Matrix.html\n// 0 is actually calculated as  4.994106574466076e-17\nconst toXYZ_M$5 = [\n\t[ 0.6369580483012914, 0.14461690358620832,  0.1688809751641721  ],\n\t[ 0.2627002120112671, 0.6779980715188708,   0.05930171646986196 ],\n\t[ 0.000000000000000,  0.028072693049087428, 1.060985057710791   ],\n];\n\n// from ITU-R BT.2124-0 Annex 2 p.3\nconst fromXYZ_M$5 = [\n\t[  1.716651187971268,  -0.355670783776392, -0.253366281373660  ],\n\t[ -0.666684351832489,   1.616481236634939,  0.0157685458139111 ],\n\t[  0.017639857445311,  -0.042770613257809,  0.942103121235474  ],\n];\n\nvar REC2020Linear = new RGBColorSpace({\n\tid: \"rec2020-linear\",\n\tcssId: \"--rec2020-linear\",\n\tname: \"Linear REC.2020\",\n\twhite: \"D65\",\n\ttoXYZ_M: toXYZ_M$5,\n\tfromXYZ_M: fromXYZ_M$5,\n});\n\n// import sRGB from \"./srgb.js\";\n\nconst α = 1.09929682680944;\nconst β = 0.018053968510807;\n\nvar REC2020 = new RGBColorSpace({\n\tid: \"rec2020\",\n\tname: \"REC.2020\",\n\tbase: REC2020Linear,\n\t// Non-linear transfer function from Rec. ITU-R BT.2020-2 table 4\n\ttoBase (RGB) {\n\t\treturn RGB.map(function (val) {\n\t\t\tif (val < β * 4.5) {\n\t\t\t\treturn val / 4.5;\n\t\t\t}\n\n\t\t\treturn Math.pow((val + α - 1) / α, 1 / 0.45);\n\t\t});\n\t},\n\tfromBase (RGB) {\n\t\treturn RGB.map(function (val) {\n\t\t\tif (val >= β) {\n\t\t\t\treturn α * Math.pow(val, 0.45) - (α - 1);\n\t\t\t}\n\n\t\t\treturn 4.5 * val;\n\t\t});\n\t},\n});\n\nconst toXYZ_M$4 = [\n\t[0.4865709486482162, 0.26566769316909306, 0.1982172852343625],\n\t[0.2289745640697488, 0.6917385218365064,  0.079286914093745],\n\t[0.0000000000000000, 0.04511338185890264, 1.043944368900976],\n];\n\nconst fromXYZ_M$4 = [\n\t[ 2.493496911941425,   -0.9313836179191239, -0.40271078445071684],\n\t[-0.8294889695615747,   1.7626640603183463,  0.023624685841943577],\n\t[ 0.03584583024378447, -0.07617238926804182, 0.9568845240076872],\n];\n\nvar P3Linear = new RGBColorSpace({\n\tid: \"p3-linear\",\n\tcssId: \"--display-p3-linear\",\n\tname: \"Linear P3\",\n\twhite: \"D65\",\n\ttoXYZ_M: toXYZ_M$4,\n\tfromXYZ_M: fromXYZ_M$4,\n});\n\n// This is the linear-light version of sRGB\n// as used for example in SVG filters\n// or in Canvas\n\n// This matrix was calculated directly from the RGB and white chromaticities\n// when rounded to 8 decimal places, it agrees completely with the official matrix\n// see https://github.com/w3c/csswg-drafts/issues/5922\nconst toXYZ_M$3 = [\n\t[ 0.41239079926595934, 0.357584339383878,   0.1804807884018343  ],\n\t[ 0.21263900587151027, 0.715168678767756,   0.07219231536073371 ],\n\t[ 0.01933081871559182, 0.11919477979462598, 0.9505321522496607  ],\n];\n\n// This matrix is the inverse of the above;\n// again it agrees with the official definition when rounded to 8 decimal places\nconst fromXYZ_M$3 = [\n\t[  3.2409699419045226,  -1.537383177570094,   -0.4986107602930034  ],\n\t[ -0.9692436362808796,   1.8759675015077202,   0.04155505740717559 ],\n\t[  0.05563007969699366, -0.20397695888897652,  1.0569715142428786  ],\n];\n\nvar sRGBLinear = new RGBColorSpace({\n\tid: \"srgb-linear\",\n\tname: \"Linear sRGB\",\n\twhite: \"D65\",\n\ttoXYZ_M: toXYZ_M$3,\n\tfromXYZ_M: fromXYZ_M$3,\n});\n\n/* List of CSS color keywords\n * Note that this does not include currentColor, transparent,\n * or system colors\n */\n\n// To produce: Visit https://www.w3.org/TR/css-color-4/#named-colors\n// and run in the console:\n// copy($$(\"tr\", $(\".named-color-table tbody\")).map(tr => `\"${tr.cells[2].textContent.trim()}\": [${tr.cells[4].textContent.trim().split(/\\s+/).map(c => c === \"0\"? \"0\" : c === \"255\"? \"1\" : c + \" / 255\").join(\", \")}]`).join(\",\\n\"))\nvar KEYWORDS = {\n\t\"aliceblue\": [240 / 255, 248 / 255, 1],\n\t\"antiquewhite\": [250 / 255, 235 / 255, 215 / 255],\n\t\"aqua\": [0, 1, 1],\n\t\"aquamarine\": [127 / 255, 1, 212 / 255],\n\t\"azure\": [240 / 255, 1, 1],\n\t\"beige\": [245 / 255, 245 / 255, 220 / 255],\n\t\"bisque\": [1, 228 / 255, 196 / 255],\n\t\"black\": [0, 0, 0],\n\t\"blanchedalmond\": [1, 235 / 255, 205 / 255],\n\t\"blue\": [0, 0, 1],\n\t\"blueviolet\": [138 / 255, 43 / 255, 226 / 255],\n\t\"brown\": [165 / 255, 42 / 255, 42 / 255],\n\t\"burlywood\": [222 / 255, 184 / 255, 135 / 255],\n\t\"cadetblue\": [95 / 255, 158 / 255, 160 / 255],\n\t\"chartreuse\": [127 / 255, 1, 0],\n\t\"chocolate\": [210 / 255, 105 / 255, 30 / 255],\n\t\"coral\": [1, 127 / 255, 80 / 255],\n\t\"cornflowerblue\": [100 / 255, 149 / 255, 237 / 255],\n\t\"cornsilk\": [1, 248 / 255, 220 / 255],\n\t\"crimson\": [220 / 255, 20 / 255, 60 / 255],\n\t\"cyan\": [0, 1, 1],\n\t\"darkblue\": [0, 0, 139 / 255],\n\t\"darkcyan\": [0, 139 / 255, 139 / 255],\n\t\"darkgoldenrod\": [184 / 255, 134 / 255, 11 / 255],\n\t\"darkgray\": [169 / 255, 169 / 255, 169 / 255],\n\t\"darkgreen\": [0, 100 / 255, 0],\n\t\"darkgrey\": [169 / 255, 169 / 255, 169 / 255],\n\t\"darkkhaki\": [189 / 255, 183 / 255, 107 / 255],\n\t\"darkmagenta\": [139 / 255, 0, 139 / 255],\n\t\"darkolivegreen\": [85 / 255, 107 / 255, 47 / 255],\n\t\"darkorange\": [1, 140 / 255, 0],\n\t\"darkorchid\": [153 / 255, 50 / 255, 204 / 255],\n\t\"darkred\": [139 / 255, 0, 0],\n\t\"darksalmon\": [233 / 255, 150 / 255, 122 / 255],\n\t\"darkseagreen\": [143 / 255, 188 / 255, 143 / 255],\n\t\"darkslateblue\": [72 / 255, 61 / 255, 139 / 255],\n\t\"darkslategray\": [47 / 255, 79 / 255, 79 / 255],\n\t\"darkslategrey\": [47 / 255, 79 / 255, 79 / 255],\n\t\"darkturquoise\": [0, 206 / 255, 209 / 255],\n\t\"darkviolet\": [148 / 255, 0, 211 / 255],\n\t\"deeppink\": [1, 20 / 255, 147 / 255],\n\t\"deepskyblue\": [0, 191 / 255, 1],\n\t\"dimgray\": [105 / 255, 105 / 255, 105 / 255],\n\t\"dimgrey\": [105 / 255, 105 / 255, 105 / 255],\n\t\"dodgerblue\": [30 / 255, 144 / 255, 1],\n\t\"firebrick\": [178 / 255, 34 / 255, 34 / 255],\n\t\"floralwhite\": [1, 250 / 255, 240 / 255],\n\t\"forestgreen\": [34 / 255, 139 / 255, 34 / 255],\n\t\"fuchsia\": [1, 0, 1],\n\t\"gainsboro\": [220 / 255, 220 / 255, 220 / 255],\n\t\"ghostwhite\": [248 / 255, 248 / 255, 1],\n\t\"gold\": [1, 215 / 255, 0],\n\t\"goldenrod\": [218 / 255, 165 / 255, 32 / 255],\n\t\"gray\": [128 / 255, 128 / 255, 128 / 255],\n\t\"green\": [0, 128 / 255, 0],\n\t\"greenyellow\": [173 / 255, 1, 47 / 255],\n\t\"grey\": [128 / 255, 128 / 255, 128 / 255],\n\t\"honeydew\": [240 / 255, 1, 240 / 255],\n\t\"hotpink\": [1, 105 / 255, 180 / 255],\n\t\"indianred\": [205 / 255, 92 / 255, 92 / 255],\n\t\"indigo\": [75 / 255, 0, 130 / 255],\n\t\"ivory\": [1, 1, 240 / 255],\n\t\"khaki\": [240 / 255, 230 / 255, 140 / 255],\n\t\"lavender\": [230 / 255, 230 / 255, 250 / 255],\n\t\"lavenderblush\": [1, 240 / 255, 245 / 255],\n\t\"lawngreen\": [124 / 255, 252 / 255, 0],\n\t\"lemonchiffon\": [1, 250 / 255, 205 / 255],\n\t\"lightblue\": [173 / 255, 216 / 255, 230 / 255],\n\t\"lightcoral\": [240 / 255, 128 / 255, 128 / 255],\n\t\"lightcyan\": [224 / 255, 1, 1],\n\t\"lightgoldenrodyellow\": [250 / 255, 250 / 255, 210 / 255],\n\t\"lightgray\": [211 / 255, 211 / 255, 211 / 255],\n\t\"lightgreen\": [144 / 255, 238 / 255, 144 / 255],\n\t\"lightgrey\": [211 / 255, 211 / 255, 211 / 255],\n\t\"lightpink\": [1, 182 / 255, 193 / 255],\n\t\"lightsalmon\": [1, 160 / 255, 122 / 255],\n\t\"lightseagreen\": [32 / 255, 178 / 255, 170 / 255],\n\t\"lightskyblue\": [135 / 255, 206 / 255, 250 / 255],\n\t\"lightslategray\": [119 / 255, 136 / 255, 153 / 255],\n\t\"lightslategrey\": [119 / 255, 136 / 255, 153 / 255],\n\t\"lightsteelblue\": [176 / 255, 196 / 255, 222 / 255],\n\t\"lightyellow\": [1, 1, 224 / 255],\n\t\"lime\": [0, 1, 0],\n\t\"limegreen\": [50 / 255, 205 / 255, 50 / 255],\n\t\"linen\": [250 / 255, 240 / 255, 230 / 255],\n\t\"magenta\": [1, 0, 1],\n\t\"maroon\": [128 / 255, 0, 0],\n\t\"mediumaquamarine\": [102 / 255, 205 / 255, 170 / 255],\n\t\"mediumblue\": [0, 0, 205 / 255],\n\t\"mediumorchid\": [186 / 255, 85 / 255, 211 / 255],\n\t\"mediumpurple\": [147 / 255, 112 / 255, 219 / 255],\n\t\"mediumseagreen\": [60 / 255, 179 / 255, 113 / 255],\n\t\"mediumslateblue\": [123 / 255, 104 / 255, 238 / 255],\n\t\"mediumspringgreen\": [0, 250 / 255, 154 / 255],\n\t\"mediumturquoise\": [72 / 255, 209 / 255, 204 / 255],\n\t\"mediumvioletred\": [199 / 255, 21 / 255, 133 / 255],\n\t\"midnightblue\": [25 / 255, 25 / 255, 112 / 255],\n\t\"mintcream\": [245 / 255, 1, 250 / 255],\n\t\"mistyrose\": [1, 228 / 255, 225 / 255],\n\t\"moccasin\": [1, 228 / 255, 181 / 255],\n\t\"navajowhite\": [1, 222 / 255, 173 / 255],\n\t\"navy\": [0, 0, 128 / 255],\n\t\"oldlace\": [253 / 255, 245 / 255, 230 / 255],\n\t\"olive\": [128 / 255, 128 / 255, 0],\n\t\"olivedrab\": [107 / 255, 142 / 255, 35 / 255],\n\t\"orange\": [1, 165 / 255, 0],\n\t\"orangered\": [1, 69 / 255, 0],\n\t\"orchid\": [218 / 255, 112 / 255, 214 / 255],\n\t\"palegoldenrod\": [238 / 255, 232 / 255, 170 / 255],\n\t\"palegreen\": [152 / 255, 251 / 255, 152 / 255],\n\t\"paleturquoise\": [175 / 255, 238 / 255, 238 / 255],\n\t\"palevioletred\": [219 / 255, 112 / 255, 147 / 255],\n\t\"papayawhip\": [1, 239 / 255, 213 / 255],\n\t\"peachpuff\": [1, 218 / 255, 185 / 255],\n\t\"peru\": [205 / 255, 133 / 255, 63 / 255],\n\t\"pink\": [1, 192 / 255, 203 / 255],\n\t\"plum\": [221 / 255, 160 / 255, 221 / 255],\n\t\"powderblue\": [176 / 255, 224 / 255, 230 / 255],\n\t\"purple\": [128 / 255, 0, 128 / 255],\n\t\"rebeccapurple\": [102 / 255, 51 / 255, 153 / 255],\n\t\"red\": [1, 0, 0],\n\t\"rosybrown\": [188 / 255, 143 / 255, 143 / 255],\n\t\"royalblue\": [65 / 255, 105 / 255, 225 / 255],\n\t\"saddlebrown\": [139 / 255, 69 / 255, 19 / 255],\n\t\"salmon\": [250 / 255, 128 / 255, 114 / 255],\n\t\"sandybrown\": [244 / 255, 164 / 255, 96 / 255],\n\t\"seagreen\": [46 / 255, 139 / 255, 87 / 255],\n\t\"seashell\": [1, 245 / 255, 238 / 255],\n\t\"sienna\": [160 / 255, 82 / 255, 45 / 255],\n\t\"silver\": [192 / 255, 192 / 255, 192 / 255],\n\t\"skyblue\": [135 / 255, 206 / 255, 235 / 255],\n\t\"slateblue\": [106 / 255, 90 / 255, 205 / 255],\n\t\"slategray\": [112 / 255, 128 / 255, 144 / 255],\n\t\"slategrey\": [112 / 255, 128 / 255, 144 / 255],\n\t\"snow\": [1, 250 / 255, 250 / 255],\n\t\"springgreen\": [0, 1, 127 / 255],\n\t\"steelblue\": [70 / 255, 130 / 255, 180 / 255],\n\t\"tan\": [210 / 255, 180 / 255, 140 / 255],\n\t\"teal\": [0, 128 / 255, 128 / 255],\n\t\"thistle\": [216 / 255, 191 / 255, 216 / 255],\n\t\"tomato\": [1, 99 / 255, 71 / 255],\n\t\"turquoise\": [64 / 255, 224 / 255, 208 / 255],\n\t\"violet\": [238 / 255, 130 / 255, 238 / 255],\n\t\"wheat\": [245 / 255, 222 / 255, 179 / 255],\n\t\"white\": [1, 1, 1],\n\t\"whitesmoke\": [245 / 255, 245 / 255, 245 / 255],\n\t\"yellow\": [1, 1, 0],\n\t\"yellowgreen\": [154 / 255, 205 / 255, 50 / 255],\n};\n\nlet coordGrammar = Array(3).fill(\"<percentage> | <number>[0, 255]\");\nlet coordGrammarNumber = Array(3).fill(\"<number>[0, 255]\");\n\nvar sRGB = new RGBColorSpace({\n\tid: \"srgb\",\n\tname: \"sRGB\",\n\tbase: sRGBLinear,\n\tfromBase: rgb => {\n\t\t// convert an array of linear-light sRGB values in the range 0.0-1.0\n\t\t// to gamma corrected form\n\t\t// https://en.wikipedia.org/wiki/SRGB\n\t\treturn rgb.map(val => {\n\t\t\tlet sign = val < 0 ? -1 : 1;\n\t\t\tlet abs = val * sign;\n\n\t\t\tif (abs > 0.0031308) {\n\t\t\t\treturn sign * (1.055 * (abs ** (1 / 2.4)) - 0.055);\n\t\t\t}\n\n\t\t\treturn 12.92 * val;\n\t\t});\n\t},\n\ttoBase: rgb => {\n\t\t// convert an array of sRGB values in the range 0.0 - 1.0\n\t\t// to linear light (un-companded) form.\n\t\t// https://en.wikipedia.org/wiki/SRGB\n\t\treturn rgb.map(val => {\n\t\t\tlet sign = val < 0 ? -1 : 1;\n\t\t\tlet abs = val * sign;\n\n\t\t\tif (abs <= 0.04045) {\n\t\t\t\treturn val / 12.92;\n\t\t\t}\n\n\t\t\treturn sign * (((abs + 0.055) / 1.055) ** 2.4);\n\t\t});\n\t},\n\tformats: {\n\t\t\"rgb\": {\n\t\t\tcoords: coordGrammar,\n\t\t},\n\t\t\"rgb_number\": {\n\t\t\tname: \"rgb\",\n\t\t\tcommas: true,\n\t\t\tcoords: coordGrammarNumber,\n\t\t\tnoAlpha: true,\n\t\t},\n\t\t\"color\": { /* use defaults */ },\n\t\t\"rgba\": {\n\t\t\tcoords: coordGrammar,\n\t\t\tcommas: true,\n\t\t\tlastAlpha: true,\n\t\t},\n\t\t\"rgba_number\": {\n\t\t\tname: \"rgba\",\n\t\t\tcommas: true,\n\t\t\tcoords: coordGrammarNumber,\n\t\t},\n\t\t\"hex\": {\n\t\t\ttype: \"custom\",\n\t\t\ttoGamut: true,\n\t\t\ttest: str => /^#([a-f0-9]{3,4}){1,2}$/i.test(str),\n\t\t\tparse (str) {\n\t\t\t\tif (str.length <= 5) {\n\t\t\t\t\t// #rgb or #rgba, duplicate digits\n\t\t\t\t\tstr = str.replace(/[a-f0-9]/gi, \"$&$&\");\n\t\t\t\t}\n\n\t\t\t\tlet rgba = [];\n\t\t\t\tstr.replace(/[a-f0-9]{2}/gi, component => {\n\t\t\t\t\trgba.push(parseInt(component, 16) / 255);\n\t\t\t\t});\n\n\t\t\t\treturn {\n\t\t\t\t\tspaceId: \"srgb\",\n\t\t\t\t\tcoords: rgba.slice(0, 3),\n\t\t\t\t\talpha: rgba.slice(3)[0],\n\t\t\t\t};\n\t\t\t},\n\t\t\tserialize: (coords, alpha, {\n\t\t\t\tcollapse = true, // collapse to 3-4 digit hex when possible?\n\t\t\t} = {}) => {\n\t\t\t\tif (alpha < 1) {\n\t\t\t\t\tcoords.push(alpha);\n\t\t\t\t}\n\n\t\t\t\tcoords = coords.map(c => Math.round(c * 255));\n\n\t\t\t\tlet collapsible = collapse && coords.every(c => c % 17 === 0);\n\n\t\t\t\tlet hex = coords.map(c => {\n\t\t\t\t\tif (collapsible) {\n\t\t\t\t\t\treturn (c / 17).toString(16);\n\t\t\t\t\t}\n\n\t\t\t\t\treturn c.toString(16).padStart(2, \"0\");\n\t\t\t\t}).join(\"\");\n\n\t\t\t\treturn \"#\" + hex;\n\t\t\t},\n\t\t},\n\t\t\"keyword\": {\n\t\t\ttype: \"custom\",\n\t\t\ttest: str => /^[a-z]+$/i.test(str),\n\t\t\tparse (str) {\n\t\t\t\tstr = str.toLowerCase();\n\t\t\t\tlet ret = {spaceId: \"srgb\", coords: null, alpha: 1};\n\n\t\t\t\tif (str === \"transparent\") {\n\t\t\t\t\tret.coords = KEYWORDS.black;\n\t\t\t\t\tret.alpha = 0;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tret.coords = KEYWORDS[str];\n\t\t\t\t}\n\n\t\t\t\tif (ret.coords) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\t\t\t},\n\t\t},\n\t},\n});\n\nvar P3 = new RGBColorSpace({\n\tid: \"p3\",\n\tcssId: \"display-p3\",\n\tname: \"P3\",\n\tbase: P3Linear,\n\t// Gamma encoding/decoding is the same as sRGB\n\tfromBase: sRGB.fromBase,\n\ttoBase: sRGB.toBase,\n});\n\n// Default space for CSS output. Code in Color.js makes this wider if there's a DOM available\ndefaults.display_space = sRGB;\n\nlet supportsNone;\n\nif (typeof CSS !== \"undefined\" && CSS.supports) {\n\t// Find widest supported color space for CSS\n\tfor (let space of [lab, REC2020, P3]) {\n\t\tlet coords = space.getMinCoords();\n\t\tlet color = {space, coords, alpha: 1};\n\t\tlet str = serialize(color);\n\n\t\tif (CSS.supports(\"color\", str)) {\n\t\t\tdefaults.display_space = space;\n\t\t\tbreak;\n\t\t}\n\t}\n}\n\n/**\n * Returns a serialization of the color that can actually be displayed in the browser.\n * If the default serialization can be displayed, it is returned.\n * Otherwise, the color is converted to Lab, REC2020, or P3, whichever is the widest supported.\n * In Node.js, this is basically equivalent to `serialize()` but returns a `String` object instead.\n *\n * @export\n * @param {{space, coords} | Color | string} color\n * @param {*} [options={}] Options to be passed to serialize()\n * @param {ColorSpace | string} [options.space = defaults.display_space] Color space to use for serialization if default is not supported\n * @returns {String} String object containing the serialized color with a color property containing the converted color (or the original, if no conversion was necessary)\n */\nfunction display (color, {space = defaults.display_space, ...options} = {}) {\n\tlet ret = serialize(color, options);\n\n\tif (typeof CSS === \"undefined\" || CSS.supports(\"color\", ret) || !defaults.display_space) {\n\t\tret = new String(ret);\n\t\tret.color = color;\n\t}\n\telse {\n\t\t// If we're here, what we were about to output is not supported\n\t\tlet fallbackColor = color;\n\n\t\t// First, check if the culprit is none values\n\t\tlet hasNone = color.coords.some(isNone) || isNone(color.alpha);\n\n\t\tif (hasNone) {\n\t\t\t// Does the browser support none values?\n\t\t\tif (!(supportsNone ??= CSS.supports(\"color\", \"hsl(none 50% 50%)\"))) {\n\t\t\t\t// Nope, try again without none\n\t\t\t\tfallbackColor = clone(color);\n\t\t\t\tfallbackColor.coords = fallbackColor.coords.map(skipNone);\n\t\t\t\tfallbackColor.alpha = skipNone(fallbackColor.alpha);\n\n\t\t\t\tret = serialize(fallbackColor, options);\n\n\t\t\t\tif (CSS.supports(\"color\", ret)) {\n\t\t\t\t\t// We're done, now it's supported\n\t\t\t\t\tret = new String(ret);\n\t\t\t\t\tret.color = fallbackColor;\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// If we're here, the color function is not supported\n\t\t// Fall back to fallback space\n\t\tfallbackColor = to(fallbackColor, space);\n\t\tret = new String(serialize(fallbackColor, options));\n\t\tret.color = fallbackColor;\n\t}\n\n\treturn ret;\n}\n\nfunction equals (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\treturn color1.space === color2.space\n\t       && color1.alpha === color2.alpha\n\t       && color1.coords.every((c, i) => c === color2.coords[i]);\n}\n\n/**\n * Relative luminance\n */\n\nfunction getLuminance (color) {\n\t// Assume getColor() is called on color in get()\n\treturn get(color, [xyz_d65, \"y\"]);\n}\n\nfunction setLuminance (color, value) {\n\t// Assume getColor() is called on color in set()\n\tset(color, [xyz_d65, \"y\"], value);\n}\n\nfunction register$2 (Color) {\n\tObject.defineProperty(Color.prototype, \"luminance\", {\n\t\tget () {\n\t\t\treturn getLuminance(this);\n\t\t},\n\t\tset (value) {\n\t\t\tsetLuminance(this, value);\n\t\t},\n\t});\n}\n\nvar luminance = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tgetLuminance: getLuminance,\n\tregister: register$2,\n\tsetLuminance: setLuminance\n});\n\n// WCAG 2.0 contrast https://www.w3.org/TR/WCAG20-TECHS/G18.html\n// Simple contrast, with fixed 5% viewing flare contribution\n// Symmetric, does not matter which is foreground and which is background\n\n\nfunction contrastWCAG21 (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\tlet Y1 = Math.max(getLuminance(color1), 0);\n\tlet Y2 = Math.max(getLuminance(color2), 0);\n\n\tif (Y2 > Y1) {\n\t\t[Y1, Y2] = [Y2, Y1];\n\t}\n\n\treturn (Y1 + .05) / (Y2 + .05);\n}\n\n// APCA 0.0.98G\n// https://github.com/Myndex/apca-w3\n// see also https://github.com/w3c/silver/issues/643\n\n\n// exponents\nconst normBG = 0.56;\nconst normTXT = 0.57;\nconst revTXT = 0.62;\nconst revBG = 0.65;\n\n// clamps\nconst blkThrs = 0.022;\nconst blkClmp = 1.414;\nconst loClip = 0.1;\nconst deltaYmin = 0.0005;\n\n// scalers\n// see https://github.com/w3c/silver/issues/645\nconst scaleBoW = 1.14;\nconst loBoWoffset = 0.027;\nconst scaleWoB = 1.14;\n\nfunction fclamp (Y) {\n\tif (Y >= blkThrs) {\n\t\treturn Y;\n\t}\n\treturn Y + (blkThrs - Y) ** blkClmp;\n}\n\nfunction linearize (val) {\n\tlet sign = val < 0 ? -1 : 1;\n\tlet abs = Math.abs(val);\n\treturn sign * Math.pow(abs, 2.4);\n}\n\n// Not symmetric, requires a foreground (text) color, and a background color\nfunction contrastAPCA (background, foreground) {\n\tforeground = getColor(foreground);\n\tbackground = getColor(background);\n\n\tlet S;\n\tlet C;\n\tlet Sapc;\n\n\t// Myndex as-published, assumes sRGB inputs\n\tlet R, G, B;\n\n\tforeground = to(foreground, \"srgb\");\n\t// Should these be clamped to in-gamut values?\n\n\t// Calculates \"screen luminance\" with non-standard simple gamma EOTF\n\t// weights should be from CSS Color 4, not the ones here which are via Myndex and copied from Lindbloom\n\t[R, G, B] = foreground.coords;\n\tlet lumTxt = linearize(R) * 0.2126729 + linearize(G) * 0.7151522 + linearize(B) * 0.0721750;\n\n\tbackground = to(background, \"srgb\");\n\t[R, G, B] = background.coords;\n\tlet lumBg = linearize(R) * 0.2126729 + linearize(G) * 0.7151522 + linearize(B) * 0.0721750;\n\n\t// toe clamping of very dark values to account for flare\n\tlet Ytxt = fclamp(lumTxt);\n\tlet Ybg = fclamp(lumBg);\n\n\t// are we \"Black on White\" (dark on light), or light on dark?\n\tlet BoW = Ybg > Ytxt;\n\n\t// why is this a delta, when Y is not perceptually uniform?\n\t// Answer: it is a noise gate, see\n\t// https://github.com/LeaVerou/color.js/issues/208\n\tif (Math.abs(Ybg - Ytxt) < deltaYmin) {\n\t\tC = 0;\n\t}\n\telse {\n\t\tif (BoW) {\n\t\t\t// dark text on light background\n\t\t\tS = Ybg ** normBG - Ytxt ** normTXT;\n\t\t\tC = S * scaleBoW;\n\t\t}\n\t\telse {\n\t\t\t// light text on dark background\n\t\t\tS = Ybg ** revBG - Ytxt ** revTXT;\n\t\t\tC = S * scaleWoB;\n\t\t}\n\t}\n\tif (Math.abs(C) < loClip) {\n\t\tSapc = 0;\n\t}\n\telse if (C > 0) {\n\t\t// not clear whether Woffset is loBoWoffset or loWoBoffset\n\t\t// but they have the same value\n\t\tSapc = C - loBoWoffset;\n\t}\n\telse {\n\t\tSapc = C + loBoWoffset;\n\t}\n\n\treturn Sapc * 100;\n}\n\n// Michelson  luminance contrast\n// the relation between the spread and the sum of the two luminances\n// Symmetric, does not matter which is foreground and which is background\n// No black level compensation for flare.\n\n\nfunction contrastMichelson (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\tlet Y1 = Math.max(getLuminance(color1), 0);\n\tlet Y2 = Math.max(getLuminance(color2), 0);\n\n\tif (Y2 > Y1) {\n\t\t[Y1, Y2] = [Y2, Y1];\n\t}\n\n\tlet denom = (Y1 + Y2);\n\treturn denom === 0 ? 0 : (Y1 - Y2) / denom;\n}\n\n// Weber luminance contrast\n// The difference between the two luminances divided by the lower luminance\n// Symmetric, does not matter which is foreground and which is background\n// No black level compensation for flare.\n\n\n// the darkest sRGB color above black is #000001 and this produces\n// a plain Weber contrast of ~45647.\n// So, setting the divide-by-zero result at 50000 is a reasonable\n// max clamp for the plain Weber\nconst max = 50000;\n\nfunction contrastWeber (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\tlet Y1 = Math.max(getLuminance(color1), 0);\n\tlet Y2 = Math.max(getLuminance(color2), 0);\n\n\tif (Y2 > Y1) {\n\t\t[Y1, Y2] = [Y2, Y1];\n\t}\n\n\treturn Y2 === 0 ? max : (Y1 - Y2) / Y2;\n}\n\n// CIE Lightness difference, as used by Google Material Design\n// Google HCT Tone is the same as CIE Lightness\n// https://material.io/blog/science-of-color-design\n\n\nfunction contrastLstar (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\tlet L1 = get(color1, [lab, \"l\"]);\n\tlet L2 = get(color2, [lab, \"l\"]);\n\n\treturn Math.abs(L1 - L2);\n}\n\n// κ * ε  = 2^3 = 8\nconst ε$3 = 216 / 24389;  // 6^3/29^3 == (24/116)^3\nconst ε3 = 24 / 116;\nconst κ$2 = 24389 / 27;   // 29^3/3^3\n\nlet white$1 = WHITES.D65;\n\nvar lab_d65 = new ColorSpace({\n\tid: \"lab-d65\",\n\tname: \"Lab D65\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\ta: {\n\t\t\trefRange: [-125, 125],\n\t\t},\n\t\tb: {\n\t\t\trefRange: [-125, 125],\n\t\t},\n\t},\n\n\t// Assuming XYZ is relative to D65, convert to CIE Lab\n\t// from CIE standard, which now defines these as a rational fraction\n\twhite: white$1,\n\n\tbase: xyz_d65,\n\t// Convert D65-adapted XYZ to Lab\n\t//  CIE 15.3:2004 section 8.2.1.1\n\tfromBase (XYZ) {\n\t\t// compute xyz, which is XYZ scaled relative to reference white\n\t\tlet xyz = XYZ.map((value, i) => value / white$1[i]);\n\n\t\t// now compute f\n\t\tlet f = xyz.map(value => value > ε$3 ? Math.cbrt(value) : (κ$2 * value + 16) / 116);\n\n\t\treturn [\n\t\t\t(116 * f[1]) - 16,   // L\n\t\t\t500 * (f[0] - f[1]), // a\n\t\t\t200 * (f[1] - f[2]),  // b\n\t\t];\n\t},\n\t// Convert Lab to D65-adapted XYZ\n\t// Same result as CIE 15.3:2004 Appendix D although the derivation is different\n\t// http://www.brucelindbloom.com/index.html?Eqn_RGB_XYZ_Matrix.html\n\ttoBase (Lab) {\n\t\t// compute f, starting with the luminance-related term\n\t\tlet f = [];\n\t\tf[1] = (Lab[0] + 16) / 116;\n\t\tf[0] = Lab[1] / 500 + f[1];\n\t\tf[2] = f[1] - Lab[2] / 200;\n\n\t\t// compute xyz\n\t\tlet xyz = [\n\t\t\tf[0]   > ε3 ? Math.pow(f[0], 3)                : (116 * f[0] - 16) / κ$2,\n\t\t\tLab[0] > 8  ? Math.pow((Lab[0] + 16) / 116, 3) : Lab[0] / κ$2,\n\t\t\tf[2]   > ε3 ? Math.pow(f[2], 3)                : (116 * f[2] - 16) / κ$2,\n\t\t];\n\n\t\t// Compute XYZ by scaling xyz by reference white\n\t\treturn xyz.map((value, i) => value * white$1[i]);\n\t},\n\n\tformats: {\n\t\t\"lab-d65\": {\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>[-1,1]\", \"<number> | <percentage>[-1,1]\"],\n\t\t},\n\t},\n});\n\n// Delta Phi Star perceptual lightness contrast\n// See https://github.com/Myndex/deltaphistar\n// The (difference between two Lstars each raised to phi) raised to (1/phi)\n// Symmetric, does not matter which is foreground and which is background\n\n\nconst phi = Math.pow(5, 0.5) * 0.5 + 0.5; // Math.phi can be used if Math.js\n\nfunction contrastDeltaPhi (color1, color2) {\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\tlet Lstr1 = get(color1, [lab_d65, \"l\"]);\n\tlet Lstr2 = get(color2, [lab_d65, \"l\"]);\n\n\tlet deltaPhiStar = Math.abs(Math.pow(Lstr1, phi) - Math.pow(Lstr2, phi));\n\n\tlet contrast = Math.pow(deltaPhiStar, (1 / phi)) * Math.SQRT2 - 40;\n\n\treturn (contrast < 7.5) ? 0.0 : contrast ;\n}\n\nvar contrastMethods = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tcontrastAPCA: contrastAPCA,\n\tcontrastDeltaPhi: contrastDeltaPhi,\n\tcontrastLstar: contrastLstar,\n\tcontrastMichelson: contrastMichelson,\n\tcontrastWCAG21: contrastWCAG21,\n\tcontrastWeber: contrastWeber\n});\n\nfunction contrast (background, foreground, o = {}) {\n\tif (isString(o)) {\n\t\to = {algorithm: o};\n\t}\n\n\tlet {algorithm, ...rest} = o;\n\n\tif (!algorithm) {\n\t\tlet algorithms = Object.keys(contrastMethods).map(a => a.replace(/^contrast/, \"\")).join(\", \");\n\t\tthrow new TypeError(`contrast() function needs a contrast algorithm. Please specify one of: ${algorithms}`);\n\t}\n\n\tbackground = getColor(background);\n\tforeground = getColor(foreground);\n\n\tfor (let a in contrastMethods) {\n\t\tif (\"contrast\" + algorithm.toLowerCase() === a.toLowerCase()) {\n\t\t\treturn contrastMethods[a](background, foreground, rest);\n\t\t}\n\t}\n\n\tthrow new TypeError(`Unknown contrast algorithm: ${algorithm}`);\n}\n\n// Chromaticity coordinates\nfunction uv (color) {\n\t// Assumes getAll() calls getColor() on color\n\tlet [X, Y, Z] = getAll(color, xyz_d65);\n\tlet denom = X + 15 * Y + 3 * Z;\n\treturn [4 * X / denom, 9 * Y / denom];\n}\n\nfunction xy (color) {\n\t// Assumes getAll() calls getColor() on color\n\tlet [X, Y, Z] = getAll(color, xyz_d65);\n\tlet  sum = X + Y + Z;\n\treturn [X / sum, Y / sum];\n}\n\nfunction register$1 (Color) {\n\t// no setters, as lightness information is lost\n\t// when converting color to chromaticity\n\tObject.defineProperty(Color.prototype, \"uv\", {\n\t\tget () {\n\t\t\treturn uv(this);\n\t\t},\n\t});\n\n\tObject.defineProperty(Color.prototype, \"xy\", {\n\t\tget () {\n\t\t\treturn xy(this);\n\t\t},\n\t});\n}\n\nvar chromaticity = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tregister: register$1,\n\tuv: uv,\n\txy: xy\n});\n\nfunction deltaE (c1, c2, o = {}) {\n\tif (isString(o)) {\n\t\to = {method: o};\n\t}\n\n\tlet {method = defaults.deltaE, ...rest} = o;\n\n\tfor (let m in deltaEMethods) {\n\t\tif (\"deltae\" + method.toLowerCase() === m.toLowerCase()) {\n\t\t\treturn deltaEMethods[m](c1, c2, rest);\n\t\t}\n\t}\n\n\tthrow new TypeError(`Unknown deltaE method: ${method}`);\n}\n\nfunction lighten (color, amount = .25) {\n\tlet space = ColorSpace.get(\"oklch\", \"lch\");\n\tlet lightness = [space, \"l\"];\n\treturn set(color, lightness, l => l * (1 + amount));\n}\n\nfunction darken (color, amount = .25) {\n\tlet space = ColorSpace.get(\"oklch\", \"lch\");\n\tlet lightness = [space, \"l\"];\n\treturn set(color, lightness, l => l * (1 - amount));\n}\n\nvar variations = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tdarken: darken,\n\tlighten: lighten\n});\n\n/**\n * Functions related to color interpolation\n */\n\n/**\n * Return an intermediate color between two colors\n * Signatures: mix(c1, c2, p, options)\n *             mix(c1, c2, options)\n *             mix(color)\n * @param {Color | string} c1 The first color\n * @param {Color | string} [c2] The second color\n * @param {number} [p=.5] A 0-1 percentage where 0 is c1 and 1 is c2\n * @param {Object} [o={}]\n * @return {Color}\n */\nfunction mix (c1, c2, p = .5, o = {}) {\n\t[c1, c2] = [getColor(c1), getColor(c2)];\n\n\tif (type(p) === \"object\") {\n\t\t[p, o] = [.5, p];\n\t}\n\n\tlet r = range(c1, c2, o);\n\treturn r(p);\n}\n\n/**\n *\n * @param {Color | string | Function} c1 The first color or a range\n * @param {Color | string} [c2] The second color if c1 is not a range\n * @param {Object} [options={}]\n * @return {Color[]}\n */\nfunction steps (c1, c2, options = {}) {\n\tlet colorRange;\n\n\tif (isRange(c1)) {\n\t\t// Tweaking existing range\n\t\t[colorRange, options] = [c1, c2];\n\t\t[c1, c2] = colorRange.rangeArgs.colors;\n\t}\n\n\tlet {\n\t\tmaxDeltaE, deltaEMethod,\n\t\tsteps = 2, maxSteps = 1000,\n\t\t...rangeOptions\n\t} = options;\n\n\tif (!colorRange) {\n\t\t[c1, c2] = [getColor(c1), getColor(c2)];\n\t\tcolorRange = range(c1, c2, rangeOptions);\n\t}\n\n\tlet totalDelta = deltaE(c1, c2);\n\tlet actualSteps = maxDeltaE > 0 ? Math.max(steps, Math.ceil(totalDelta / maxDeltaE) + 1) : steps;\n\tlet ret = [];\n\n\tif (maxSteps !== undefined) {\n\t\tactualSteps = Math.min(actualSteps, maxSteps);\n\t}\n\n\tif (actualSteps === 1) {\n\t\tret = [{p: .5, color: colorRange(.5)}];\n\t}\n\telse {\n\t\tlet step = 1 / (actualSteps - 1);\n\t\tret = Array.from({length: actualSteps}, (_, i) => {\n\t\t\tlet p = i * step;\n\t\t\treturn {p, color: colorRange(p)};\n\t\t});\n\t}\n\n\tif (maxDeltaE > 0) {\n\t\t// Iterate over all stops and find max deltaE\n\t\tlet maxDelta = ret.reduce((acc, cur, i) => {\n\t\t\tif (i === 0) {\n\t\t\t\treturn 0;\n\t\t\t}\n\n\t\t\tlet ΔΕ = deltaE(cur.color, ret[i - 1].color, deltaEMethod);\n\t\t\treturn Math.max(acc, ΔΕ);\n\t\t}, 0);\n\n\t\twhile (maxDelta > maxDeltaE) {\n\t\t\t// Insert intermediate stops and measure maxDelta again\n\t\t\t// We need to do this for all pairs, otherwise the midpoint shifts\n\t\t\tmaxDelta = 0;\n\n\t\t\tfor (let i = 1; (i < ret.length) && (ret.length < maxSteps); i++) {\n\t\t\t\tlet prev = ret[i - 1];\n\t\t\t\tlet cur = ret[i];\n\n\t\t\t\tlet p = (cur.p + prev.p) / 2;\n\t\t\t\tlet color = colorRange(p);\n\t\t\t\tmaxDelta = Math.max(maxDelta, deltaE(color, prev.color), deltaE(color, cur.color));\n\t\t\t\tret.splice(i, 0, {p, color: colorRange(p)});\n\t\t\t\ti++;\n\t\t\t}\n\t\t}\n\t}\n\n\tret = ret.map(a => a.color);\n\n\treturn ret;\n}\n\n/**\n * Interpolate to color2 and return a function that takes a 0-1 percentage\n * @param {Color | string | Function} color1 The first color or an existing range\n * @param {Color | string} [color2] If color1 is a color, this is the second color\n * @param {Object} [options={}]\n * @returns {Function} A function that takes a 0-1 percentage and returns a color\n */\nfunction range (color1, color2, options = {}) {\n\tif (isRange(color1)) {\n\t\t// Tweaking existing range\n\t\tlet [r, options] = [color1, color2];\n\n\t\treturn range(...r.rangeArgs.colors, {...r.rangeArgs.options, ...options});\n\t}\n\n\tlet {space, outputSpace, progression, premultiplied} = options;\n\n\tcolor1 = getColor(color1);\n\tcolor2 = getColor(color2);\n\n\t// Make sure we're working on copies of these colors\n\tcolor1 = clone(color1);\n\tcolor2 = clone(color2);\n\n\tlet rangeArgs = {colors: [color1, color2], options};\n\n\tif (space) {\n\t\tspace = ColorSpace.get(space);\n\t}\n\telse {\n\t\tspace = ColorSpace.registry[defaults.interpolationSpace] || color1.space;\n\t}\n\n\toutputSpace = outputSpace ? ColorSpace.get(outputSpace) : space;\n\n\tcolor1 = to(color1, space);\n\tcolor2 = to(color2, space);\n\n\t// Gamut map to avoid areas of flat color\n\tcolor1 = toGamut(color1);\n\tcolor2 = toGamut(color2);\n\n\t// Handle hue interpolation\n\t// See https://github.com/w3c/csswg-drafts/issues/4735#issuecomment-635741840\n\tif (space.coords.h && space.coords.h.type === \"angle\") {\n\t\tlet arc = options.hue = options.hue || \"shorter\";\n\n\t\tlet hue = [space, \"h\"];\n\t\tlet [θ1, θ2] = [get(color1, hue), get(color2, hue)];\n\t\t// Undefined hues must be evaluated before hue fix-up to properly\n\t\t// calculate hue arcs between undefined and defined hues.\n\t\t// See https://github.com/w3c/csswg-drafts/issues/9436#issuecomment-1746957545\n\t\tif (isNaN(θ1) && !isNaN(θ2)) {\n\t\t\tθ1 = θ2;\n\t\t}\n\t\telse if (isNaN(θ2) && !isNaN(θ1)) {\n\t\t\tθ2 = θ1;\n\t\t}\n\t\t[θ1, θ2] = adjust(arc, [θ1, θ2]);\n\t\tset(color1, hue, θ1);\n\t\tset(color2, hue, θ2);\n\t}\n\n\tif (premultiplied) {\n\t\t// not coping with polar spaces yet\n\t\tcolor1.coords = color1.coords.map(c => c * color1.alpha);\n\t\tcolor2.coords = color2.coords.map(c => c * color2.alpha);\n\t}\n\n\treturn Object.assign(p => {\n\t\tp = progression ? progression(p) : p;\n\t\tlet coords = color1.coords.map((start, i) => {\n\t\t\tlet end = color2.coords[i];\n\t\t\treturn interpolate(start, end, p);\n\t\t});\n\n\t\tlet alpha = interpolate(color1.alpha, color2.alpha, p);\n\t\tlet ret = {space, coords, alpha};\n\n\t\tif (premultiplied) {\n\t\t\t// undo premultiplication\n\t\t\tret.coords = ret.coords.map(c => c / alpha);\n\t\t}\n\n\t\tif (outputSpace !== space) {\n\t\t\tret = to(ret, outputSpace);\n\t\t}\n\n\t\treturn ret;\n\t}, {\n\t\trangeArgs,\n\t});\n}\n\nfunction isRange (val) {\n\treturn type(val) === \"function\" && !!val.rangeArgs;\n}\n\ndefaults.interpolationSpace = \"lab\";\n\nfunction register (Color) {\n\tColor.defineFunction(\"mix\", mix, {returns: \"color\"});\n\tColor.defineFunction(\"range\", range, {returns: \"function<color>\"});\n\tColor.defineFunction(\"steps\", steps, {returns: \"array<color>\"});\n}\n\nvar interpolation = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tisRange: isRange,\n\tmix: mix,\n\trange: range,\n\tregister: register,\n\tsteps: steps\n});\n\nvar HSL = new ColorSpace({\n\tid: \"hsl\",\n\tname: \"HSL\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\ts: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Saturation\",\n\t\t},\n\t\tl: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t},\n\n\tbase: sRGB,\n\n\t// Adapted from https://drafts.csswg.org/css-color-4/better-rgbToHsl.js\n\tfromBase: rgb => {\n\t\tlet max = Math.max(...rgb);\n\t\tlet min = Math.min(...rgb);\n\t\tlet [r, g, b] = rgb;\n\t\tlet [h, s, l] = [NaN, 0, (min + max) / 2];\n\t\tlet d = max - min;\n\n\t\tif (d !== 0) {\n\t\t\ts = (l === 0 || l === 1) ? 0 : (max - l) / Math.min(l, 1 - l);\n\n\t\t\tswitch (max) {\n\t\t\t\tcase r: h = (g - b) / d + (g < b ? 6 : 0); break;\n\t\t\t\tcase g: h = (b - r) / d + 2; break;\n\t\t\t\tcase b: h = (r - g) / d + 4;\n\t\t\t}\n\n\t\t\th = h * 60;\n\t\t}\n\n\t\t// Very out of gamut colors can produce negative saturation\n\t\t// If so, just rotate the hue by 180 and use a positive saturation\n\t\t// see https://github.com/w3c/csswg-drafts/issues/9222\n\t\tif (s < 0) {\n\t\t\th += 180;\n\t\t\ts = Math.abs(s);\n\t\t}\n\n\t\tif (h >= 360) {\n\t\t\th -= 360;\n\t\t}\n\n\t\treturn [h, s * 100, l * 100];\n\t},\n\n\t// Adapted from https://en.wikipedia.org/wiki/HSL_and_HSV#HSL_to_RGB_alternative\n\ttoBase: hsl => {\n\t\tlet [h, s, l] = hsl;\n\t\th = h % 360;\n\n\t\tif (h < 0) {\n\t\t\th += 360;\n\t\t}\n\n\t\ts /= 100;\n\t\tl /= 100;\n\n\t\tfunction f (n) {\n\t\t\tlet k = (n + h / 30) % 12;\n\t\t\tlet a = s * Math.min(l, 1 - l);\n\t\t\treturn l - a * Math.max(-1, Math.min(k - 3, 9 - k, 1));\n\t\t}\n\n\t\treturn [f(0), f(8), f(4)];\n\t},\n\n\tformats: {\n\t\t\"hsl\": {\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage>\", \"<percentage>\"],\n\t\t},\n\t\t\"hsla\": {\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage>\", \"<percentage>\"],\n\t\t\tcommas: true,\n\t\t\tlastAlpha: true,\n\t\t},\n\t},\n});\n\n// The Hue, Whiteness Blackness (HWB) colorspace\n// See https://drafts.csswg.org/css-color-4/#the-hwb-notation\n// Note that, like HSL, calculations are done directly on\n// gamma-corrected sRGB values rather than linearising them first.\n\nvar HSV = new ColorSpace({\n\tid: \"hsv\",\n\tname: \"HSV\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\ts: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Saturation\",\n\t\t},\n\t\tv: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Value\",\n\t\t},\n\t},\n\n\tbase: HSL,\n\t// https://en.wikipedia.org/wiki/HSL_and_HSV#Interconversion\n\tfromBase (hsl) {\n\t\tlet [h, s, l] = hsl;\n\t\ts /= 100;\n\t\tl /= 100;\n\n\t\tlet v = l + s * Math.min(l, 1 - l);\n\n\t\treturn [\n\t\t\th, // h is the same\n\t\t\tv === 0 ? 0 : 200 * (1 - l / v), // s\n\t\t\t100 * v,\n\t\t];\n\t},\n\t// https://en.wikipedia.org/wiki/HSL_and_HSV#Interconversion\n\ttoBase (hsv) {\n\t\tlet [h, s, v] = hsv;\n\n\t\ts /= 100;\n\t\tv /= 100;\n\n\t\tlet l = v * (1 - s / 2);\n\n\t\treturn [\n\t\t\th, // h is the same\n\t\t\t(l === 0 || l === 1) ? 0 : ((v - l) / Math.min(l, 1 - l)) * 100,\n\t\t\tl * 100,\n\t\t];\n\t},\n\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--hsv\",\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage> | <number>\", \"<percentage> | <number>\"],\n\t\t},\n\t},\n});\n\n// The Hue, Whiteness Blackness (HWB) colorspace\n// See https://drafts.csswg.org/css-color-4/#the-hwb-notation\n// Note that, like HSL, calculations are done directly on\n// gamma-corrected sRGB values rather than linearising them first.\n\nvar hwb = new ColorSpace({\n\tid: \"hwb\",\n\tname: \"HWB\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\tw: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Whiteness\",\n\t\t},\n\t\tb: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Blackness\",\n\t\t},\n\t},\n\n\tbase: HSV,\n\tfromBase (hsv) {\n\t\tlet [h, s, v] = hsv;\n\n\t\treturn [h, v * (100 - s) / 100, 100 - v];\n\t},\n\ttoBase (hwb) {\n\t\tlet [h, w, b] = hwb;\n\n\t\t// Now convert percentages to [0..1]\n\t\tw /= 100;\n\t\tb /= 100;\n\n\t\t// Achromatic check (white plus black >= 1)\n\t\tlet sum = w + b;\n\t\tif (sum >= 1) {\n\t\t\tlet gray = w / sum;\n\t\t\treturn [h, 0, gray * 100];\n\t\t}\n\n\t\tlet v = (1 - b);\n\t\tlet s = (v === 0) ? 0 : 1 - w / v;\n\t\treturn [h, s * 100, v * 100];\n\t},\n\n\tformats: {\n\t\t\"hwb\": {\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage> | <number>\", \"<percentage> | <number>\"],\n\t\t},\n\t},\n});\n\n// convert an array of linear-light a98-rgb values to CIE XYZ\n// http://www.brucelindbloom.com/index.html?Eqn_RGB_XYZ_Matrix.html\n// has greater numerical precision than section 4.3.5.3 of\n// https://www.adobe.com/digitalimag/pdfs/AdobeRGB1998.pdf\n// but the values below were calculated from first principles\n// from the chromaticity coordinates of R G B W\nconst toXYZ_M$2 = [\n\t[ 0.5766690429101305,   0.1855582379065463,   0.1882286462349947  ],\n\t[ 0.29734497525053605,  0.6273635662554661,   0.07529145849399788 ],\n\t[ 0.02703136138641234,  0.07068885253582723,  0.9913375368376388  ],\n];\n\nconst fromXYZ_M$2 = [\n\t[  2.0415879038107465,    -0.5650069742788596,   -0.34473135077832956 ],\n\t[ -0.9692436362808795,     1.8759675015077202,    0.04155505740717557 ],\n\t[  0.013444280632031142,  -0.11836239223101838,   1.0151749943912054  ],\n];\n\nvar A98Linear = new RGBColorSpace({\n\tid: \"a98rgb-linear\",\n\tcssId: \"--a98-rgb-linear\",\n\tname: \"Linear Adobe® 98 RGB compatible\",\n\twhite: \"D65\",\n\ttoXYZ_M: toXYZ_M$2,\n\tfromXYZ_M: fromXYZ_M$2,\n});\n\nvar a98rgb = new RGBColorSpace({\n\tid: \"a98rgb\",\n\tcssId: \"a98-rgb\",\n\tname: \"Adobe® 98 RGB compatible\",\n\tbase: A98Linear,\n\ttoBase: RGB => RGB.map(val => Math.pow(Math.abs(val), 563 / 256) * Math.sign(val)),\n\tfromBase: RGB => RGB.map(val => Math.pow(Math.abs(val), 256 / 563) * Math.sign(val)),\n});\n\n// convert an array of  prophoto-rgb values to CIE XYZ\n// using  D50 (so no chromatic adaptation needed afterwards)\n// matrix cannot be expressed in rational form, but is calculated to 64 bit accuracy\n// see https://github.com/w3c/csswg-drafts/issues/7675\nconst toXYZ_M$1 = [\n\t[ 0.79776664490064230,  0.13518129740053308,  0.03134773412839220 ],\n\t[ 0.28807482881940130,  0.71183523424187300,  0.00008993693872564 ],\n\t[ 0.00000000000000000,  0.00000000000000000,  0.82510460251046020 ],\n];\n\nconst fromXYZ_M$1 = [\n\t[  1.34578688164715830, -0.25557208737979464, -0.05110186497554526 ],\n\t[ -0.54463070512490190,  1.50824774284514680,  0.02052744743642139 ],\n\t[  0.00000000000000000,  0.00000000000000000,  1.21196754563894520 ],\n];\n\nvar ProPhotoLinear = new RGBColorSpace({\n\tid: \"prophoto-linear\",\n\tcssId: \"--prophoto-rgb-linear\",\n\tname: \"Linear ProPhoto\",\n\twhite: \"D50\",\n\tbase: XYZ_D50,\n\ttoXYZ_M: toXYZ_M$1,\n\tfromXYZ_M: fromXYZ_M$1,\n});\n\nconst Et = 1 / 512;\nconst Et2 = 16 / 512;\n\nvar prophoto = new RGBColorSpace({\n\tid: \"prophoto\",\n\tcssId: \"prophoto-rgb\",\n\tname: \"ProPhoto\",\n\tbase: ProPhotoLinear,\n\ttoBase (RGB) {\n\t\t// Transfer curve is gamma 1.8 with a small linear portion\n\t\treturn RGB.map(v => v < Et2 ? v / 16 : v ** 1.8);\n\t},\n\tfromBase (RGB) {\n\t\treturn RGB.map(v => v >= Et ? v ** (1 / 1.8) : 16 * v);\n\t},\n});\n\nvar oklch = new ColorSpace({\n\tid: \"oklch\",\n\tname: \"Oklch\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 1],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\tc: {\n\t\t\trefRange: [0, 0.4],\n\t\t\tname: \"Chroma\",\n\t\t},\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t},\n\twhite: \"D65\",\n\n\tbase: OKLab,\n\tfromBase (oklab) {\n\t\t// Convert to polar form\n\t\tlet [L, a, b] = oklab;\n\t\tlet h;\n\t\tconst ε = 0.0002; // chromatic components much smaller than a,b\n\n\t\tif (Math.abs(a) < ε && Math.abs(b) < ε) {\n\t\t\th = NaN;\n\t\t}\n\t\telse {\n\t\t\th = Math.atan2(b, a) * 180 / Math.PI;\n\t\t}\n\n\t\treturn [\n\t\t\tL, // OKLab L is still L\n\t\t\tMath.sqrt(a ** 2 + b ** 2), // Chroma\n\t\t\tconstrain(h), // Hue, in degrees [0 to 360)\n\t\t];\n\t},\n\t// Convert from polar form\n\ttoBase (oklch) {\n\t\tlet [L, C, h] = oklch;\n\t\tlet a, b;\n\n\t\t// check for NaN hue\n\t\tif (isNaN(h)) {\n\t\t\ta = 0;\n\t\t\tb = 0;\n\t\t}\n\t\telse {\n\t\t\ta = C * Math.cos(h * Math.PI / 180);\n\t\t\tb = C * Math.sin(h * Math.PI / 180);\n\t\t}\n\n\t\treturn [ L, a, b ];\n\t},\n\n\tformats: {\n\t\t\"oklch\": {\n\t\t\tcoords: [\"<percentage> | <number>\", \"<number> | <percentage>[0,1]\", \"<number> | <angle>\"],\n\t\t},\n\t},\n});\n\nlet white = WHITES.D65;\n\nconst ε$2 = 216 / 24389;  // 6^3/29^3 == (24/116)^3\nconst κ$1 = 24389 / 27;   // 29^3/3^3\nconst [U_PRIME_WHITE, V_PRIME_WHITE] = uv({space: xyz_d65, coords: white});\n\nvar Luv = new ColorSpace({\n\tid: \"luv\",\n\tname: \"Luv\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\t// Reference ranges from https://facelessuser.github.io/coloraide/colors/luv/\n\t\tu: {\n\t\t\trefRange: [-215, 215],\n\t\t},\n\t\tv: {\n\t\t\trefRange: [-215, 215],\n\t\t},\n\t},\n\n\twhite: white,\n\tbase: xyz_d65,\n\n\t// Convert D65-adapted XYZ to Luv\n\t// https://en.wikipedia.org/wiki/CIELUV#The_forward_transformation\n\tfromBase (XYZ) {\n\t\tlet xyz = [skipNone(XYZ[0]), skipNone(XYZ[1]), skipNone(XYZ[2])];\n\t\tlet y = xyz[1];\n\n\t\tlet [up, vp] = uv({space: xyz_d65, coords: xyz});\n\n\t\t// Protect against XYZ of [0, 0, 0]\n\t\tif (!Number.isFinite(up) || !Number.isFinite(vp)) {\n\t\t\treturn [0, 0, 0];\n\t\t}\n\n\t\tlet L = y <= ε$2 ? κ$1 * y : 116 * Math.cbrt(y) - 16;\n\t\treturn [\n\t\t\tL,\n\t\t\t13 * L * (up - U_PRIME_WHITE),\n\t\t\t13 * L * (vp - V_PRIME_WHITE),\n\t\t ];\n\t},\n\n\t// Convert Luv to D65-adapted XYZ\n\t// https://en.wikipedia.org/wiki/CIELUV#The_reverse_transformation\n\ttoBase (Luv) {\n\t\tlet [L, u, v] = Luv;\n\n\t\t// Protect against division by zero and NaN Lightness\n\t\tif (L === 0 || isNone(L)) {\n\t\t\treturn [0, 0, 0];\n\t\t}\n\n\t\tu = skipNone(u);\n\t\tv = skipNone(v);\n\n\t\tlet up = (u / (13 * L)) + U_PRIME_WHITE;\n\t\tlet vp = (v / (13 * L)) + V_PRIME_WHITE;\n\n\t\tlet y = L <= 8 ? L / κ$1 : Math.pow((L + 16) / 116, 3);\n\n\t\treturn [\n\t\t\ty * ((9 * up) / (4 * vp)),\n\t\t\ty,\n\t\t\ty * ((12 - 3 * up - 20 * vp) / (4 * vp)),\n\t\t];\n\t},\n\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--luv\",\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>[-1,1]\", \"<number> | <percentage>[-1,1]\"],\n\t\t},\n\t},\n});\n\nvar LCHuv = new ColorSpace({\n\tid: \"lchuv\",\n\tname: \"LChuv\",\n\tcoords: {\n\t\tl: {\n\t\t\trefRange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t\tc: {\n\t\t\trefRange: [0, 220],\n\t\t\tname: \"Chroma\",\n\t\t},\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t},\n\n\tbase: Luv,\n\tfromBase (Luv) {\n\t\t// Convert to polar form\n\t\tlet [L, u, v] = Luv;\n\t\tlet hue;\n\t\tconst ε = 0.02;\n\n\t\tif (Math.abs(u) < ε && Math.abs(v) < ε) {\n\t\t\thue = NaN;\n\t\t}\n\t\telse {\n\t\t\thue = Math.atan2(v, u) * 180 / Math.PI;\n\t\t}\n\n\t\treturn [\n\t\t\tL, // L is still L\n\t\t\tMath.sqrt(u ** 2 + v ** 2), // Chroma\n\t\t\tconstrain(hue), // Hue, in degrees [0 to 360)\n\t\t];\n\t},\n\ttoBase (LCH) {\n\t\t// Convert from polar form\n\t\tlet [Lightness, Chroma, Hue] = LCH;\n\t\t// Clamp any negative Chroma\n\t\tif (Chroma < 0) {\n\t\t\tChroma = 0;\n\t\t}\n\t\t// Deal with NaN Hue\n\t\tif (isNaN(Hue)) {\n\t\t\tHue = 0;\n\t\t}\n\t\treturn [\n\t\t\tLightness, // L is still L\n\t\t\tChroma * Math.cos(Hue * Math.PI / 180), // u\n\t\t\tChroma * Math.sin(Hue * Math.PI / 180),  // v\n\t\t];\n\t},\n\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--lchuv\",\n\t\t\tcoords: [\"<number> | <percentage>\", \"<number> | <percentage>\", \"<number> | <angle>\"],\n\t\t},\n\t},\n});\n\n/*\nAdapted from: https://github.com/hsluv/hsluv-javascript/blob/14b49e6cf9a9137916096b8487a5372626b57ba4/src/hsluv.ts\n\nCopyright (c) 2012-2022 Alexei Boronine\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n*/\n\n\nconst ε$1 = 216 / 24389;  // 6^3/29^3 == (24/116)^3\nconst κ = 24389 / 27;   // 29^3/3^3\n\nconst m_r0 = fromXYZ_M$3[0][0];\nconst m_r1 = fromXYZ_M$3[0][1];\nconst m_r2 = fromXYZ_M$3[0][2];\nconst m_g0 = fromXYZ_M$3[1][0];\nconst m_g1 = fromXYZ_M$3[1][1];\nconst m_g2 = fromXYZ_M$3[1][2];\nconst m_b0 = fromXYZ_M$3[2][0];\nconst m_b1 = fromXYZ_M$3[2][1];\nconst m_b2 = fromXYZ_M$3[2][2];\n\nfunction distanceFromOriginAngle (slope, intercept, angle) {\n\tconst d = intercept / (Math.sin(angle) - slope * Math.cos(angle));\n\treturn d < 0 ? Infinity : d;\n}\n\nfunction calculateBoundingLines (l) {\n\tconst sub1 = Math.pow(l + 16, 3) / 1560896;\n\tconst sub2 = sub1 > ε$1 ? sub1 : l / κ;\n\tconst s1r = sub2 * (284517 * m_r0 - 94839 * m_r2);\n\tconst s2r = sub2 * (838422 * m_r2 + 769860 * m_r1 + 731718 * m_r0);\n\tconst s3r = sub2 * (632260 * m_r2 - 126452 * m_r1);\n\tconst s1g = sub2 * (284517 * m_g0 - 94839 * m_g2);\n\tconst s2g = sub2 * (838422 * m_g2 + 769860 * m_g1 + 731718 * m_g0);\n\tconst s3g = sub2 * (632260 * m_g2 - 126452 * m_g1);\n\tconst s1b = sub2 * (284517 * m_b0 - 94839 * m_b2);\n\tconst s2b = sub2 * (838422 * m_b2 + 769860 * m_b1 + 731718 * m_b0);\n\tconst s3b = sub2 * (632260 * m_b2 - 126452 * m_b1);\n\n\treturn {\n\t\tr0s: s1r / s3r,\n\t\tr0i: s2r * l / s3r,\n\t\tr1s: s1r / (s3r + 126452),\n\t\tr1i: (s2r - 769860) * l / (s3r + 126452),\n\t\tg0s: s1g / s3g,\n\t\tg0i: s2g * l / s3g,\n\t\tg1s: s1g / (s3g + 126452),\n\t\tg1i: (s2g - 769860) * l / (s3g + 126452),\n\t\tb0s: s1b / s3b,\n\t\tb0i: s2b * l / s3b,\n\t\tb1s: s1b / (s3b + 126452),\n\t\tb1i: (s2b - 769860) * l / (s3b + 126452),\n\t};\n}\n\nfunction calcMaxChromaHsluv (lines, h) {\n\tconst hueRad = h / 360 * Math.PI * 2;\n\tconst r0 = distanceFromOriginAngle(lines.r0s, lines.r0i, hueRad);\n\tconst r1 = distanceFromOriginAngle(lines.r1s, lines.r1i, hueRad);\n\tconst g0 = distanceFromOriginAngle(lines.g0s, lines.g0i, hueRad);\n\tconst g1 = distanceFromOriginAngle(lines.g1s, lines.g1i, hueRad);\n\tconst b0 = distanceFromOriginAngle(lines.b0s, lines.b0i, hueRad);\n\tconst b1 = distanceFromOriginAngle(lines.b1s, lines.b1i, hueRad);\n\n\treturn Math.min(r0, r1, g0, g1, b0, b1);\n}\n\nvar hsluv = new ColorSpace({\n\tid: \"hsluv\",\n\tname: \"HSLuv\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\ts: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Saturation\",\n\t\t},\n\t\tl: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t},\n\n\tbase: LCHuv,\n\tgamutSpace: sRGB,\n\n\t// Convert LCHuv to HSLuv\n\tfromBase (lch) {\n\t\tlet [l, c, h] = [skipNone(lch[0]), skipNone(lch[1]), skipNone(lch[2])];\n\t\tlet s;\n\n\t\tif (l > 99.9999999) {\n\t\t\ts = 0;\n\t\t\tl = 100;\n\t\t}\n\t\telse if (l < 0.00000001) {\n\t\t\ts = 0;\n\t\t\tl = 0;\n\t\t}\n\t\telse {\n\t\t\tlet lines = calculateBoundingLines(l);\n\t\t\tlet max = calcMaxChromaHsluv(lines, h);\n\t\t\ts = c / max * 100;\n\t\t}\n\n\t\treturn [h, s, l];\n\t},\n\n\t// Convert HSLuv to LCHuv\n\ttoBase (hsl) {\n\t\tlet [h, s, l] = [skipNone(hsl[0]), skipNone(hsl[1]), skipNone(hsl[2])];\n\t\tlet c;\n\n\t\tif (l > 99.9999999) {\n\t\t\tl = 100;\n\t\t\tc = 0;\n\t\t}\n\t\telse if (l < 0.00000001) {\n\t\t\tl = 0;\n\t\t\tc = 0;\n\t\t}\n\t\telse {\n\t\t\tlet lines = calculateBoundingLines(l);\n\t\t\tlet max = calcMaxChromaHsluv(lines, h);\n\t\t\tc = max / 100 * s;\n\t\t}\n\n\t\treturn [l, c, h];\n\t},\n\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--hsluv\",\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage> | <number>\", \"<percentage> | <number>\"],\n\t\t},\n\t},\n});\n\n/*\nAdapted from: https://github.com/hsluv/hsluv-javascript/blob/14b49e6cf9a9137916096b8487a5372626b57ba4/src/hsluv.ts\n\nCopyright (c) 2012-2022 Alexei Boronine\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n*/\n\n\nfromXYZ_M$3[0][0];\nfromXYZ_M$3[0][1];\nfromXYZ_M$3[0][2];\nfromXYZ_M$3[1][0];\nfromXYZ_M$3[1][1];\nfromXYZ_M$3[1][2];\nfromXYZ_M$3[2][0];\nfromXYZ_M$3[2][1];\nfromXYZ_M$3[2][2];\n\nfunction distanceFromOrigin (slope, intercept) {\n\treturn Math.abs(intercept) / Math.sqrt(Math.pow(slope, 2) + 1);\n}\n\nfunction calcMaxChromaHpluv (lines) {\n\tlet r0 = distanceFromOrigin(lines.r0s, lines.r0i);\n\tlet r1 = distanceFromOrigin(lines.r1s, lines.r1i);\n\tlet g0 = distanceFromOrigin(lines.g0s, lines.g0i);\n\tlet g1 = distanceFromOrigin(lines.g1s, lines.g1i);\n\tlet b0 = distanceFromOrigin(lines.b0s, lines.b0i);\n\tlet b1 = distanceFromOrigin(lines.b1s, lines.b1i);\n\n\treturn Math.min(r0, r1, g0, g1, b0, b1);\n}\n\nvar hpluv = new ColorSpace({\n\tid: \"hpluv\",\n\tname: \"HPLuv\",\n\tcoords: {\n\t\th: {\n\t\t\trefRange: [0, 360],\n\t\t\ttype: \"angle\",\n\t\t\tname: \"Hue\",\n\t\t},\n\t\ts: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Saturation\",\n\t\t},\n\t\tl: {\n\t\t\trange: [0, 100],\n\t\t\tname: \"Lightness\",\n\t\t},\n\t},\n\n\tbase: LCHuv,\n\tgamutSpace: \"self\",\n\n\t// Convert LCHuv to HPLuv\n\tfromBase (lch) {\n\t\tlet [l, c, h] = [skipNone(lch[0]), skipNone(lch[1]), skipNone(lch[2])];\n\t\tlet s;\n\n\t\tif (l > 99.9999999) {\n\t\t\ts = 0;\n\t\t\tl = 100;\n\t\t}\n\t\telse if (l < 0.00000001) {\n\t\t\ts = 0;\n\t\t\tl = 0;\n\t\t}\n\t\telse {\n\t\t\tlet lines = calculateBoundingLines(l);\n\t\t\tlet max = calcMaxChromaHpluv(lines);\n\t\t\ts = c / max * 100;\n\t\t}\n\t\treturn [h, s, l];\n\t},\n\n\t// Convert HPLuv to LCHuv\n\ttoBase (hsl) {\n\t\tlet [h, s, l] = [skipNone(hsl[0]), skipNone(hsl[1]), skipNone(hsl[2])];\n\t\tlet c;\n\n\t\tif (l > 99.9999999) {\n\t\t\tl = 100;\n\t\t\tc = 0;\n\t\t}\n\t\telse if (l < 0.00000001) {\n\t\t\tl = 0;\n\t\t\tc = 0;\n\t\t}\n\t\telse {\n\t\t\tlet lines = calculateBoundingLines(l);\n\t\t\tlet max = calcMaxChromaHpluv(lines);\n\t\t\tc = max / 100 * s;\n\t\t}\n\n\t\treturn [l, c, h];\n\t},\n\n\tformats: {\n\t\tcolor: {\n\t\t\tid: \"--hpluv\",\n\t\t\tcoords: [\"<number> | <angle>\", \"<percentage> | <number>\", \"<percentage> | <number>\"],\n\t\t},\n\t},\n});\n\nconst Yw = 203;\t// absolute luminance of media white, cd/m²\nconst n = 2610 / (2 ** 14);\nconst ninv = (2 ** 14) / 2610;\nconst m = 2523 / (2 ** 5);\nconst minv = (2 ** 5) / 2523;\nconst c1 = 3424 / (2 ** 12);\nconst c2 = 2413 / (2 ** 7);\nconst c3 = 2392 / (2 ** 7);\n\nvar rec2100Pq = new RGBColorSpace({\n\tid: \"rec2100pq\",\n\tcssId: \"rec2100-pq\",\n\tname: \"REC.2100-PQ\",\n\tbase: REC2020Linear,\n\ttoBase (RGB) {\n\t\t// given PQ encoded component in range [0, 1]\n\t\t// return media-white relative linear-light\n\t\treturn RGB.map(function (val) {\n\t\t\tlet x = ((Math.max(((val ** minv) - c1), 0) / (c2 - (c3 * (val ** minv)))) ** ninv);\n\t\t\treturn (x * 10000 / Yw); \t// luminance relative to diffuse white, [0, 70 or so].\n\t\t});\n\t},\n\tfromBase (RGB) {\n\t\t// given media-white relative linear-light\n\t\t// returnPQ encoded component in range [0, 1]\n\t\treturn RGB.map(function (val) {\n\t\t\tlet x = Math.max(val * Yw / 10000, 0); \t// absolute luminance of peak white is 10,000 cd/m².\n\t\t\tlet num = (c1 + (c2 * (x ** n)));\n\t\t\tlet denom = (1 + (c3 * (x ** n)));\n\n\t\t\treturn ((num / denom)  ** m);\n\t\t});\n\t},\n});\n\n// FIXME see https://github.com/LeaVerou/color.js/issues/190\n\nconst a = 0.17883277;\nconst b = 0.28466892; // 1 - (4 * a)\nconst c = 0.55991073; // 0.5 - a * Math.log(4 *a)\n\nconst scale = 3.7743;\t// Place 18% grey at HLG 0.38, so media white at 0.75\n\nvar rec2100Hlg = new RGBColorSpace({\n\tid: \"rec2100hlg\",\n\tcssId: \"rec2100-hlg\",\n\tname: \"REC.2100-HLG\",\n\treferred: \"scene\",\n\n\tbase: REC2020Linear,\n\ttoBase (RGB) {\n\t\t// given HLG encoded component in range [0, 1]\n\t\t// return media-white relative linear-light\n\t\treturn RGB.map(function (val) {\n\t\t\t// first the HLG EOTF\n\t\t\t// ITU-R BT.2390-10 p.30 section\n\t\t\t// 6.3 The hybrid log-gamma electro-optical transfer function (EOTF)\n\t\t\t// Then scale by 3 so media white is 1.0\n\t\t\tif (val <= 0.5) {\n\t\t\t\treturn (val ** 2) / 3 * scale;\n\t\t\t}\n\t\t\treturn ((Math.exp((val - c) / a) + b) / 12) * scale;\n\t\t});\n\t},\n\tfromBase (RGB) {\n\t\t// given media-white relative linear-light\n\t\t// where diffuse white is 1.0,\n\t\t// return HLG encoded component in range [0, 1]\n\t\treturn RGB.map(function (val) {\n\t\t\t// first scale to put linear-light media white at 1/3\n\t\t\tval /= scale;\n\t\t\t// now the HLG OETF\n\t\t\t// ITU-R BT.2390-10 p.23\n\t\t\t// 6.1 The hybrid log-gamma opto-electronic transfer function (OETF)\n\t\t\tif (val <= 1 / 12) {\n\t\t\t\treturn Math.sqrt(3 * val);\n\t\t\t}\n\t\t\treturn a * Math.log(12 * val - b) + c;\n\t\t});\n\t},\n});\n\nconst CATs = {};\n\nhooks.add(\"chromatic-adaptation-start\", env => {\n\tif (env.options.method) {\n\t\tenv.M = adapt(env.W1, env.W2, env.options.method);\n\t}\n});\n\nhooks.add(\"chromatic-adaptation-end\", env => {\n\tif (!env.M) {\n\t\tenv.M = adapt(env.W1, env.W2, env.options.method);\n\t}\n});\n\nfunction defineCAT ({id, toCone_M, fromCone_M}) {\n\t// Use id, toCone_M, fromCone_M like variables\n\tCATs[id] = arguments[0];\n}\n\nfunction adapt (W1, W2, id = \"Bradford\") {\n\t// adapt from a source whitepoint or illuminant W1\n\t// to a destination whitepoint or illuminant W2,\n\t// using the given chromatic adaptation transform (CAT)\n\t// debugger;\n\tlet method = CATs[id];\n\n\tlet [ρs, γs, βs] = multiplyMatrices(method.toCone_M, W1);\n\tlet [ρd, γd, βd] = multiplyMatrices(method.toCone_M, W2);\n\n\t// all practical illuminants have non-zero XYZ so no division by zero can occur below\n\tlet scale = [\n\t\t[ρd / ρs,  0,        0      ],\n\t\t[0,        γd / γs,  0      ],\n\t\t[0,        0,        βd / βs],\n\t];\n\t// console.log({scale});\n\n\tlet scaled_cone_M = multiplyMatrices(scale, method.toCone_M);\n\tlet adapt_M\t= multiplyMatrices(method.fromCone_M, scaled_cone_M);\n\t// console.log({scaled_cone_M, adapt_M});\n\treturn adapt_M;\n}\n\ndefineCAT({\n\tid: \"von Kries\",\n\ttoCone_M: [\n\t\t[  0.4002400,  0.7076000, -0.0808100 ],\n\t\t[ -0.2263000,  1.1653200,  0.0457000 ],\n\t\t[  0.0000000,  0.0000000,  0.9182200 ],\n\t],\n\tfromCone_M: [\n\t\t[ 1.8599363874558397, -1.1293816185800916,   0.21989740959619328     ],\n\t\t[ 0.3611914362417676,  0.6388124632850422,  -0.000006370596838649899 ],\n\t\t[ 0,                   0,                    1.0890636230968613      ],\n\t],\n});\n\ndefineCAT({\n\tid: \"Bradford\",\n\t// Convert an array of XYZ values in the range 0.0 - 1.0\n\t// to cone fundamentals\n\ttoCone_M: [\n\t\t[  0.8951000,  0.2664000, -0.1614000 ],\n\t\t[ -0.7502000,  1.7135000,  0.0367000 ],\n\t\t[  0.0389000, -0.0685000,  1.0296000 ],\n\t],\n\t// and back\n\tfromCone_M: [\n\t\t[  0.9869929054667121, -0.14705425642099013, 0.15996265166373122  ],\n\t\t[  0.4323052697233945,  0.5183602715367774,  0.049291228212855594 ],\n\t\t[ -0.00852866457517732, 0.04004282165408486, 0.96848669578755     ],\n\t],\n});\n\ndefineCAT({\n\tid: \"CAT02\",\n\t// with complete chromatic adaptation to W2, so D = 1.0\n\ttoCone_M: [\n\t\t[  0.7328000,  0.4296000, -0.1624000 ],\n\t\t[ -0.7036000,  1.6975000,  0.0061000 ],\n\t\t[  0.0030000,  0.0136000,  0.9834000 ],\n\t],\n\tfromCone_M: [\n\t\t[  1.0961238208355142,   -0.27886900021828726, 0.18274517938277307 ],\n\t\t[  0.4543690419753592,    0.4735331543074117,  0.07209780371722911 ],\n\t\t[ -0.009627608738429355, -0.00569803121611342, 1.0153256399545427  ],\n\t],\n});\n\ndefineCAT({\n\tid: \"CAT16\",\n\ttoCone_M: [\n\t\t[  0.401288,  0.650173, -0.051461 ],\n\t\t[ -0.250268,  1.204414,  0.045854 ],\n\t\t[ -0.002079,  0.048952,  0.953127 ],\n\t],\n\t// the extra precision is needed to avoid roundtripping errors\n\tfromCone_M: [\n\t\t[  1.862067855087233,   -1.0112546305316845,  0.14918677544445172  ],\n\t\t[  0.3875265432361372,   0.6214474419314753, -0.008973985167612521 ],\n\t\t[ -0.01584149884933386, -0.03412293802851557, 1.0499644368778496   ],\n\t],\n});\n\nObject.assign(WHITES, {\n\t// whitepoint values from ASTM E308-01 with 10nm spacing, 1931 2 degree observer\n\t// all normalized to Y (luminance) = 1.00000\n\t// Illuminant A is a tungsten electric light, giving a very warm, orange light.\n\tA:   [1.09850, 1.00000, 0.35585],\n\n\t// Illuminant C was an early approximation to daylight: illuminant A with a blue filter.\n\tC:   [0.98074, 1.000000, 1.18232],\n\n\t// The daylight series of illuminants simulate natural daylight.\n\t// The color temperature (in degrees Kelvin/100) ranges from\n\t// cool, overcast daylight (D50) to bright, direct sunlight (D65).\n\tD55: [0.95682, 1.00000, 0.92149],\n\tD75: [0.94972, 1.00000, 1.22638],\n\n\t// Equal-energy illuminant, used in two-stage CAT16\n\tE:   [1.00000, 1.00000, 1.00000],\n\n\t// The F series of illuminants represent fluorescent lights\n\tF2:  [0.99186, 1.00000, 0.67393],\n\tF7:  [0.95041, 1.00000, 1.08747],\n\tF11: [1.00962, 1.00000, 0.64350],\n});\n\n// The ACES whitepoint\n// see TB-2018-001 Derivation of the ACES White Point CIE Chromaticity Coordinates\n// also https://github.com/ampas/aces-dev/blob/master/documents/python/TB-2018-001/aces_wp.py\n// Similar to D60\nWHITES.ACES = [0.32168 / 0.33767, 1.00000, (1.00000 - 0.32168 - 0.33767) / 0.33767];\n\n// convert an array of linear-light ACEScc values to CIE XYZ\nconst toXYZ_M = [\n\t[  0.6624541811085053,   0.13400420645643313,  0.1561876870049078  ],\n\t[  0.27222871678091454,  0.6740817658111484,   0.05368951740793705 ],\n\t[ -0.005574649490394108, 0.004060733528982826, 1.0103391003129971  ],\n];\nconst fromXYZ_M = [\n\t[  1.6410233796943257,   -0.32480329418479,    -0.23642469523761225  ],\n\t[ -0.6636628587229829,    1.6153315916573379,   0.016756347685530137 ],\n\t[  0.011721894328375376, -0.008284441996237409, 0.9883948585390215   ],\n];\n\nvar ACEScg = new RGBColorSpace({\n\tid: \"acescg\",\n\tcssId: \"--acescg\",\n\tname: \"ACEScg\",\n\n\t// ACEScg – A scene-referred, linear-light encoding of ACES Data\n\t// https://docs.acescentral.com/specifications/acescg/\n\t// uses the AP1 primaries, see section 4.3.1 Color primaries\n\tcoords: {\n\t\tr: {\n\t\t\trange: [0, 65504],\n\t\t\tname: \"Red\",\n\t\t},\n\t\tg: {\n\t\t\trange: [0, 65504],\n\t\t\tname: \"Green\",\n\t\t},\n\t\tb: {\n\t\t\trange: [0, 65504],\n\t\t\tname: \"Blue\",\n\t\t},\n\t},\n\n\treferred: \"scene\",\n\n\twhite: WHITES.ACES,\n\n\ttoXYZ_M,\n\tfromXYZ_M,\n});\n\n// export default Color;\n\nconst ε = 2 ** -16;\n\n// the smallest value which, in the 32bit IEEE 754 float encoding,\n// decodes as a non-negative value\nconst ACES_min_nonzero = -0.35828683;\n\n// brightest encoded value, decodes to 65504\nconst ACES_cc_max = (Math.log2(65504) + 9.72) / 17.52; // 1.468\n\nvar acescc = new RGBColorSpace({\n\tid: \"acescc\",\n\tcssId: \"--acescc\",\n\tname: \"ACEScc\",\n\t// see S-2014-003 ACEScc – A Logarithmic Encoding of ACES Data\n\t// https://docs.acescentral.com/specifications/acescc/\n\t// uses the AP1 primaries, see section 4.3.1 Color primaries\n\n\t// Appendix A: \"Very small ACES scene referred values below 7 1/4 stops\n\t// below 18% middle gray are encoded as negative ACEScc values.\n\t// These values should be preserved per the encoding in Section 4.4\n\t// so that all positive ACES values are maintained.\"\n\tcoords: {\n\t\tr: {\n\t\t\trange: [ACES_min_nonzero, ACES_cc_max],\n\t\t\tname: \"Red\",\n\t\t},\n\t\tg: {\n\t\t\trange: [ACES_min_nonzero, ACES_cc_max],\n\t\t\tname: \"Green\",\n\t\t},\n\t\tb: {\n\t\t\trange: [ACES_min_nonzero, ACES_cc_max],\n\t\t\tname: \"Blue\",\n\t\t},\n\t},\n\treferred: \"scene\",\n\n\tbase: ACEScg,\n\t// from section 4.4.2 Decoding Function\n\ttoBase (RGB) {\n\t\tconst low = (9.72 - 15) / 17.52; // -0.3014\n\n\t\treturn RGB.map(function (val) {\n\t\t\tif (val <= low) {\n\t\t\t\treturn (2 ** ((val * 17.52) - 9.72) - ε) * 2; // very low values, below -0.3014\n\t\t\t}\n\t\t\telse if (val < ACES_cc_max) {\n\t\t\t\treturn 2 ** ((val * 17.52) - 9.72);\n\t\t\t}\n\t\t\telse { // val >= ACES_cc_max\n\t\t\t\treturn 65504;\n\t\t\t}\n\t\t});\n\t},\n\n\t// Non-linear encoding function from S-2014-003, section 4.4.1 Encoding Function\n\tfromBase (RGB) {\n\t\treturn RGB.map(function (val) {\n\t\t\tif (val <= 0) {\n\t\t\t\treturn (Math.log2(ε) + 9.72) / 17.52; // -0.3584\n\t\t\t}\n\t\t\telse if (val < ε) {\n\t\t\t\treturn  (Math.log2(ε + val * 0.5) + 9.72) / 17.52;\n\t\t\t}\n\t\t\telse { // val >= ε\n\t\t\t\treturn  (Math.log2(val) + 9.72) / 17.52;\n\t\t\t}\n\t\t});\n\t},\n\t// encoded media white (rgb 1,1,1) => linear  [ 222.861, 222.861, 222.861 ]\n\t// encoded media black (rgb 0,0,0) => linear [ 0.0011857, 0.0011857, 0.0011857]\n});\n\nvar spaces = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tA98RGB: a98rgb,\n\tA98RGB_Linear: A98Linear,\n\tACEScc: acescc,\n\tACEScg: ACEScg,\n\tCAM16_JMh: cam16,\n\tHCT: hct,\n\tHPLuv: hpluv,\n\tHSL: HSL,\n\tHSLuv: hsluv,\n\tHSV: HSV,\n\tHWB: hwb,\n\tICTCP: ictcp,\n\tJzCzHz: jzczhz,\n\tJzazbz: Jzazbz,\n\tLCH: lch,\n\tLCHuv: LCHuv,\n\tLab: lab,\n\tLab_D65: lab_d65,\n\tLuv: Luv,\n\tOKLCH: oklch,\n\tOKLab: OKLab,\n\tP3: P3,\n\tP3_Linear: P3Linear,\n\tProPhoto: prophoto,\n\tProPhoto_Linear: ProPhotoLinear,\n\tREC_2020: REC2020,\n\tREC_2020_Linear: REC2020Linear,\n\tREC_2100_HLG: rec2100Hlg,\n\tREC_2100_PQ: rec2100Pq,\n\tXYZ_ABS_D65: XYZ_Abs_D65,\n\tXYZ_D50: XYZ_D50,\n\tXYZ_D65: xyz_d65,\n\tsRGB: sRGB,\n\tsRGB_Linear: sRGBLinear\n});\n\n/**\n * Class that represents a color\n */\nclass Color {\n\t/**\n\t * Creates an instance of Color.\n\t * Signatures:\n\t * - `new Color(stringToParse)`\n\t * - `new Color(otherColor)`\n\t * - `new Color({space, coords, alpha})`\n\t * - `new Color(space, coords, alpha)`\n\t * - `new Color(spaceId, coords, alpha)`\n\t */\n\tconstructor (...args) {\n\t\tlet color;\n\n\t\tif (args.length === 1) {\n\t\t\tcolor = getColor(args[0]);\n\t\t}\n\n\t\tlet space, coords, alpha;\n\n\t\tif (color) {\n\t\t\tspace = color.space || color.spaceId;\n\t\t\tcoords = color.coords;\n\t\t\talpha = color.alpha;\n\t\t}\n\t\telse {\n\t\t\t// default signature new Color(ColorSpace, array [, alpha])\n\t\t\t[space, coords, alpha] = args;\n\t\t}\n\n\t\tObject.defineProperty(this, \"space\", {\n\t\t\tvalue: ColorSpace.get(space),\n\t\t\twritable: false,\n\t\t\tenumerable: true,\n\t\t\tconfigurable: true, // see note in https://262.ecma-international.org/8.0/#sec-proxy-object-internal-methods-and-internal-slots-get-p-receiver\n\t\t});\n\n\t\tthis.coords = coords ? coords.slice() : [0, 0, 0];\n\n\t\t// Clamp alpha to [0, 1]\n\t\tthis.alpha = alpha > 1 || alpha === undefined ? 1 : (alpha < 0 ? 0 : alpha);\n\n\t\t// Convert \"NaN\" to NaN\n\t\tfor (let i = 0; i < this.coords.length; i++) {\n\t\t\tif (this.coords[i] === \"NaN\") {\n\t\t\t\tthis.coords[i] = NaN;\n\t\t\t}\n\t\t}\n\n\t\t// Define getters and setters for each coordinate\n\t\tfor (let id in this.space.coords) {\n\t\t\tObject.defineProperty(this, id, {\n\t\t\t\tget: () => this.get(id),\n\t\t\t\tset: value => this.set(id, value),\n\t\t\t});\n\t\t}\n\t}\n\n\tget spaceId () {\n\t\treturn this.space.id;\n\t}\n\n\tclone () {\n\t\treturn new Color(this.space, this.coords, this.alpha);\n\t}\n\n\ttoJSON () {\n\t\treturn {\n\t\t\tspaceId: this.spaceId,\n\t\t\tcoords: this.coords,\n\t\t\talpha: this.alpha,\n\t\t};\n\t}\n\n\tdisplay (...args) {\n\t\tlet ret = display(this, ...args);\n\n\t\t// Convert color object to Color instance\n\t\tret.color = new Color(ret.color);\n\n\t\treturn ret;\n\t}\n\n\t/**\n\t * Get a color from the argument passed\n\t * Basically gets us the same result as new Color(color) but doesn't clone an existing color object\n\t */\n\tstatic get (color, ...args) {\n\t\tif (color instanceof Color) {\n\t\t\treturn color;\n\t\t}\n\n\t\treturn new Color(color, ...args);\n\t}\n\n\tstatic defineFunction (name, code, o = code) {\n\t\tlet {instance = true, returns} = o;\n\n\t\tlet func = function (...args) {\n\t\t\tlet ret = code(...args);\n\n\t\t\tif (returns === \"color\") {\n\t\t\t\tret = Color.get(ret);\n\t\t\t}\n\t\t\telse if (returns === \"function<color>\") {\n\t\t\t\tlet f = ret;\n\t\t\t\tret = function (...args) {\n\t\t\t\t\tlet ret = f(...args);\n\t\t\t\t\treturn Color.get(ret);\n\t\t\t\t};\n\t\t\t\t// Copy any function metadata\n\t\t\t\tObject.assign(ret, f);\n\t\t\t}\n\t\t\telse if (returns === \"array<color>\") {\n\t\t\t\tret = ret.map(c => Color.get(c));\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t};\n\n\t\tif (!(name in Color)) {\n\t\t\tColor[name] = func;\n\t\t}\n\n\t\tif (instance) {\n\t\t\tColor.prototype[name] = function (...args) {\n\t\t\t\treturn func(this, ...args);\n\t\t\t};\n\t\t}\n\t}\n\n\tstatic defineFunctions (o) {\n\t\tfor (let name in o) {\n\t\t\tColor.defineFunction(name, o[name], o[name]);\n\t\t}\n\t}\n\n\tstatic extend (exports) {\n\t\tif (exports.register) {\n\t\t\texports.register(Color);\n\t\t}\n\t\telse {\n\t\t\t// No register method, just add the module's functions\n\t\t\tfor (let name in exports) {\n\t\t\t\tColor.defineFunction(name, exports[name]);\n\t\t\t}\n\t\t}\n\t}\n}\n\nColor.defineFunctions({\n\tget,\n\tgetAll,\n\tset,\n\tsetAll,\n\tto,\n\tequals,\n\tinGamut,\n\ttoGamut,\n\tdistance,\n\ttoString: serialize,\n});\n\nObject.assign(Color, {\n\tutil,\n\thooks,\n\tWHITES,\n\tSpace: ColorSpace,\n\tspaces: ColorSpace.registry,\n\tparse,\n\n\t// Global defaults one may want to configure\n\tdefaults,\n});\n\nfor (let key of Object.keys(spaces)) {\n\tColorSpace.register(spaces[key]);\n}\n\n/**\n * This plugin defines getters and setters for color[spaceId]\n * e.g. color.lch on *any* color gives us the lch coords\n */\n\n// Add space accessors to existing color spaces\nfor (let id in ColorSpace.registry) {\n\taddSpaceAccessors(id, ColorSpace.registry[id]);\n}\n\n// Add space accessors to color spaces not yet created\nhooks.add(\"colorspace-init-end\", space => {\n\taddSpaceAccessors(space.id, space);\n\tspace.aliases?.forEach(alias => {\n\t\taddSpaceAccessors(alias, space);\n\t});\n});\n\nfunction addSpaceAccessors (id, space) {\n\tlet propId = id.replace(/-/g, \"_\");\n\n\tObject.defineProperty(Color.prototype, propId, {\n\t\t// Convert coords to coords in another colorspace and return them\n\t\t// Source colorspace: this.spaceId\n\t\t// Target colorspace: id\n\t\tget () {\n\t\t\tlet ret = this.getAll(id);\n\n\t\t\tif (typeof Proxy === \"undefined\") {\n\t\t\t\t// If proxies are not supported, just return a static array\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\t// Enable color.spaceId.coordName syntax\n\t\t\treturn new Proxy(ret, {\n\t\t\t\thas: (obj, property) => {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tColorSpace.resolveCoord([space, property]);\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\tcatch (e) {}\n\n\t\t\t\t\treturn Reflect.has(obj, property);\n\t\t\t\t},\n\t\t\t\tget: (obj, property, receiver) => {\n\t\t\t\t\tif (property && typeof property !== \"symbol\" && !(property in obj)) {\n\t\t\t\t\t\tlet {index} = ColorSpace.resolveCoord([space, property]);\n\n\t\t\t\t\t\tif (index >= 0) {\n\t\t\t\t\t\t\treturn obj[index];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn Reflect.get(obj, property, receiver);\n\t\t\t\t},\n\t\t\t\tset: (obj, property, value, receiver) => {\n\t\t\t\t\tif (property && typeof property !== \"symbol\" && !(property in obj) || property >= 0) {\n\t\t\t\t\t\tlet {index} = ColorSpace.resolveCoord([space, property]);\n\n\t\t\t\t\t\tif (index >= 0) {\n\t\t\t\t\t\t\tobj[index] = value;\n\n\t\t\t\t\t\t\t// Update color.coords\n\t\t\t\t\t\t\tthis.setAll(id, obj);\n\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn Reflect.set(obj, property, value, receiver);\n\t\t\t\t},\n\t\t\t});\n\t\t},\n\t\t// Convert coords in another colorspace to internal coords and set them\n\t\t// Target colorspace: this.spaceId\n\t\t// Source colorspace: id\n\t\tset (coords) {\n\t\t\tthis.setAll(id, coords);\n\t\t},\n\t\tconfigurable: true,\n\t\tenumerable: true,\n\t});\n}\n\n// Import all modules of Color.js\n\nColor.extend(deltaEMethods);\nColor.extend({deltaE});\nObject.assign(Color, {deltaEMethods});\nColor.extend(variations);\nColor.extend({contrast});\nColor.extend(chromaticity);\nColor.extend(luminance);\nColor.extend(interpolation);\nColor.extend(contrastMethods);\n\n\n//# sourceMappingURL=color.js.map\n\n\n//# sourceURL=webpack://bb-plugin/./node_modules/colorjs.io/dist/color.js?\n}");

/***/ }),

/***/ "./src/FL/Builder/system/ui/i18n/index.js":
/*!************************************************!*\
  !*** ./src/FL/Builder/system/ui/i18n/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   __: () => (/* binding */ __)\n/* harmony export */ });\n/**\n * @since 2.8\n * @param {String} string\n * @return {String}\n */\nfunction __(string) {\n  if (typeof window.parent.FLBuilderStrings === 'undefined') {\n    return string;\n  }\n  var strings = window.parent.FLBuilderStrings.i18n;\n  if (typeof strings[string] !== 'undefined') {\n    return strings[string];\n  } else {\n    console.warn('No translation found for \"' + string + '\" Please add string to FLBuilderStrings.i18n object in includes/ui-js-config.php');\n    return string;\n  }\n}\n\n//# sourceURL=webpack://bb-plugin/./src/FL/Builder/system/ui/i18n/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/gallery/builtin.js":
/*!******************************************************************!*\
  !*** ./src/FL/controls/components/background/gallery/builtin.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\nconst builtin = [{\n  value: [{\n    id: 1,\n    type: 'color',\n    state: {\n      color: 'hwb(169 0% 0% / 0.44)'\n    }\n  }, {\n    id: 2,\n    type: 'image',\n    state: {\n      repeat: 'no-repeat',\n      size: 'cover',\n      url: 'https://images.unsplash.com/photo-1720180320326-7697b073241b?w=500&auto=format&fit=crop&q=60&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxmZWF0dXJlZC1waG90b3MtZmVlZHwxMTJ8fHxlbnwwfHx8fHw%3D'\n    }\n  }]\n}, {\n  value: [{\n    id: 1,\n    type: 'gradient',\n    state: {\n      angle: 45,\n      colorSpace: 'oklch',\n      type: 'linear',\n      stops: [{\n        from: 0,\n        color: \"purple\"\n      }, {\n        from: 50,\n        color: \"transparent\"\n      }, {\n        from: 100,\n        color: \"skyblue\"\n      }]\n    }\n  }]\n}, {\n  value: [{\n    id: 1,\n    type: 'gradient',\n    state: {\n      angle: 0,\n      colorSpace: 'oklch',\n      type: 'radial',\n      stops: [{\n        from: 0,\n        color: \"hwb(76 0% 0% )\"\n      }, {\n        from: 100,\n        color: \"hwb(187 0% 0% )\"\n      }]\n    }\n  }]\n}, {\n  value: [{\n    id: 1,\n    type: 'color',\n    state: {\n      color: 'hwb(79 0% 0% / 0.77)'\n    }\n  }]\n}, {\n  value: [{\n    id: 1,\n    type: 'color',\n    state: {\n      color: 'hwb(320 0% 0% / 0.51)'\n    }\n  }]\n}];\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (builtin);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/gallery/builtin.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/gallery/index.js":
/*!****************************************************************!*\
  !*** ./src/FL/controls/components/background/gallery/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../state */ \"./src/FL/controls/state/index.js\");\n/* harmony import */ var _series_definitions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../series-definitions */ \"./src/FL/controls/components/background/series-definitions/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils */ \"./src/FL/controls/components/background/utils.js\");\n/* harmony import */ var _builtin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./builtin */ \"./src/FL/controls/components/background/gallery/builtin.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/background/gallery/style.scss\");\n\n\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst getCSS = value => (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getCSSForLayers)(value, _series_definitions__WEBPACK_IMPORTED_MODULE_3__[\"default\"]);\nconst BackgroundGallery = ({\n  setBackground,\n  current = []\n}) => {\n  const {\n    backgroundPresets = [],\n    addBackgroundPreset\n  } = (0,_state__WEBPACK_IMPORTED_MODULE_2__.useControlsStore)();\n  const showBuiltins = true;\n  return /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_1__.Dialog.Button, {\n    label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Gallery', 'fl-builder'),\n    dialogProps: {\n      className: \"fl-control fl-controls-background-gallery-dialog\"\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    className: \"bg-gallery-grid\",\n    style: {\n      width: 400,\n      height: 600\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1',\n      display: 'flex',\n      gap: 8\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      fontSize: 20,\n      flexGrow: 1\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Background Gallery', 'fl-builder')), /*#__PURE__*/React.createElement(\"button\", {\n    className: \"fl-control fl-controls-button\",\n    onClick: () => addBackgroundPreset(current)\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save Current', 'fl-builder'))), 0 < backgroundPresets.length && /*#__PURE__*/React.createElement(\"div\", {\n    className: \"bg-gallery-section\"\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    className: \"bg-gallery-section-title\"\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Saved Backgrounds', 'fl-builder')), backgroundPresets.map((value, i) => {\n    const background = getCSS(value, _series_definitions__WEBPACK_IMPORTED_MODULE_3__[\"default\"]);\n    return /*#__PURE__*/React.createElement(\"div\", {\n      key: i,\n      className: \"bg-gallery-item\"\n    }, /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_1__.Color.Swatch, {\n      style: {\n        '--size': 'auto',\n        aspectRatio: '3/2',\n        display: 'flex'\n      },\n      onClick: e => {\n        setBackground(value);\n        e.stopPropagation();\n      }\n    }, /*#__PURE__*/React.createElement(\"div\", {\n      style: {\n        background\n      }\n    })));\n  })), showBuiltins && /*#__PURE__*/React.createElement(\"div\", {\n    className: \"bg-gallery-section\"\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    className: \"bg-gallery-section-title\"\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Preset Backgrounds', 'fl-builder')), _builtin__WEBPACK_IMPORTED_MODULE_5__[\"default\"].map(({\n    value\n  }, i) => {\n    const background = getCSS(value, _series_definitions__WEBPACK_IMPORTED_MODULE_3__[\"default\"]);\n    return /*#__PURE__*/React.createElement(\"div\", {\n      key: i,\n      className: \"bg-gallery-item\"\n    }, /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_1__.Color.Swatch, {\n      style: {\n        '--size': 'auto',\n        aspectRatio: '3/2',\n        display: 'flex'\n      },\n      onClick: e => {\n        setBackground(value);\n        e.stopPropagation();\n      }\n    }, /*#__PURE__*/React.createElement(\"div\", {\n      style: {\n        background\n      }\n    })));\n  }))));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BackgroundGallery);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/gallery/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/gallery/style.scss":
/*!******************************************************************!*\
  !*** ./src/FL/controls/components/background/gallery/style.scss ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/gallery/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/index.js":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/background/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Input: () => (/* binding */ Input),\n/* harmony export */   getCSS: () => (/* binding */ getCSS)\n/* harmony export */ });\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../series */ \"./src/FL/controls/components/series/index.js\");\n/* harmony import */ var _series_definitions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./series-definitions */ \"./src/FL/controls/components/background/series-definitions/index.js\");\n/* harmony import */ var _gallery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./gallery */ \"./src/FL/controls/components/background/gallery/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ \"./src/FL/controls/components/background/utils.js\");\n\n\n\n\n\nconst getCSS = value => (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getCSSForLayers)(value, _series_definitions__WEBPACK_IMPORTED_MODULE_2__[\"default\"]);\nconst Empty = () => /*#__PURE__*/React.createElement(\"div\", {\n  className: \"fl-series-empty\"\n}, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Click + to add layers', 'fl-builder'));\n\n/**\n * Main Background Component\n */\nconst Input = ({\n  value: _value = [],\n  onChange = () => {}\n}) => {\n  const value = Array.isArray(_value) ? _value : [];\n\n  // pass to toolbarItems\n  const toolbar = /*#__PURE__*/React.createElement(_gallery__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    current: value,\n    setBackground: onChange\n  });\n  return /*#__PURE__*/React.createElement(_series__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    items: value,\n    setItems: onChange,\n    definitions: _series_definitions__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n    appendNewItems: \"before\",\n    empty: Empty,\n    toolbarItems: null\n  });\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/color.js":
/*!***************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/color.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../series */ \"./src/FL/controls/components/series/index.js\");\n/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../input */ \"./src/FL/controls/components/input/index.js\");\n/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./default */ \"./src/FL/controls/components/background/series-definitions/default.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  ..._default__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Color', 'fl-builder'),\n  createItem: item => ({\n    ...item,\n    state: {\n      color: 'deepskyblue'\n    }\n  }),\n  getCSS: ({\n    state\n  }) => `linear-gradient(${state.color}, ${state.color})`,\n  content: ({\n    state,\n    setState\n  }) => {\n    const CustomPickerButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n      showReset,\n      ...rest\n    }, ref) => {\n      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_series__WEBPACK_IMPORTED_MODULE_2__.TitleCard, _extends({\n        ref: ref,\n        as: \"button\",\n        style: {\n          paddingLeft: 20\n        },\n        title: state.color ? state.color : 'Choose Color...',\n        thumbProps: {\n          style: {\n            backgroundColor: state.color\n          }\n        }\n      }, rest));\n    });\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      type: \"color\",\n      value: state.color,\n      onChange: value => setState({\n        color: value\n      }),\n      buttonComponent: CustomPickerButton\n    });\n  }\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/color.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/default.js":
/*!*****************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/default.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ \"./src/FL/controls/components/background/utils.js\");\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  getCSS: ({\n    state\n  }) => (0,_utils__WEBPACK_IMPORTED_MODULE_0__.createLayerString)(state)\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/default.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/gradient/index.js":
/*!************************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/gradient/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../series */ \"./src/FL/controls/components/series/index.js\");\n/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../input */ \"./src/FL/controls/components/input/index.js\");\n/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../default */ \"./src/FL/controls/components/background/series-definitions/default.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/background/series-definitions/gradient/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\n\n\nconst GradientPicker = ({\n  state,\n  setState\n}) => {\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Gradient.Input, {\n    value: state,\n    onChange: setState\n  });\n};\nconst Content = ({\n  state,\n  setState\n}) => {\n  const CustomPickerButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_series__WEBPACK_IMPORTED_MODULE_4__.TitleCard, _extends({\n      ref: ref,\n      style: {\n        paddingLeft: 20\n      },\n      title: state.type ? `${state.type} gradient` : 'Select Gradient...',\n      thumbProps: {\n        style: {\n          background: ___WEBPACK_IMPORTED_MODULE_3__.Gradient.getCSS(state)\n        }\n      }\n    }, props));\n  });\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.DialogButton, {\n    button: CustomPickerButton,\n    dialogProps: {\n      className: 'fl-controls-gradient-picker-dialog'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GradientPicker, {\n    state: state,\n    setState: setState\n  }));\n};\nconst gradient = {\n  ..._default__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Gradient', 'fl-builder'),\n  getCSS: ({\n    state\n  }) => ___WEBPACK_IMPORTED_MODULE_3__.Gradient.getCSS(state),\n  content: Content,\n  createItem: item => {\n    return {\n      ...item,\n      state: {\n        type: 'linear',\n        angle: 0,\n        colorSpace: 'oklch',\n        stops: [{\n          from: 0,\n          color: 'hwb(328 0% 10% )'\n        }, {\n          from: 100,\n          color: 'hwb(187 0% 1% )'\n        }]\n      }\n    };\n  }\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (gradient);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/gradient/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/gradient/style.scss":
/*!**************************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/gradient/style.scss ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/gradient/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/image/index.js":
/*!*********************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/image/index.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   getCSS: () => (/* binding */ getCSS)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../default */ \"./src/FL/controls/components/background/series-definitions/default.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../series */ \"./src/FL/controls/components/series/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/components/background/utils.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst defaultState = {\n  sourceType: 'media',\n  mediaAttachment: {\n    id: null,\n    url: ''\n  },\n  svg: '',\n  url: '',\n  repeat: 'repeat',\n  position: '',\n  size: '',\n  clip: '',\n  attachment: ''\n};\nconst getCSS = ({\n  state\n}) => {\n  const {\n    sourceType,\n    mediaAttachment,\n    url,\n    svg,\n    attachment,\n    repeat,\n    position,\n    size,\n    clip\n  } = {\n    ...defaultState,\n    ...state\n  };\n  let parts = [];\n  if (!url && !svg && !mediaAttachment.url) {\n    return '';\n  }\n  if (attachment && '' !== attachment) {\n    parts.push(attachment);\n  }\n  if (clip) {\n    parts.push(clip);\n  }\n\n  // URL and SVG Handling\n  let urlString = '';\n  if ('url' === sourceType && '' !== url) {\n    urlString = ` url(${url})`;\n  } else if ('media' === sourceType && mediaAttachment.url) {\n    urlString = ` url(${mediaAttachment.url})`;\n  } else if ('svg' === sourceType && '' !== svg) {\n    let _svg = svg.replaceAll('\\n', '').replaceAll('\\t', '').replaceAll('\"#', '\"%23');\n    urlString = ` url('data:image/svg+xml;utf8,${_svg}')`;\n  }\n  if (!urlString) {\n    return '';\n  }\n  parts.push(urlString);\n  if (repeat) {\n    parts.push(repeat);\n  }\n  if (position) {\n    let positionSize = position;\n    if (size) {\n      positionSize += ' / ' + size;\n    }\n    parts.push(positionSize);\n  }\n  return parts.map(part => part.trim()).join(' ');\n};\nconst Image = ({\n  state,\n  setState\n}) => {\n  const {\n    sourceType,\n    mediaAttachment,\n    svg,\n    url,\n    repeat,\n    position,\n    size,\n    clip,\n    attachment\n  } = {\n    ...defaultState,\n    ...state\n  };\n  const setSourceType = value => setState({\n    ...state,\n    sourceType: value\n  });\n  const backgroundString = getCSS({\n    state\n  }) ?? '';\n  const CustomPickerButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {\n    return /*#__PURE__*/React.createElement(_series__WEBPACK_IMPORTED_MODULE_4__.TitleCard, _extends({\n      ref: ref,\n      as: \"button\",\n      style: {\n        paddingLeft: 20\n      },\n      title: 'Photo',\n      thumbProps: {\n        style: {\n          background: backgroundString\n        }\n      }\n    }, props));\n  });\n  const types = {\n    media: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Media Library', 'fl-builder'),\n    url: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('URL', 'fl-builder'),\n    svg: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('SVG', 'fl-builder')\n  };\n  return /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.DialogButton, {\n    button: CustomPickerButton,\n    dialogProps: {\n      className: 'fl-controls-photo-picker-dialog'\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      boxSizing: 'border-box',\n      display: 'grid',\n      gridTemplateColumns: 'repeat(2, minmax(0,1fr))',\n      gap: 16,\n      width: 300,\n      height: 600,\n      padding: 16,\n      placeContent: 'start stretch',\n      overflow: 'auto'\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1'\n    }\n  }, /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Color.Swatch, {\n    style: {\n      '--size': 'auto',\n      aspectRatio: '3/2',\n      position: 'relative',\n      overflow: 'hidden'\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      position: 'absolute',\n      width: '100%',\n      height: '100%',\n      background: backgroundString\n    }\n  }))), /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-controls-button-group\",\n    style: {\n      gridColumn: '1/-1'\n    }\n  }, forEach(types, (value, label) => {\n    return /*#__PURE__*/React.createElement(\"button\", {\n      key: value,\n      className: value === sourceType ? 'is-selected' : '',\n      onClick: () => setSourceType(value)\n    }, label);\n  })), /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1',\n      display: 'grid'\n    }\n  }, 'media' === sourceType && /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Media.PickerButton, {\n    attachmentId: mediaAttachment.id,\n    url: mediaAttachment.url,\n    onSelect: meta => {\n      setState({\n        ...state,\n        mediaAttachment: {\n          id: meta.id,\n          url: meta.url\n        }\n      });\n    },\n    onSizeSelect: size => {\n      setState({\n        ...state,\n        mediaAttachment: {\n          ...state.mediaAttachment,\n          url: size.url\n        }\n      });\n    },\n    onRemove: () => {\n      setState({\n        ...state,\n        mediaAttachment: {\n          ...defaultState.mediaAttachment\n        }\n      });\n    },\n    style: {\n      height: 50\n    }\n  }), 'url' === sourceType && /*#__PURE__*/React.createElement(\"textarea\", {\n    value: url,\n    onChange: e => setState({\n      ...state,\n      url: e.target.value\n    }),\n    rows: 7,\n    style: {\n      resize: 'vertical'\n    }\n  }), 'svg' === sourceType && /*#__PURE__*/React.createElement(\"textarea\", {\n    value: svg,\n    onChange: e => setState({\n      ...state,\n      svg: e.target.value\n    }),\n    rows: 10,\n    style: {\n      resize: 'vertical'\n    }\n  })), /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-controls-grid-table\",\n    style: {\n      gridColumn: '1/-1'\n    }\n  }, /*#__PURE__*/React.createElement(\"div\", null, /*#__PURE__*/React.createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Repeat', 'fl-builder')), /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Select, {\n    value: repeat,\n    onChange: e => setState({\n      ...state,\n      repeat: e.target.value\n    }),\n    options: {\n      'no-repeat': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('No Repeat', 'fl-builder'),\n      'repeat': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Repeat', 'fl-builder'),\n      'repeat-x': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Repeat Horizonal', 'fl-builder'),\n      'repeat-y': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Repeat Vertical', 'fl-builder'),\n      'space': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Space', 'fl-builder'),\n      'round': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Round', 'fl-builder')\n    }\n  })), /*#__PURE__*/React.createElement(\"div\", null, /*#__PURE__*/React.createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Position', 'fl-builder')), /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Select, {\n    value: position,\n    onChange: e => setState({\n      ...state,\n      position: e.target.value\n    }),\n    options: {\n      'left top': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Top Left', 'fl-builder'),\n      'center top': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Top Center', 'fl-builder'),\n      'right top': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Top Right', 'fl-builder'),\n      'left center': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Center Left', 'fl-builder'),\n      'center': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Center', 'fl-builder'),\n      'right center': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Center Right', 'fl-builder'),\n      'left bottom': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Bottom Left', 'fl-builder'),\n      'center bottom': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Bottom Center', 'fl-builder'),\n      'right bottom': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Bottom Right', 'fl-builder')\n    }\n  })), /*#__PURE__*/React.createElement(\"div\", null, /*#__PURE__*/React.createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Size', 'fl-builder')), /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Select, {\n    value: size,\n    onChange: e => setState({\n      ...state,\n      size: e.target.value\n    }),\n    options: {\n      '': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Default Size', 'fl-builder'),\n      cover: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cover', 'fl-builder'),\n      contain: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Contain', 'fl-builder')\n    }\n  })), /*#__PURE__*/React.createElement(\"div\", null, /*#__PURE__*/React.createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Clip To', 'fl-builder')), /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_3__.Select, {\n    value: clip,\n    onChange: e => setState({\n      ...state,\n      clip: e.target.value\n    }),\n    options: {\n      'border-box': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Border', 'fl-builder'),\n      'padding-box': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Padding', 'fl-builder'),\n      'content-box': (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Content', 'fl-builder')\n    }\n  })))));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  ..._default__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Photo', 'fl-builder'),\n  content: Image,\n  getCSS,\n  createItem: item => {\n    return {\n      ...item,\n      state: {\n        ...defaultState,\n        ...item.state\n      }\n    };\n  }\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/image/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/index.js":
/*!***************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./color */ \"./src/FL/controls/components/background/series-definitions/color.js\");\n/* harmony import */ var _gradient__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./gradient */ \"./src/FL/controls/components/background/series-definitions/gradient/index.js\");\n/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./image */ \"./src/FL/controls/components/background/series-definitions/image/index.js\");\n/* harmony import */ var _pattern__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pattern */ \"./src/FL/controls/components/background/series-definitions/pattern/index.js\");\n\n\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  color: _color__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  gradient: _gradient__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  image: _image__WEBPACK_IMPORTED_MODULE_2__[\"default\"]\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/pattern/builtin-patterns.js":
/*!**********************************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/pattern/builtin-patterns.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   dotsOne: () => (/* binding */ dotsOne),\n/* harmony export */   rings: () => (/* binding */ rings),\n/* harmony export */   stripes: () => (/* binding */ stripes),\n/* harmony export */   sunburst: () => (/* binding */ sunburst),\n/* harmony export */   triangles: () => (/* binding */ triangles)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../input */ \"./src/FL/controls/components/input/index.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\nconst LabelWrap = ({\n  label,\n  children,\n  style,\n  ...rest\n}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n  style: {\n    display: 'grid',\n    gridTemplateColumns: '1fr 1fr',\n    gap: 8,\n    placeContent: 'center',\n    alignItems: 'center',\n    ...style\n  }\n}, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", {\n  style: {\n    margin: 0\n  }\n}, label), children);\nconst rings = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rings', 'fl-builder'),\n  defaultState: {\n    bgColor: '#000',\n    spacing: 5\n  },\n  controls: ({\n    state,\n    setStateProp\n  }) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Background', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.bgColor,\n      onChange: value => setStateProp('bgColor', value)\n    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Spacing', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.spacing,\n      onChange: e => setStateProp('spacing', e.target.value)\n    })));\n  },\n  getCSS: ({\n    bgColor = '#000',\n    spacing = 5\n  }) => {\n    const lines = spacing + 'px';\n    return `repeating-radial-gradient(circle at center,\n\t\t\t${bgColor},\n\t\t\t${lines},\n\t\t\t${bgColor},\n\t\t\t0,\n\t\t\t#0000,\n\t\t\tcalc( ${lines} * 2),\n\t\t\t#0000 0\n\t\t)`;\n  }\n};\nconst stripes = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Stripes', 'fl-builder'),\n  defaultState: {\n    color: 'transparent',\n    bgColor: 'black',\n    weight: 10,\n    angle: 45\n  },\n  controls: ({\n    state,\n    setStateProp\n  }) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Foreground', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.color,\n      onChange: value => setStateProp('color', value)\n    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Background', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.bgColor,\n      onChange: value => setStateProp('bgColor', value)\n    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Weight', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.weight,\n      onChange: e => setStateProp('weight', e.target.value)\n    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      style: {\n        display: 'grid',\n        gridTemplateColumns: '1fr 1fr',\n        gap: 16\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Angle', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.angle,\n      onChange: e => setStateProp('angle', e.target.value),\n      min: 0,\n      max: 360,\n      step: 1\n    })));\n  },\n  getCSS: ({\n    color,\n    bgColor,\n    weight,\n    angle\n  }) => {\n    const between = weight * 5 + 'px';\n    return `repeating-linear-gradient(${angle}deg, ${color}, ${color} ${weight}px, ${bgColor} ${weight}px, ${bgColor} ${between})`;\n  }\n};\nconst sunburst = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Sunburst', 'fl-builder'),\n  defaultState: {\n    color: '#000',\n    density: 5\n  },\n  controls: ({\n    state,\n    setStateProp\n  }) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Color', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.color,\n      onChange: value => setStateProp('color', value)\n    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Density', 'fl-builder'),\n      style: {\n        gridTemplateColumns: '1fr 1fr'\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.density,\n      onChange: e => setStateProp('density', e.target.value),\n      min: 0,\n      max: 10,\n      step: .5\n    }))));\n  },\n  getCSS({\n    density,\n    color\n  }) {\n    return `repeating-conic-gradient(${color} 0 ${density}%,transparent 0 10%)`;\n  }\n};\nconst dotsOne = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dots', 'fl-builder'),\n  defaultState: {\n    color: '#000',\n    size: 15,\n    spacing: 60\n  },\n  controls: ({\n    state,\n    setStateProp\n  }) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Color', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.color,\n      onChange: value => setStateProp('color', value)\n    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Size', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.size,\n      onChange: e => setStateProp('size', e.target.value),\n      min: 0,\n      max: 50,\n      step: 1\n    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Spacing', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.spacing,\n      onChange: e => setStateProp('spacing', e.target.value),\n      min: 0,\n      max: 200,\n      step: 1\n    }))));\n  },\n  getCSS({\n    color,\n    size,\n    spacing\n  }) {\n    return `radial-gradient(${color} ${size}%, transparent ${size}%) 0 0 / ${spacing}px ${spacing}px,\n\t\t\t\tradial-gradient(${color} ${size}%, transparent ${size}%) ${spacing / 2}px ${spacing / 2}px / ${spacing}px ${spacing}px`;\n  }\n};\nconst triangles = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Triangles', 'fl-builder'),\n  defaultState: {\n    angle: 115,\n    size: 30,\n    color: 'black'\n  },\n  controls: ({\n    state,\n    setStateProp\n  }) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Color', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"color\",\n      value: state.color,\n      onChange: value => setStateProp('color', value)\n    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Size', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.size,\n      onChange: e => setStateProp('size', e.target.value),\n      min: 0,\n      max: 200,\n      step: 1\n    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LabelWrap, {\n      label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Angle', 'fl-builder')\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: \"range\",\n      value: state.angle,\n      onChange: e => setStateProp('angle', e.target.value),\n      min: 0,\n      max: 360,\n      step: 1\n    }))));\n  },\n  getCSS({\n    color,\n    size\n  }) {\n    const bgSize = `${size / 2}px ${size}px`;\n    return `linear-gradient(115deg, transparent 75%, ${color} 75%) 0 0 / ${bgSize},\n\t\t\t\t\t linear-gradient(245deg, transparent 75%, ${color} 75%) 0 0 / ${bgSize},\n\t\t\t\t\t linear-gradient(115deg, transparent 75%, ${color} 75%) ${size / 4}px -${size / 2}px / ${bgSize},\n\t\t\t\t\t linear-gradient(245deg, transparent 75%, ${color} 75%) ${size / 4}px -${size / 2}px / ${bgSize}`;\n  }\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/pattern/builtin-patterns.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/series-definitions/pattern/index.js":
/*!***********************************************************************************!*\
  !*** ./src/FL/controls/components/background/series-definitions/pattern/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ \"@wordpress/i18n\");\n/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../default */ \"./src/FL/controls/components/background/series-definitions/default.js\");\n/* harmony import */ var _builtin_patterns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./builtin-patterns */ \"./src/FL/controls/components/background/series-definitions/pattern/builtin-patterns.js\");\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst defaultPattern = {\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Unnamed Pattern', 'fl-builder'),\n  defaultState: {},\n  controls: () => null,\n  getCSS: () => ''\n};\nconst firstPatternKey = Object.keys(_builtin_patterns__WEBPACK_IMPORTED_MODULE_4__)[0];\nconst getPattern = (name = firstPatternKey) => _builtin_patterns__WEBPACK_IMPORTED_MODULE_4__[name] ?? defaultPattern;\nconst Pattern = ({\n  state: _state = {},\n  setState\n}) => {\n  const pattern = _state?.pattern ?? firstPatternKey;\n  const {\n    controls: PatternControls,\n    defaultState\n  } = getPattern(pattern);\n  const state = {\n    ...defaultState,\n    ..._state,\n    pattern\n  };\n  const setStateProp = (name, value) => setState({\n    ...state,\n    [name]: value\n  });\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      padding: '16px',\n      gap: 8,\n      display: 'flex',\n      flexDirection: 'column'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"select\", {\n    value: pattern,\n    onChange: e => setStateProp('pattern', e.target.value)\n  }, forEach(_builtin_patterns__WEBPACK_IMPORTED_MODULE_4__, (key, {\n    label\n  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"option\", {\n    key: key,\n    value: key\n  }, label))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'flex',\n      gap: 16,\n      overflow: 'auto',\n      scrollSnapType: 'x manditory'\n    }\n  }, forEach(_builtin_patterns__WEBPACK_IMPORTED_MODULE_4__, (key, {\n    label,\n    getCSS,\n    defaultState\n  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    key: key,\n    onClick: () => setStateProp('pattern', key),\n    style: {\n      flex: '0 0 160px'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      aspectRatio: '3/2',\n      background: getCSS({\n        ...defaultState\n      }),\n      boxShadow: key === pattern && 'inset 0 0 0 2px var(--fl-builder-accent-color)'\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", {\n    style: {\n      margin: 0\n    }\n  }, label)))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PatternControls, {\n    state: state,\n    setState: setState,\n    setStateProp: setStateProp\n  }));\n};\nconst label = (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pattern', 'fl-builder');\nconst image = {\n  ..._default__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  label,\n  /*\n  getTitle: ( { state } ) => {\n  \tif ( undefined !== patterns[ state.pattern ] ) {\n  \t\treturn sprintf( '%s Pattern', patterns[ state.pattern ].label )\n  \t}\n  \treturn label\n  },*/\n\n  getCSS: ({\n    state\n  }) => {\n    const {\n      getCSS = () => '',\n      defaultState = {}\n    } = getPattern(state?.pattern);\n    return getCSS({\n      ...defaultState,\n      ...state\n    });\n  }\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (image);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/series-definitions/pattern/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/background/utils.js":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/background/utils.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createLayerString: () => (/* binding */ createLayerString),\n/* harmony export */   getCSSForLayers: () => (/* binding */ getCSSForLayers),\n/* harmony export */   isShortcodeBackground: () => (/* binding */ isShortcodeBackground),\n/* harmony export */   isValidBackground: () => (/* binding */ isValidBackground)\n/* harmony export */ });\n/**\n * Background layers in css\n *\n * A layer can consist of some or all of these. Layers are separated by commas.\n * <attachment> <bg-image>\n */\nconst getCSSForLayers = (layers = [], defs) => {\n  if (!layers || 'string' === typeof layers || 0 >= layers.length) {\n    return '';\n  }\n\n  // Top to bottom\n  const strings = layers.map(layer => {\n    if (!layer || undefined === defs[layer.type]) {\n      return null;\n    }\n    const string = defs[layer.type].getCSS(layer);\n    if (isShortcodeBackground(string)) {\n      FLBuilder.preview?.delayPreview();\n      return string.trim();\n    }\n    return isValidBackground(string) ? string.trim() : null;\n  });\n  return strings.filter(str => null !== str).join(', ');\n};\n\n/**\n * Convert data to background strings\n *\n * @param Object || Array<Object> || String\n * @return string\n */\nconst createLayerString = obj => {\n  let parts = [];\n  const layer = {\n    image: '',\n    attachment: '',\n    position: '',\n    size: '',\n    ...obj\n  };\n\n  // Allow single layer to return multiple layer objects as array\n  if (Array.isArray(obj)) {\n    return obj.map(createLayerString).join(', \\n\\t');\n\n    // allow pre-rendered css background strings\n  } else if ('string' === typeof obj) {\n    return obj;\n\n    // Convert object to string parts\n  } else {\n    const attachments = ['fixed', 'scroll', 'local'];\n    if (attachments.includes(layer.attachment)) {\n      parts.push(layer.attachment);\n    }\n    if ('' !== layer.image) {\n      parts.push(layer.image);\n    }\n    if ('' !== layer.position && '' === layer.size) {\n      parts.push(layer.position);\n    }\n\n    /*\n    if ( '' !== layer.size ) {\n    \tparts.push( layer.size )\n    }*/\n  }\n  const repeatValues = ['repeat', 'no-repeat', 'space', 'round', 'repeat-x', 'repeat-y'];\n  if ('' !== layer.repeat && repeatValues.includes(layer.repeat)) {\n    parts.push(layer.repeat);\n  }\n  return parts.join(' ');\n};\nconst isValidBackground = value => CSS.supports('background', value);\nconst isShortcodeBackground = string => /\\[([^\\]]+)\\]/.test(string);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/background/utils.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/data-provider/context.js":
/*!*******************************************************************!*\
  !*** ./src/FL/controls/components/color/data-provider/context.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ColorPickerContext: () => (/* binding */ ColorPickerContext),\n/* harmony export */   useColor: () => (/* binding */ useColor)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\nconst ColorPickerContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();\nconst useColor = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ColorPickerContext);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/data-provider/context.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/data-provider/index.js":
/*!*****************************************************************!*\
  !*** ./src/FL/controls/components/color/data-provider/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ColorProvider: () => (/* reexport safe */ _provider__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n/* harmony export */   useColor: () => (/* reexport safe */ _context__WEBPACK_IMPORTED_MODULE_0__.useColor)\n/* harmony export */ });\n/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./context */ \"./src/FL/controls/components/color/data-provider/context.js\");\n/* harmony import */ var _provider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./provider */ \"./src/FL/controls/components/color/data-provider/provider.js\");\n\n\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/data-provider/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/data-provider/provider.js":
/*!********************************************************************!*\
  !*** ./src/FL/controls/components/color/data-provider/provider.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context */ \"./src/FL/controls/components/color/data-provider/context.js\");\n\n\nconst ColorPickerProvider = ({\n  value = '',\n  onChange = () => {},\n  children\n}) => {\n  const [rawValue, setRawValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);\n  const isValid = CSS.supports('color', value);\n  const api = {\n    isValid,\n    rawValue: rawValue,\n    setValue: v => {\n      setRawValue(v);\n      onChange(v);\n    }\n  };\n\n  // Sync with external prop.value changes\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    rawValue !== value && setRawValue(value);\n  }, [value]);\n  return /*#__PURE__*/React.createElement(_context__WEBPACK_IMPORTED_MODULE_1__.ColorPickerContext.Provider, {\n    value: api\n  }, children);\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColorPickerProvider);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/data-provider/provider.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/index.js":
/*!***************************************************!*\
  !*** ./src/FL/controls/components/color/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Picker: () => (/* binding */ Picker),\n/* harmony export */   Provider: () => (/* binding */ Provider),\n/* harmony export */   Swatch: () => (/* reexport safe */ _ui_swatch__WEBPACK_IMPORTED_MODULE_4__[\"default\"]),\n/* harmony export */   getComputedValue: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_6__.getComputedValue),\n/* harmony export */   getMetadata: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_6__.getMetadata),\n/* harmony export */   use: () => (/* binding */ use)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dialog */ \"./src/FL/controls/components/dialog/index.js\");\n/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ui */ \"./src/FL/controls/components/color/ui/index.js\");\n/* harmony import */ var _ui_swatch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ui/swatch */ \"./src/FL/controls/components/color/ui/swatch.js\");\n/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./data-provider */ \"./src/FL/controls/components/color/data-provider/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils */ \"./src/FL/controls/components/color/utils/index.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/color/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\n\n\n\n\n// Allows other scripts to do Color.use()\nconst use = _data_provider__WEBPACK_IMPORTED_MODULE_5__.useColor;\n\n// <Color.Provider />\nconst Provider = _data_provider__WEBPACK_IMPORTED_MODULE_5__.ColorProvider;\nconst SwatchButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  showReset = true,\n  style = {},\n  ...rest\n}, ref) => {\n  const {\n    rawValue,\n    setValue\n  } = (0,_data_provider__WEBPACK_IMPORTED_MODULE_5__.useColor)();\n  const hasValue = '' !== rawValue;\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n    className: \"fl-controls-color-input\",\n    ref: ref,\n    style: {\n      '--radius': 'var(--fl-controls-radius)',\n      '--size': '36px',\n      display: 'flex',\n      height: 'var(--size)',\n      ...style\n    }\n  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ui_swatch__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n    value: rawValue,\n    as: \"button\",\n    style: {\n      '--radius': 'inherit',\n      flexGrow: 1,\n      width: 'auto',\n      height: 'auto',\n      borderTopRightRadius: hasValue && showReset ? 0 : null,\n      borderBottomRightRadius: hasValue && showReset ? 0 : null\n    }\n  }), true === showReset && hasValue && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    onClick: e => {\n      setValue('');\n      e.stopPropagation();\n    },\n    style: {\n      padding: 0,\n      width: 24,\n      display: 'grid',\n      placeContent: 'center',\n      border: '1px solid var(--fl-controls-outline-color)',\n      borderLeft: 'none',\n      borderTopLeftRadius: 0,\n      borderBottomLeftRadius: 0,\n      borderTopRightRadius: 'var(--radius)',\n      borderBottomRightRadius: 'var(--radius)',\n      backgroundColor: 'var(--fl-controls-platter-bg-color)'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_1__.Close, null)));\n});\nconst ColorDialogButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  buttonComponent: Component = SwatchButton,\n  showReset = true,\n  filterTabs,\n  defaultTab,\n  onConnect,\n  buttonProps = {}\n}, ref) => {\n  const {\n    rawValue\n  } = (0,_data_provider__WEBPACK_IMPORTED_MODULE_5__.useColor)();\n  const sourceColor = '' !== rawValue ? rawValue : 'grey';\n  const accentColor = `color-mix( in srgb, grey 30%, color-mix( in srgb-linear, black 40%, ${sourceColor} ) )`;\n  const platterFgColor = `color-mix( in srgb, grey 50%, color-mix( in srgb-linear, black 82%, ${sourceColor} ) )`;\n  const platterBgColor = `color-mix( in srgb-linear, var(--fl-controls-platter-bg-color) 70%, ${sourceColor} )`;\n  const platterFocusBgColor = `color-mix( in srgb-linear, var(--fl-controls-platter-bg-color) 70%, ${sourceColor} )`;\n  const outlineColor = `color-mix( in srgb, var(--fl-controls-outline-color) 88%, ${sourceColor} )`;\n  const isColor = v => CSS.supports('color', v);\n  const colorStyleVars = {\n    '--accent-color': isColor(accentColor) ? accentColor : null,\n    '--platter-bg-color': isColor(platterBgColor) ? platterBgColor : null,\n    '--platter-fg-color': isColor(platterFgColor) ? platterFgColor : null,\n    '--platter-focus-bg-color': isColor(platterFocusBgColor) ? platterFocusBgColor : null,\n    '--outline-color': isColor(outlineColor) ? outlineColor : null\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dialog__WEBPACK_IMPORTED_MODULE_2__.DialogButton, {\n    button: Component,\n    buttonProps: {\n      ...buttonProps,\n      showReset\n    },\n    ref: ref\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      ...colorStyleVars,\n      '--bar-size': '44px',\n      '--panel-size': '300px',\n      width: 'var(--panel-size)',\n      background: 'var(--bg-color)',\n      display: 'grid',\n      gridTemplateRows: 'var(--bar-size) minmax( 0, calc( var(--panel-size) + var(--bar-size) ) ) var(--bar-size)',\n      borderRadius: 'var(--radius)'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ui__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    filterTabs: filterTabs,\n    defaultTab: defaultTab,\n    onConnect: onConnect\n  })));\n});\n\n/**\n * Color Picker Button Component\n */\nconst Picker = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  value,\n  onChange = () => {},\n  ...rest\n}, ref) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_data_provider__WEBPACK_IMPORTED_MODULE_5__.ColorProvider, {\n  value: value,\n  onChange: onChange\n}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ColorDialogButton, _extends({\n  ref: ref\n}, rest))));\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/style.scss":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/color/style.scss ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/color-area.js":
/*!***********************************************************!*\
  !*** ./src/FL/controls/components/color/ui/color-area.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils */ \"./src/FL/controls/utils/index.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\nconst ColorArea = ({\n  style,\n  value = [0, 0],\n  onChange = () => {},\n  thumbStyle = {},\n  onPointerDown = () => {},\n  onPointerUp = () => {},\n  ...rest\n}) => {\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const thumb = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const rAF = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const [isDown, setIsDown] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const calculateValues = e => {\n    if (rAF.current) {\n      cancelAnimationFrame(rAF.current);\n    }\n\n    // Only perform the calc once per frame\n    rAF.current = requestAnimationFrame(() => {\n      // Pointer position relative to document\n      const pageX = 'number' === typeof e.pageX ? e.pageX : e.touches[0].pageX;\n      const pageY = 'number' === typeof e.pageY ? e.pageY : e.touches[0].pageY;\n\n      // Element position (relative to viewport)\n      const bounds = ref.current.getBoundingClientRect();\n\n      // Factor in page offset in case of scroll\n      const x = pageX - (bounds.left + window.top.pageXOffset);\n      const y = pageY - (bounds.top + window.top.pageYOffset);\n\n      // Get percentage x/y within container bounds\n      const xPercent = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.mapNumRange)((0,_utils__WEBPACK_IMPORTED_MODULE_1__.clamp)(x, 0, bounds.width), 0, bounds.width, 0, 100);\n      const yPercent = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.mapNumRange)((0,_utils__WEBPACK_IMPORTED_MODULE_1__.clamp)(y, 0, bounds.height), 0, bounds.height, 0, 100);\n      const coords = [Math.round(xPercent), Math.round(yPercent)];\n      if (coords[0] !== value[0] || coords[1] !== value[1]) {\n        onChange(coords, {\n          container: ref.current,\n          rect: bounds,\n          page: [pageX, pageY],\n          xy: [pageX - bounds.left, pageY - bounds.top],\n          percent: coords\n        });\n      }\n    });\n  };\n  const onDown = e => {\n    onPointerDown();\n    e.preventDefault();\n    setIsDown(true);\n    calculateValues(e);\n  };\n  const onUp = () => {\n    onPointerUp();\n    setIsDown(false);\n  };\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    const onMove = e => isDown && calculateValues(e);\n    const win = window.top;\n    win.addEventListener('pointermove', onMove);\n    win.addEventListener('pointerup', onUp);\n    return () => {\n      win.removeEventListener('pointermove', onMove);\n      win.removeEventListener('pointerup', onUp);\n    };\n  }, [isDown]);\n  return /*#__PURE__*/React.createElement(\"div\", _extends({\n    ref: ref,\n    onPointerDown: onDown,\n    style: {\n      boxSizing: 'border-box',\n      aspectRatio: '3/2',\n      background: 'grey',\n      position: 'relative',\n      ...style\n    }\n  }, rest), /*#__PURE__*/React.createElement(\"button\", {\n    ref: thumb,\n    className: \"fl-control fl-controls-drag-thumb\",\n    onPointerDown: onDown,\n    style: {\n      boxSizing: 'border-box',\n      ...thumbStyle,\n      left: `${value[0]}%`,\n      top: `${value[1]}%`\n    }\n  }));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColorArea);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/color-area.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/eyedropper.js":
/*!***********************************************************!*\
  !*** ./src/FL/controls/components/color/ui/eyedropper.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_2__);\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n/**\n * Not all browsers support the EyeDropper API\n * Also a site must be served via SSL/HTTPS for eyedropper functionality\n * See https://developer.mozilla.org/en-US/docs/Web/API/EyeDropper_API\n */\nconst EyeDropperButton = ({\n  className,\n  onChange = () => {},\n  ...rest\n}) => {\n  const [isActive, setIsActive] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  if (undefined === window.EyeDropper) {\n    return null;\n  }\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", _extends({\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('fl-controls-color-eyedropper', className),\n    onClick: async () => {\n      const eyeDropper = new EyeDropper();\n      const result = await eyeDropper.open();\n      if (result.sRGBHex) {\n        onChange(result.sRGBHex);\n      }\n    }\n  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_2__.Crosshair, null));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EyeDropperButton);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/eyedropper.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/index.js":
/*!******************************************************!*\
  !*** ./src/FL/controls/components/color/ui/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../state */ \"./src/FL/controls/state/index.js\");\n/* harmony import */ var _eyedropper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./eyedropper */ \"./src/FL/controls/components/color/ui/eyedropper.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _swatch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./swatch */ \"./src/FL/controls/components/color/ui/swatch.js\");\n/* harmony import */ var _tab_srgb__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./tab-srgb */ \"./src/FL/controls/components/color/ui/tab-srgb.js\");\n/* harmony import */ var _tab_mix__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./tab-mix */ \"./src/FL/controls/components/color/ui/tab-mix.js\");\n/* harmony import */ var _tab_presets__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./tab-presets */ \"./src/FL/controls/components/color/ui/tab-presets.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/color/ui/style.scss\");\n\n\n\n\n\n\n\n\n\n\n\nconst availableTabs = {\n  srgb: _tab_srgb__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n  mix: _tab_mix__WEBPACK_IMPORTED_MODULE_8__[\"default\"],\n  presets: _tab_presets__WEBPACK_IMPORTED_MODULE_9__[\"default\"]\n};\nconst Picker = ({\n  filterTabs = () => true,\n  defaultTab = 'srgb',\n  placeholderText = '#123123...',\n  onConnect\n}) => {\n  const {\n    rawValue = '',\n    setValue\n  } = ___WEBPACK_IMPORTED_MODULE_5__.Color.use();\n\n  // Process tabs\n  let tabs = {};\n  const tabKeys = Object.keys(availableTabs).filter(filterTabs);\n  for (let key in availableTabs) {\n    if (tabKeys.includes(key)) {\n      tabs[key] = availableTabs[key];\n    }\n  }\n  const [visibleTab, setVisibleTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultTab);\n  const [isPresetSaved, setIsPresetSaved] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const TabContent = tabs[visibleTab].content;\n  const {\n    addColorPreset\n  } = (0,_state__WEBPACK_IMPORTED_MODULE_3__.useControlsStore)();\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-color-picker-toolbar\",\n    style: {\n      gridArea: '1/1/span 1/-1',\n      display: 'flex',\n      borderTopRightRadius: 'var(--radius)',\n      borderTopLeftRadius: 'var(--radius)',\n      paddingLeft: undefined === window.EyeDropper ? 8 : null\n    }\n  }, window.EyeDropper && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      height: 'var(--bar-size)',\n      aspectRatio: '1/1',\n      display: 'grid',\n      placeContent: 'center'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_eyedropper__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n    onChange: v => {\n      setValue(v);\n      setVisibleTab(defaultTab);\n    }\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"picker-input-wrap\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n    value: rawValue,\n    style: {\n      borderRadius: '50%'\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    autoFocus: true,\n    type: \"text\",\n    value: rawValue,\n    onInput: e => setValue(e.target.value),\n    placeholder: placeholderText,\n    title: rawValue\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      flex: '1 0 auto',\n      height: 'var(--bar-size)',\n      minWidth: 'var(--bar-size)',\n      display: 'grid',\n      placeContent: 'center'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    className: \"fl-control\",\n    disabled: '' === rawValue,\n    onClick: () => {\n      if ('' !== rawValue) {\n        addColorPreset(rawValue);\n        if (document.startViewTransition) {\n          document.startViewTransition(() => {\n            setIsPresetSaved(true);\n            setTimeout(() => {\n              document.startViewTransition(() => setIsPresetSaved(false));\n            }, 1000);\n          });\n        } else {\n          setIsPresetSaved(true);\n          setTimeout(() => setIsPresetSaved(false), 2000);\n        }\n      }\n    },\n    style: {\n      boxSizing: 'border-box',\n      aspectRatio: 1,\n      display: 'grid',\n      gridAutoFlow: 'column',\n      placeContent: 'center',\n      placeItems: 'center',\n      gap: 4,\n      padding: '0px 6px',\n      viewTransitionName: 'fl-controls-color-picker-saved-preset-button'\n    }\n  }, !isPresetSaved && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"svg\", {\n    width: \"20\",\n    height: \"20\",\n    viewBox: \"0 0 20 20\",\n    fill: \"none\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"path\", {\n    d: \"M15.6569 9.99999H4.34315\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"path\", {\n    d: \"M10 4.34314V15.6568\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  })), isPresetSaved && (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Saved', 'fl-builder')))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      gridArea: '2 / 1 / span 1 / -1',\n      display: 'grid'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TabContent, {\n    onConnect: onConnect\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-controls-picker-bottom-tabs\",\n    style: {\n      gridArea: 'span 1 / 1 / -1 / -1',\n      display: 'flex',\n      justifyContent: 'center',\n      background: 'var(--platter-bg-color)',\n      borderBottomLeftRadius: 'var(--radius)',\n      borderBottomRightRadius: 'var(--radius)',\n      overflow: 'hidden'\n    }\n  }, Object.entries(tabs).map(([key, {\n    label\n  }]) => {\n    const isActiveTab = key === visibleTab;\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n      key: key,\n      onClick: () => setVisibleTab(key),\n      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('fl-control', {\n        'is-selected': isActiveTab\n      }),\n      style: {\n        color: isActiveTab ? null : 'var(--fl-builder-platter-color)',\n        background: isActiveTab ? 'var(--bg-color)' : 'var(--fl-builder-platter-bg-color)'\n      }\n    }, label);\n  })));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Picker);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/style.scss":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/color/ui/style.scss ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/swatch.js":
/*!*******************************************************!*\
  !*** ./src/FL/controls/components/color/ui/swatch.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SwatchGroup: () => (/* binding */ SwatchGroup),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _utils_display__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/display */ \"./src/FL/controls/components/color/utils/display.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\nconst Swatch = ({\n  as = 'div',\n  value,\n  className,\n  style,\n  onClick,\n  children,\n  ...rest\n}) => {\n  let Tag = 'function' === typeof onClick ? 'button' : as;\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Tag, _extends({\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('fl-control', 'fl-controls-color-swatch', className),\n    style: {\n      '--color': CSS.supports('color', value) ? (0,_utils_display__WEBPACK_IMPORTED_MODULE_2__.getColorDisplayValue)(value) : null,\n      ...style\n    },\n    onClick: onClick\n  }, rest), children);\n};\nconst SwatchGroup = ({\n  as: Tag = 'div',\n  title,\n  className,\n  children,\n  appearance = 'swatches',\n  accessories,\n  ...rest\n}) => {\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Tag, _extends({\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({\n      'fl-controls-swatch-group': true,\n      [`fl-appearance-${appearance}`]: appearance\n    }, className)\n  }, rest), title && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-controls-swatch-group-heading\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", null, title), accessories), children);\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Swatch);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/swatch.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/tab-mix.js":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/color/ui/tab-mix.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ \"@wordpress/i18n\");\n/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../ */ \"./src/FL/controls/components/index.js\");\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst Mix = () => {\n  const {\n    setValue\n  } = ___WEBPACK_IMPORTED_MODULE_3__.Color.use();\n  const [colorA, setColorA] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('rgb(0, 255, 251)');\n  const [colorB, setColorB] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('rgb(254, 1, 136)');\n  const [percentA, setPercentA] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(50);\n  const [colorSpace, setColorSpace] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('lch');\n  const getValue = (a, b, percent, colorSpace) => `color-mix( in ${colorSpace}, ${a} ${percent}%, ${b})`;\n  const currentValue = getValue(colorA, colorB, percentA, colorSpace);\n  const rAF = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const colorSpaces = {\n    'srgb': 'sRGB',\n    'srgb-linear': 'Linear sRGB',\n    'oklab': 'OKLAB',\n    'lch': 'LCH',\n    'oklch': 'OKLCH'\n\n    /*'display-p3': 'Display-P3',*/\n  };\n  const swatchCount = 10;\n  const swatches = new Array(swatchCount).fill('');\n  const updateValue = value => {\n    /**\n     * Sync value setting with frames to prevent setting more than once per-frame update\n     */\n    if (rAF.current) {\n      cancelAnimationFrame(rAF.current);\n    }\n    rAF.current = requestAnimationFrame(() => setValue(value));\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateRows: `calc( 32px * ${Object.keys(colorSpaces).length} ) 1fr`\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateColumns: `repeat( ${swatchCount - 1}, 1fr)`,\n      background: 'charcoal'\n    }\n  }, Object.keys(colorSpaces).map(colorSpace => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, {\n      key: colorSpace\n    }, swatches.map((_, i) => {\n      // Skip zero cause its just the pure start color\n      if (0 === i) {\n        return null;\n      }\n      const percent = Math.round(i * (100 / swatchCount));\n      const value = getValue(colorA, colorB, percent, colorSpace);\n      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Color.Swatch, {\n        key: i,\n        className: \"mix-swatch\",\n        style: {\n          '--color': value,\n          width: 'auto',\n          height: 'auto'\n        },\n        onClick: () => {\n          setValue(value);\n          setPercentA(percent);\n          setColorSpace(colorSpace);\n        },\n        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)('%d%% Mix in %s Color Space', percent, colorSpaces[colorSpace])\n      });\n    }));\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      padding: '4px 16px',\n      display: 'grid',\n      gridAutoRows: 'var(--fl-controls-target-size)',\n      gridRow: '2 / span 4',\n      gap: 8\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      placeContent: 'center'\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mix two color values to create a new color', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateColumns: 'repeat(6, var(--fl-controls-target-size)',\n      placeContent: 'center'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Color.Picker, {\n    showReset: false,\n    filterTabs: tab => 'mix' !== tab,\n    value: colorB,\n    onChange: b => {\n      setColorB(b);\n      setValue(getValue(colorA, b, percentA, colorSpace));\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      placeContent: 'center',\n      fontSize: 24,\n      color: 'var(--accent-color)'\n    }\n  }, \"+\"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Color.Picker, {\n    showReset: false,\n    filterTabs: tab => 'mix' !== tab,\n    value: colorA,\n    onChange: a => {\n      setColorA(a);\n      setValue(getValue(a, colorB, percentA, colorSpace));\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      placeContent: 'center',\n      fontSize: 24,\n      color: 'var(--accent-color)'\n    }\n  }, \"=\"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Color.Swatch, {\n    style: {\n      '--size': 'auto',\n      '--color': currentValue,\n      gridColumn: 'span 2',\n      borderRadius: 'var(--fl-controls-radius)'\n    },\n    onClick: () => setValue(currentValue)\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", {\n    style: {\n      display: 'flex',\n      alignItems: 'center'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", {\n    style: {\n      width: '6ch'\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mix', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_3__.Slider, {\n    value: percentA,\n    onChange: e => {\n      const percent = Math.round(e.target.value);\n      setPercentA(percent);\n      updateValue(getValue(colorA, colorB, percent, colorSpace));\n    },\n    min: 0,\n    max: 100,\n    step: 0.5,\n    style: {\n      '--thumb-color': getValue(colorA, colorB, percentA, colorSpace),\n      '--track-color': `linear-gradient( in ${colorSpace} to left, ${colorA}, ${colorB} )`\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", {\n    style: {\n      width: '6ch',\n      textAlign: 'right'\n    }\n  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)('%s%%', percentA))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", {\n    style: {\n      display: 'flex',\n      alignItems: 'center',\n      gap: 8\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", {\n    style: {\n      flexShrink: 0\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Color Space', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"select\", {\n    style: {\n      flexGrow: 1\n    },\n    value: colorSpace,\n    onChange: e => {\n      const space = e.target.value;\n      setColorSpace(space);\n      setValue(getValue(colorA, colorB, percentA, space));\n    }\n  }, forEach(colorSpaces, (value, label) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"option\", {\n    key: value,\n    value: value\n  }, label))))));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Mix', 'fl-builder'),\n  content: Mix\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/tab-mix.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/tab-presets.js":
/*!************************************************************!*\
  !*** ./src/FL/controls/components/color/ui/tab-presets.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../state */ \"./src/FL/controls/state/index.js\");\n/* harmony import */ var _swatch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./swatch */ \"./src/FL/controls/components/color/ui/swatch.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../ */ \"./src/FL/controls/components/index.js\");\n\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst Presets = ({\n  onConnect\n}) => {\n  const hasConnectLogic = 'function' === typeof onConnect;\n  const {\n    colorPresets,\n    colorSets,\n    deleteColorPreset\n  } = (0,_state__WEBPACK_IMPORTED_MODULE_3__.useControlsStore)();\n  const {\n    setValue\n  } = ___WEBPACK_IMPORTED_MODULE_5__.Color.use();\n  const formatColor = value => {\n    if (!CSS.supports('color', value) && CSS.supports('color', `#${value}`)) {\n      return `#${value}`;\n    }\n    return value;\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      padding: '0 16px 16px',\n      overflow: 'auto',\n      gap: 8,\n      alignContent: 'start'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_4__.SwatchGroup, {\n    title: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Saved Colors', 'fl-builder')\n  }, 0 >= colorPresets.length && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1'\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Once you choose a color you can save it as a preset by clicking the + button above.', 'fl-builder')), 0 < colorPresets.length && colorPresets.map(value => {\n    const val = formatColor(value);\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n      key: value,\n      className: \"removable-swatch-wrap\"\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n      as: \"button\",\n      value: val,\n      onClick: () => setValue(val),\n      title: val\n    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n      className: \"remove-swatch-button\",\n      onClick: () => {\n        if (window.confirm((0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Are you sure you want to delete this preset?', 'fl-builder'))) {\n          deleteColorPreset(val);\n        }\n      },\n      style: {\n        '--color': value\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_2__.Close, null))));\n  })), hasConnectLogic && forEach(colorSets, (key, {\n    name,\n    colors\n  }) => {\n    if (0 >= colors.length) {\n      return null;\n    }\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_4__.SwatchGroup, {\n      key: key,\n      title: name,\n      appearance: \"list\"\n    }, colors.map(({\n      uid,\n      label,\n      color,\n      isGlobalColor\n    }) => {\n      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n        key: uid,\n        style: {\n          gridColumn: '1/-1',\n          display: 'grid',\n          gridTemplateColumns: 'subgrid',\n          placeItems: 'center start',\n          padding: 0,\n          background: 'none',\n          border: 'none',\n          textTransform: 'capitalize'\n        },\n        onClick: e => {\n          onConnect({\n            uid,\n            label,\n            color,\n            isGlobalColor\n          }, e);\n        }\n      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n        value: color,\n        title: label\n      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, label));\n    }));\n  }));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Presets', 'fl-builder'),\n  content: Presets\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/tab-presets.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/ui/tab-srgb.js":
/*!*********************************************************!*\
  !*** ./src/FL/controls/components/color/ui/tab-srgb.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var colorjs_io__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! colorjs.io */ \"./node_modules/colorjs.io/dist/color.js\");\n/* harmony import */ var _color_area__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./color-area */ \"./src/FL/controls/components/color/ui/color-area.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils */ \"./src/FL/controls/components/color/utils/index.js\");\n/* harmony import */ var _swatch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./swatch */ \"./src/FL/controls/components/color/ui/swatch.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\n\nconst numRange = (start, stop, step = 1) => {\n  return Array.from({\n    length: (stop - start) / step + 1\n  }, (value, index) => start + index * step);\n};\nconst stringFromHSL = (h, s, l, a) => {\n  const hue = Math.round(h);\n  const sat = Math.round(s);\n  const light = Math.round(l);\n  const alpha = Number.parseFloat(a).toFixed(2);\n  return `hsl(${hue} ${sat}% ${light}% ${1 > alpha ? '/ ' + alpha : ''})`;\n};\nfunction hsv2hsl(hsvH, hsvS, hsvV) {\n  const hslL = (200 - hsvS) * hsvV / 100;\n  const [hslS, hslV] = [0 === hslL || 200 === hslL ? 0 : hsvS * hsvV / 100 / (100 >= hslL ? hslL : 200 - hslL) * 100, hslL * 5 / 10];\n  return [hsvH, hslS, hslV];\n}\nfunction hsl2hsv(hslH, hslS, hslL) {\n  const hsv1 = hslS * (hslL < 50 ? hslL : 100 - hslL) / 100;\n  const hsvS = hsv1 === 0 ? 0 : 2 * hsv1 / (hslL + hsv1) * 100;\n  const hsvV = hslL + hsv1;\n  return [hslH, hsvS, hsvV];\n}\nconst Page = ({\n  style,\n  ...rest\n}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n  className: \"fl-color-picker-page\",\n  style: {\n    boxSizing: 'border-box',\n    scrollSnapAlign: 'start',\n    flexShrink: 0,\n    gridColumn: '1/-1',\n    display: 'grid',\n    gridTemplateColumns: 'subgrid',\n    gap: '0 8px',\n    ...style\n  }\n}, rest));\nconst HWBTab = () => {\n  const rAF = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const {\n    rawValue,\n    setValue\n  } = ___WEBPACK_IMPORTED_MODULE_4__.Color.use();\n  const [isPointerDown, setIsPointerDown] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const [hue, setHue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);\n  const [saturation, setSaturation] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);\n  const [lightness, setLightness] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);\n  const [hsvValue, setHSVValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);\n  const [alpha, setAlpha] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1);\n  const syncRawValue = value => {\n    if (CSS.supports('color', value)) {\n      try {\n        const parsed = new colorjs_io__WEBPACK_IMPORTED_MODULE_2__[\"default\"](value);\n        const {\n          alpha: _alpha,\n          space,\n          hsl,\n          hsv\n        } = parsed;\n        if (alpha !== _alpha) {\n          setAlpha(_alpha);\n        }\n        const spaces = ['sRGB', 'Linear sRGB', 'HSL', 'HSV', 'HWB'];\n        if (spaces.includes(space.name)) {\n          const [h, s, l] = hsl;\n          const [hsvH, hsvS, hsvV] = hsv;\n          if (hue !== hsvH && !isNaN(hsvH)) {\n            const threshlold = 10;\n            const isHueDifferent = hue - hsvH < 360 && (hsvH >= hue + threshlold || hsvH <= hue - threshlold);\n            if (isHueDifferent) {\n              setHue(hsvH);\n            }\n          }\n          if (lightness !== l) {\n            setLightness(l);\n          }\n          if (saturation !== hsvS) {\n            setSaturation(hsvS);\n          }\n          if (hsvValue !== hsvV) {\n            setHSVValue(hsvV);\n          }\n        }\n      } catch (error) {\n        // Can't parse, don't worry about it\n      }\n    }\n  };\n\n  /**\n   * Update local state whenever the raw value is updated externally\n   */\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (!isPointerDown) {\n      syncRawValue(rawValue);\n    }\n  }, [rawValue]);\n  const opaqueColor = stringFromHSL(...hsv2hsl(hue, saturation, hsvValue));\n  const hslGradient = `linear-gradient(to top, black, rgb(0 0 0 / 0 ) ),\n\t\t\t\t\t\t linear-gradient(to right, white, rgb(255 255 255 / 0 ) ),\n\t\t\t\t\t\t linear-gradient( hsl( ${hue} 100% 50%), hsl( ${hue} 100% 50%) )`;\n\n  /**\n   * Stub for a true translation function.\n   * This uses a dom element to get the browser's resolved rgb() value\n   */\n  const convertValue = value => (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getComputedValue)(value);\n  const updateValue = value => {\n    /**\n     * Sync value setting with frames to prevent setting more than once per-frame update\n     */\n    if (rAF.current) {\n      cancelAnimationFrame(rAF.current);\n    }\n    rAF.current = requestAnimationFrame(() => setValue(convertValue(value)));\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateColumns: 'min-content minmax(0, 1fr ) minmax( 5ch, min-content )',\n      flexDirection: 'column',\n      scrollSnapType: 'y mandatory',\n      color: 'var(--fg-color)'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Page, {\n    style: {\n      gridTemplateRows: '1fr auto auto auto'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_color_area__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    value: [saturation, 100 - hsvValue],\n    onChange: ([x, y]) => {\n      const saturation = x;\n      const value = 100 - y;\n      setSaturation(saturation);\n      setHSVValue(value);\n      const hsl = hsv2hsl(hue, saturation, value);\n      updateValue(stringFromHSL(hue, saturation, hsl[2], alpha));\n    },\n    onPointerDown: () => setIsPointerDown(true),\n    onPointerUp: () => setIsPointerDown(false),\n    style: {\n      gridColumn: '1/-1',\n      aspectRatio: 'none',\n      background: hslGradient\n    },\n    thumbStyle: {\n      '--color': opaqueColor\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"colorscale\",\n    style: {\n      gridColumn: '1/-1',\n      display: 'flex',\n      alignItems: 'center',\n      justifyContent: 'center',\n      pointerEvents: isPointerDown ? 'none' : ''\n    }\n  }, ['transparent', ...numRange(0, 100, 10).toReversed()].map(lightness => {\n    const value = 'string' === typeof lightness ? lightness : stringFromHSL(0, 0, lightness);\n    const textColor = 40 < lightness ? 'black' : 'white';\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_swatch__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n      key: value,\n      as: \"button\",\n      value: value,\n      onClick: () => updateValue(value),\n      style: {\n        '--size': '24px',\n        '--radius': 0,\n        '--text-color': textColor,\n        flexGrow: 1,\n        aspectRatio: 'none',\n        boxShadow: 'none',\n        cursor: 'pointer'\n      }\n    }, 'transparent' !== lightness && lightness);\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1',\n      display: 'grid',\n      gridTemplateColumns: 'subgrid',\n      padding: '8px 0'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1',\n      display: 'grid',\n      gridTemplateColumns: 'subgrid',\n      alignContent: 'center',\n      alignItems: 'center',\n      paddingLeft: 16,\n      paddingRight: 8,\n      height: 'var(--bar-size)'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Hue', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.Slider, {\n    className: \"hue-slider\",\n    type: \"range\",\n    min: 0,\n    max: 360,\n    value: hue,\n    onChange: e => {\n      const _hue = Math.round(e.target.value);\n      setHue(_hue);\n      const hsl = stringFromHSL(...hsv2hsl(_hue, saturation, hsvValue), alpha);\n      updateValue(hsl);\n    },\n    onPointerDown: () => setIsPointerDown(true),\n    onPointerUp: () => setIsPointerDown(false),\n    style: {\n      '--hue': hue,\n      '--sat': saturation\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, Math.round(hue))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      gridColumn: '1/-1',\n      display: 'grid',\n      gridTemplateColumns: 'subgrid',\n      alignContent: 'center',\n      alignItems: 'center',\n      paddingLeft: 16,\n      paddingRight: 8,\n      height: 'var(--bar-size)'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Alpha', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.Slider, {\n    className: \"alpha-slider\",\n    type: \"range\",\n    min: 0,\n    max: 1,\n    step: .01,\n    value: alpha,\n    onChange: e => {\n      const _alpha = e.target.value;\n      setAlpha(_alpha);\n      updateValue(stringFromHSL(...hsv2hsl(hue, saturation, hsvValue), _alpha));\n    },\n    onPointerDown: () => setIsPointerDown(true),\n    onPointerUp: () => setIsPointerDown(false),\n    style: {\n      '--thumb-color': stringFromHSL(hue, saturation, 50),\n      '--hue': hue,\n      '--sat': `${saturation}%`\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, parseInt(alpha * 100))))));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('sRGB', 'fl-builder'),\n  content: HWBTab\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/ui/tab-srgb.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/utils/display.js":
/*!***********************************************************!*\
  !*** ./src/FL/controls/components/color/utils/display.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getColorDisplayValue: () => (/* binding */ getColorDisplayValue)\n/* harmony export */ });\n/**\n * Attempts to get a color value for a CSS variable\n * that is set in the layout iframe so that it can be\n * displayed in the controls.\n */\nconst getColorDisplayValue = value => {\n  const layoutFrame = window.parent.document.getElementById('fl-builder-ui-iframe');\n  if (layoutFrame && value.startsWith('var(')) {\n    const layoutDocument = layoutFrame.contentDocument || layoutFrame.contentWindow.document;\n    const temp = layoutDocument.createElement('div');\n    temp.style.color = value;\n    layoutDocument.body.appendChild(temp);\n    const computedStyle = layoutDocument.defaultView.getComputedStyle(temp);\n    value = computedStyle.color ? computedStyle.color : value;\n    layoutDocument.body.removeChild(temp);\n  }\n  return value;\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/utils/display.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/utils/index.js":
/*!*********************************************************!*\
  !*** ./src/FL/controls/components/color/utils/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getComputedValue: () => (/* reexport safe */ _meta__WEBPACK_IMPORTED_MODULE_0__.getComputedValue),\n/* harmony export */   getMetadata: () => (/* reexport safe */ _meta__WEBPACK_IMPORTED_MODULE_0__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./meta */ \"./src/FL/controls/components/color/utils/meta.js\");\n\n\n// Don't use this yet - math still WIP\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/utils/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/color/utils/meta.js":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/color/utils/meta.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   getComputedValue: () => (/* binding */ getComputedValue)\n/* harmony export */ });\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../utils */ \"./src/FL/controls/utils/index.js\");\n\nconst {\n  rgbToHsl,\n  rgbToHwb,\n  rgbToHex\n} = _utils__WEBPACK_IMPORTED_MODULE_0__.color;\n\n/**\n * Shared DOM Element reference for use in computing color values\n */\nlet element = null;\nconst getComputedValue = raw => {\n  if (!element) {\n    element = document.createElement('div');\n    document.body.append(element);\n  }\n  element.style.color = raw;\n  const value = window.getComputedStyle(element).getPropertyValue('color');\n  element.style.color = '';\n  return value;\n};\n\n/**\n * Break down the computed value\n */\nconst getComputedMeta = value => {\n  // Get the values between the ( ) of a color function value\n  const parts = /\\(([^)]+)\\)/.exec(value)[1];\n  const arr = parts.replaceAll(',', ' ').split(/(\\s+)/).filter(str => str.trim().length > 0 && '/' !== str).map(str => {\n    // Some values may be strings like colorspace\n    if (isNaN(str)) {\n      return str;\n    }\n\n    // But channel values should be converted to numbers\n    return parseFloat(str);\n  });\n\n  // Get the {funcName}(0,0,0,0) off the color value }\n  const funcName = value.split('(')[0];\n\n  // Normalize channel data\n  if ('color' === funcName) {\n    const [colorSpace, ...channels] = arr;\n    return {\n      funcName,\n      colorSpace,\n      channels: 3 === channels.length ? [...channels, 1] : channels // Ensure alpha value\n    };\n  } else {\n    let colorSpace = funcName;\n    if ('rgb' === funcName) {\n      colorSpace = 'srgb';\n    }\n    return {\n      funcName,\n      colorSpace,\n      channels: 3 === arr.length ? [...arr, 1] : arr // Ensure alpha value\n    };\n  }\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (value => {\n  const computed = getComputedValue(value);\n  const meta = getComputedMeta(computed);\n  const {\n    colorSpace\n  } = meta;\n  const getSRGB = () => {\n    const {\n      colorSpace,\n      channels\n    } = meta;\n\n    // meant to mimick the browser's default rgb value for invalid colors\n    let rgba = {\n      r: 60,\n      g: 67,\n      b: 74,\n      a: 1\n    };\n    if ('srgb' === colorSpace) {\n      rgba = {\n        ...rgba,\n        r: channels[0],\n        g: channels[1],\n        b: channels[2],\n        a: channels[3]\n      };\n    }\n    const {\n      r,\n      g,\n      b,\n      a\n    } = rgba;\n    const hex = rgbToHex(r, g, b);\n\n    // Switch 255 values to percentages before converting\n    const _r = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.mapNumRange)(rgba.r, 0, 255, 0, 1);\n    const _g = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.mapNumRange)(rgba.g, 0, 255, 0, 1);\n    const _b = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.mapNumRange)(rgba.b, 0, 255, 0, 1);\n    const [hue, saturation, lightness] = rgbToHsl(_r, _g, _b);\n    const [_, whiteness, blackness] = rgbToHwb(_r, _g, _b);\n    return {\n      rgb: rgba,\n      rgbString: `rgb( ${r} ${g} ${b} / ${a} )`,\n      hsl: {\n        h: hue,\n        s: saturation,\n        l: lightness,\n        a\n      },\n      hslString: `hsl( ${hue} ${saturation}% ${lightness}% / ${a})`,\n      hwbString: `hwb( ${hue} ${whiteness}% ${blackness}% / ${a})`,\n      hex,\n      alpha: a,\n      red: r,\n      green: g,\n      blue: b,\n      hue,\n      whiteness,\n      blackness,\n      saturation,\n      lightness\n    };\n  };\n  return {\n    rawValue: value,\n    computedValue: computed,\n    colorSpace,\n    getSRGB\n  };\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/color/utils/meta.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/dialog/dialog-button.js":
/*!************************************************************!*\
  !*** ./src/FL/controls/components/dialog/dialog-button.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DialogButton: () => (/* binding */ DialogButton),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ */ \"./src/FL/controls/components/dialog/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/utils/index.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\nconst DialogButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  button: Button = 'button',\n  label = 'Button',\n  children,\n  className,\n  appearance,\n  buttonProps = {},\n  dialogProps = {},\n  position,\n  enableViewTransitions = false,\n  tabs\n}, ref) => {\n  const button = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const dialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n\n  /**\n   * Close the dialog w/ View Transition support.\n   */\n  const close = () => {\n    const doClose = () => dialog.current?.close();\n    const document = window.top.document;\n    if (enableViewTransitions && document.startViewTransition) {\n      const transition = document.startViewTransition(doClose);\n      transition.ready.then(() => {\n        dialog.current.animate({\n          scale: [1, .25]\n        }, {\n          duration: 500,\n          easing: 'ease-in'\n        });\n      });\n    }\n    doClose();\n  };\n\n  /**\n   * Show the dialog w/ View Transition Support\n   */\n  const showModal = () => {\n    const doShow = () => dialog.current?.showModal();\n    const document = window.top.document;\n    if (enableViewTransitions && document.startViewTransition) {\n      const transition = document.startViewTransition(doShow);\n      transition.ready.then(() => {\n        dialog.current.animate({\n          scale: [.25, 1]\n        }, {\n          duration: 500,\n          easing: 'ease-in'\n        });\n      });\n    }\n    doShow();\n  };\n\n  /**\n   * Toggle the internal versions of showModal() and close()\n   */\n  const toggle = () => {\n    if (dialog.current && !!dialog.current.open) {\n      close();\n    } else {\n      showModal();\n    }\n  };\n\n  /*\n   * Expose API object to parent component via ref\n   */\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useImperativeHandle)(ref, () => {\n    return {\n      button: button.current,\n      dialog: dialog.current,\n      showModal,\n      close,\n      toggle\n    };\n  }, [button.current, dialog.current, showModal, close, toggle]);\n  const handlePosition = ({\n    dialog\n  }, e) => {\n    let posStyles = {};\n    if (button.current && dialog) {\n      const btn = button.current?.getBoundingClientRect();\n      const {\n        clientWidth: dialogWidth,\n        clientHeight: dialogHeight\n      } = dialog;\n      const {\n        innerHeight: viewportHeight,\n        innerWidth: viewportWidth\n      } = window.top;\n      const inset = 32;\n\n      // Beside Left Top\n      const left = btn.left - (dialogWidth + inset);\n      const top = btn.top;\n      const clampedLeft = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.clamp)(left, 0 + inset, viewportWidth - dialogWidth - inset);\n      const clampedTop = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.clamp)(top, 0 + inset, viewportHeight - dialogHeight - inset);\n      posStyles = {\n        bottom: 'auto',\n        right: 'auto',\n        left: clampedLeft + 'px',\n        top: clampedTop + 'px',\n        transformOrigin: `${dialogWidth - btn.width / 2}px top`\n      };\n      if ('function' === typeof position) {\n        posStyles = position({\n          dialog,\n          dialogRect: {\n            width: dialogWidth,\n            height: dialogHeight\n          },\n          button: button.current,\n          buttonRect: btn,\n          styles: posStyles\n        }, e);\n      }\n      return posStyles;\n    }\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Button, _extends({\n    ref: button,\n    as: \"div\",\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('fl-controls-dialog-button', className),\n    onClick: toggle\n  }, buttonProps), label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Dialog, _extends({\n    ref: dialog,\n    appearance: appearance,\n    position: handlePosition,\n    enableViewTransitions: enableViewTransitions,\n    tabs: tabs\n  }, dialogProps), children));\n});\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DialogButton);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/dialog/dialog-button.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/dialog/dialog.js":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/dialog/dialog.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../error */ \"./src/FL/controls/components/error/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ \"./src/FL/controls/components/dialog/utils.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\nconst useLightDimissDialog = (dismiss = () => {}) => {\n  const startCoords = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const onPointerDown = ({\n    pageX,\n    pageY\n  }) => startCoords.current = {\n    pageX,\n    pageY\n  };\n  const onKeyUp = e => {\n    if ('Escape' === e.key) {\n      dismiss(e);\n    }\n    e.stopPropagation();\n  };\n  const pointerStartedInside = e => {\n    if (!startCoords.current) {\n      return false;\n    }\n    const {\n      pageX,\n      pageY\n    } = startCoords.current;\n    const {\n      top,\n      left,\n      width,\n      height\n    } = e.target.getBoundingClientRect();\n    const {\n      pageYOffset,\n      pageXOffset\n    } = window;\n    const elTop = top + pageYOffset;\n    const elLeft = left + pageXOffset;\n    const rect = {\n      left: elLeft,\n      top: elTop,\n      width,\n      height\n    };\n    return pageX >= rect.left && pageX <= rect.left + rect.width && pageY >= rect.top && pageY <= rect.top + rect.height;\n  };\n  const onClick = e => {\n    if (!pointerStartedInside(e) && e.target.matches('dialog')) {\n      dismiss(e);\n\n      // Because we don't want to dismiss nested panels - just this one.\n      e.stopPropagation();\n    }\n  };\n  return {\n    onPointerDown,\n    onMouseMove: e => e.stopPropagation(),\n    onKeyUp,\n    onClick\n  };\n};\nconst Dialog = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  className,\n  children,\n  position,\n  tabs,\n  appearance = 'panel',\n  enableViewTransitions = false,\n  style,\n  ...rest\n}, ref) => {\n  const element = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n\n  /**\n   * Light dismiss enables click outside of an element to dismiss as well as hitting ESC\n   */\n  const lightDismissProps = useLightDimissDialog(() => element.current?.close());\n\n  /**\n   * Ensure the ref we're using and a ref passed in are the same and always exist.\n   */\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useImperativeHandle)(ref, () => {\n    /**\n     * Wrap showModal() and fire a custom \"show\" event because browser doesn't provide one.\n     * This gives us an event to calculate position on.\n     */\n    const _showModal = element.current.showModal;\n    element.current.showModal = () => {\n      _showModal.call(element.current);\n\n      // Wait a frame before firing to ensure we can read width/height of element for positioning.\n      requestAnimationFrame(() => element.current.dispatchEvent(new Event('show')));\n    };\n\n    // Expose the dialog element w/ extra methods via ref\n    return element.current;\n  }, [element.current]);\n\n  /**\n   * Use custom \"show\" event to determine position\n   */\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (element.current) {\n      const onShow = e => {\n        let styles = {};\n        if ('function' === typeof position) {\n          styles = position({\n            dialog: element.current\n          }, e);\n        }\n        (0,_utils__WEBPACK_IMPORTED_MODULE_3__.setElementStyles)(element.current, styles);\n      };\n      element.current?.addEventListener('show', onShow);\n      return () => element.current?.removeEventListener('show', onShow);\n    }\n  }, [element.current, position]);\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"dialog\", _extends({\n    ref: element,\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({\n      'fl-controls-dialog': true,\n      [`fl-appearance-${appearance}`]: appearance,\n      'uses-view-transitions': undefined !== document.startViewTransition && enableViewTransitions\n    }, className),\n    style: style\n  }, lightDismissProps, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_error__WEBPACK_IMPORTED_MODULE_2__[\"default\"].Boundary, null, children));\n});\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dialog);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/dialog/dialog.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/dialog/index.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/components/dialog/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Dialog: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_0__[\"default\"]),\n/* harmony export */   DialogButton: () => (/* reexport safe */ _dialog_button__WEBPACK_IMPORTED_MODULE_1__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dialog */ \"./src/FL/controls/components/dialog/dialog.js\");\n/* harmony import */ var _dialog_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dialog-button */ \"./src/FL/controls/components/dialog/dialog-button.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/dialog/style.scss\");\n\n\n\n_dialog__WEBPACK_IMPORTED_MODULE_0__[\"default\"].Button = _dialog_button__WEBPACK_IMPORTED_MODULE_1__[\"default\"];\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/dialog/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/dialog/style.scss":
/*!******************************************************!*\
  !*** ./src/FL/controls/components/dialog/style.scss ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/dialog/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/dialog/utils.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/components/dialog/utils.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   setElementStyles: () => (/* binding */ setElementStyles)\n/* harmony export */ });\nconst setElementStyles = (element, styles = {}) => {\n  if (element) {\n    for (let key in styles) {\n      element.style[key] = styles[key];\n    }\n  }\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/dialog/utils.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/error/index.js":
/*!***************************************************!*\
  !*** ./src/FL/controls/components/error/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DefaultError: () => (/* binding */ DefaultError),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\nconst DefaultError = ({\n  error,\n  title = (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There seems to be an error', 'fl-builder'),\n  children,\n  style = {},\n  ...rest\n}) => {\n  const boxStyle = {\n    display: 'flex',\n    flexDirection: 'column',\n    flex: '1 1 auto',\n    justifyContent: 'center',\n    alignItems: 'center',\n    padding: 8,\n    gap: 16,\n    textAlign: 'center',\n    minHeight: 0,\n    maxHeight: '100%',\n    lineBreak: 'anywhere',\n    ...style\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n    style: boxStyle\n  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      color: 'inherit',\n      fontSize: 14\n    }\n  }, title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"code\", {\n    style: {\n      color: 'inherit'\n    }\n  }, error.message), children);\n};\nclass Boundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {\n  constructor(props) {\n    super(props);\n    this.state = {\n      hasError: false,\n      error: null\n    };\n  }\n  static getDerivedStateFromError(error) {\n    return {\n      hasError: true,\n      error\n    };\n  }\n  render() {\n    const {\n      alternate = DefaultError,\n      children,\n      ...rest\n    } = this.props;\n    const {\n      hasError,\n      error\n    } = this.state;\n    if (hasError) {\n      return /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(alternate, {\n        error,\n        ...rest\n      });\n    }\n    return children;\n  }\n}\n\n// Ensure the proper display name in the react dev tools tree\nconst Error = {\n  Boundary,\n  DefaultError\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Error);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/error/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/gradient/index.js":
/*!******************************************************!*\
  !*** ./src/FL/controls/components/gradient/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Input: () => (/* binding */ Input),\n/* harmony export */   Range: () => (/* binding */ Range),\n/* harmony export */   getCSS: () => (/* binding */ getCSS)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/utils/index.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ \"./src/FL/controls/components/gradient/utils.js\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/gradient/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\n\nconst sortStops = stops => stops.toSorted((a, b) => a.from - b.from);\nconst Range = ({\n  value: stops = [],\n  onChange,\n  colorSpace\n}) => {\n  const range = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const rAF = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null); // requestAnimationFrame id\n  const preventWheel = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.usePreventWheel)();\n\n  // Index of the stop currently being edited\n  const [isDown, setIsDown] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const [index, setIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);\n  const sortedStops = sortStops(stops);\n  const rangeBG = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getGradientString)({\n    type: 'linear',\n    angle: 90,\n    colorSpace,\n    stops\n  });\n  const firstStopColor = sortedStops[0]?.color;\n  const lastStopColor = sortedStops[sortedStops.length - 1].color;\n  const defaultStop = {\n    color: null !== index ? stops[index].color : '#ff0000',\n    from: 0,\n    to: null\n  };\n  const calculateValues = e => {\n    if (rAF.current) {\n      cancelAnimationFrame(rAF.current);\n    }\n    requestAnimationFrame(() => {\n      const pageX = 'number' === typeof e.pageX ? e.pageX : e.touches[0].pageX;\n\n      //const pageY = 'number' === typeof e.pageY ? e.pageY : e.touches[0].pageY\n\n      if (range.current) {\n        const bounds = range.current.getBoundingClientRect();\n        const x = pageX - bounds.left;\n        const xPercent = Math.round((0,_utils__WEBPACK_IMPORTED_MODULE_3__.mapNumRange)((0,_utils__WEBPACK_IMPORTED_MODULE_3__.clamp)(x, 0, bounds.width), 0, bounds.width, 0, 100));\n        if (stops[index].from !== xPercent) {\n          const newStops = stops.toSpliced(index, 1, {\n            ...stops[index],\n            from: xPercent\n          });\n          onChange(newStops);\n        }\n      }\n    });\n  };\n  const onPointerDown = i => {\n    setIndex(i);\n    setIsDown(true);\n  };\n  const reset = () => setIsDown(false);\n  const onPointerMove = e => {\n    if (isDown) {\n      calculateValues(e);\n    }\n    e.stopPropagation();\n  };\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (isDown) {\n      const win = window.top;\n      win.addEventListener('pointermove', onPointerMove);\n      win.addEventListener('pointerup', reset);\n      win.addEventListener('pointercancel', reset);\n      return () => {\n        win.removeEventListener('pointermove', onPointerMove);\n        win.removeEventListener('pointerup', reset);\n        win.removeEventListener('pointercancel', reset);\n      };\n    }\n  }, [isDown]);\n  const deleteSelectedStop = () => {\n    if (2 < stops.length) {\n      onChange(stops.filter((_, i) => i !== index));\n      setIndex(null);\n    }\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Color.Swatch, {\n    className: \"fl-controls-gradient-stop-range\",\n    style: {\n      width: 'auto',\n      height: ''\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"range-endcap\",\n    style: {\n      background: firstStopColor\n    },\n    onClick: () => {\n      const newStops = sortStops([...stops, {\n        ...defaultStop\n      }]);\n      onChange(newStops);\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: range,\n    className: \"fl-controls-gradient-stops-wrapper\",\n    style: {\n      background: rangeBG\n    },\n    onClick: e => {\n      const pageX = 'number' === typeof e.pageX ? e.pageX : e.touches[0].pageX;\n\n      //const pageY = 'number' === typeof e.pageY ? e.pageY : e.touches[0].pageY\n\n      const range = e.target;\n      const bounds = range.getBoundingClientRect();\n      const x = pageX - bounds.left;\n      const xPercent = Math.round((0,_utils__WEBPACK_IMPORTED_MODULE_3__.mapNumRange)((0,_utils__WEBPACK_IMPORTED_MODULE_3__.clamp)(x, 0, bounds.width), 0, bounds.width, 0, 100));\n      const newStops = sortStops([...stops, {\n        ...defaultStop,\n        from: xPercent\n      }]);\n      onChange(newStops);\n    }\n  }, stops.map((stop, i) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n      key: `gradient-stop-${i}`,\n      className: i === index ? 'is-selected' : '',\n      \"data-gradient-stop\": i,\n      onPointerDown: e => onPointerDown(i, e),\n      onClick: e => {\n        e.stopPropagation();\n      },\n      onDoubleClick: e => {\n        deleteSelectedStop();\n        e.stopPropagation();\n      },\n      onFocus: () => setIndex(i),\n      onKeyUp: e => {\n        if ('Escape' === e.key) {\n          e.target.blur();\n        }\n        if ('Backspace' === e.key) {\n          deleteSelectedStop();\n        }\n        e.stopPropagation();\n      },\n      style: {\n        '--color': stop.color,\n        left: `${stop.from}%`,\n        zIndex: null !== index && i === index ? '1' : ''\n      }\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"span\", null));\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"range-endcap\",\n    style: {\n      background: lastStopColor\n    },\n    onClick: () => {\n      const newStops = sortStops([...stops, {\n        ...defaultStop,\n        from: 100\n      }]);\n      onChange(newStops);\n    }\n  })), null !== index && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateColumns: 'subgrid',\n      gridColumn: '1/-1'\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      flexGrow: 1\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Color.Picker, {\n    showReset: false,\n    value: stops[index]?.color,\n    onChange: color => onChange(stops.with(index, {\n      ...stops[index],\n      color\n    }))\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    ref: preventWheel,\n    type: \"number\",\n    value: stops[index]?.from,\n    onChange: e => onChange(stops.with(index, {\n      ...stops[index],\n      from: e.target.value\n    })),\n    min: \"0\",\n    max: \"100\"\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    className: \"stop-remove-button\",\n    onClick: () => {\n      onChange(stops.filter((_, i) => i !== index));\n      setIndex(null);\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_5__.Trash, null))), null === index && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridColumn: '1/-1',\n      placeContent: 'center'\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select Color Stop', 'fl-builder')));\n};\nconst types = {\n  linear: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Linear', 'fl-builder'),\n  radial: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Radial', 'fl-builder'),\n  conic: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Conic', 'fl-builder')\n};\nconst colorSpaces = {\n  'sRGB': 'sRGB',\n  'srgb-linear': 'Linear sRGB',\n  oklab: 'OKLAB',\n  oklch: 'OKLCH'\n};\nconst Input = ({\n  value: state = _utils__WEBPACK_IMPORTED_MODULE_4__.defaultState,\n  onChange: setState = () => {},\n  style,\n  ...rest\n}) => {\n  const {\n    type,\n    colorSpace,\n    angle\n  } = {\n    ..._utils__WEBPACK_IMPORTED_MODULE_4__.defaultState,\n    ...state\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n    className: \"fl-controls-gradient-picker\",\n    style: {\n      display: 'grid',\n      gap: 8,\n      ...style\n    }\n  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Color.Swatch, {\n    style: {\n      '--background': (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getGradientString)(state),\n      gridColumn: '1/-1',\n      aspectRatio: '3/2',\n      width: 'auto',\n      height: 'auto',\n      borderRadius: 8\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Range, {\n    value: Array.isArray(state.stops) ? state.stops : [],\n    onChange: stops => setState({\n      ...state,\n      stops\n    }),\n    colorSpace: colorSpace\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-controls-grid-table span-cols\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Type', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Select, {\n    value: type,\n    options: types,\n    onChange: e => setState({\n      ...state,\n      type: e.target.value\n    })\n  })), 'linear' === type && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Angle', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    type: \"number\",\n    min: \"0\",\n    max: \"360\",\n    step: \"1\",\n    value: angle,\n    onChange: e => setState({\n      ...state,\n      angle: e.target.value\n    })\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"label\", null, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Color Space', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_2__.Select, {\n    value: colorSpace,\n    options: colorSpaces,\n    onChange: e => setState({\n      ...state,\n      colorSpace: e.target.value\n    })\n  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    className: \"fl-control fl-controls-button\",\n    style: {\n      display: 'grid',\n      placeContent: 'center'\n    },\n    title: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Distribute color spots', 'fl-builder'),\n    onClick: () => {\n      const newStops = sortStops(state.stops).map((stop, i) => {\n        return {\n          ...stop,\n          from: Math.round(i * (100 / (state.stops.length - 1))),\n          to: null\n        };\n      });\n      setState({\n        ...state,\n        stops: newStops\n      });\n    }\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_5__.SpaceAroundHorizontal, null))));\n};\nconst getCSS = _utils__WEBPACK_IMPORTED_MODULE_4__.getGradientString;\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/gradient/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/gradient/style.scss":
/*!********************************************************!*\
  !*** ./src/FL/controls/components/gradient/style.scss ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/gradient/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/gradient/utils.js":
/*!******************************************************!*\
  !*** ./src/FL/controls/components/gradient/utils.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   defaultState: () => (/* binding */ defaultState),\n/* harmony export */   getGradientString: () => (/* binding */ getGradientString)\n/* harmony export */ });\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/utils/index.js\");\n\nconst splitColorString = string => {\n  return string.split(',').map(item => ({\n    color: item,\n    from: 0\n  }));\n};\nconst getStopString = ({\n  color = 'red',\n  from = 0,\n  to = null\n}) => `${color} ${from}%${to ? ' ' + to + '%' : ''}`;\nconst defaultState = {\n  type: 'linear',\n  colorSpace: '',\n  angle: 0,\n  stops: []\n};\nconst getGradientString = state => {\n  const {\n    type,\n    colorSpace,\n    angle,\n    stops: _stops\n  } = {\n    ...defaultState,\n    ...state\n  };\n  const stops = 'string' === typeof _stops ? splitColorString(_stops) : _stops;\n  const sorted = stops.toSorted((a, b) => a.from - b.from);\n  const stopString = sorted.map(getStopString).join(', ');\n  let origin = '';\n  if ('' !== colorSpace) {\n    origin = `in ${colorSpace}`;\n  }\n  const getConicStopString = stops => {\n    return stops.toSorted((a, b) => a.from - b.from).map(({\n      color,\n      from\n    }) => {\n      const xDeg = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.mapNumRange)(from, 0, 100, 0, 360);\n      return `${color} ${xDeg}deg`;\n    }).join(', ');\n  };\n  if ('radial' === type || 'repeating-radial' === type) {\n    origin += ' circle';\n    return `${type}-gradient(${origin}, ${stopString} )`;\n  } else if ('conic' === type || 'repeating-conic' === type) {\n    return `${type}-gradient(${origin ? origin + ',' : ''} ${getConicStopString(stops)} )`;\n  } else {\n    const _angle = !angle ? 0 : angle;\n    return `${type}-gradient(${origin} ${_angle}deg, ${stopString} )`;\n  }\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/gradient/utils.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/index.js":
/*!*********************************************!*\
  !*** ./src/FL/controls/components/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Background: () => (/* reexport module object */ _background__WEBPACK_IMPORTED_MODULE_4__),\n/* harmony export */   Color: () => (/* reexport module object */ _color__WEBPACK_IMPORTED_MODULE_1__),\n/* harmony export */   Dialog: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_5__.Dialog),\n/* harmony export */   DialogButton: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_5__.DialogButton),\n/* harmony export */   Error: () => (/* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_6__[\"default\"]),\n/* harmony export */   Gradient: () => (/* reexport module object */ _gradient__WEBPACK_IMPORTED_MODULE_2__),\n/* harmony export */   Input: () => (/* reexport safe */ _input__WEBPACK_IMPORTED_MODULE_12__[\"default\"]),\n/* harmony export */   Media: () => (/* reexport safe */ _media__WEBPACK_IMPORTED_MODULE_3__[\"default\"]),\n/* harmony export */   Section: () => (/* reexport safe */ _section__WEBPACK_IMPORTED_MODULE_7__[\"default\"]),\n/* harmony export */   Select: () => (/* reexport safe */ _select__WEBPACK_IMPORTED_MODULE_8__[\"default\"]),\n/* harmony export */   Series: () => (/* reexport safe */ _series__WEBPACK_IMPORTED_MODULE_9__[\"default\"]),\n/* harmony export */   Slider: () => (/* reexport safe */ _sliders__WEBPACK_IMPORTED_MODULE_10__.Slider),\n/* harmony export */   SortableList: () => (/* reexport safe */ _sortable_list__WEBPACK_IMPORTED_MODULE_11__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/style.scss\");\n/* harmony import */ var _color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color */ \"./src/FL/controls/components/color/index.js\");\n/* harmony import */ var _gradient__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./gradient */ \"./src/FL/controls/components/gradient/index.js\");\n/* harmony import */ var _media__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./media */ \"./src/FL/controls/components/media/index.js\");\n/* harmony import */ var _background__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./background */ \"./src/FL/controls/components/background/index.js\");\n/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dialog */ \"./src/FL/controls/components/dialog/index.js\");\n/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./error */ \"./src/FL/controls/components/error/index.js\");\n/* harmony import */ var _section__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./section */ \"./src/FL/controls/components/section/index.js\");\n/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./select */ \"./src/FL/controls/components/select/index.js\");\n/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./series */ \"./src/FL/controls/components/series/index.js\");\n/* harmony import */ var _sliders__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./sliders */ \"./src/FL/controls/components/sliders/index.js\");\n/* harmony import */ var _sortable_list__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./sortable-list */ \"./src/FL/controls/components/sortable-list/index.js\");\n/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./input */ \"./src/FL/controls/components/input/index.js\");\n\n\n// Import pickers before background\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * Input is a pass-through convenience component for other things\n * so it should be imported last to avoid circular or undefined references.\n */\n\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/input/index.js":
/*!***************************************************!*\
  !*** ./src/FL/controls/components/input/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/hooks */ \"@wordpress/hooks\");\n/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./types */ \"./src/FL/controls/components/input/types/index.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ */ \"./src/FL/controls/components/index.js\");\n\n\n\n\n\nconst types = {\n  color: ___WEBPACK_IMPORTED_MODULE_4__.Color.Picker\n};\n(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('fl_controls_input_component', 'fl-controls', (Component, type = '') => {\n  if (undefined !== types[type]) {\n    return types[type];\n  }\n  return Component;\n});\n\n/**\n * Filter the type and create a suspense wrapper for chunked components.\n */\nconst FLControlsInput = props => {\n  const {\n    type,\n    ...rest\n  } = props;\n  const InputComponent = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.applyFilters)('fl_controls_input_component', _types__WEBPACK_IMPORTED_MODULE_3__.Input, type, props);\n  return /*#__PURE__*/React.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Suspense, null, /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_4__.Error.Boundary, null, /*#__PURE__*/React.createElement(InputComponent, rest)));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FLControlsInput);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/input/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/input/types/index.js":
/*!*********************************************************!*\
  !*** ./src/FL/controls/components/input/types/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Input: () => (/* reexport safe */ _input__WEBPACK_IMPORTED_MODULE_0__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./input */ \"./src/FL/controls/components/input/types/input/index.js\");\n\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/input/types/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/input/types/input/index.js":
/*!***************************************************************!*\
  !*** ./src/FL/controls/components/input/types/input/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\nconst Input = ({\n  type = 'text',\n  value,\n  className,\n  onChange,\n  ...rest\n}) => /*#__PURE__*/React.createElement(\"input\", _extends({\n  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('fl-controls-input', className),\n  type: type,\n  value: value,\n  onInput: onChange\n}, rest));\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Input);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/input/types/input/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/media/index.js":
/*!***************************************************!*\
  !*** ./src/FL/controls/components/media/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../state */ \"./src/FL/controls/state/index.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/media/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst ImagePickerButton = ({\n  attachmentId,\n  url,\n  onSelect = () => {},\n  onSizeSelect = () => {},\n  onRemove = () => {},\n  children,\n  ...rest\n}) => {\n  const {\n    addSizesForAttachment\n  } = (0,_state__WEBPACK_IMPORTED_MODULE_3__.useControlsStore)();\n\n  /**\n   * We're wrapping the media panel in a <dialog> element to ensure it presents above other flyouts\n   */\n  const dialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const mediaFrame = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const openMediaPicker = () => mediaFrame.current?.open();\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    const frame = wp.media({\n      title: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select Image', 'fl-builder'),\n      library: {\n        type: 'image'\n      },\n      button: {\n        text: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select', 'fl-builder')\n      },\n      multiple: false // Set to true to allow multiple files to be selected\n    });\n    frame.on('open', function () {\n      if (!dialog.current) {\n        const modal = this.$el.closest('.media-modal').get(0);\n        const parent = modal.parentElement;\n        dialog.current = document.createElement('dialog');\n        dialog.current.classList.add('fl-controls-media-modal-dialog');\n        parent.replaceChildren(dialog.current);\n        dialog.current.append(modal);\n      }\n      if (dialog.current) {\n        dialog.current.showModal();\n      }\n    }, frame);\n    frame.on('close', function () {\n      if (dialog.current) {\n        dialog.current.close();\n      }\n    }, frame);\n    frame.on('select', () => {\n      const attachment = mediaFrame.current.state().get('selection').first().toJSON();\n      addSizesForAttachment(attachment.id, attachment.sizes);\n      onSelect(attachment);\n    }, frame);\n    mediaFrame.current = frame;\n  }, []);\n  return /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      display: 'grid',\n      gridTemplateRows: 'repeat(2, 36px)',\n      gap: 8\n    }\n  }, /*#__PURE__*/React.createElement(AttachmentSizeSelect, {\n    attachmentId: attachmentId,\n    url: url,\n    onChange: onSizeSelect\n  }), /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      display: 'flex',\n      gap: 8\n    }\n  }, /*#__PURE__*/React.createElement(\"button\", {\n    className: \"fl-control fl-controls-button\",\n    onClick: openMediaPicker,\n    style: {\n      flexGrow: 1\n    }\n  }, /*#__PURE__*/React.createElement(\"svg\", {\n    width: \"23\",\n    height: \"18\",\n    viewBox: \"0 0 23 18\",\n    fill: \"none\"\n  }, /*#__PURE__*/React.createElement(\"path\", {\n    d: \"M3.27881 17.3462C1.33984 17.3462 0.365723 16.3906 0.365723 14.4795V3.14258C0.365723 1.23145 1.33984 0.266602 3.27881 0.266602H19.3286C21.2769 0.266602 22.2417 1.23145 22.2417 3.14258V14.4795C22.2417 16.3906 21.2769 17.3462 19.3286 17.3462H3.27881ZM15.7754 8.80176L20.748 13.4683V3.22607C20.748 2.26123 20.2285 1.76025 19.3101 1.76025H3.29736C2.36963 1.76025 1.85938 2.26123 1.85938 3.22607V13.4683L4.62402 10.9727C5.00439 10.6201 5.40332 10.4531 5.8208 10.4531C6.25684 10.4531 6.68359 10.6294 7.07324 10.9819L8.78955 12.5312L12.9829 8.7832C13.4097 8.40283 13.8643 8.22656 14.3745 8.22656C14.8755 8.22656 15.3672 8.42139 15.7754 8.80176ZM7.27734 8.89453C6.07129 8.89453 5.08789 7.91113 5.08789 6.70508C5.08789 5.5083 6.07129 4.51562 7.27734 4.51562C8.47412 4.51562 9.45752 5.5083 9.45752 6.70508C9.45752 7.91113 8.47412 8.89453 7.27734 8.89453Z\",\n    fill: \"currentColor\"\n  })), attachmentId ? (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Replace', 'fl-builder') : (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select Image', 'fl-builder')), attachmentId && /*#__PURE__*/React.createElement(\"button\", {\n    className: \"fl-control fl-controls-button\",\n    onClick: onRemove,\n    style: {\n      flexGrow: 1\n    }\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Remove', 'fl-builder'))));\n};\nconst AttachmentSizeSelect = ({\n  attachmentId,\n  url,\n  onChange = () => {},\n  ...rest\n}) => {\n  const [sizes, setSizes] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});\n  const {\n    getSizesForAttachment\n  } = (0,_state__WEBPACK_IMPORTED_MODULE_3__.useControlsStore)();\n  const getKeyforURL = (url, sizes = {}) => {\n    if (0 < Object.keys(sizes).length) {\n      const match = Object.entries(sizes).find(([key, size]) => url === size.url);\n      if (match) {\n        return match[0];\n      }\n    }\n    return '';\n  };\n  const value = getKeyforURL(url, sizes);\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (attachmentId) {\n      getSizesForAttachment(attachmentId).then(sizes => {\n        if (undefined !== sizes && 0 < Object.keys(sizes).length) {\n          setSizes(sizes);\n        }\n      });\n    }\n  }, [attachmentId]);\n  if (!attachmentId || !sizes || 0 >= Object.keys(sizes).length) {\n    return null;\n  }\n  return /*#__PURE__*/React.createElement(___WEBPACK_IMPORTED_MODULE_2__.Select, _extends({\n    value: value,\n    options: sizes,\n    getLabel: ({\n      width,\n      height\n    }, key) => `${key} - ${width} x ${height}`,\n    onChange: e => onChange(sizes[e.target.value])\n  }, rest));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  PickerButton: ImagePickerButton\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/media/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/media/style.scss":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/media/style.scss ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/media/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/section/index.js":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/section/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/section/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\nconst FLControlsSection = ({\n  as: Tag = 'div',\n  title,\n  className,\n  children,\n  ...rest\n}) => {\n  return /*#__PURE__*/React.createElement(Tag, _extends({\n    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('fl-controls-section', className)\n  }, rest), title && /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-controls-section-title-bar\"\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-controls-section-title\"\n  }, title)), /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-controls-section-content\"\n  }, children));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FLControlsSection);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/section/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/section/style.scss":
/*!*******************************************************!*\
  !*** ./src/FL/controls/components/section/style.scss ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/section/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/select/index.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/components/select/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst Select = ({\n  className,\n  options = {},\n  getLabel = label => label,\n  ...rest\n}) => /*#__PURE__*/React.createElement(\"select\", _extends({\n  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('fl-control', className)\n}, rest), forEach(options, (value, label) => /*#__PURE__*/React.createElement(\"option\", {\n  key: value,\n  value: value\n}, getLabel(label, value))));\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/select/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/components/index.js":
/*!***************************************************************!*\
  !*** ./src/FL/controls/components/series/components/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TitleCard: () => (/* reexport safe */ _title_card__WEBPACK_IMPORTED_MODULE_0__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _title_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./title-card */ \"./src/FL/controls/components/series/components/title-card/index.js\");\n\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/components/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/components/title-card/index.js":
/*!**************************************************************************!*\
  !*** ./src/FL/controls/components/series/components/title-card/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/series/components/title-card/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\nconst TitleCard = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({\n  as: Tag = 'div',\n  title,\n  description,\n  thumb,\n  thumbSize = 'sm',\n  thumbProps = {},\n  className,\n  isSelected = false,\n  hasIssues = false,\n  ...rest\n}, ref) => {\n  const hasThumb = thumb || thumbProps;\n  return /*#__PURE__*/React.createElement(Tag, _extends({\n    ref: ref,\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()({\n      'fl-controls-title-card': true,\n      'is-selected': isSelected,\n      'has-issues': hasIssues\n    }, className)\n  }, rest), hasThumb && /*#__PURE__*/React.createElement(\"div\", _extends({\n    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('card-visual', thumbProps.className)\n  }, thumbProps, {\n    style: {\n      '--size': 'sm' === thumbSize ? '30px' : '36px',\n      ...thumbProps.style\n    }\n  }), !hasIssues && thumb, hasIssues && /*#__PURE__*/React.createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_2__.Alert, null)), /*#__PURE__*/React.createElement(\"div\", {\n    className: \"card-text\"\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    className: \"card-title\"\n  }, title), description && /*#__PURE__*/React.createElement(\"div\", {\n    className: \"card-description\"\n  }, description)));\n});\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TitleCard);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/components/title-card/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/components/title-card/style.scss":
/*!****************************************************************************!*\
  !*** ./src/FL/controls/components/series/components/title-card/style.scss ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/components/title-card/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/definitions.js":
/*!**********************************************************!*\
  !*** ./src/FL/controls/components/series/definitions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatItemDefinitions: () => (/* binding */ formatItemDefinitions),\n/* harmony export */   getBuiltinDefinitions: () => (/* binding */ getBuiltinDefinitions),\n/* harmony export */   getDefaultItemState: () => (/* binding */ getDefaultItemState),\n/* harmony export */   getItemDefinition: () => (/* binding */ getItemDefinition)\n/* harmony export */ });\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _parts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parts */ \"./src/FL/controls/components/series/parts.js\");\n\n\nconst {\n  objectMap\n} = FL.Builder.utils.objects;\nconst defaultField = {\n  name: '',\n  label: '',\n  type: 'text',\n  default: ''\n};\nconst formatField = field => ({\n  ...defaultField,\n  ...field\n});\nconst formatFields = (fields = []) => fields.map(formatField);\nconst defaultDefinition = {\n  label: 'Untitled',\n  titleField: '',\n  descriptionField: '',\n  thumbnailField: '',\n  content: _parts__WEBPACK_IMPORTED_MODULE_1__.DefaultItemContent,\n  fields: []\n};\nconst builtInDefs = {\n  custom: {\n    label: 'Custom',\n    titleField: 'title',\n    fields: [{\n      name: 'title',\n      label: 'Title',\n      type: 'text'\n    }, {\n      name: 'description',\n      label: 'Descrition',\n      type: 'text'\n    }]\n  },\n  text: {\n    label: (0,ui_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Text', 'fl-builder'),\n    titleField: 'title',\n    fields: [{\n      name: 'title',\n      label: 'Title',\n      type: 'text'\n    }]\n  }\n};\nconst getBuiltinDefinitions = () => builtInDefs;\n\n// Creates a single definition object\nconst formatItemDefinition = (name, _def) => {\n  const def = {\n    ...defaultDefinition,\n    ..._def\n  };\n  const createItem = (item = {}) => {\n    let state = {};\n    for (let i in def.fields) {\n      const field = def.fields[i];\n      let value = '';\n      if (undefined !== item.state?.[field.name]) {\n        value = item.state[field.name];\n      } else if (field.default) {\n        value = field.default;\n      }\n      state[field.name] = value;\n    }\n    const newItem = {\n      id: item.id ? item.id : Date.now(),\n      type: name,\n      state\n    };\n    if ('function' === typeof _def.createItem) {\n      return _def.createItem(newItem);\n    }\n    return newItem;\n  };\n  const defaultGetState = (item = {}) => {\n    return {\n      ...getDefaultItemState(def),\n      ...item.state\n    };\n  };\n  const getTitle = item => {\n    if (undefined !== item.state[def.titleField] && '' !== item.state[def.titleField]) {\n      return item.state[def.titleField];\n    }\n    return def.label;\n  };\n  const getDescription = item => {\n    if (undefined === item.state[def.titleField] || '' === item.state[def.titleField]) {\n      return null;\n    } else if ('' === def.descriptionField) {\n      return def.label;\n    }\n    return item.state[def.descriptionField];\n  };\n  return {\n    ...def,\n    name,\n    fields: formatFields(def.fields),\n    createItem,\n    getState: 'function' === typeof def.getState ? def.getState : defaultGetState,\n    getTitle: 'function' === typeof def.getTitle ? def.getTitle : getTitle,\n    getDescription: 'function' === typeof def.getDescription ? def.getDescription : getDescription\n  };\n};\n\n// Creates an array of definition objects\nconst formatItemDefinitions = (defs = {}, includeBuiltIn = false) => {\n  const builtIn = getBuiltinDefinitions();\n  if (0 >= defs.length) {\n    return includeBuiltIn ? objectMap(builtIn, formatItemDefinition) : {};\n  }\n  const allDefs = includeBuiltIn ? {\n    ...builtIn,\n    ...defs\n  } : defs;\n  return objectMap(allDefs, formatItemDefinition);\n};\nconst getItemDefinition = (type, defs = {}) => {\n  const typeKeys = Object.keys(defs);\n  const defaultType = defs[typeKeys[0]];\n  return '' === type || !typeKeys.includes(type) ? defaultType : defs[type];\n};\nconst getDefaultItemState = def => {\n  let state = {};\n  for (let i in def.fields) {\n    const {\n      name,\n      default: defaultValue = ''\n    } = def.fields[i];\n    state[name] = defaultValue;\n  }\n  return state;\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/definitions.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/fields.js":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/series/fields.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FieldRow: () => (/* binding */ FieldRow)\n/* harmony export */ });\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_0__);\n\nconst FieldRow = ({\n  item,\n  field,\n  setField,\n  deleteField,\n  setState\n}) => {\n  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(\"div\", null, true === field.custom && /*#__PURE__*/React.createElement(\"input\", {\n    type: \"text\",\n    value: field.label,\n    onInput: e => setField({\n      ...field,\n      label: e.target.value,\n      name: e.target.value.replaceAll(' ', '_').toLowerCase()\n    })\n  }), true !== field.custom && /*#__PURE__*/React.createElement(\"div\", null, field.label)), /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      display: 'flex'\n    }\n  }, /*#__PURE__*/React.createElement(\"input\", {\n    type: \"text\",\n    value: item.state[field.name],\n    onInput: e => setState(field.name, e.target.value)\n  }), true === field.custom && /*#__PURE__*/React.createElement(\"button\", {\n    onClick: () => deleteField(field.name)\n  }, /*#__PURE__*/React.createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_0__.Trash, null))));\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/fields.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/index.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/components/series/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TitleCard: () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_5__.TitleCard),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _definitions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./definitions */ \"./src/FL/controls/components/series/definitions.js\");\n/* harmony import */ var _item__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./item */ \"./src/FL/controls/components/series/item.js\");\n/* harmony import */ var _parts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parts */ \"./src/FL/controls/components/series/parts.js\");\n/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components */ \"./src/FL/controls/components/series/components/index.js\");\n/* harmony import */ var _sortable_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../sortable-list */ \"./src/FL/controls/components/sortable-list/index.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/series/style.scss\");\n\n\n\n\n\n\n\n\n\nconst Series = ({\n  items: _items = [],\n  setItems = () => {},\n  definitions = {},\n  setDefinitions = false,\n  appearance = 'compact',\n  empty: Empty = _parts__WEBPACK_IMPORTED_MODULE_4__.DefaultEmpty,\n  appendNewItems = 'after',\n  toolbarPosition = 'before',\n  toolbarItems,\n  canReset = true,\n  canAdd = true,\n  cloneItem,\n  deleteItem,\n  clearItems,\n  customAddMenu,\n  className\n}) => {\n  const defs = (0,_definitions__WEBPACK_IMPORTED_MODULE_2__.formatItemDefinitions)(definitions);\n  const items = (0,_item__WEBPACK_IMPORTED_MODULE_3__.formatItems)(_items, defs);\n  const _clearItems = () => {\n    if ('function' === typeof clearItems) {\n      return clearItems();\n    }\n    setItems([]);\n  };\n  const _cloneItem = clonedItem => {\n    if ('function' === typeof cloneItem) {\n      return cloneItem(clonedItem.id, clonedItem);\n    }\n\n    // Default behavior\n    const newItem = {\n      ...clonedItem,\n      id: Date.now()\n    };\n    const i = items.findIndex(item => item.id === clonedItem.id);\n    setItems(items.toSpliced(i + 1, 0, newItem));\n  };\n  const _deleteItem = id => {\n    if ('function' === typeof deleteItem) {\n      return deleteItem(id);\n    }\n    setItems(items.filter(item => id !== item.id));\n  };\n  const setItem = newItem => {\n    const i = items.findIndex(item => item.id === newItem.id);\n    setItems(items.with(i, newItem));\n  };\n  const setDefinition = (name, config) => {\n    'function' === typeof setDefinitions && setDefinitions({\n      ...defs,\n      [name]: {\n        ...defs[name],\n        ...config\n      }\n    });\n  };\n  const Toolbar = () => /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-series-toolbar\"\n  }, toolbarItems, /*#__PURE__*/React.createElement(\"div\", null), canReset && /*#__PURE__*/React.createElement(\"button\", {\n    onClick: _clearItems\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Clear', 'fl-builder')), canAdd && /*#__PURE__*/React.createElement(_parts__WEBPACK_IMPORTED_MODULE_4__.AddItemButton, {\n    defs: defs,\n    addItem: newItem => {\n      const newItems = 'before' === appendNewItems ? [newItem, ...items] : [...items, newItem];\n      setItems(newItems);\n    },\n    customAddMenu: customAddMenu\n  }));\n  return /*#__PURE__*/React.createElement(\"div\", {\n    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({\n      'fl-controls-series': true,\n      [`fl-appearance-${appearance}`]: appearance,\n      [`toolbar-position-${toolbarPosition}`]: toolbarPosition\n    }, className)\n  }, 'before' === toolbarPosition && /*#__PURE__*/React.createElement(Toolbar, null), /*#__PURE__*/React.createElement(_sortable_list__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n    className: \"fl-controls-series-list\",\n    items: items,\n    setItems: setItems,\n    item: _item__WEBPACK_IMPORTED_MODULE_3__.SeriesItem,\n    getItemProps: item => {\n      return {\n        item,\n        setItem,\n        definition: (0,_definitions__WEBPACK_IMPORTED_MODULE_2__.getItemDefinition)(item.type, defs),\n        setDefinition,\n        cloneItem: _cloneItem,\n        deleteItem: _deleteItem,\n        canCustomize: false !== setDefinitions\n      };\n    },\n    empty: Empty,\n    isItemEnabled: item => Object.keys(defs).includes(item.type)\n  }), 'after' === toolbarPosition && /*#__PURE__*/React.createElement(Toolbar, null));\n};\nSeries.TitleCard = _components__WEBPACK_IMPORTED_MODULE_5__.TitleCard;\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Series);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/item.js":
/*!***************************************************!*\
  !*** ./src/FL/controls/components/series/item.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SeriesItem: () => (/* binding */ SeriesItem),\n/* harmony export */   formatItem: () => (/* binding */ formatItem),\n/* harmony export */   formatItems: () => (/* binding */ formatItems)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _definitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./definitions */ \"./src/FL/controls/components/series/definitions.js\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dialog */ \"./src/FL/controls/components/dialog/index.js\");\n/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error */ \"./src/FL/controls/components/error/index.js\");\n\n\n\n\n\nconst defaultItem = {\n  id: '',\n  type: '',\n  state: {}\n};\nconst formatItem = (item, def = {}) => ({\n  ...defaultItem,\n  ...item,\n  state: def.getState(item)\n});\n\n/**\n * Ensure proper structure for all items in an array\n */\nconst formatItems = (items = [], defs = {}) => {\n  return items.map(item => formatItem(item, (0,_definitions__WEBPACK_IMPORTED_MODULE_1__.getItemDefinition)(item.type, defs)));\n};\nconst SeriesItem = ({\n  item,\n  setItem,\n  definition,\n  setDefinition,\n  canCustomize = false,\n  cloneItem: _cloneItem,\n  deleteItem: _deleteItem\n}) => {\n  const {\n    content: ItemContent,\n    getTitle,\n    getDescription\n  } = definition;\n  const cloneItem = e => {\n    e.preventDefault();\n    _cloneItem(item);\n  };\n  const deleteItem = e => {\n    e.preventDefault();\n    _deleteItem(item.id);\n  };\n  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_error__WEBPACK_IMPORTED_MODULE_4__[\"default\"].Boundary, null, /*#__PURE__*/React.createElement(ItemContent, {\n    title: getTitle(item),\n    description: getDescription(item),\n    item: item,\n    setItem: setItem,\n    definition: definition,\n    state: item.state,\n    setState: state => setItem({\n      ...item,\n      state\n    }),\n    style: {\n      paddingLeft: 20\n    }\n  })), /*#__PURE__*/React.createElement(\"div\", {\n    className: \"fl-series-item-actions\"\n  }, /*#__PURE__*/React.createElement(\"div\", {\n    style: {\n      display: 'grid',\n      placeContent: 'center start'\n    }\n  }, /*#__PURE__*/React.createElement(\"svg\", {\n    width: \"10\",\n    height: \"19\",\n    viewBox: \"0 0 10 19\",\n    fill: \"none\",\n    style: {\n      marginRight: 'auto'\n    }\n  }, /*#__PURE__*/React.createElement(\"path\", {\n    d: \"M2 2H8\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  }), /*#__PURE__*/React.createElement(\"path\", {\n    d: \"M2 7H8\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  }), /*#__PURE__*/React.createElement(\"path\", {\n    d: \"M2 12H8\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  }), /*#__PURE__*/React.createElement(\"path\", {\n    d: \"M2 17H8\",\n    stroke: \"currentColor\",\n    strokeWidth: \"1.5\",\n    strokeLinecap: \"round\"\n  }))), /*#__PURE__*/React.createElement(\"button\", {\n    onClick: cloneItem\n  }, /*#__PURE__*/React.createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_2__.Clone, null)), /*#__PURE__*/React.createElement(\"button\", {\n    onClick: deleteItem\n  }, /*#__PURE__*/React.createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_2__.Trash, null))));\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/item.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/parts.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/components/series/parts.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AddItemButton: () => (/* binding */ AddItemButton),\n/* harmony export */   DefaultEmpty: () => (/* binding */ DefaultEmpty),\n/* harmony export */   DefaultItemContent: () => (/* binding */ DefaultItemContent),\n/* harmony export */   DefaultMenuContent: () => (/* binding */ DefaultMenuContent)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ui_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ui/i18n */ \"./src/FL/Builder/system/ui/i18n/index.js\");\n/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components */ \"./src/FL/controls/components/series/components/index.js\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! fl-symbols */ \"fl-symbols\");\n/* harmony import */ var fl_symbols__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(fl_symbols__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/utils/index.js\");\n/* harmony import */ var _sortable_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../sortable-list */ \"./src/FL/controls/components/sortable-list/index.js\");\n/* harmony import */ var _fields__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./fields */ \"./src/FL/controls/components/series/fields.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\n\n\n\n\nconst {\n  forEach\n} = FL.Builder.utils.objects;\nconst AddItemButton = ({\n  defs,\n  addItem,\n  customAddMenu: CustomMenu\n}) => {\n  const [isShowing, setIsShowing] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const menu = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.useClickOutside)(() => setIsShowing(false));\n  const hasMultipleDefs = 1 < Object.keys(defs).length;\n  const Menu = ({\n    addItem\n  }) => forEach(defs, (type, def) => {\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"li\", {\n      key: type\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n      onClick: () => {\n        addItem(def.createItem());\n      }\n    }, def.label));\n  });\n  const handleClick = e => {\n    e.stopPropagation();\n    if (!(hasMultipleDefs || CustomMenu)) {\n      const def = defs[Object.keys(defs)[0]];\n      'function' === typeof def?.createItem && addItem(def.createItem());\n    } else {\n      setIsShowing(!isShowing);\n    }\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-series-add-button\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    onClick: handleClick\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(fl_symbols__WEBPACK_IMPORTED_MODULE_4__.Plus, null)), isShowing && (hasMultipleDefs || CustomMenu) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"ul\", {\n    ref: menu,\n    className: \"fl-series-add-button-menu \"\n  }, CustomMenu ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CustomMenu, {\n    addItem: addItem,\n    closeMenu: () => setIsShowing(false)\n  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Menu, {\n    addItem: addItem\n  })));\n};\nconst DefaultEmpty = ({\n  emptyMessage = (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('No Items', 'fl-builder'),\n  className,\n  ...rest\n}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", _extends({\n  className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('fl-series-empty', className)\n}, rest), emptyMessage);\nconst DefaultItemContent = ({\n  item,\n  setItem,\n  definition,\n  state,\n  setState,\n  ...rest\n}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components__WEBPACK_IMPORTED_MODULE_3__.TitleCard, rest);\nconst DefaultMenuContent = ({\n  item,\n  setItem,\n  definition,\n  setDefinition,\n  canCustomize,\n  cloneItem,\n  deleteItem\n}) => {\n  const setState = (key, value) => setItem({\n    ...item,\n    state: {\n      ...item.state,\n      [key]: value\n    }\n  });\n  const addField = () => {\n    setDefinition({\n      ...definition,\n      fields: [...definition.fields, {\n        name: 'untitled',\n        label: 'Untitled Field',\n        type: 'text',\n        default: '',\n        custom: true\n      }]\n    });\n  };\n  const setField = (name, config) => {\n    const index = definition.fields.findIndex(field => field.name === name);\n    const newField = {\n      ...definition.fields[name],\n      ...config\n    };\n    setDefinition({\n      ...definition,\n      fields: definition.fields.with(index, newField)\n    });\n  };\n  const deleteField = name => {\n    setDefinition({\n      ...definition,\n      fields: definition.fields.filter(field => name !== field.name)\n    });\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-series-item-editor\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-series-item-editor-content\"\n  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_sortable_list__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n    className: \"fl-series-item-fields\",\n    items: definition.fields,\n    item: _fields__WEBPACK_IMPORTED_MODULE_7__.FieldRow,\n    getItemProps: field => ({\n      field,\n      setField: v => setField(field.name, v),\n      deleteField,\n      item,\n      setState\n    })\n  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: \"fl-series-item-editor-toolbar\"\n  }, canCustomize && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    onClick: addField\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Add Field', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    onClick: cloneItem\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Duplicate', 'fl-builder')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"button\", {\n    onClick: deleteItem\n  }, (0,ui_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Delete', 'fl-builder'))));\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/parts.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/series/style.scss":
/*!******************************************************!*\
  !*** ./src/FL/controls/components/series/style.scss ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/series/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/sliders/index.js":
/*!*****************************************************!*\
  !*** ./src/FL/controls/components/sliders/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Slider: () => (/* binding */ Slider)\n/* harmony export */ });\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/components/sliders/style.scss\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\nconst Slider = ({\n  className,\n  vertical = false,\n  style,\n  ...rest\n}) => {\n  return /*#__PURE__*/React.createElement(\"input\", _extends({\n    type: \"range\",\n    className: `fl-range-input ${className}`,\n    style: {\n      writingMode: true === vertical ? 'vertical-lr' : null,\n      ...style\n    }\n  }, rest));\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/sliders/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/sliders/style.scss":
/*!*******************************************************!*\
  !*** ./src/FL/controls/components/sliders/style.scss ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/sliders/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/components/sortable-list/index.js":
/*!***********************************************************!*\
  !*** ./src/FL/controls/components/sortable-list/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   defaultSortConfig: () => (/* binding */ defaultSortConfig),\n/* harmony export */   reorderByIds: () => (/* binding */ reorderByIds)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ \"./node_modules/classnames/index.js\");\n/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ \"./src/FL/controls/utils/index.js\");\n/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../error */ \"./src/FL/controls/components/error/index.js\");\nfunction _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }\n\n\n\n\nconst defaultSortConfig = {\n  items: 'li',\n  cursor: 'move',\n  distance: 3,\n  opacity: 0.75,\n  placeholder: 'fl-sortable-placeholder',\n  tolerance: 'pointer',\n  axis: 'y',\n  helper: 'clone',\n  start: () => {},\n  stop: () => {},\n  update: () => {}\n};\nconst SortableList = ({\n  items = [],\n  getId = item => item.id,\n  getItemProps = item => item,\n  sortConfig = defaultSortConfig,\n  empty: Empty,\n  item: ItemContent,\n  setItems,\n  setItemOrder = () => {},\n  isItemEnabled = () => true,\n  style,\n  ...rest\n}) => {\n  const [isDragging, setIsDragging] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);\n  const hasItems = 0 < items.length;\n  const rAF = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const ref = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.useJQuerySortable)({\n    ...sortConfig,\n    start: (e, ui) => {\n      setIsDragging(true);\n      sortConfig.start(e, ui);\n    },\n    stop: (e, ui) => {\n      setIsDragging(false);\n      sortConfig.stop(e, ui);\n    },\n    update: (e, ui) => {\n      if (rAF.current) {\n        cancelAnimationFrame(rAF.current);\n      }\n      rAF.current = requestAnimationFrame(() => {\n        const ids = jQuery(e.target).sortable('toArray', {\n          attribute: 'data-id'\n        });\n        setItemOrder(ids);\n        if ('function' === typeof setItems) {\n          setItems(reorderByIds(items, ids));\n        }\n        sortConfig.update(e, ui);\n      });\n    }\n  }, [items]);\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"ul\", _extends({\n    ref: ref,\n    style: {\n      listStyle: 'none',\n      margin: 0,\n      padding: 0,\n      ...style\n    }\n  }, rest), !hasItems && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Empty, null), hasItems && items.map((item, i) => {\n    if (!isItemEnabled(item)) {\n      return null;\n    }\n    const id = getId(item, i);\n    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"li\", {\n      key: id,\n      \"data-id\": id\n    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_error__WEBPACK_IMPORTED_MODULE_3__[\"default\"].Boundary, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ItemContent, _extends({\n      isDragging: isDragging\n    }, getItemProps(item)))));\n  }));\n};\nSortableList.defaultConfig = defaultSortConfig;\n\n// Reorder layers based on an array of ids\nconst reorderByIds = (layers, ids) => {\n  return layers.toSorted((a, b) => {\n    const aIndex = ids.findIndex(id => id == a.id);\n    const bIndex = ids.findIndex(id => id == b.id);\n    if (aIndex < bIndex) {\n      return -1;\n    } else if (aIndex > bIndex) {\n      return 1;\n    }\n    return 0;\n  });\n};\nSortableList.reorderByIds = reorderByIds;\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SortableList);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/sortable-list/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/components/style.scss":
/*!***********************************************!*\
  !*** ./src/FL/controls/components/style.scss ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/components/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/field-types/background/index.js":
/*!*********************************************************!*\
  !*** ./src/FL/controls/field-types/background/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ \"./src/FL/controls/components/index.js\");\n\n\nconst defaultValue = {\n  layers: [],\n  css: ''\n};\n\n/**\n * Main Background Field Component\n */\nconst BackgroundField = ({\n  name,\n  value: _value = defaultValue,\n  setValue\n}) => {\n  const value = !_value ? defaultValue : _value;\n  const layersInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();\n  const cssInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();\n  const updateInputs = (layers, css) => {\n    layersInput.current.value = JSON.stringify(layers);\n    cssInput.current.value = css;\n    jQuery(cssInput.current).trigger('change');\n  };\n\n  // Ensure css was initially generated\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (cssInput.current && '' === value.css) {\n      setValue({\n        ...value,\n        css: _components__WEBPACK_IMPORTED_MODULE_1__.Background.getCSS(value.layers)\n      });\n    }\n  }, []);\n  const setLayers = newLayers => {\n    const css = _components__WEBPACK_IMPORTED_MODULE_1__.Background.getCSS(newLayers);\n    setValue({\n      layers: newLayers,\n      css\n    });\n    updateInputs(newLayers, css);\n  };\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components__WEBPACK_IMPORTED_MODULE_1__.Background.Input, {\n    type: \"background\",\n    value: Array.isArray(value.layers) ? value.layers : [],\n    onChange: setLayers\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    type: \"hidden\",\n    name: `${name}[layers]`,\n    value: Array.isArray(value.layers) ? JSON.stringify(value.layers) : '[]',\n    ref: layersInput\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    type: \"hidden\",\n    name: `${name}[css]`,\n    value: value.css,\n    ref: cssInput\n  }));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'background',\n  label: 'Background',\n  content: BackgroundField\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/field-types/background/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/field-types/color/index.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/field-types/color/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ \"./src/FL/controls/components/index.js\");\n\n\n\nconst ColorField = ({\n  name,\n  value,\n  setValue,\n  field,\n  getFieldElement\n}) => {\n  const picker = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const input = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const {\n    show_alpha = true,\n    show_reset = true\n  } = field;\n  const processValue = value => {\n    // if its a hex without the # add it\n    if (!CSS.supports('color', value) && CSS.supports('color', '#' + value)) {\n      return '#' + value;\n    }\n    return value;\n  };\n  const _value = processValue(value);\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    const el = input.current;\n    if (!el) return;\n    let currentValue = el.value;\n\n    // Define custom getter/setter for `.value`\n    Object.defineProperty(el, 'value', {\n      get() {\n        return currentValue;\n      },\n      set(newVal) {\n        if (newVal !== currentValue) {\n          currentValue = newVal;\n          setValue(newVal);\n        }\n      },\n      configurable: true\n    });\n\n    // Set initial value (triggers setter if changed)\n    el.value = el.value;\n\n    // Cleanup: restore default behavior\n    return () => {\n      delete el.value;\n    };\n  }, [setValue]);\n  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components__WEBPACK_IMPORTED_MODULE_1__.Color.Picker, {\n    ref: picker,\n    value: _value,\n    showAlpha: show_alpha,\n    showReset: show_reset,\n    onChange: val => {\n      setValue(val);\n      input.current.value = val;\n      jQuery(input.current).trigger('change');\n    },\n    onConnect: ({\n      uid,\n      isGlobalColor\n    }) => {\n      if (undefined !== FLThemeBuilderFieldConnections) {\n        const originalName = name.replace(/_(large|medium|responsive)$/, '');\n        const field = jQuery(getFieldElement(originalName));\n        const property = isGlobalColor ? 'global_color_' + uid : 'theme_color_' + uid;\n        const label = FLBuilderConfig.globalColorLabels[property];\n        const config = {\n          property: property,\n          object: 'site',\n          field: 'color',\n          settings: null\n        };\n        FLThemeBuilderFieldConnections._connectField(field, label, config);\n        picker.current.close();\n      }\n    }\n  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"input\", {\n    ref: input,\n    type: \"hidden\",\n    name: name,\n    value: _value,\n    className: \"fl-color-picker-value fl-react-color-picker-value\"\n  }));\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  name: 'color',\n  label: 'Color',\n  content: ColorField\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/field-types/color/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/field-types/index.js":
/*!**********************************************!*\
  !*** ./src/FL/controls/field-types/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   background: () => (/* reexport safe */ _background__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n/* harmony export */   color: () => (/* reexport safe */ _color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./color */ \"./src/FL/controls/field-types/color/index.js\");\n/* harmony import */ var _background__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./background */ \"./src/FL/controls/field-types/background/index.js\");\n\n\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/field-types/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/index.js":
/*!**********************************!*\
  !*** ./src/FL/controls/index.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./state */ \"./src/FL/controls/state/index.js\");\n/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components */ \"./src/FL/controls/components/index.js\");\n/* harmony import */ var _field_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./field-types */ \"./src/FL/controls/field-types/index.js\");\n/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.scss */ \"./src/FL/controls/style.scss\");\n\n\n\n\nwindow.FL = window.FL || {};\nFL.controls = Object.freeze({\n  useControlsStore: _state__WEBPACK_IMPORTED_MODULE_0__.useControlsStore,\n  createFormStore: _state__WEBPACK_IMPORTED_MODULE_0__.createFormStore,\n  Color: _components__WEBPACK_IMPORTED_MODULE_1__.Color,\n  Background: _components__WEBPACK_IMPORTED_MODULE_1__.Background,\n  Gradient: _components__WEBPACK_IMPORTED_MODULE_1__.Gradient,\n  Dialog: _components__WEBPACK_IMPORTED_MODULE_1__.Dialog,\n  DialogButton: _components__WEBPACK_IMPORTED_MODULE_1__.DialogButton,\n  Error: _components__WEBPACK_IMPORTED_MODULE_1__.Error,\n  Section: _components__WEBPACK_IMPORTED_MODULE_1__.Section,\n  Series: _components__WEBPACK_IMPORTED_MODULE_1__.Series,\n  Input: _components__WEBPACK_IMPORTED_MODULE_1__.Input,\n  fieldTypes: _field_types__WEBPACK_IMPORTED_MODULE_2__\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/state/controls-store/index.js":
/*!*******************************************************!*\
  !*** ./src/FL/controls/state/controls-store/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! redux */ \"redux\");\n/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(redux__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./reducer */ \"./src/FL/controls/state/controls-store/reducer.js\");\n\n\n\nconst defaultState = {\n  color: {\n    presets: []\n  },\n  backgrounds: {\n    presets: []\n  },\n  attachmentSizes: {}\n};\n\n// eslint-disable-next-line\nconst createControlsStore = (storeKey = 'fl-controls', initialState = defaultState) => {\n  const store = (0,redux__WEBPACK_IMPORTED_MODULE_1__.createStore)(_reducer__WEBPACK_IMPORTED_MODULE_2__[\"default\"], initialState);\n  const actions = {\n    setState(state) {\n      return store.dispatch({\n        type: 'SET_STATE',\n        state\n      });\n    },\n    async addColorPreset(value) {\n      const data = await wp.apiFetch({\n        path: '/fl-controls/v1/color_presets',\n        method: 'POST',\n        data: {\n          addPresets: [value]\n        }\n      });\n      return store.dispatch({\n        type: 'SET_COLOR_PRESETS',\n        presets: data.presets\n      });\n    },\n    async deleteColorPreset(value) {\n      const data = await wp.apiFetch({\n        path: '/fl-controls/v1/color_presets',\n        method: 'DELETE',\n        data: {\n          deletePresets: [value]\n        }\n      });\n      return store.dispatch({\n        type: 'SET_COLOR_PRESETS',\n        presets: data.presets\n      });\n    },\n    async clearColorPresets() {\n      await wp.apiFetch({\n        path: '/fl-controls/v1/color_presets',\n        method: 'POST',\n        data: {\n          clearPresets: true\n        }\n      });\n      return store.dispatch({\n        type: 'SET_COLOR_PRESETS',\n        presets: []\n      });\n    },\n    async addBackgroundPreset(value) {\n      const data = await wp.apiFetch({\n        path: '/fl-controls/v1/background_presets',\n        method: 'POST',\n        data: {\n          addPresets: [value]\n        }\n      });\n      return store.dispatch({\n        type: 'SET_BACKGROUND_PRESETS',\n        presets: data.presets\n      });\n    },\n    addSizesForAttachment(id, sizes = {}) {\n      return store.dispatch({\n        type: 'ADD_ATTACHMENT_SIZES',\n        id,\n        sizes\n      });\n    }\n  };\n\n  // Fetch initial state\n  // eslint-disable-next-line\n  requestIdleCallback(async () => {\n    const state = await wp.apiFetch({\n      path: '/fl-controls/v1/state',\n      method: 'GET'\n    });\n    actions.setState({\n      ...initialState,\n      ...state\n    });\n  });\n  const selectState = state => ({\n    colorPresets: state.color.presets,\n    colorSets: state.color.sets,\n    backgroundPresets: state.backgrounds.presets,\n    attachmentSizes: state.attachmentSizes\n  });\n  return {\n    useControlsStore: () => {\n      const snapshot = store.getState();\n      const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(selectState(snapshot));\n      (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => store.subscribe(() => setState(selectState(store.getState()))), []);\n      return {\n        ...state,\n        ...actions,\n        // eslint-disable-next-line\n        getSizesForAttachment: async id => {\n          if (undefined !== state.attachmentSizes[id]) {\n            return state.attachmentSizes[id];\n          } else {\n            // Fetch the sizes object from the server\n            const data = await wp.apiFetch({\n              path: '/fl-controls/v1/attachment_sizes?id=' + id,\n              method: 'GET'\n            });\n\n            // Cache the sizes in the store before returning\n            actions.addSizesForAttachment(id, data.sizes);\n            return data.sizes;\n          }\n        }\n      };\n    }\n  };\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createControlsStore);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/state/controls-store/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/state/controls-store/reducer.js":
/*!*********************************************************!*\
  !*** ./src/FL/controls/state/controls-store/reducer.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((state, action) => {\n  switch (action.type) {\n    case 'SET_STATE':\n      return {\n        ...action.state\n      };\n    case 'SET_COLOR_PRESETS':\n      return {\n        ...state,\n        color: {\n          ...state.color,\n          presets: action.presets\n        }\n      };\n    case 'SET_BACKGROUND_PRESETS':\n      return {\n        ...state,\n        backgrounds: {\n          ...state.backgrounds,\n          presets: action.presets\n        }\n      };\n    case 'ADD_ATTACHMENT_SIZES':\n      return {\n        ...state,\n        attachmentSizes: {\n          ...state.attachmentSizes,\n          [action.id]: action.sizes\n        }\n      };\n    default:\n      return {\n        ...state,\n        color: {\n          ...state.color,\n          presets: state.color.presets\n        }\n      };\n  }\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/state/controls-store/reducer.js?\n}");

/***/ }),

/***/ "./src/FL/controls/state/create-external-store/index.js":
/*!**************************************************************!*\
  !*** ./src/FL/controls/state/create-external-store/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\nconst createExternalStore = (initial, config = {}) => {\n  let state = initial;\n  let subscribers = new Set();\n  const subscribe = callback => {\n    subscribers.add(callback);\n    return () => subscribers.delete(callback);\n  };\n  const getSnapshot = () => state;\n  const setState = newState => {\n    state = newState;\n    subscribers.forEach(callback => callback());\n  };\n  const useExternalState = () => {\n    const _state = (0,react__WEBPACK_IMPORTED_MODULE_0__.useSyncExternalStore)(subscribe, getSnapshot);\n    return [_state, setState];\n  };\n\n  // Setup External API\n  let api = {\n    subscribe,\n    getSnapshot,\n    setState,\n    useExternalState\n  };\n  for (let prop in config) {\n    const callback = config[prop];\n    api[prop] = (...rest) => setState(callback(getSnapshot(), ...rest));\n  }\n  return api;\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createExternalStore);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/state/create-external-store/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/state/create-form-store/index.js":
/*!**********************************************************!*\
  !*** ./src/FL/controls/state/create-form-store/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _create_external_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../create-external-store */ \"./src/FL/controls/state/create-external-store/index.js\");\n\nconst createFormStore = (_forms = []) => {\n  // Ensure state is an array even if a single object is given\n  const forms = Array.isArray(_forms) ? _forms : [_forms];\n  const store = (0,_create_external_store__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(forms, {\n    /**\n     * These functions get wrapped into the store object with state passed.\n     */\n    setForm: (state, value) => [value],\n    pushForm: (state, value) => [...state, value],\n    updateForms: (state, value) => value,\n    pop: state => state.toSpliced(-1, 1),\n    reset: () => [],\n    setCurrentForm: (forms, state = {}) => forms.toSpliced(-1, 1, state)\n  });\n  store.useFormState = store.useExternalState;\n  return store;\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createFormStore);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/state/create-form-store/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/state/index.js":
/*!****************************************!*\
  !*** ./src/FL/controls/state/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createExternalStore: () => (/* reexport safe */ _create_external_store__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n/* harmony export */   createFormStore: () => (/* reexport safe */ _create_form_store__WEBPACK_IMPORTED_MODULE_2__[\"default\"]),\n/* harmony export */   useControlsStore: () => (/* binding */ useControlsStore)\n/* harmony export */ });\n/* harmony import */ var _controls_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./controls-store */ \"./src/FL/controls/state/controls-store/index.js\");\n/* harmony import */ var _create_external_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./create-external-store */ \"./src/FL/controls/state/create-external-store/index.js\");\n/* harmony import */ var _create_form_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-form-store */ \"./src/FL/controls/state/create-form-store/index.js\");\n\n\n\nconst {\n  useControlsStore\n} = (0,_controls_store__WEBPACK_IMPORTED_MODULE_0__[\"default\"])();\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/state/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/style.scss":
/*!************************************!*\
  !*** ./src/FL/controls/style.scss ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/style.scss?\n}");

/***/ }),

/***/ "./src/FL/controls/utils/color/index.js":
/*!**********************************************!*\
  !*** ./src/FL/controls/utils/color/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   hexToRGB: () => (/* binding */ hexToRGB),\n/* harmony export */   hslToRgb: () => (/* binding */ hslToRgb),\n/* harmony export */   hwbToRgb: () => (/* binding */ hwbToRgb),\n/* harmony export */   isHex: () => (/* binding */ isHex),\n/* harmony export */   rgbToHex: () => (/* binding */ rgbToHex),\n/* harmony export */   rgbToHsl: () => (/* binding */ rgbToHsl),\n/* harmony export */   rgbToHwb: () => (/* binding */ rgbToHwb)\n/* harmony export */ });\n/**\n * Color functions - many pulled directly from W3C Spec\n * https://drafts.csswg.org/css-color\n */\n\n/**\n * @param {number} hue - Hue as degrees 0..360\n * @param {number} sat - Saturation in reference range [0,100]\n * @param {number} light - Lightness in reference range [0,100]\n * @return {number[]} Array of sRGB components; in-gamut colors in range [0..1]\n */\nfunction hslToRgb(hue, sat, light, a = 1) {\n  hue = hue % 360;\n  if (hue < 0) {\n    hue += 360;\n  }\n  sat /= 100;\n  light /= 100;\n  function f(n) {\n    let k = (n + hue / 30) % 12;\n    let a = sat * Math.min(light, 1 - light);\n    return light - a * Math.max(-1, Math.min(k - 3, 9 - k, 1));\n  }\n  return [f(0), f(8), f(4), a];\n}\n\n/**\n * @param {number} hue -  Hue as degrees 0..360\n * @param {number} white -  Whiteness in reference range [0,100]\n * @param {number} black -  Blackness in reference range [0,100]\n * @return {number[]} Array of RGB components 0..1\n */\nfunction hwbToRgb(hue, white, black) {\n  white /= 100;\n  black /= 100;\n  if (white + black >= 1) {\n    let gray = white / (white + black);\n    return [gray, gray, gray];\n  }\n  let rgb = hslToRgb(hue, 100, 50);\n  for (let i = 0; i < 3; i++) {\n    rgb[i] *= 1 - white - black;\n    rgb[i] += white;\n  }\n  return rgb;\n}\n\n/**\n * @param {number} red - Red component 0..1\n * @param {number} green - Green component 0..1\n * @param {number} blue - Blue component 0..1\n * @return {number[]} Array of HSL values: Hue as degrees 0..360, Saturation and Lightness in reference range [0,100]\n */\nfunction rgbToHsl(red, green, blue, a = 1) {\n  let max = Math.max(red, green, blue);\n  let min = Math.min(red, green, blue);\n  let [hue, sat, light] = [0, 0, (min + max) / 2];\n  let d = max - min;\n  if (d !== 0) {\n    sat = light === 0 || light === 1 ? 0 : (max - light) / Math.min(light, 1 - light);\n    switch (max) {\n      case red:\n        hue = (green - blue) / d + (green < blue ? 6 : 0);\n        break;\n      case green:\n        hue = (blue - red) / d + 2;\n        break;\n      case blue:\n        hue = (red - green) / d + 4;\n    }\n    hue = hue * 60;\n  }\n\n  // Very out of gamut colors can produce negative saturation\n  // If so, just rotate the hue by 180 and use a positive saturation\n  // see https://github.com/w3c/csswg-drafts/issues/9222\n  if (sat < 0) {\n    hue += 180;\n    sat = Math.abs(sat);\n  }\n  if (hue >= 360) {\n    hue = hue - 360;\n  }\n  return [parseInt(hue), (sat * 100).toFixed(2), (light * 100).toFixed(2), a];\n}\n\n/**\n * @param {number} red - Red component 0..1\n * @param {number} green - Green component 0..1\n * @param {number} blue - Blue component 0..1\n * @return {number[]} Array of HWB values: Hue as degrees 0..360, Whiteness and Blackness in reference range [0,100]\n */\nfunction rgbToHwb(red, green, blue, a = 1) {\n  var hsl = rgbToHsl(red, green, blue);\n  var white = Math.min(red, green, blue);\n  var black = 1 - Math.max(red, green, blue);\n  return [parseFloat(hsl[0].toFixed(2)), (white * 100).toFixed(2), (black * 100).toFixed(2), a];\n}\nconst isHex = color => /^#([0-9A-F]{3}|[0-9A-F]{4}|[0-9A-F]{6}|[0-9A-F]{8})$/i.test(color);\nfunction hexToRGB(h) {\n  let r = 0,\n    g = 0,\n    b = 0,\n    a = 1;\n\n  // 3 digits\n  if (h.length == 4) {\n    r = \"0x\" + h[1] + h[1];\n    g = \"0x\" + h[2] + h[2];\n    b = \"0x\" + h[3] + h[3];\n\n    // 6 digits\n  } else if (h.length == 7) {\n    r = \"0x\" + h[1] + h[2];\n    g = \"0x\" + h[3] + h[4];\n    b = \"0x\" + h[5] + h[6];\n\n    // 4 digits\n  } else if (h.length == 5) {\n    r = \"0x\" + h[1] + h[1];\n    g = \"0x\" + h[2] + h[2];\n    b = \"0x\" + h[3] + h[3];\n    a = \"0x\" + h[4] + h[4];\n\n    // 8 digits\n  } else if (h.length == 9) {\n    r = \"0x\" + h[1] + h[2];\n    g = \"0x\" + h[3] + h[4];\n    b = \"0x\" + h[5] + h[6];\n    a = \"0x\" + h[7] + h[8];\n  }\n  a = +(a / 255).toFixed(3);\n  r = parseInt(r);\n  g = parseInt(g);\n  b = parseInt(b);\n  return [r, g, b, a];\n}\nconst rgbToHex = (r, g, b) => {\n  return '#' + ((r << 16) + (g << 8) + b).toString(16).padStart(6, '0');\n};\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/utils/color/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/utils/index.js":
/*!****************************************!*\
  !*** ./src/FL/controls/utils/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   clamp: () => (/* binding */ clamp),\n/* harmony export */   color: () => (/* reexport module object */ _color__WEBPACK_IMPORTED_MODULE_3__),\n/* harmony export */   degreesToPercent: () => (/* binding */ degreesToPercent),\n/* harmony export */   mapNumRange: () => (/* binding */ mapNumRange),\n/* harmony export */   useClickOutside: () => (/* reexport safe */ _use_click_outside__WEBPACK_IMPORTED_MODULE_0__[\"default\"]),\n/* harmony export */   useJQuerySortable: () => (/* reexport safe */ _use_jquery_sortable__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n/* harmony export */   usePreventWheel: () => (/* reexport safe */ _use_prevent_wheel__WEBPACK_IMPORTED_MODULE_2__[\"default\"])\n/* harmony export */ });\n/* harmony import */ var _use_click_outside__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./use-click-outside */ \"./src/FL/controls/utils/use-click-outside.js\");\n/* harmony import */ var _use_jquery_sortable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./use-jquery-sortable */ \"./src/FL/controls/utils/use-jquery-sortable.js\");\n/* harmony import */ var _use_prevent_wheel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./use-prevent-wheel */ \"./src/FL/controls/utils/use-prevent-wheel.js\");\n/* harmony import */ var _color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./color */ \"./src/FL/controls/utils/color/index.js\");\n\n\n\n\n\nconst clamp = (num, a, b) => Math.max(Math.min(num, Math.max(a, b)), Math.min(a, b));\nconst mapNumRange = (num, inMin, inMax, outMin, outMax) => {\n  return (num - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;\n};\nconst degreesToPercent = v => mapNumRange(v, 0, 360, 0, 100);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/utils/index.js?\n}");

/***/ }),

/***/ "./src/FL/controls/utils/use-click-outside.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/utils/use-click-outside.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\n\n/**\n * Fire callback if any click is outside of a certain dom element.\n * Given ref must be passed to dom element.\n */\nconst useClickOutside = (onClickOutside = () => {}) => {\n  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  const checkClick = e => {\n    if (!e.composedPath().includes(ref.current)) {\n      onClickOutside(e);\n    }\n  };\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(() => {\n    window.parent.addEventListener('pointerdown', checkClick);\n    return () => window.parent.removeEventListener('pointerdown', checkClick);\n  }, []);\n  return ref;\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useClickOutside);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/utils/use-click-outside.js?\n}");

/***/ }),

/***/ "./src/FL/controls/utils/use-jquery-sortable.js":
/*!******************************************************!*\
  !*** ./src/FL/controls/utils/use-jquery-sortable.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\n\n/**\n * Hook that accepts a jQuery.sortable() config object and returns a ref callback\n * Add the ref to the root list wrapper that you would normally apply sortable to.\n *\n * @param {Object} Sortable config\n * @param Array deps - just like dependencies for useCallback or useEffect\n * @return Function - ref callback\n */\nconst useJQuerySortable = (config = {}, deps = []) => {\n  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(el => {\n    const $el = jQuery(el).sortable(config);\n    //return () => $el.sortable( 'destroy' )\n  }, deps);\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useJQuerySortable);\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/utils/use-jquery-sortable.js?\n}");

/***/ }),

/***/ "./src/FL/controls/utils/use-prevent-wheel.js":
/*!****************************************************!*\
  !*** ./src/FL/controls/utils/use-prevent-wheel.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\nconst stopWheel = e => e.stopPropagation();\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (() => {\n  const [el, setEl] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n    if (el) {\n      el.addEventListener('wheel', stopWheel, {\n        passive: false\n      });\n      return () => el.removeEventListener('wheel', stopWheel);\n    }\n  }, [el]);\n  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(setEl);\n});\n\n//# sourceURL=webpack://bb-plugin/./src/FL/controls/utils/use-prevent-wheel.js?\n}");

/***/ }),

/***/ "@wordpress/hooks":
/*!***************************!*\
  !*** external "wp.hooks" ***!
  \***************************/
/***/ ((module) => {

"use strict";
module.exports = wp.hooks;

/***/ }),

/***/ "@wordpress/i18n":
/*!**************************!*\
  !*** external "wp.i18n" ***!
  \**************************/
/***/ ((module) => {

"use strict";
module.exports = wp.i18n;

/***/ }),

/***/ "fl-symbols":
/*!*****************************!*\
  !*** external "FL.symbols" ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = FL.symbols;

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

"use strict";
module.exports = React;

/***/ }),

/***/ "redux":
/*!************************!*\
  !*** external "Redux" ***!
  \************************/
/***/ ((module) => {

"use strict";
module.exports = Redux;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./src/FL/controls/index.js");
/******/ 	
/******/ })()
;