<?php
/*
 * Plugin Name: BD Login Page Customizer
 * Description: Customize the WordPress login page with custom styles and settings.
 * Version: 1.0.1
 * Author: bdplugins
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       bd-login-page-customizer
*/
if (! defined('ABSPATH')) exit;

define("BDPLPC_VERSION", "1.0.1");

// Add a menu for the plugin settings
add_action('admin_menu', function () {
    add_menu_page(
        'Login Page Customizer',
        'Login Customizer',
        'manage_options',
        'login-page-customizer',
        'bdplpc_settings_page',
        'dashicons-admin-appearance',
        100
    );
});


// Settings page callback
function bdplpc_settings_page()
{
    if (isset($_POST['bdplpc_save_settings'])) {
        check_admin_referer('bdplpc_save_settings_nonce');

        $bdplpc_background_color = sanitize_hex_color(wp_unslash($_POST['bdplpc_background_color'] ?? '#ffffff'));
        $bdplpc_background_url = esc_url_raw(wp_unslash($_POST['bdplpc_logo_url'] ?? ''));
        $bdplpc_form_background_color = sanitize_hex_color(wp_unslash($_POST['bdplpc_form_background_color'] ?? ''));
        $bdplpc_header_url = esc_url_raw(wp_unslash($_POST['bdplpc_header_url'] ?? ''));
        $bdplpc_bg_image_url = esc_url_raw(wp_unslash($_POST['bdplpc_bg_image_url'] ?? ''));

        update_option('bdplpc_background_color', $bdplpc_background_color);
        update_option('bdplpc_bg_image_url', $bdplpc_bg_image_url);
        update_option('bdplpc_logo_url', $bdplpc_background_url);
        update_option('bdplpc_form_background_color', $bdplpc_form_background_color);
        echo '<div class="updated"><p>Settings saved!</p></div>';
        update_option('bdplpc_header_url', $bdplpc_header_url);
    }

    $background_color = get_option('bdplpc_background_color', '#ffffff');
    $bdplpc_bg_image_url = get_option('bdplpc_bg_image_url', '');
    $logo_url = get_option('bdplpc_logo_url', '');
    $form_background_color = get_option('bdplpc_form_background_color', '#ffffff');
    $header_url = get_option('bdplpc_header_url', 'https://wordpress.org/');

?>
    <div class="wrap">
        <h1>Login Page Customizer</h1>
        <form method="post">
            <?php wp_nonce_field('bdplpc_save_settings_nonce'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="bdplpc_background_color">Background Color</label>
                    </th>
                    <td>
                        <input type="color" id="bdplpc_background_color" name="bdplpc_background_color" value="<?php echo esc_attr($background_color); ?>">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="bdplpc_logo_url">Background Image Url</label>
                    </th>
                    <td>
                        <input type="url" id="bdplpc_bg_image_url" name="bdplpc_bg_image_url" value="<?php echo esc_url($bdplpc_bg_image_url); ?>" size="50">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="bdplpc_logo_url">Logo URL</label>
                    </th>
                    <td>
                        <input type="url" id="bdplpc_logo_url" name="bdplpc_logo_url" value="<?php echo esc_url($logo_url); ?>" size="50">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="bdplpc_logo_url">Login Header Url</label>
                    </th>
                    <td>
                        <input type="url" id="bdplpc_header_url" name="bdplpc_header_url" value="<?php echo esc_url($header_url); ?>" size="50">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="bdplpc_form_background_color">Login Form Background Color</label>
                    </th>
                    <td>
                        <input type="color" id="bdplpc_form_background_color" name="bdplpc_form_background_color" value="<?php echo esc_attr($form_background_color); ?>">
                    </td>
                </tr>
            </table>
            <p class="submit">
                <button type="submit" name="bdplpc_save_settings" class="button button-primary">Save Settings</button>
            </p>
        </form>
    </div>
<?php
}

// Enqueue custom styles on the login page
add_action('login_enqueue_scripts', 'bdplpc_login_assets');

function bdplpc_login_assets()
{
    $background_color = esc_attr(get_option('bdplpc_background_color', '#ffffff'));
    $bdplpc_bg_image_url = esc_attr(get_option('bdplpc_bg_image_url', ''));
    $logo_url = esc_url(get_option('bdplpc_logo_url', ''));
    $form_background_color = esc_attr(get_option('bdplpc_form_background_color', '#ffffff'));

    $inline_css = "
        :root {
            --bdplpc-background-color: {$background_color};
            --bdplpc-background-image: url('{$bdplpc_bg_image_url}');
            --bdplpc-logo-url: url('{$logo_url}');
            --bdplpc-form-background-color: {$form_background_color};
        }";

    wp_enqueue_style('bdplpc-login-styles', plugin_dir_url(__FILE__) . 'assets/css/login.css', [], BDPLPC_VERSION);
    wp_add_inline_style('bdplpc-login-styles', $inline_css);
}

add_filter('login_headerurl', 'bdplpc_login_header_url');

function bdplpc_login_header_url()
{
    $header_url = get_option('bdplpc_header_url', 'https://wordpress.org/');
    return $header_url;
}
