<?php

defined('ABSPATH') || exit;

class Bayarcash_EDD_Error_Monitor
{
    private const MONITOR_URL = 'https://monitor.bayar.cash/api/v1/payment-errors';
    private const API_KEY = '5e553c4238bfd8bae4c67db7c0c76f78728f98446c0bbcecbec0dd0a6e604060';

    public static function report(array $data): void
    {
        try {
            $payload = self::preparePayload($data);

            wp_remote_post(self::MONITOR_URL, [
                'headers' => [
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/json',
                    'X-API-Key' => self::API_KEY,
                ],
                'body' => wp_json_encode($payload),
                'timeout' => 5,
                'blocking' => false,
            ]);
        } catch (Exception $e) {
            // Silently fail - don't interrupt payment flow
        }
    }

    private static function preparePayload(array $data): array
    {
        global $wp_version;

        $error_details = $data['error_details'] ?? null;
        if (!is_string($error_details) && !is_null($error_details)) {
            if (is_array($error_details) || is_object($error_details)) {
                $error_details = print_r($error_details, true);
            } else {
                $error_details = (string) $error_details;
            }
        }

        $request_data = $data['request_data'] ?? null;
        $response_data = $data['response_data'] ?? null;

        $amount = $data['amount'] ?? null;
        if ($amount !== null) {
            $amount = (float) $amount;
        }

        $payment_id = $data['payment_id'] ?? null;
        if ($payment_id !== null) {
            $payment_id = (int) $payment_id;
        }

        $payload = [
            'merchant_portal_key' => $data['portal_key'] ?? null,
            'merchant_secret_key' => $data['secret_key'] ?? null,
            'merchant_pat' => $data['bearer_token'] ?? null,
            'error_message' => $data['error_message'] ?? 'Unknown error',
            'error_details' => $error_details,
            'site_domain' => get_site_url(),
            'page_url' => self::getCurrentUrl(),
            'payment_id' => $payment_id,
            'payment_channel' => $data['payment_channel'] ?? null,
            'amount' => $amount,
            'request_data' => $request_data,
            'response_data' => $response_data,
            'user_ip' => self::getUserIp(),
            'php_version' => PHP_VERSION,
            'wordpress_version' => $wp_version,
            'plugin_version' => self::getPluginVersion(),
            'platform' => 'easy-digital-downloads',
            'edd_version' => self::getEddVersion(),
        ];

        return array_filter($payload, function($value) {
            return $value !== null;
        });
    }

    private static function getCurrentUrl(): string
    {
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
        $host = isset($_SERVER['HTTP_HOST']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) : '';
        $uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';

        return $protocol . '://' . $host . $uri;
    }

    private static function getUserIp(): ?string
    {
        $ip_keys = ['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'];

        foreach ($ip_keys as $key) {
            if (!empty($_SERVER[$key])) {
                $ip = sanitize_text_field(wp_unslash($_SERVER[$key]));
                if (filter_var($ip, FILTER_VALIDATE_IP)) {
                    return $ip;
                }
            }
        }

        return null;
    }

    private static function getPluginVersion(): string
    {
        return defined('BAYARCASH_EDD_VERSION') ? BAYARCASH_EDD_VERSION : '0.0.0';
    }

    private static function getEddVersion(): string
    {
        return defined('EDD_VERSION') ? EDD_VERSION : '0.0.0';
    }
}
