jQuery(document).ready(function($) {
    function initBayarcashPaymentOptions() {
        var $bayarcashError = $('.bayarcash-error-notice').first();
        var $eddError = $('.edd_errors, .edd-alert-error').first();

        if (!$bayarcashError.length && !$eddError.length) {
            var firstOption = $(".bayarcash-payment-option input[type=radio]").first();
            if (firstOption.length) {
                firstOption.prop('checked', true).trigger('change');
            }
        } else {
            var $errorToScroll = $bayarcashError.length ? $bayarcashError : $eddError;
            if ($errorToScroll.length && $errorToScroll.offset()) {
                $('html, body').animate({
                    scrollTop: $errorToScroll.offset().top - 100
                }, 200);
            }
        }
    }

    initBayarcashPaymentOptions();

    setTimeout(initBayarcashPaymentOptions, 500);

    $('body').on('edd_gateway_loaded', function() {
        setTimeout(initBayarcashPaymentOptions, 100);
    });
});