<?php
/**
 * Plugin Name: Basic Image Converter and Optimizer
 * Plugin URI: https://clickfoundry.co/basic-image-converter-optimizer
 * Description: Automatically creates WebP and AVIF versions of uploaded images using ImageMagick
 * Version: 1.0.1
 * Author: Christian Sanchez
 * Author URI: https://clickfoundry.co
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: basic-image-converter-and-optimizer
 */

// Prevent direct access
if (!defined('ABSPATH')) exit;

// Define plugin constants
define('BASIIMCO_VERSION', '1.0.0');
define('BASIIMCO_PLUGIN_DIR', plugin_dir_path(__FILE__));

// Load the main plugin class
require_once BASIIMCO_PLUGIN_DIR . 'includes/class-basic-image-converter-optimizer.php';

register_activation_hook(__FILE__, array('BASIIMCO_Main', 'basiimco_on_activation'));
register_deactivation_hook(__FILE__, array('BASIIMCO_Main', 'basiimco_on_deactivation'));

// Initialize the plugin
new BASIIMCO_Main();