<?php
/*                                                                                                                                                                                                                                                             
Plugin Name: Azimuth basic function
Plugin URI: http://wordpress.org/extend/plugins/basic-for-azimuth-web-site/
Description: Plugin for implement basic function for all Azimuth web site
Version: 1.0.8
Author: Daniele Zamboni
Author URI: 
Author Email: d.zamboni@azimuthmark.com
License: GPLv3
*/
/* Start Adding Functions Below this Line */

// Youtube video with smart Youtube

function add_video_wmode_transparent($html, $url, $attr) {

if ( strpos( $html, "<embed src=" ) !== false )
   { return str_replace('</param><embed', '</param><param name="wmode" value="opaque"></param><embed wmode="opaque" ', $html); }
elseif ( strpos ( $html, 'feature=oembed' ) !== false )
   { return str_replace( 'feature=oembed', 'feature=oembed&wmode=opaque', $html ); }
else
   { return $html; }
}
add_filter( 'embed_oembed_html', 'add_video_wmode_transparent', 10, 3);


// Widget in the admin page

add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');

function my_custom_dashboard_widgets() {
global $wp_meta_boxes;

wp_add_dashboard_widget('custom_help_widget', 'Azimuth Mark S.r.l.', 'custom_dashboard_help');
}

function custom_dashboard_help() {
echo '<p>Benvenuti nel vostro sito web ! Hai bisogno d&acute;aiuto ? Per contattare il Web master <a href="mailto:d.zamboni@azimuthmark.com">clicca qui</a>. Per ulteriori informazioni visiti <a href="http://www.azimuthmark.com" target="_blank">il nostro sito.</a></p>';
}

// Footer in the admin page

function remove_footer_admin () {
echo 'Contatta <a href="mailto:d.zamboni@azimuthmark.com">Web master</a> | Designed by <a href="http://www.azimuthmark.com" target="_blank">Azimtuh Mark S.r.l.</a></p>';
}

add_filter('admin_footer_text', 'remove_footer_admin');

// Custom logo in log-in page

function custom_loginlogo() {
echo '<style type="text/css">
h1 a {background-image: url('.get_bloginfo('template_directory').'/images/login_logo.png) !important; }
</style>';
}
add_action('login_head', 'custom_loginlogo');

// Random post

add_action('init','random_add_rewrite');
function random_add_rewrite() {
       global $wp;
       $wp->add_query_var('random');
       add_rewrite_rule('random/?$', 'index.php?random=1', 'top');
}

add_action('template_redirect','random_template');
function random_template() {
       if (get_query_var('random') == 1) {
               $posts = get_posts('post_type=post&orderby=rand&numberposts=1');
               foreach($posts as $post) {
                       $link = get_permalink($post);
               }
               wp_redirect($link,307);
               exit;
       }
}

// Disable to show error for log-in

add_filter('login_errors',create_function('$a', "return null;"));


// Theme Setting favicon upload
	$themename 				= "My Framework";
	$shortname 				= "my_framework";
	
	// Options Page Functions
	function themeoptions_admin_menu() 
	{
		// here's where we add our theme options page link to the dashboard sidebar
		add_theme_page("Theme Options", "Theme Options", 'edit_themes', basename(__FILE__), 'themeoptions_page');
	}
	function themeoptions_page() 
	{
		// here's the main function that will generate our options page
		if ( $_POST['update_themeoptions'] == 'true' ) { themeoptions_update(); }
?>
<div class="wrap">
	<div id="icon-themes" class="icon32"><br /></div>
	<h2>Theme Options</h2>
	<form method="POST" action="">
		<input type="hidden" name="update_themeoptions" value="true" />
		<h3>Favicon Image</h3>
		<p><input type="text" name="favicon" id="favicon" size="60" value="<?php echo get_option('mytheme_favicon'); ?>"/> Path to Favicon</p>
		<p><input type="submit" name="search" value="Update Options" class="button" /></p>
	</form>
</div>
<?php
	}
	function themeoptions_update()
	{
		// this is where validation would go
		update_option('mytheme_logoimage', 	$_POST['logoimage']);
		update_option('mytheme_favicon', 	$_POST['favicon']);
	}
	add_action('admin_menu', 'themeoptions_admin_menu');


// Stop malicius request

global $user_ID; if($user_ID) {
if(!current_user_can('level_10')) {
if (strlen($_SERVER['REQUEST_URI']) > 255 ||
strpos($_SERVER['REQUEST_URI'], "eval(") ||
strpos($_SERVER['REQUEST_URI'], "CONCAT") ||
strpos($_SERVER['REQUEST_URI'], "UNION SELECT") ||
strpos($_SERVER['REQUEST_URI'], "base64")) {
@header("HTTP/1.1 414 Request-URI Too Long");
@header("Status: 414 Request-URI Too Long");
@header("Connection: Close");
@exit;
}
}
} 

//1.0.7
// Don't show alert of upgrade wordpress

add_action('admin_menu','wphidenag');
function wphidenag() {
remove_action( 'admin_notices', 'update_nag', 3 );
}

//1.0.8
// Disqus: Prevent from replacing comment count
remove_filter('comments_number', 'dsq_comments_text');
remove_filter('get_comments_number', 'dsq_comments_number');
remove_action('loop_end', 'dsq_loop_end');

// Change maximum upload size
@ini_set( 'upload_max_size' , '64M' );
@ini_set( 'post_max_size', '64M');
@ini_set( 'max_execution_time', '300' );

/* Stop Adding Functions Below this Line */
?>