<?php

  /**
   * Show notice about new feature: Google Drive Storage
   *
   * @category Child Plugin
   * @version v0.1.0
   * @since v0.1.0
   * @author iClyde <kontakt@iclyde.pl>
   */

  // Namespace
  namespace Inisev\Subs;

  // Disallow direct access
  if ( ! defined( 'ABSPATH' ) ) exit;

  /**
   * Main class for handling the GDrive Banner
   */
  if (!class_exists('Inisev\Subs\BMI_Banners_GDrive')) {
    class BMI_Banners_GDrive {
      
      /**
       * Variable declarations
       */
      public $name = null;
      public $nonce = null;
      public $plugin_menu_url = null;
      public $assets_js = null;
      public $assets_css = null;

      /**
       * Initializes the module
       */
      function __construct($display_name, $plugin_menu_url) {

        $this->name = $display_name;
        $this->nonce = wp_create_nonce('bmi_grive_action');
        $this->plugin_menu_url = admin_url('admin.php?page=' . $plugin_menu_url);

        $this->assets_js = __DIR__ . DIRECTORY_SEPARATOR . 'assets' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR;
        $this->assets_css = __DIR__ . DIRECTORY_SEPARATOR . 'assets' . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR;

        if (get_option('bmi_gdrive_banner_dismissed', false)) return false;
        add_action('wp_ajax_bmi_gdrive_banner', [&$this, 'handle_banner_action']);
        $this->display_banner_if_possible();

      }

      /**
       * Checks if banner should be displayed and adds action
       */
      public function display_banner_if_possible() {
        
        if (!$this->check_page()) return;
        if (!$this->check_version()) return;

        add_action('admin_notices', [&$this, 'include_banner'], 100);

      }

      /**
       * Handles banner Action (close)
       */
      public function handle_banner_action() {
        if (check_ajax_referer('bmi_grive_action', 'nonce', false) === false) return wp_send_json_error();
        if (!current_user_can('manage_options')) return wp_send_json_error();

        $mode = sanitize_text_field($_POST['mode']);
        if ($mode == 'dismiss') update_option('bmi_gdrive_banner_dismissed', true);

      }

      /**
       * Returns URL to image
       */
      public function __img($filename) {
        
        $path = __DIR__ . DIRECTORY_SEPARATOR . 'assets' . DIRECTORY_SEPARATOR . 'imgs' . DIRECTORY_SEPARATOR . $filename;
        $url = plugins_url($this->path, BMI_ROOT_DIR);

        return $url;

      }

      /**
       * Print banner HTML
       */
      public function include_banner() {

        wp_enqueue_style('bmi-gdrive-banner-style', plugin_dir_url($this->assets_css) . 'css/styles.css', [], filemtime($this->assets_css . 'styles.css'));
        wp_enqueue_script('bmi-gdrive-banner-script', plugin_dir_url($this->assets_js) . 'js/script.js', [], filemtime($this->assets_js . 'script.js'), true);
        require_once __DIR__ . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'banner.php';

      }

      /**
       * Checks if the banner should be displayed on particular page
       */
      public function check_page() {

        global $pagenow;

        if (!is_admin()) return false;
        if (!current_user_can('manage_options')) return false;

        $allowed_pages = ['index.php', 'plugins.php'];
        if (!(in_array($pagenow, $allowed_pages) || strpos($_SERVER['REQUEST_URI'], 'admin.php?page=backup-migration'))) return false;

        return true;

      }

      /**
       * Check if the plugin was updated
       * There is no reason to display it for new users, but only to these who awaited that feature
       */
      public function check_version() {

        // Get applied hotfixes
        $hotfixes = get_option('bmi_hotfixes', array());
        
        // New installs should have 0 hotfixes
        if (sizeof($hotfixes) == 0) {
          
          // For new users there is no need to display the banner
          update_option('bmi_gdrive_banner_dismissed', true);
          return false;

        }

        return true;

      }

    }
  }
