<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<table>
  <tr class="br_stg_tr_template">
    <td class="stg-tr-name tooltip-html" tooltip="<?php esc_attr_e('Original name:', 'backup-backup') ?>"></td>
    <td class="stg-tr-url">
      <a class="stg-tr-url-el tooltip" tooltip="" href="#!" target="_blank"></a>
    </td>
    <td class="stg-tr-size"></td>
    <td class="stg-tr-server tooltip"></td>
    <td class="stg-tr-creation"></td>
    <td class="stg-tr-expiration"><span>00:00:00</span></td>
    <td class="flex">
      <div>
        <img class="tooltip bc-stg-edit-btn hoverable untab" tabindex="-1" tooltip="<?php esc_attr_e('Edit display name of the staging site', 'backup-backup') ?>" src="<?php echo esc_url( $this->get_asset('images', 'pen-edit.svg') ); ?>" alt="image">
      </div>
      <div>
        <img class="tooltip bc-stg-url-btn hoverable untab" tabindex="-1" tooltip="<?php esc_attr_e('Copy URL of the staging site', 'backup-backup') ?>" src="<?php echo esc_url( $this->get_asset('images', 'link-min.png') ); ?>" alt="image">
      </div>
      <a class="stg-login-btn" href="#" target="_blank">
        <div class="hoverable tooltip" tooltip="<?php esc_attr_e('Log into the website without password', 'backup-backup') ?>">
          <img src="<?php echo esc_url( $this->get_asset('images', 'log-in.svg') ); ?>" width="12px" alt="image">
          <?php esc_html_e('Enter', 'backup-backup') ?>
        </div>
      </a>
      <img class="tooltip bc-stg-remove-btn hoverable" tooltip="<?php esc_attr_e('Delete this site', 'backup-backup') ?>" src="<?php echo esc_url( $this->get_asset('images', 'red-close-min.svg') ); ?>" alt="image">
    </td>
  </tr>
</table>
