<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;
  use BMI\Plugin\Backup_Migration_Plugin AS BMP;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="cf lh28 valign-restore">

  <div class="left cf hoverable" id="show-upload-area">
    <div class="left">
      <img class="a2" src="<?php echo esc_url($this->get_asset('images', 'upload-min.png')); ?>" width="15px" alt="image">
    </div>
    <div class="left f16 secondary hoverable">
      <?php esc_html_e('Upload backup files', 'backup-backup') ?>
    </div>
  </div>

  <div class="left cf" style="margin-left: 35px;">
    <div class="left">
      <img class="a1" src="<?php echo esc_url($this->get_asset('images', 'search-min.png')); ?>" width="15px" alt="image">
    </div>
    <div class="left f16">
      <?php esc_html_e('Rescan for backup files:', 'backup-backup') ?>
      <a href="#" id="rescan-for-backups" class="secondary hoverable"><?php esc_html_e('Refresh', 'backup-backup') ?></a>
      <span style="display: none;">| <a href="#"><?php esc_html_e('Remotely', 'backup-backup') ?></a></span>
      <span id="reloading-bm-list" style="display: none;"><div class="spinner-loader"></div></span>
    </div>
  </div>

</div>

<div class="mtl del-all-btn-wrp mbll" style="display: none;">
  <button class="btn red deleteAllSelected"><?php esc_html_e('Delete all selected backups', 'backup-backup') ?></button>
</div>

<div class="upload_area hidden">

  <div id="drop-area">
    <label for="upid_input">
      <form class="my-form center mt">
        <div class="img_upload center block"></div>
        <div class="f18 muted-text mtll">
          <?php esc_html_e("Drag & drop your backup file here", 'backup-backup'); ?>
        </div>
        <div class="cf mtl center inline">
          <div class="left ortext">
            <?php esc_html_e("...or", 'backup-backup'); ?>&nbsp;&nbsp;
          </div>
          <div class="left">
            <div class="btn upload_button">
              <?php esc_html_e("Browse for file", 'backup-backup'); ?>
            </div>
          </div>
        </div>
        <input type="file" id="upid_input" accept=".zip,.gz,.tar" onchange="jQuery.fchunker_upload()">
      </form>
    </label>
  </div>

  <div class="mtl center upload-progress" style="display: none;">

    <div class="upload-title mtl">
      <?php esc_html_e("Upload in progress", 'backup-backup'); ?>
    </div>

    <div class="upload-progress-bar">
      <span>
        <div class="upload-percentage">99%</div>
      </span>
    </div>

    <div class="mtll">
      <a href="#" class="f16 medium red-text nodec hoverable" onclick="window.location.reload()"><?php esc_html_e("Cancel upload", 'backup-backup'); ?></a>
    </div>

  </div>

  <div class="f18 mt30 lh30">
    <?php esc_html_e("Alternatively, you can place the files (e.g. via FTP) into your local backup directory", 'backup-backup'); ?> (<?php echo esc_html(BMP::fixSlashes(BMI_BACKUPS)); ?>) <?php esc_html_e('or remote storage, and then use the "Rescan for backup files" - option above to make them show up in the list.', 'backup-backup'); ?>
  </div>

</div>

<div class="center mtll" id="load-more-backups-wrp">
  <a href="#" id="load-more-backups" style="display: none;" class="btn inline semibold mm60">
    <?php esc_html_e('Load more', 'backup-backup'); ?>
  </a>
</div>
