<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="bmi-modal" id="staging-success-modal">

  <div class="bmi-modal-wrapper" style="max-width: 645px; max-width: min(645px, 80vw);">
    <div class="bmi-modal-content">

      <div class="center">
        <div class="mbl cf center inline">
          <div class="left center">
            <img class="inline bmi-staging-success-img-normal" src="<?php echo esc_url( $this->get_asset('images', 'success.png') ); ?>" alt="success">
            <img class="inline bmi-image-hide bmi-staging-success-img-tastewp" src="<?php echo esc_url( $this->get_asset('images', 'tlogo.svg') ); ?>" alt="tastewp">
          </div>
          <div class="left f24 bold lh50"><?php esc_html_e("Staging site created!", 'backup-backup'); ?></div>
        </div>
      </div>

      <div class="f19 mbl center lh30">
        <div id="bmi-tastewp-staging-success-text" style="display: none;">
          <?php esc_html_e("Your staging site has been created successfully.", 'backup-backup'); ?><br>
          <?php esc_html_e("Please visit it now to complete the activation process.", 'backup-backup'); ?>
        </div>
        <div id="bmi-local-staging-success-text">
          <?php esc_html_e("Your staging site has been created successfuly,", 'backup-backup'); ?><br>
          <?php esc_html_e("you can visit it now, or later from staging sites list.", 'backup-backup'); ?>
        </div>
        <br />
        <div class="bmi-staging-bolder-wrap">
          <b><?php esc_html_e("URL:", 'backup-backup'); ?> <a href="#!" id="bmi-staging-latest-url" target="_blank">https://somesite.com/xyz</a></b>
        </div>
      </div>

      <div class="flex flexcenter">
        <div class="cf inline">
          <div class="left inline mr50">
            <a href="#" target="_blank" id="bmi-visit-latest-staging" class="btn mm60 center block bold nodec">
              <?php esc_html_e("Visit the site", 'backup-backup'); ?>
            </a>
          </div>
          <div class="left inline">
            <a href="#" class="btn bmi-modal-closer inline mm60 center block bold grey nodec">
              <?php esc_html_e("Close", 'backup-backup'); ?>
            </a>
          </div>
        </div>
      </div>

    </div>
  </div>

</div>
