<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="bmi-modal bmi-modal-no-close bmi-modal-not-allowed" id="staging-progress-modal">

  <div class="bmi-modal-wrapper no-hpad" style="max-width: 900px; max-width: min(900px, 80vw)">
    <div class="bmi-modal-content center">

      <div class="mm60 f30 bold black"><?php esc_html_e('Staging site creation in progress', 'backup-backup') ?></div>

      <div class="red-error-bg tml" style="display: none;">
        <div class="red-warning mtl mbl f18">
          <?php esc_html_e('Do not close this window as long as the creation process is ongoing', 'backup-backup'); ?>
        </div>
      </div>

      <div class="mm60 progress-bar-wrapper">

        <div class="progress-bar">
          <div class="progress-active-bar" style="width: 0%;"></div>
          <div class="progress-percentage" style="left: 0%;">0%</div>
        </div>

      </div>

      <div class="mm60 step-progress cf">
        <div class="left f16 medium">
          <?php esc_html_e('Step: ', 'backup-backup') ?>
          <span id="staging_current_step"><?php esc_html_e('Preparing creation of staging site...', 'backup-backup') ?></span>
        </div>
      </div>

      <div class="mm60 live-log" id="staging-live-log-wrapper">

        <div class="log-wrapper">
          <pre></pre>
        </div>

        <div class="f16 semibold secondary hoverable pointer">
          <a href="<?php echo esc_url( get_site_url() . '/?backup-migration=PROGRESS_LOGS&progress-id=latest_staging.log&bmi-id=current&t=' . time() . '&sk=' . bmi_get_config('REQUEST:SECRET') ); ?>"
             download="staging_live_log.txt" class="nlink">
            <?php esc_html_e('Download live log', 'backup-backup') ?>
          </a>
          <span>&nbsp;|&nbsp;</span>
          <div class="f16 inline" id="bmi-staging-stop">
            <?php esc_html_e('Stop the process', 'backup-backup') ?>
          </div>
        </div>

      </div>

    </div>
  </div>

</div>
