<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="bmi-modal" id="staging-delete-confirm-modal">

  <div class="bmi-modal-wrapper" style="max-width: 380px; max-width: min(380px, 80vw);">
    <a href="#" class="bmi-modal-close">×</a>
    <div class="bmi-modal-content">

      <div class="mbl center">
        <img class="center block inline" src="<?php echo esc_url( $this->get_asset('images', 'trash.png') ); ?>" alt="trash">
      </div>

      <div class="center f24 bold mbl lh30 text1">
        <?php esc_html_e("Are you sure you want to", 'backup-backup'); ?><br>
        <?php esc_html_e("delete this staging site?", 'backup-backup'); ?>
      </div>

      <div class="f19 mbl center lh30">
        <b><?php esc_html_e("URL:", 'backup-backup'); ?> <a href="#!" id="bmi-staging-removal-url" target="_blank">https://somesite.com/xyz</a></b>
      </div>

      <div class="center f19 mbl">
        <a href="#" id="stg-removal-confirm" class="btn bold red inline mm60">
          <?php esc_html_e("Yes, kill it!", 'backup-backup'); ?>
        </a>
      </div>

      <div class="center f19">
        <a href="#" class="bold bmi-modal-closer hoverable text-muted nodec">
          <?php esc_html_e("No, cancel", 'backup-backup'); ?>
        </a>
      </div>

    </div>
  </div>

</div>
