<?php


  // Namespace
  namespace BMI\Plugin;

  // Use classes
  use BMI\Plugin\BMI_Logger as Logger;
  use BMI\Plugin\Backup_Migration_Plugin as BMP;
  use BMI\Plugin\Extracter\BMI_Extracter as Extracter;
  use BMI\Plugin\Progress\BMI_MigrationProgress as MigrationProgress;
  use BMI\Plugin AS BMI;

  // Allow only PHP CLI to use this script
  if (php_sapi_name() !== 'cli') {
    echo 'This script it dedicated for PHP CLI';
    exit;
  }

  function isFunctionEnabled($func) {
    $disabled = explode(',', ini_get('disable_functions'));
    $isDisabled = in_array($func, $disabled);
    if (!$isDisabled && function_exists($func)) return true;
    else return false;
  }

  // Find WordPress Path
  function bmi_find_wordpress_base_path() {

    $dir = dirname(__FILE__);
    $previous = null;

    do {

      if (file_exists($dir . '/wp-load.php') && file_exists($dir . '/wp-config.php')) return $dir;
      if ($previous == $dir) break;
      $previous = $dir;

    } while ($dir = dirname($dir));

    return null;

  }

  // Tell WP to not use Themes and set Base Path
  define('BASE_PATH', bmi_find_wordpress_base_path() . '/');
  define('BMI_USING_CLI_FUNCTIONALITY', true);
  if (isset($argv[1])) define('BMI_CLI_FUNCTION', $argv[1]);
  else {
    
    echo "\n\n========= BACKUP MIGRATION PLUGIN =========\n\n";
    echo "Please specify CLI function: bmi_restore [<backup_name>.zip], bmi_backup or bmi_quick_migration <backup URL>\n\n";
    echo "Examples: \n";
    echo " – php -f cli-handler.php bmi_backup\n";
    echo " – php -f cli-handler.php bmi_backup BMI_12-12-12_nameOfMySite_nameOfBackup.zip\n";
    echo " – php -f cli-handler.php bmi_restore BMI_12-12-12_nameOfMySite_nameOfBackup.zip\n";
    echo " – php -f cli-handler.php bmi_quick_migration \"http://localhost/site/linkToMyBackup.zip\"\n";
    echo "\n========= BACKUP MIGRATION PLUGIN =========\n\n";
    exit();

  }

  if (isset($argv[2])) define('BMI_CLI_ARGUMENT', $argv[2]);
  if (isset($argv[3])) define('BMI_CLI_ARGUMENT_2', $argv[3]);

  // Pseudo Server variables
  $_SERVER['REQUEST_METHOD'] = 'CLI';

  // Increase max execution time
  if (isFunctionEnabled('headers_sent')) {
    if (!headers_sent()) {
      if (isFunctionEnabled('set_time_limit')) @set_time_limit(259200);
      if (isFunctionEnabled('ini_set')) {
        @ini_set('max_input_time', '259200');
        @ini_set('max_execution_time', '259200');
      }
    }
  }

  // Response
  ob_start();
  echo '100101011101' . "\n";

  @header('Connection: close');
  @header('Content-Length: ' . ob_get_length());

  ob_end_clean();
  flush();
  
  if (isFunctionEnabled('fastcgi_finish_request') && isFunctionEnabled('is_callable') && is_callable('fastcgi_finish_request')) {
    fastcgi_finish_request();
  }

  // Let the server know it's server-side script
  if (isFunctionEnabled('ignore_user_abort')) {
    @ignore_user_abort(true);
  }

  if (isFunctionEnabled('session_write_close')) {
    @session_write_close();
  }
  
  function fixSlashes($str, $slash = false) {
    // Old version
    // $str = str_replace('\\\\', DIRECTORY_SEPARATOR, $str);
    // $str = str_replace('\\', DIRECTORY_SEPARATOR, $str);
    // $str = str_replace('\/', DIRECTORY_SEPARATOR, $str);
    // $str = str_replace('/', DIRECTORY_SEPARATOR, $str);

    // if ($str[strlen($str) - 1] == DIRECTORY_SEPARATOR) {
    //   $str = substr($str, 0, -1);
    // }
    
    // Since 1.3.2
    $protocol = '';
    if ($slash == false) $slash = DIRECTORY_SEPARATOR;
    if (substr($str, 0, 7) == 'http://') $protocol = 'http://';
    else if (substr($str, 0, 8) == 'https://') $protocol = 'https://';
    
    $str = substr($str, strlen($protocol));
    $str = preg_replace('/[\\\\\/]+/', $slash, $str);
    $str = rtrim($str, '/\\' );

    return $protocol . $str;
  }
  
  function bmiLoadWordPressAndBackupPlugin() {
    
    // Define how WP should load
    define('WP_USE_THEMES', false);
    define('SHORTINIT', true);
    
    // Set path to our plugin's main file
    $bmiPluginPathToLoad = fixSlashes(dirname(__DIR__) . '/backup-backup.php');
    $bmiPluginPathToLoadPro = fixSlashes(dirname(dirname(__DIR__)) . '/backup-backup-pro/backup-backup-pro.php');

    // Use WP Globals and load WordPress
    global $wp, $wp_query, $wp_the_query, $wp_rewrite, $wp_did_header;
    require_once bmi_find_wordpress_base_path() . DIRECTORY_SEPARATOR . 'wp-load.php';
    global $wp_version;
    
    // Load directory WordPress constants 
    require_once ABSPATH . WPINC . '/formatting.php';
    require_once ABSPATH . WPINC . '/meta.php';
    wp_plugin_directory_constants();
    
    // Allow to register activation hook and realpath
    $GLOBALS['wp_plugin_paths'] = array();
    $GLOBALS['shortcode_tags'] = array();
    
    // Load all dependencies of WordPress for Backup plugin
    $dependencies = [
      ABSPATH . WPINC . '/l10n.php',
      ABSPATH . WPINC . '/plugin.php',
      ABSPATH . WPINC . '/link-template.php',
      ABSPATH . WPINC . '/class-wp-textdomain-registry.php',
      ABSPATH . WPINC . '/class-wp-locale.php',
      ABSPATH . WPINC . '/class-wp-locale-switcher.php',
      ABSPATH . WPINC . '/session.php',
      ABSPATH . WPINC . '/pluggable.php',
      ABSPATH . WPINC . '/class-wp-ajax-response.php',
      ABSPATH . WPINC . '/capabilities.php',
      ABSPATH . WPINC . '/class-wp-roles.php',
      ABSPATH . WPINC . '/class-wp-role.php',
      ABSPATH . WPINC . '/class-wp-user.php',
      ABSPATH . WPINC . '/class-wp-query.php',
      ABSPATH . WPINC . '/query.php',
      ABSPATH . WPINC . '/general-template.php',
      ABSPATH . WPINC . '/http.php',
      ABSPATH . WPINC . '/class-http.php',
      ABSPATH . WPINC . '/class-wp-http.php',
      ABSPATH . WPINC . '/class-wp-http-streams.php',
      ABSPATH . WPINC . '/class-wp-http-curl.php',
      ABSPATH . WPINC . '/class-wp-http-proxy.php',
      ABSPATH . WPINC . '/class-wp-http-cookie.php',
      ABSPATH . WPINC . '/class-wp-http-encoding.php',
      ABSPATH . WPINC . '/class-wp-http-response.php',
      ABSPATH . WPINC . '/class-wp-http-requests-response.php',
      ABSPATH . WPINC . '/class-wp-http-requests-hooks.php',
      ABSPATH . WPINC . '/widgets.php',
      ABSPATH . WPINC . '/class-wp-widget.php',
      ABSPATH . WPINC . '/class-wp-widget-factory.php',
      ABSPATH . WPINC . '/class-wp-user-request.php',
      ABSPATH . WPINC . '/user.php',
      ABSPATH . WPINC . '/class-wp-user-query.php',
      ABSPATH . WPINC . '/class-wp-session-tokens.php',
      ABSPATH . WPINC . '/class-wp-user-meta-session-tokens.php',
      ABSPATH . WPINC . '/rest-api.php',
      ABSPATH . WPINC . '/kses.php',
      ABSPATH . WPINC . '/theme.php',
      ABSPATH . WPINC . '/rewrite.php',
      ABSPATH . WPINC . '/class-wp-block-editor-context.php',
      ABSPATH . WPINC . '/class-wp-block-type.php',
      ABSPATH . WPINC . '/class-wp-block-pattern-categories-registry.php',
      ABSPATH . WPINC . '/class-wp-block-patterns-registry.php',
      ABSPATH . WPINC . '/class-wp-block-styles-registry.php',
      ABSPATH . WPINC . '/class-wp-block-type-registry.php',
      ABSPATH . WPINC . '/class-wp-block.php',
      ABSPATH . WPINC . '/class-wp-block-list.php',
      ABSPATH . WPINC . '/class-wp-block-parser-block.php',
      ABSPATH . WPINC . '/class-wp-block-parser-frame.php',
      ABSPATH . WPINC . '/class-wp-block-parser.php',
      ABSPATH . WPINC . '/blocks.php',
      ABSPATH . WPINC . '/blocks/index.php',
    ];
    
    for ($i = 0; $i < sizeof($dependencies); ++$i) { 
      $dependency = $dependencies[$i];
      if (strpos($dependency, 'class-http.php') && version_compare($wp_version, '5.9.0', '>=')) {
        continue;
      }
      if (strpos($dependency, 'session.php') && version_compare($wp_version, '4.7.0', '>=')) {
        continue;
      }
      if (file_exists($dependency)) require_once $dependency;
    }
    
    // Load Cookie Constants
    wp_cookie_constants();
    
    // Load SSL Constants for DB export
    wp_ssl_constants();
    
    // Register Translation
    if (class_exists('WP_Textdomain_Registry')) {
      $GLOBALS['wp_textdomain_registry'] = new \WP_Textdomain_Registry();
    }
    
    if (file_exists($bmiPluginPathToLoadPro) && is_readable($bmiPluginPathToLoadPro)) {
      wp_register_plugin_realpath($bmiPluginPathToLoadPro);
      include_once $bmiPluginPathToLoadPro;
      
      require_once BMI_PRO_ROOT_DIR . '/classes/core' . ((BMI_PRO_DEBUG) ? '.to-enc' : '') . '.php';
      $bmi_pro_instance = new BMI_Pro_Core();
      $bmi_pro_instance->initialize();
    }
    
    // Register our backup plugin and load its contents
    wp_register_plugin_realpath($bmiPluginPathToLoad);
    include_once $bmiPluginPathToLoad;
    
    // Enable our plugin WITHOUT calling plugins_loaded hook – it's important
    require_once BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'constants.php';

    // Initialize backup-migration
    if (!class_exists('Backup_Migration_Plugin')) {

      // Require initializator
      require_once BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'initializer.php';

      // Initialize entire plugin
      $bmi_instance = new BMI\Backup_Migration_Plugin();
      $bmi_instance->initialize();

    }
    
  }
  
  bmiLoadWordPressAndBackupPlugin();
