<?php

  /**
   * Plugin Name: Backup Migration
   * Description: Most sophisticated backup & migration plugin for WordPress
   *      Author: Inisev
   *  Author URI: https://inisev.com
   *  Plugin URI: https://backupbliss.com
   * Text Domain: backup-backup
   *     Version: 2.1.1
   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  // Default namespace
  use BMI\Plugin AS BMI;

  // Not dynamic constants
  if (!defined('BMI_DEBUG')) {
    define('BMI_DEBUG', false);
  }
  if (!defined('BMI_VERSION')) {
    define('BMI_VERSION', '2.1.1');
  }
  if (!defined('BMI_ROOT_DIR')) {
    define('BMI_ROOT_DIR', __DIR__);
  }
  if (!defined('BMI_ROOT_FILE')) {
    define('BMI_ROOT_FILE', __FILE__);
  }
  if (!defined('BMI_INCLUDES')) {
    define('BMI_INCLUDES', BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'includes');
  }
  if (!defined('BMI_MODULES_DIR')) {
    define('BMI_MODULES_DIR', BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR);
  }

  // Activation hook
  register_activation_hook(BMI_ROOT_FILE, function () {
    require_once BMI_INCLUDES . DIRECTORY_SEPARATOR . 'activation.php';
    BMI\bmi_activate_plugin();
  });

  // Fixes for some cases
  require_once BMI_INCLUDES . DIRECTORY_SEPARATOR . 'compatibility.php';

  // Opt-in sub plugin
  require_once BMI_INCLUDES . DIRECTORY_SEPARATOR . 'analyst.php';

  // Load plugin after all
  add_action('init', function () {

    // Global plugin variables
    require_once BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'constants.php';

    // Initialize backup-migration
    if (!class_exists('Backup_Migration_Plugin')) {

      // Require initializator
      require_once BMI_ROOT_DIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'initializer.php';

      // Initialize entire plugin
      $bmi_instance = new BMI\Backup_Migration_Plugin();
      $bmi_instance->initialize();

    }

  }, 15);
